/*
 * Decompiled with CFR 0.152.
 */
package kamon.trace;

import java.util.concurrent.ThreadLocalRandom;
import kamon.metric.Counter;
import kamon.trace.RandomSampler$;
import kamon.trace.Sampler;
import kamon.trace.Sampler$Metrics$;
import kamon.trace.Trace;
import kamon.trace.Trace$SamplingDecision$DoNotSample$;
import kamon.trace.Trace$SamplingDecision$Sample$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005!4AAE\n\u00011!A1\u0005\u0001B\u0001B\u0003%A\u0005C\u0003(\u0001\u0011%\u0001\u0006C\u0004,\u0001\t\u0007I\u0011\u0002\u0017\t\r5\u0002\u0001\u0015!\u0003%\u0011\u001dq\u0003A1A\u0005\n1Baa\f\u0001!\u0002\u0013!\u0003b\u0002\u0019\u0001\u0005\u0004%I!\r\u0005\u0007q\u0001\u0001\u000b\u0011\u0002\u001a\t\u000fe\u0002!\u0019!C\u0005c!1!\b\u0001Q\u0001\nIBQa\u000f\u0001\u0005BqBQ\u0001\u0016\u0001\u0005BU;QAX\n\t\u0002}3QAE\n\t\u0002\u0001DQa\n\b\u0005\u0002\u0005DQA\u0019\b\u0005\u0002\rDQ!\u001a\b\u0005\u0002\u0019\u0014QBU1oI>l7+Y7qY\u0016\u0014(B\u0001\u000b\u0016\u0003\u0015!(/Y2f\u0015\u00051\u0012!B6b[>t7\u0001A\n\u0004\u0001ey\u0002C\u0001\u000e\u001e\u001b\u0005Y\"\"\u0001\u000f\u0002\u000bM\u001c\u0017\r\\1\n\u0005yY\"AB!osJ+g\r\u0005\u0002!C5\t1#\u0003\u0002#'\t91+Y7qY\u0016\u0014\u0018a\u00039s_\n\f'-\u001b7jif\u0004\"AG\u0013\n\u0005\u0019Z\"A\u0002#pk\ndW-\u0001\u0004=S:LGO\u0010\u000b\u0003S)\u0002\"\u0001\t\u0001\t\u000b\r\u0012\u0001\u0019\u0001\u0013\u0002\u001d}+\b\u000f]3s\u0005>,h\u000eZ1ssV\tA%A\b`kB\u0004XM\u001d\"pk:$\u0017M]=!\u00039yFn\\<fe\n{WO\u001c3bef\fqb\u00187po\u0016\u0014(i\\;oI\u0006\u0014\u0018\u0010I\u0001\u001c?\u00064g-\u001b:nCRLg/\u001a#fG&\u001c\u0018n\u001c8D_VtG/\u001a:\u0016\u0003I\u0002\"a\r\u001c\u000e\u0003QR!!N\u000b\u0002\r5,GO]5d\u0013\t9DGA\u0004D_VtG/\u001a:\u00029}\u000bgMZ5s[\u0006$\u0018N^3EK\u000eL7/[8o\u0007>,h\u000e^3sA\u0005ArL\\3hCRLg/\u001a#fG&\u001c\u0018n\u001c8D_VtG/\u001a:\u00023}sWmZ1uSZ,G)Z2jg&|gnQ8v]R,'\u000fI\u0001\u0007I\u0016\u001c\u0017\u000eZ3\u0015\u0005uZ\u0005C\u0001 I\u001d\tydI\u0004\u0002A\u000b:\u0011\u0011\tR\u0007\u0002\u0005*\u00111iF\u0001\u0007yI|w\u000e\u001e \n\u0003YI!\u0001F\u000b\n\u0005\u001d\u001b\u0012!\u0002+sC\u000e,\u0017BA%K\u0005A\u0019\u0016-\u001c9mS:<G)Z2jg&|gN\u0003\u0002H'!)Aj\u0003a\u0001\u001b\u0006Iq\u000e]3sCRLwN\u001c\t\u0003\u001dFs!\u0001I(\n\u0005A\u001b\u0012aB*b[BdWM]\u0005\u0003%N\u0013\u0011b\u00149fe\u0006$\u0018n\u001c8\u000b\u0005A\u001b\u0012\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0003Y\u0003\"aV.\u000f\u0005aK\u0006CA!\u001c\u0013\tQ6$\u0001\u0004Qe\u0016$WMZ\u0005\u00039v\u0013aa\u0015;sS:<'B\u0001.\u001c\u00035\u0011\u0016M\u001c3p[N\u000bW\u000e\u001d7feB\u0011\u0001ED\n\u0003\u001de!\u0012aX\u0001\u0006CB\u0004H.\u001f\u000b\u0003S\u0011DQa\t\tA\u0002\u0011\naa\u0019:fCR,GCA\u0015h\u0011\u0015\u0019\u0013\u00031\u0001%\u0001")
public class RandomSampler
implements Sampler {
    private final double probability;
    private final double _upperBoundary;
    private final double _lowerBoundary;
    private final Counter _affirmativeDecisionCounter;
    private final Counter _negativeDecisionCounter;

    public static RandomSampler create(double d) {
        return RandomSampler$.MODULE$.create(d);
    }

    public static RandomSampler apply(double d) {
        return RandomSampler$.MODULE$.apply(d);
    }

    private double _upperBoundary() {
        return this._upperBoundary;
    }

    private double _lowerBoundary() {
        return this._lowerBoundary;
    }

    private Counter _affirmativeDecisionCounter() {
        return this._affirmativeDecisionCounter;
    }

    private Counter _negativeDecisionCounter() {
        return this._negativeDecisionCounter;
    }

    @Override
    public Trace.SamplingDecision decide(Sampler.Operation operation) {
        Trace.SamplingDecision samplingDecision;
        long random = ThreadLocalRandom.current().nextLong();
        if ((double)random >= this._lowerBoundary() && (double)random <= this._upperBoundary()) {
            this._affirmativeDecisionCounter().increment();
            samplingDecision = Trace$SamplingDecision$Sample$.MODULE$;
        } else {
            this._negativeDecisionCounter().increment();
            samplingDecision = Trace$SamplingDecision$DoNotSample$.MODULE$;
        }
        return samplingDecision;
    }

    public String toString() {
        return new StringBuilder(29).append("RandomSampler(probability = ").append(this.probability).append(")").toString();
    }

    public RandomSampler(double probability) {
        this.probability = probability;
        this._upperBoundary = (double)Long.MAX_VALUE * probability;
        this._lowerBoundary = -this._upperBoundary();
        this._affirmativeDecisionCounter = Sampler$Metrics$.MODULE$.samplingDecisions("random", Trace$SamplingDecision$Sample$.MODULE$);
        this._negativeDecisionCounter = Sampler$Metrics$.MODULE$.samplingDecisions("random", Trace$SamplingDecision$DoNotSample$.MODULE$);
    }
}

