/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.dataset.datatype;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.dbunit.dataset.datatype.BytesDataType;
import org.dbunit.dataset.datatype.TypeCastException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BinaryStreamDataType
extends BytesDataType {
    private static final Logger logger = LoggerFactory.getLogger(BinaryStreamDataType.class);

    public BinaryStreamDataType(String name, int sqlType) {
        super(name, sqlType);
    }

    @Override
    public Object getSqlValue(int column, ResultSet resultSet) throws SQLException, TypeCastException {
        InputStream in;
        if (logger.isDebugEnabled()) {
            logger.debug("getSqlValue(column={}, resultSet={}) - start", (Object)new Integer(column), (Object)resultSet);
        }
        if ((in = resultSet.getBinaryStream(column)) == null || resultSet.wasNull()) {
            return null;
        }
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            byte[] buffer = new byte[32];
            int length = in.read(buffer);
            while (length != -1) {
                out.write(buffer, 0, length);
                length = in.read(buffer);
            }
            return out.toByteArray();
        }
        catch (IOException e) {
            throw new TypeCastException(e);
        }
    }

    @Override
    public void setSqlValue(Object value, int column, PreparedStatement statement) throws SQLException, TypeCastException {
        if (logger.isDebugEnabled()) {
            logger.debug("setSqlValue(value={}, column={}, statement={}) - start", new Object[]{value, new Integer(column), statement});
        }
        byte[] bytes = (byte[])this.typeCast(value);
        if (value == null || bytes == null) {
            logger.debug("Setting SQL column value to <null>");
            statement.setNull(column, this.getSqlType());
        } else {
            ByteArrayInputStream in = new ByteArrayInputStream(bytes);
            statement.setBinaryStream(column, (InputStream)in, bytes.length);
        }
    }
}

