/*
 * Decompiled with CFR 0.152.
 */
package akka.remote.artery.compress;

import akka.actor.Address;
import akka.event.Logging$;
import akka.event.LoggingAdapter;
import akka.remote.artery.ArterySettings;
import akka.remote.artery.InboundContext;
import akka.remote.artery.OutboundContext;
import akka.remote.artery.compress.CompressionTable;
import akka.remote.artery.compress.CountMinSketch;
import akka.remote.artery.compress.DecompressionTable;
import akka.remote.artery.compress.DecompressionTable$;
import akka.remote.artery.compress.InboundCompression$;
import akka.remote.artery.compress.InboundCompression$Tables$;
import akka.remote.artery.compress.TopHeavyHitters;
import akka.remote.artery.compress.UnknownCompressedIdException;
import akka.util.OptionVal;
import akka.util.OptionVal$;
import java.io.Serializable;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Builder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\r\u0015uA\u0002\"D\u0011\u000395J\u0002\u0004N\u0007\"\u0005qI\u0014\u0005\u0006+\u0006!\ta\u0016\u0005\b1\u0006\u0011\r\u0011\"\u0002Z\u0011\u0019a\u0016\u0001)A\u00075\u001e)Q,\u0001E\u0001=\u001a)\u0001-\u0001E\u0001C\")QK\u0002C\u0001U\")1N\u0002C\u0001Y\"I!\u0011\u0005\u0004\u0002\u0002\u0013\u0005%1\u0005\u0005\n\u0005\u007f1\u0011\u0011!CA\u0005\u0003B\u0011Ba\u0018\u0007\u0003\u0003%IA!\u0019\u0007\t\u0001\f!i\u001c\u0005\n\u007f2\u0011)\u001a!C\u0001\u0003\u0003A!\"!\n\r\u0005#\u0005\u000b\u0011BA\u0002\u0011)\t9\u0003\u0004BK\u0002\u0013\u0005\u0011\u0011\u0006\u0005\u000b\u0003Wa!\u0011#Q\u0001\n\u0005%\u0001BCA\u0017\u0019\tU\r\u0011\"\u0001\u0002*!Q\u0011q\u0006\u0007\u0003\u0012\u0003\u0006I!!\u0003\t\u0015\u0005EBB!f\u0001\n\u0003\t\u0019\u0004\u0003\u0006\u0002B1\u0011\t\u0012)A\u0005\u0003kA!\"a\u0011\r\u0005+\u0007I\u0011AA#\u0011)\ti\u0005\u0004B\tB\u0003%\u0011q\t\u0005\u0007+2!\t!a\u0014\t\u000f\u0005uC\u0002\"\u0001\u0002`!9\u0011\u0011\u000f\u0007\u0005\u0002\u0005M\u0004\"CA;\u0019\u0005\u0005I\u0011AA<\u0011%\t\u0019\nDI\u0001\n\u0003\t)\nC\u0005\u000202\t\n\u0011\"\u0001\u00022\"I\u0011\u0011\u0018\u0007\u0012\u0002\u0013\u0005\u00111\u0018\u0005\n\u0003\u007fc\u0011\u0013!C\u0001\u0003\u0003D\u0011\"!3\r#\u0003%\t!a3\t\u0013\u0005MG\"!A\u0005B\u0005U\u0007\"CAr\u0019\u0005\u0005I\u0011AA#\u0011%\t)\u000fDA\u0001\n\u0003\t9\u000fC\u0005\u0002n2\t\t\u0011\"\u0011\u0002p\"I\u0011Q \u0007\u0002\u0002\u0013\u0005\u0011q \u0005\n\u0005\u0013a\u0011\u0011!C!\u0005\u0017A\u0011Ba\u0004\r\u0003\u0003%\tE!\u0005\t\u0013\tMA\"!A\u0005B\tU\u0001\"\u0003B\f\u0019\u0005\u0005I\u0011\tB\r\r\u001di5)!\u0001H\u0005SB!B!\u001c*\u0005\u000b\u0007I\u0011\u0001B8\u0011)\u0011i(\u000bB\u0001B\u0003%!\u0011\u000f\u0005\u000b\u0005\u007fJ#Q1A\u0005\u0002\t\u0005\u0005B\u0003BJS\t\u0005\t\u0015!\u0003\u0003\u0004\"Q!QS\u0015\u0003\u0006\u0004%\tAa&\t\u0015\t}\u0015F!A!\u0002\u0013\u0011I\n\u0003\u0006\u0003\"&\u0012\t\u0011)A\u0005\u0005GC!B!+*\u0005\u000b\u0007I\u0011\u0001BV\u0011)\u0011y,\u000bB\u0001B\u0003%!Q\u0016\u0005\u0007+&\"\tA!1\t\u0011\t=\u0017\u0006)Q\u0005\u0005#D\u0001B!6*A\u0003&!\u0011\u0001\u0005\t\u0005?L\u0003\u0015)\u0003\u0002H!A!\u0011]\u0015!\u0002\u0013\t9\u0005\u0003\u0005\u0003d&\u0002\u000b\u0011\u0002Bs\u0011\u001d\u0011Y/\u000bD\u0001\u0005[DqAa@*\t\u000b\u0019\t\u0001C\u0004\u0004\u0016%\")aa\u0006\t\u000f\r\u001d\u0012\u0006\"\u0001\u0004*!911J\u0015\u0005\n\r5\u0003\u0002CB+S\u0011\u0005qia\u0016\t\u000f\re\u0013F\"\u0005\u0004\\!91QN\u0015\u0005\n\r=\u0004b\u0002B\nS\u0011\u00053QO\u0001\u0013\u0013:\u0014w.\u001e8e\u0007>l\u0007O]3tg&|gN\u0003\u0002E\u000b\u0006A1m\\7qe\u0016\u001c8O\u0003\u0002G\u000f\u00061\u0011M\u001d;fefT!\u0001S%\u0002\rI,Wn\u001c;f\u0015\u0005Q\u0015\u0001B1lW\u0006\u0004\"\u0001T\u0001\u000e\u0003\r\u0013!#\u00138c_VtGmQ8naJ,7o]5p]N\u0011\u0011a\u0014\t\u0003!Nk\u0011!\u0015\u0006\u0002%\u0006)1oY1mC&\u0011A+\u0015\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?\u0007\u0001!\u0012aS\u0001\u0014\u0017\u0016,\u0007o\u00147e)\u0006\u0014G.Z:Ok6\u0014WM]\u000b\u00025>\t1,H\u0001\u0004\u0003QYU-\u001a9PY\u0012$\u0016M\u00197fg:+XNY3sA\u00051A+\u00192mKN\u0004\"a\u0018\u0004\u000e\u0003\u0005\u0011a\u0001V1cY\u0016\u001c8c\u0001\u0004PEB\u00111\r[\u0007\u0002I*\u0011QMZ\u0001\u0003S>T\u0011aZ\u0001\u0005U\u00064\u0018-\u0003\u0002jI\na1+\u001a:jC2L'0\u00192mKR\ta,A\u0003f[B$\u00180F\u0002n\u0005?)\u0012A\u001c\t\u0005?2\u0011i\"F\u0002q\u0003'\u0019B\u0001D(riB\u0011\u0001K]\u0005\u0003gF\u0013q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002v{:\u0011ao\u001f\b\u0003ojl\u0011\u0001\u001f\u0006\u0003sZ\u000ba\u0001\u0010:p_Rt\u0014\"\u0001*\n\u0005q\f\u0016a\u00029bG.\fw-Z\u0005\u0003SzT!\u0001`)\u0002\u0013=dG\rV1cY\u0016\u001cXCAA\u0002!\u0015)\u0018QAA\u0005\u0013\r\t9A \u0002\u0005\u0019&\u001cH\u000fE\u0003M\u0003\u0017\ty!C\u0002\u0002\u000e\r\u0013!\u0003R3d_6\u0004(/Z:tS>tG+\u00192mKB!\u0011\u0011CA\n\u0019\u0001!q!!\u0006\r\u0005\u0004\t9BA\u0001U#\u0011\tI\"a\b\u0011\u0007A\u000bY\"C\u0002\u0002\u001eE\u0013qAT8uQ&tw\rE\u0002Q\u0003CI1!a\tR\u0005\r\te._\u0001\u000b_2$G+\u00192mKN\u0004\u0013aC1di&4X\rV1cY\u0016,\"!!\u0003\u0002\u0019\u0005\u001cG/\u001b<f)\u0006\u0014G.\u001a\u0011\u0002\u00139,\u0007\u0010\u001e+bE2,\u0017A\u00038fqR$\u0016M\u00197fA\u00059\u0012\r\u001a<feRL7/Z7f]RLe\u000e\u0015:pOJ,7o]\u000b\u0003\u0003k\u0001R\u0001UA\u001c\u0003wI1!!\u000fR\u0005\u0019y\u0005\u000f^5p]B)A*!\u0010\u0002\u0010%\u0019\u0011qH\"\u0003!\r{W\u000e\u001d:fgNLwN\u001c+bE2,\u0017\u0001G1em\u0016\u0014H/[:f[\u0016tG/\u00138Qe><'/Z:tA\u0005i1.Z3q\u001f2$G+\u00192mKN,\"!a\u0012\u0011\u0007A\u000bI%C\u0002\u0002LE\u00131!\u00138u\u00039YW-\u001a9PY\u0012$\u0016M\u00197fg\u0002\"B\"!\u0015\u0002T\u0005U\u0013qKA-\u00037\u0002Ba\u0018\u0007\u0002\u0010!1qp\u0006a\u0001\u0003\u0007Aq!a\n\u0018\u0001\u0004\tI\u0001C\u0004\u0002.]\u0001\r!!\u0003\t\u000f\u0005Er\u00031\u0001\u00026!9\u00111I\fA\u0002\u0005\u001d\u0013aC:fY\u0016\u001cG\u000fV1cY\u0016$B!!\u0019\u0002nA1\u00111MA5\u0003\u0013i!!!\u001a\u000b\u0007\u0005\u001d\u0014*\u0001\u0003vi&d\u0017\u0002BA6\u0003K\u0012\u0011b\u00149uS>tg+\u00197\t\u000f\u0005=\u0004\u00041\u0001\u0002H\u00059a/\u001a:tS>t\u0017aE:uCJ$Xk]5oO:+\u0007\u0010\u001e+bE2,GCAA)\u0003\u0011\u0019w\u000e]=\u0016\t\u0005e\u0014q\u0010\u000b\r\u0003w\n\t)a\"\u0002\n\u0006-\u0015\u0011\u0013\t\u0005?2\ti\b\u0005\u0003\u0002\u0012\u0005}DaBA\u000b5\t\u0007\u0011q\u0003\u0005\t\u007fj\u0001\n\u00111\u0001\u0002\u0004B)Q/!\u0002\u0002\u0006B)A*a\u0003\u0002~!I\u0011q\u0005\u000e\u0011\u0002\u0003\u0007\u0011Q\u0011\u0005\n\u0003[Q\u0002\u0013!a\u0001\u0003\u000bC\u0011\"!\r\u001b!\u0003\u0005\r!!$\u0011\u000bA\u000b9$a$\u0011\u000b1\u000bi$! \t\u0013\u0005\r#\u0004%AA\u0002\u0005\u001d\u0013AD2paf$C-\u001a4bk2$H%M\u000b\u0005\u0003/\u000bi+\u0006\u0002\u0002\u001a*\"\u00111AANW\t\ti\n\u0005\u0003\u0002 \u0006%VBAAQ\u0015\u0011\t\u0019+!*\u0002\u0013Ut7\r[3dW\u0016$'bAAT#\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005-\u0016\u0011\u0015\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,GaBA\u000b7\t\u0007\u0011qC\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\u0011\t\u0019,a.\u0016\u0005\u0005U&\u0006BA\u0005\u00037#q!!\u0006\u001d\u0005\u0004\t9\"\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001a\u0016\t\u0005M\u0016Q\u0018\u0003\b\u0003+i\"\u0019AA\f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIQ*B!a1\u0002HV\u0011\u0011Q\u0019\u0016\u0005\u0003k\tY\nB\u0004\u0002\u0016y\u0011\r!a\u0006\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%kU!\u0011QZAi+\t\tyM\u000b\u0003\u0002H\u0005mEaBA\u000b?\t\u0007\u0011qC\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005]\u0007\u0003BAm\u0003?l!!a7\u000b\u0007\u0005ug-\u0001\u0003mC:<\u0017\u0002BAq\u00037\u0014aa\u0015;sS:<\u0017\u0001\u00049s_\u0012,8\r^!sSRL\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003?\tI\u000fC\u0005\u0002l\n\n\t\u00111\u0001\u0002H\u0005\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!!=\u0011\r\u0005M\u0018\u0011`A\u0010\u001b\t\t)PC\u0002\u0002xF\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\tY0!>\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0005\u0003\u00119\u0001E\u0002Q\u0005\u0007I1A!\u0002R\u0005\u001d\u0011un\u001c7fC:D\u0011\"a;%\u0003\u0003\u0005\r!a\b\u0002%A\u0014x\u000eZ;di\u0016cW-\\3oi:\u000bW.\u001a\u000b\u0005\u0003/\u0014i\u0001C\u0005\u0002l\u0016\n\t\u00111\u0001\u0002H\u0005A\u0001.Y:i\u0007>$W\r\u0006\u0002\u0002H\u0005AAo\\*ue&tw\r\u0006\u0002\u0002X\u00061Q-];bYN$BA!\u0001\u0003\u001c!I\u00111\u001e\u0015\u0002\u0002\u0003\u0007\u0011q\u0004\t\u0005\u0003#\u0011y\u0002B\u0004\u0002\u0016!\u0011\r!a\u0006\u0002\u000b\u0005\u0004\b\u000f\\=\u0016\t\t\u0015\"1\u0006\u000b\r\u0005O\u0011iCa\r\u00036\t]\"Q\b\t\u0005?2\u0011I\u0003\u0005\u0003\u0002\u0012\t-BaBA\u000b\u0013\t\u0007\u0011q\u0003\u0005\u0007\u007f&\u0001\rAa\f\u0011\u000bU\f)A!\r\u0011\u000b1\u000bYA!\u000b\t\u000f\u0005\u001d\u0012\u00021\u0001\u00032!9\u0011QF\u0005A\u0002\tE\u0002bBA\u0019\u0013\u0001\u0007!\u0011\b\t\u0006!\u0006]\"1\b\t\u0006\u0019\u0006u\"\u0011\u0006\u0005\b\u0003\u0007J\u0001\u0019AA$\u0003\u001d)h.\u00199qYf,BAa\u0011\u0003TQ!!Q\tB-!\u0015\u0001\u0016q\u0007B$!5\u0001&\u0011\nB'\u0005\u001f\u0012yE!\u0016\u0002H%\u0019!1J)\u0003\rQ+\b\u000f\\36!\u0015)\u0018Q\u0001B(!\u0015a\u00151\u0002B)!\u0011\t\tBa\u0015\u0005\u000f\u0005U!B1\u0001\u0002\u0018A)\u0001+a\u000e\u0003XA)A*!\u0010\u0003R!I!1\f\u0006\u0002\u0002\u0003\u0007!QL\u0001\u0004q\u0012\u0002\u0004\u0003B0\r\u0005#\nAb\u001e:ji\u0016\u0014V\r\u001d7bG\u0016$\"Aa\u0019\u0011\t\u0005e'QM\u0005\u0005\u0005O\nYN\u0001\u0004PE*,7\r^\u000b\u0005\u0005W\u0012)l\u0005\u0002*\u001f\u0006\u0019An\\4\u0016\u0005\tE\u0004\u0003\u0002B:\u0005sj!A!\u001e\u000b\u0007\t]\u0014*A\u0003fm\u0016tG/\u0003\u0003\u0003|\tU$A\u0004'pO\u001eLgnZ!eCB$XM]\u0001\u0005Y><\u0007%\u0001\u0005tKR$\u0018N\\4t+\t\u0011\u0019\t\u0005\u0003\u0003\u0006\n5e\u0002\u0002BD\u0005\u0013k\u0011!R\u0005\u0004\u0005\u0017+\u0015AD!si\u0016\u0014\u0018pU3ui&twm]\u0005\u0005\u0005\u001f\u0013\tJA\u0006D_6\u0004(/Z:tS>t'b\u0001BF\u000b\u0006I1/\u001a;uS:<7\u000fI\u0001\n_JLw-\u001b8VS\u0012,\"A!'\u0011\u0007A\u0013Y*C\u0002\u0003\u001eF\u0013A\u0001T8oO\u0006QqN]5hS:,\u0016\u000e\u001a\u0011\u0002\u001d%t'm\\;oI\u000e{g\u000e^3yiB!!q\u0011BS\u0013\r\u00119+\u0012\u0002\u000f\u0013:\u0014w.\u001e8e\u0007>tG/\u001a=u\u00031AW-\u0019<z\u0011&$H/\u001a:t+\t\u0011i\u000bE\u0003M\u0005_\u0013\u0019,C\u0002\u00032\u000e\u0013q\u0002V8q\u0011\u0016\fg/\u001f%jiR,'o\u001d\t\u0005\u0003#\u0011)\fB\u0004\u0002\u0016%\u0012\rAa.\u0012\t\te\u0016q\u0004\t\u0004!\nm\u0016b\u0001B_#\n!a*\u001e7m\u00035AW-\u0019<z\u0011&$H/\u001a:tAQa!1\u0019Bc\u0005\u000f\u0014IMa3\u0003NB!A*\u000bBZ\u0011\u001d\u0011ig\ra\u0001\u0005cBqAa 4\u0001\u0004\u0011\u0019\tC\u0004\u0003\u0016N\u0002\rA!'\t\u000f\t\u00056\u00071\u0001\u0003$\"9!\u0011V\u001aA\u0002\t5\u0016A\u0002;bE2,7\u000fE\u0003\u0003T2\u0011\u0019L\u0004\u0002M\u0001\u0005)\u0011\r\\5wK\"\u001aQG!7\u0011\u0007A\u0013Y.C\u0002\u0003^F\u0013\u0001B^8mCRLG.Z\u0001\fe\u0016\u001cXM\u001c3D_VtG/\u0001\bnCb\u0014Vm]3oI\u000e{WO\u001c;\u0002\u0007\rl7\u000fE\u0002M\u0005OL1A!;D\u00059\u0019u.\u001e8u\u001b&t7k[3uG\"\f!\u0002Z3d_6\u0004(/Z:t)\u0019\u0011yO!=\u0003|B1\u00111MA5\u0005gCqAa=:\u0001\u0004\u0011)0\u0001\u000bj]\u000e|W.\u001b8h)\u0006\u0014G.\u001a,feNLwN\u001c\t\u0004!\n]\u0018b\u0001B}#\n!!)\u001f;f\u0011\u001d\u0011i0\u000fa\u0001\u0003\u000f\n1!\u001b3y\u0003I!WmY8naJ,7o]%oi\u0016\u0014h.\u00197\u0015\u0011\t=81AB\u0003\u0007\u000fAqAa=;\u0001\u0004\u0011)\u0010C\u0004\u0003~j\u0002\r!a\u0012\t\u000f\r%!\b1\u0001\u0002H\u0005q\u0011\r\u001e;f[B$8i\\;oi\u0016\u0014\bf\u0001\u001e\u0004\u000eA!1qBB\t\u001b\t\t)+\u0003\u0003\u0004\u0014\u0005\u0015&a\u0002;bS2\u0014XmY\u0001\u0015G>tg-\u001b:n\u0003\u00124XM\u001d;jg\u0016lWM\u001c;\u0015\r\re1qDB\u0012!\r\u000161D\u0005\u0004\u0007;\t&\u0001B+oSRDqa!\t<\u0001\u0004\u0011)0\u0001\u0007uC\ndWMV3sg&|g\u000eC\u0004\u0004&m\u0002\rA!\u0001\u0002\r\u001d\fg/Z+q\u0003%Ign\u0019:f[\u0016tG\u000f\u0006\u0005\u0004\u001a\r-21IB$\u0011\u001d\u0019i\u0003\u0010a\u0001\u0007_\tQB]3n_R,\u0017\t\u001a3sKN\u001c\b\u0003BB\u0019\u0007oi!aa\r\u000b\u0007\rU\u0012*A\u0003bGR|'/\u0003\u0003\u0004:\rM\"aB!eIJ,7o\u001d\u0015\u0005\u0007W\u0019i\u0004\u0005\u0003\u0002d\r}\u0012\u0002BB!\u0003K\u0012a!\u001e8vg\u0016$\u0007bBB#y\u0001\u0007!1W\u0001\u0006m\u0006dW/\u001a\u0005\b\u0007\u0013b\u0004\u0019\u0001BM\u0003\u0005q\u0017\u0001I1eI\u0006sGm\u00115fG.Le\r[3bmfD\u0015\u000e\u001e;fe\u0012+G/Z2uK\u0012$bA!\u0001\u0004P\rE\u0003bBB#{\u0001\u0007!1\u0017\u0005\b\u0007'j\u0004\u0019\u0001BM\u0003\u0015\u0019w.\u001e8u\u0003e\u0011XO\u001c(fqR$\u0016M\u00197f\u0003\u00124XM\u001d;jg\u0016lWM\u001c;\u0015\u0005\re\u0011!G1em\u0016\u0014H/[:f\u0007>l\u0007O]3tg&|g\u000eV1cY\u0016$ba!\u0007\u0004^\r\u001d\u0004bBB0\u007f\u0001\u00071\u0011M\u0001\fCN\u001cxnY5bi&|g\u000e\u0005\u0003\u0003\b\u000e\r\u0014bAB3\u000b\nyq*\u001e;c_VtGmQ8oi\u0016DH\u000fC\u0004\u0004j}\u0002\raa\u001b\u0002\u000bQ\f'\r\\3\u0011\u000b1\u000biDa-\u0002?A\u0014X\r]1sK\u000e{W\u000e\u001d:fgNLwN\\!em\u0016\u0014H/[:f[\u0016tG\u000f\u0006\u0003\u0004l\rE\u0004bBB:\u0001\u0002\u0007!Q_\u0001\u0011]\u0016DH\u000fV1cY\u00164VM]:j_:$\"aa\u001e\u0011\t\re4\u0011\u0011\b\u0005\u0007w\u001ai\b\u0005\u0002x#&\u00191qP)\u0002\rA\u0013X\rZ3g\u0013\u0011\t\toa!\u000b\u0007\r}\u0014\u000b")
public abstract class InboundCompression<T> {
    private final LoggingAdapter log;
    private final ArterySettings.Compression settings;
    private final long originUid;
    private final InboundContext inboundContext;
    private final TopHeavyHitters<T> heavyHitters;
    private Tables<T> tables;
    private volatile boolean alive;
    private int resendCount;
    private final int maxResendCount;
    private final CountMinSketch cms;

    public static int KeepOldTablesNumber() {
        return InboundCompression$.MODULE$.KeepOldTablesNumber();
    }

    public LoggingAdapter log() {
        return this.log;
    }

    public ArterySettings.Compression settings() {
        return this.settings;
    }

    public long originUid() {
        return this.originUid;
    }

    public TopHeavyHitters<T> heavyHitters() {
        return this.heavyHitters;
    }

    public abstract T decompress(byte var1, int var2);

    public final T decompressInternal(byte incomingTableVersion, int idx, int attemptCounter) {
        Object object;
        block5: {
            Object object2;
            block6: {
                byte activeVersion;
                Tables<T> current;
                while (true) {
                    DecompressionTable decompressionTable;
                    if (attemptCounter > 2) {
                        throw new IllegalStateException(new StringBuilder(52).append("Unable to decompress ").append(idx).append(" from table ").append(incomingTableVersion).append(". Internal tables: ").append(this.tables).toString());
                    }
                    current = this.tables;
                    activeVersion = current.activeTable().version();
                    if (incomingTableVersion == DecompressionTable$.MODULE$.DisabledVersion()) {
                        OptionVal$.MODULE$.None();
                        object = null;
                        break block5;
                    }
                    DecompressionTable<T> decompressionTable2 = current.selectTable(incomingTableVersion);
                    if (new OptionVal(decompressionTable2) != null && !OptionVal$.MODULE$.isEmpty$extension((Object)(decompressionTable = (DecompressionTable)OptionVal.Some$.MODULE$.unapply(decompressionTable2)))) {
                        DecompressionTable selectedTable = (DecompressionTable)OptionVal$.MODULE$.get$extension((Object)decompressionTable);
                        Object value = selectedTable.get(idx);
                        if (value == null) {
                            throw new UnknownCompressedIdException(idx);
                        }
                        object2 = OptionVal.Some$.MODULE$.apply(value);
                        break block6;
                    }
                    if (!InboundCompression.incomingVersionIsAdvertisementInProgress$1(incomingTableVersion, current)) break;
                    this.log().debug("Received first value from originUid [{}] compressed using the advertised compression table, flipping to it (version: {})", (Object)BoxesRunTime.boxToLong((long)this.originUid()), (Object)BoxesRunTime.boxToByte((byte)current.nextTable().version()));
                    this.confirmAdvertisement(incomingTableVersion, false);
                    ++attemptCounter;
                }
                this.log().warning("Inbound message from originUid [{}] is using unknown compression table version. It may have been sent with compression table built for previous incarnation of this system. Versions activeTable: {}, nextTable: {}, incomingTable: {}", (Object)BoxesRunTime.boxToLong((long)this.originUid()), (Object)BoxesRunTime.boxToByte((byte)activeVersion), (Object)BoxesRunTime.boxToByte((byte)current.nextTable().version()), (Object)BoxesRunTime.boxToByte((byte)incomingTableVersion));
                OptionVal$.MODULE$.None();
                object2 = null;
            }
            object = object2;
        }
        return (T)object;
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void confirmAdvertisement(byte tableVersion, boolean gaveUp) {
        CompressionTable inProgress;
        boolean bl = false;
        Some some = null;
        Option<CompressionTable<T>> option = this.tables.advertisementInProgress();
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            CompressionTable inProgress2 = (CompressionTable)some.value();
            if (tableVersion == inProgress2.version()) {
                this.tables = this.tables.startUsingNextTable();
                this.log().debug("{} compression table version [{}] for originUid [{}]", (Object)(gaveUp ? "Gave up" : "Confirmed"), (Object)BoxesRunTime.boxToByte((byte)tableVersion), (Object)BoxesRunTime.boxToLong((long)this.originUid()));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        if (bl && tableVersion != (inProgress = (CompressionTable)some.value()).version()) {
            this.log().debug("{} compression table version [{}] for originUid [{}] but other version in progress [{}]", (Object)(gaveUp ? "Gave up" : "Confirmed"), (Object)BoxesRunTime.boxToByte((byte)tableVersion), (Object)BoxesRunTime.boxToLong((long)this.originUid()), (Object)BoxesRunTime.boxToByte((byte)inProgress.version()));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        if (!None$.MODULE$.equals(option)) throw new MatchError(option);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public void increment(Address remoteAddress, T value, long n) {
        long count = this.cms.addObjectAndEstimateCount(value, n);
        this.addAndCheckIfheavyHitterDetected(value, count);
        this.alive = true;
    }

    private boolean addAndCheckIfheavyHitterDetected(T value, long count) {
        return this.heavyHitters().update(value, count);
    }

    public void runNextTableAdvertisement() {
        Option<CompressionTable<T>> option = this.tables.advertisementInProgress();
        if (None$.MODULE$.equals(option)) {
            OutboundContext outboundContext;
            OutboundContext outboundContext2 = this.inboundContext.association(this.originUid());
            if (new OptionVal((Object)outboundContext2) != null && !OptionVal$.MODULE$.isEmpty$extension((Object)(outboundContext = (OutboundContext)OptionVal.Some$.MODULE$.unapply((Object)outboundContext2)))) {
                BoxedUnit boxedUnit;
                OutboundContext association = (OutboundContext)OptionVal$.MODULE$.get$extension((Object)outboundContext);
                if (this.alive && association.isOrdinaryMessageStreamActive()) {
                    CompressionTable<T> table = this.prepareCompressionAdvertisement(this.tables.nextTable().version());
                    Tables<T> qual$1 = this.tables;
                    DecompressionTable<T> x$1 = table.invert();
                    Some x$2 = new Some(table);
                    List<DecompressionTable<T>> x$3 = qual$1.copy$default$1();
                    DecompressionTable<T> x$4 = qual$1.copy$default$2();
                    int x$5 = qual$1.copy$default$5();
                    Tables<T> nextState = qual$1.copy(x$3, x$4, x$1, (Option<CompressionTable<T>>)x$2, x$5);
                    this.tables = nextState;
                    this.alive = false;
                    this.resendCount = 0;
                    this.advertiseCompressionTable(association, table);
                    boxedUnit = BoxedUnit.UNIT;
                } else if (association.isOrdinaryMessageStreamActive()) {
                    this.log().debug("{} for originUid [{}] not changed, no need to advertise same.", (Object)Logging$.MODULE$.simpleName(this.tables.activeTable()), (Object)BoxesRunTime.boxToLong((long)this.originUid()));
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit2 = boxedUnit;
            } else {
                OptionVal$.MODULE$.None();
                OutboundContext outboundContext3 = outboundContext2;
                if (!(null != null ? !((Object)null).equals(outboundContext3) : outboundContext3 != null)) {
                    this.log().debug("No Association for originUid [{}] yet, unable to advertise compression table.", (Object)BoxesRunTime.boxToLong((long)this.originUid()));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    throw new MatchError((Object)new OptionVal((Object)outboundContext2));
                }
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (option instanceof Some) {
            BoxedUnit boxedUnit;
            Some some = (Some)option;
            CompressionTable inProgress = (CompressionTable)some.value();
            ++this.resendCount;
            if (this.resendCount <= this.maxResendCount) {
                OutboundContext outboundContext;
                OutboundContext outboundContext4 = this.inboundContext.association(this.originUid());
                if (new OptionVal((Object)outboundContext4) != null && !OptionVal$.MODULE$.isEmpty$extension((Object)(outboundContext = (OutboundContext)OptionVal.Some$.MODULE$.unapply((Object)outboundContext4)))) {
                    OutboundContext association = (OutboundContext)OptionVal$.MODULE$.get$extension((Object)outboundContext);
                    this.log().debug("Advertisement in progress for originUid [{}] version [{}], resending [{}:{}]", (Object)BoxesRunTime.boxToLong((long)this.originUid()), (Object)BoxesRunTime.boxToByte((byte)inProgress.version()), (Object)BoxesRunTime.boxToInteger((int)this.resendCount), (Object)BoxesRunTime.boxToInteger((int)this.maxResendCount));
                    this.advertiseCompressionTable(association, inProgress);
                    BoxedUnit boxedUnit3 = BoxedUnit.UNIT;
                } else {
                    OptionVal$.MODULE$.None();
                    OutboundContext outboundContext5 = outboundContext4;
                    if (!(null != null ? !((Object)null).equals(outboundContext5) : outboundContext5 != null)) {
                        BoxedUnit boxedUnit4 = BoxedUnit.UNIT;
                    } else {
                        throw new MatchError((Object)new OptionVal((Object)outboundContext4));
                    }
                }
                boxedUnit = BoxedUnit.UNIT;
            } else {
                this.log().debug("Advertisement in progress for originUid [{}] version [{}] but no confirmation after retries.", (Object)BoxesRunTime.boxToLong((long)this.originUid()), (Object)BoxesRunTime.boxToByte((byte)inProgress.version()));
                this.confirmAdvertisement(inProgress.version(), true);
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit5 = boxedUnit;
        } else {
            throw new MatchError(option);
        }
    }

    public abstract void advertiseCompressionTable(OutboundContext var1, CompressionTable<T> var2);

    private CompressionTable<T> prepareCompressionAdvertisement(byte nextTableVersion) {
        Builder mb = Predef$.MODULE$.Map().newBuilder();
        mb.$plus$plus$eq((IterableOnce)this.heavyHitters().iterator().zipWithIndex());
        Map mappings = (Map)mb.result();
        return new CompressionTable(this.originUid(), nextTableVersion, mappings);
    }

    public String toString() {
        return new StringBuilder(34).append(Logging$.MODULE$.simpleName(this.getClass())).append("(countMinSketch: ").append(this.cms).append(", heavyHitters: ").append(this.heavyHitters()).append(")").toString();
    }

    private static final boolean incomingVersionIsAdvertisementInProgress$1(byte incomingTableVersion, Tables current$1) {
        return current$1.advertisementInProgress().isDefined() && incomingTableVersion == ((CompressionTable)current$1.advertisementInProgress().get()).version();
    }

    public InboundCompression(LoggingAdapter log, ArterySettings.Compression settings, long originUid, InboundContext inboundContext, TopHeavyHitters<T> heavyHitters) {
        this.log = log;
        this.settings = settings;
        this.originUid = originUid;
        this.inboundContext = inboundContext;
        this.heavyHitters = heavyHitters;
        this.tables = InboundCompression$Tables$.MODULE$.empty();
        this.alive = true;
        this.resendCount = 0;
        this.maxResendCount = 3;
        this.cms = new CountMinSketch(16, 1024, (int)System.currentTimeMillis());
        log.debug("Initializing {} for originUid [{}]", (Object)Logging$.MODULE$.simpleName(this.getClass()), (Object)BoxesRunTime.boxToLong((long)originUid));
    }

    public static final class Tables<T>
    implements Product,
    Serializable {
        private final List<DecompressionTable<T>> oldTables;
        private final DecompressionTable<T> activeTable;
        private final DecompressionTable<T> nextTable;
        private final Option<CompressionTable<T>> advertisementInProgress;
        private final int keepOldTables;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public List<DecompressionTable<T>> oldTables() {
            return this.oldTables;
        }

        public DecompressionTable<T> activeTable() {
            return this.activeTable;
        }

        public DecompressionTable<T> nextTable() {
            return this.nextTable;
        }

        public Option<CompressionTable<T>> advertisementInProgress() {
            return this.advertisementInProgress;
        }

        public int keepOldTables() {
            return this.keepOldTables;
        }

        /*
         * WARNING - void declaration
         */
        public DecompressionTable<T> selectTable(int version) {
            DecompressionTable decompressionTable;
            if (this.activeTable().version() == version) {
                decompressionTable = (DecompressionTable)OptionVal.Some$.MODULE$.apply(this.activeTable());
            } else {
                void var2_2;
                DecompressionTable found = this.find$1(this.oldTables(), version);
                decompressionTable = var2_2;
            }
            return decompressionTable;
        }

        public Tables<T> startUsingNextTable() {
            DecompressionTable<T> decompressionTable = this.activeTable();
            DecompressionTable qual$1 = DecompressionTable$.MODULE$.empty();
            byte x$1 = Tables.incrementTableVersion$1(this.nextTable().version());
            long x$2 = qual$1.copy$default$1();
            Object x$3 = qual$1.copy$default$3();
            return new Tables<T>(this.oldTables().$colon$colon(decompressionTable).take(this.keepOldTables()), this.nextTable(), qual$1.copy(x$2, x$1, x$3), None$.MODULE$, this.keepOldTables());
        }

        public <T> Tables<T> copy(List<DecompressionTable<T>> oldTables, DecompressionTable<T> activeTable, DecompressionTable<T> nextTable, Option<CompressionTable<T>> advertisementInProgress, int keepOldTables) {
            return new Tables<T>(oldTables, activeTable, nextTable, advertisementInProgress, keepOldTables);
        }

        public <T> List<DecompressionTable<T>> copy$default$1() {
            return this.oldTables();
        }

        public <T> DecompressionTable<T> copy$default$2() {
            return this.activeTable();
        }

        public <T> DecompressionTable<T> copy$default$3() {
            return this.nextTable();
        }

        public <T> Option<CompressionTable<T>> copy$default$4() {
            return this.advertisementInProgress();
        }

        public <T> int copy$default$5() {
            return this.keepOldTables();
        }

        public String productPrefix() {
            return "Tables";
        }

        public int productArity() {
            return 5;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.oldTables();
                    break;
                }
                case 1: {
                    object = this.activeTable();
                    break;
                }
                case 2: {
                    object = this.nextTable();
                    break;
                }
                case 3: {
                    object = this.advertisementInProgress();
                    break;
                }
                case 4: {
                    object = BoxesRunTime.boxToInteger((int)this.keepOldTables());
                    break;
                }
                default: {
                    object = Statics.ioobe((int)x$1);
                    break;
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof Tables;
        }

        public String productElementName(int x$1) {
            String string;
            int n = x$1;
            switch (n) {
                case 0: {
                    string = "oldTables";
                    break;
                }
                case 1: {
                    string = "activeTable";
                    break;
                }
                case 2: {
                    string = "nextTable";
                    break;
                }
                case 3: {
                    string = "advertisementInProgress";
                    break;
                }
                case 4: {
                    string = "keepOldTables";
                    break;
                }
                default: {
                    string = (String)Statics.ioobe((int)x$1);
                    break;
                }
            }
            return string;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash(this.oldTables()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.activeTable()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.nextTable()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.advertisementInProgress()));
            n = Statics.mix((int)n, (int)this.keepOldTables());
            return Statics.finalizeHash((int)n, (int)5);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof Tables)) return false;
            boolean bl = true;
            if (!bl) return false;
            Tables tables = (Tables)x$1;
            if (this.keepOldTables() != tables.keepOldTables()) return false;
            List<DecompressionTable<T>> list = this.oldTables();
            List<DecompressionTable<T>> list2 = tables.oldTables();
            if (list == null) {
                if (list2 != null) {
                    return false;
                }
            } else if (!list.equals(list2)) return false;
            DecompressionTable<T> decompressionTable = this.activeTable();
            DecompressionTable<T> decompressionTable2 = tables.activeTable();
            if (decompressionTable == null) {
                if (decompressionTable2 != null) {
                    return false;
                }
            } else if (!((Object)decompressionTable).equals(decompressionTable2)) return false;
            DecompressionTable<T> decompressionTable3 = this.nextTable();
            DecompressionTable<T> decompressionTable4 = tables.nextTable();
            if (decompressionTable3 == null) {
                if (decompressionTable4 != null) {
                    return false;
                }
            } else if (!((Object)decompressionTable3).equals(decompressionTable4)) return false;
            Option<CompressionTable<T>> option = this.advertisementInProgress();
            Option<CompressionTable<T>> option2 = tables.advertisementInProgress();
            if (option == null) {
                if (option2 == null) return true;
                return false;
            } else {
                if (!option.equals(option2)) return false;
                return true;
            }
        }

        private final DecompressionTable find$1(List tables, int version$1) {
            DecompressionTable decompressionTable;
            block2: {
                List list;
                block3: {
                    DecompressionTable t;
                    while (true) {
                        if (Nil$.MODULE$.equals(list = tables)) {
                            OptionVal$.MODULE$.None();
                            decompressionTable = null;
                            break block2;
                        }
                        if (!(list instanceof .colon.colon)) break block3;
                        .colon.colon colon2 = (.colon.colon)list;
                        t = (DecompressionTable)colon2.head();
                        List tail = colon2.next$access$1();
                        if (t.version() == version$1) break;
                        tables = tail;
                    }
                    decompressionTable = (DecompressionTable)OptionVal.Some$.MODULE$.apply((Object)t);
                    break block2;
                }
                throw new MatchError((Object)list);
            }
            return decompressionTable;
        }

        private static final byte incrementTableVersion$1(byte version) {
            return version == 127 ? (byte)0 : (byte)(version + 1);
        }

        public Tables(List<DecompressionTable<T>> oldTables, DecompressionTable<T> activeTable, DecompressionTable<T> nextTable, Option<CompressionTable<T>> advertisementInProgress, int keepOldTables) {
            this.oldTables = oldTables;
            this.activeTable = activeTable;
            this.nextTable = nextTable;
            this.advertisementInProgress = advertisementInProgress;
            this.keepOldTables = keepOldTables;
            Product.$init$((Product)this);
        }
    }
}

