/*
 * Decompiled with CFR 0.152.
 */
package akka.stream.impl.io;

import akka.annotation.InternalApi;
import akka.stream.impl.io.InputStreamSinkStage;
import akka.stream.impl.io.InputStreamSinkStage$Close$;
import akka.stream.impl.io.InputStreamSinkStage$Finished$;
import akka.stream.impl.io.InputStreamSinkStage$Initialized$;
import akka.stream.impl.io.InputStreamSinkStage$ReadElementAcknowledgement$;
import akka.util.ByteString;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.SeqOps;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0005Uf!B\u000e\u001d\u0001\t\"\u0003\u0002\u0003\u0017\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0018\t\u0011!\u0003!\u0011!Q\u0001\n%C\u0001\"\u0016\u0001\u0003\u0002\u0003\u0006IA\u0016\u0005\u0006;\u0002!\tA\u0018\u0005\bI\u0002\u0001\r\u0011\"\u0001f\u0011\u001dI\u0007\u00011A\u0005\u0002)Da!\u001c\u0001!B\u00131\u0007b\u00028\u0001\u0001\u0004%\t!\u001a\u0005\b_\u0002\u0001\r\u0011\"\u0001q\u0011\u0019\u0011\b\u0001)Q\u0005M\"91\u000f\u0001a\u0001\n\u0003)\u0007b\u0002;\u0001\u0001\u0004%\t!\u001e\u0005\u0007o\u0002\u0001\u000b\u0015\u00024\t\u000ba\u0004A\u0011A=\t\u000fu\u0004\u0001\u0019!C\u0001}\"I\u0011q\u0002\u0001A\u0002\u0013\u0005\u0011\u0011\u0003\u0005\b\u0003+\u0001\u0001\u0015)\u0003\u0000\u0011!\t9\u0002\u0001Q\u0005\n\u0005e\u0001bBA$\u0001\u0011\u0005\u0013\u0011\n\u0005\b\u0003\u000f\u0002A\u0011IA*\u0011\u001d\t9\u0005\u0001C!\u0003OB\u0001\"!\u001e\u0001A\u0013%\u0011q\u000f\u0005\b\u0003\u007f\u0002A\u0011IAA\u0011!\t)\t\u0001Q\u0005\n\u0005\u001d\u0005\u0002CAR\u0001\u0001&I!!!\t\u0011\u0005\u0015\u0006\u0001)C\u0005\u0003O\u0013!#\u00138qkR\u001cFO]3b[\u0006#\u0017\r\u001d;fe*\u0011QDH\u0001\u0003S>T!a\b\u0011\u0002\t%l\u0007\u000f\u001c\u0006\u0003C\t\naa\u001d;sK\u0006l'\"A\u0012\u0002\t\u0005\\7.Y\n\u0003\u0001\u0015\u0002\"A\n\u0016\u000e\u0003\u001dR!!\b\u0015\u000b\u0003%\nAA[1wC&\u00111f\n\u0002\f\u0013:\u0004X\u000f^*ue\u0016\fW.\u0001\u0007tQ\u0006\u0014X\r\u001a\"vM\u001a,'o\u0001\u0001\u0011\u0007=\"d'D\u00011\u0015\t\t$'\u0001\u0006d_:\u001cWO\u001d:f]RT!a\r\u0015\u0002\tU$\u0018\u000e\\\u0005\u0003kA\u0012QB\u00117pG.LgnZ)vKV,\u0007CA\u001cF\u001d\tA4I\u0004\u0002:\u0005:\u0011!(\u0011\b\u0003w\u0001s!\u0001P \u000e\u0003uR!AP\u0017\u0002\rq\u0012xn\u001c;?\u0013\u0005\u0019\u0013BA\u0011#\u0013\ty\u0002%\u0003\u0002\u001e=%\u0011A\tH\u0001\u0015\u0013:\u0004X\u000f^*ue\u0016\fWnU5oWN#\u0018mZ3\n\u0005\u0019;%AF*ue\u0016\fW\u000eV8BI\u0006\u0004H/\u001a:NKN\u001c\u0018mZ3\u000b\u0005\u0011c\u0012aC:f]\u0012$vn\u0015;bO\u0016\u0004BAS'P%6\t1JC\u0001M\u0003\u0015\u00198-\u00197b\u0013\tq5JA\u0005Gk:\u001cG/[8ocA\u0011q\u0007U\u0005\u0003#\u001e\u0013Q#\u00113baR,'\u000fV8Ti\u0006<W-T3tg\u0006<W\r\u0005\u0002K'&\u0011Ak\u0013\u0002\u0005+:LG/A\u0006sK\u0006$G+[7f_V$\bCA,\\\u001b\u0005A&BA-[\u0003!!WO]1uS>t'BA\u0019L\u0013\ta\u0006L\u0001\bGS:LG/\u001a#ve\u0006$\u0018n\u001c8\u0002\rqJg.\u001b;?)\u0011y\u0016MY2\u0011\u0005\u0001\u0004Q\"\u0001\u000f\t\u000b1\"\u0001\u0019\u0001\u0018\t\u000b!#\u0001\u0019A%\t\u000bU#\u0001\u0019\u0001,\u0002\u001b%\u001c\u0018J\\5uS\u0006d\u0017N_3e+\u00051\u0007C\u0001&h\u0013\tA7JA\u0004C_>dW-\u00198\u0002#%\u001c\u0018J\\5uS\u0006d\u0017N_3e?\u0012*\u0017\u000f\u0006\u0002SW\"9ANBA\u0001\u0002\u00041\u0017a\u0001=%c\u0005q\u0011n]%oSRL\u0017\r\\5{K\u0012\u0004\u0013\u0001C5t\u0003\u000e$\u0018N^3\u0002\u0019%\u001c\u0018i\u0019;jm\u0016|F%Z9\u0015\u0005I\u000b\bb\u00027\n\u0003\u0003\u0005\rAZ\u0001\nSN\f5\r^5wK\u0002\nA\"[:Ti\u0006<W-\u00117jm\u0016\f\u0001#[:Ti\u0006<W-\u00117jm\u0016|F%Z9\u0015\u0005I3\bb\u00027\r\u0003\u0003\u0005\rAZ\u0001\u000eSN\u001cF/Y4f\u00032Lg/\u001a\u0011\u00023M,(m]2sS\n,'o\u00117pg\u0016$W\t_2faRLwN\\\u000b\u0002uB\u0011ae_\u0005\u0003y\u001e\u00121\"S(Fq\u000e,\u0007\u000f^5p]\u0006iA-\u001a;bG\",Gm\u00115v].,\u0012a \t\u0006\u0015\u0006\u0005\u0011QA\u0005\u0004\u0003\u0007Y%AB(qi&|g\u000e\u0005\u0003\u0002\b\u0005-QBAA\u0005\u0015\t\u0019$%\u0003\u0003\u0002\u000e\u0005%!A\u0003\"zi\u0016\u001cFO]5oO\u0006\tB-\u001a;bG\",Gm\u00115v].|F%Z9\u0015\u0007I\u000b\u0019\u0002C\u0004m!\u0005\u0005\t\u0019A@\u0002\u001d\u0011,G/Y2iK\u0012\u001c\u0005.\u001e8lA\u0005\u0011R\r_3dkR,\u0017J\u001a(pi\u000ecwn]3e+\u0011\tY\"!\t\u0015\t\u0005u\u00111\u0007\t\u0005\u0003?\t\t\u0003\u0004\u0001\u0005\u000f\u0005\r\"C1\u0001\u0002&\t\tA+\u0005\u0003\u0002(\u00055\u0002c\u0001&\u0002*%\u0019\u00111F&\u0003\u000f9{G\u000f[5oOB\u0019!*a\f\n\u0007\u0005E2JA\u0002B]fDq!!\u000e\u0013\u0001\u0004\t9$A\u0001g!\u0015Q\u0015\u0011HA\u000f\u0013\r\tYd\u0013\u0002\n\rVt7\r^5p]BBSAEA \u0003\u000b\u0002BASA!u&\u0019\u00111I&\u0003\rQD'o\\<tG\u0005Q\u0018\u0001\u0002:fC\u0012$\"!a\u0013\u0011\u0007)\u000bi%C\u0002\u0002P-\u00131!\u00138uQ\u0015\u0019\u0012qHA#)\u0011\tY%!\u0016\t\u000f\u0005]C\u00031\u0001\u0002Z\u0005\t\u0011\rE\u0003K\u00037\ny&C\u0002\u0002^-\u0013Q!\u0011:sCf\u00042ASA1\u0013\r\t\u0019g\u0013\u0002\u0005\u0005f$X\rK\u0003\u0015\u0003\u007f\t)\u0005\u0006\u0005\u0002L\u0005%\u00141NA8\u0011\u001d\t9&\u0006a\u0001\u00033Bq!!\u001c\u0016\u0001\u0004\tY%A\u0003cK\u001eLg\u000eC\u0004\u0002rU\u0001\r!a\u0013\u0002\r1,gn\u001a;iQ\u0015)\u0012qHA#\u0003%\u0011X-\u00193CsR,7\u000f\u0006\u0005\u0002L\u0005e\u00141PA?\u0011\u001d\t9F\u0006a\u0001\u00033Bq!!\u001c\u0017\u0001\u0004\tY\u0005C\u0004\u0002rY\u0001\r!a\u0013\u0002\u000b\rdwn]3\u0015\u0003ICSaFA \u0003\u000b\nqaZ3u\t\u0006$\u0018\r\u0006\u0006\u0002L\u0005%\u0015QRAH\u0003#Cq!a#\u0019\u0001\u0004\tI&A\u0002beJDq!!\u001c\u0019\u0001\u0004\tY\u0005C\u0004\u0002ra\u0001\r!a\u0013\t\u000f\u0005M\u0005\u00041\u0001\u0002L\u0005Aqm\u001c;CsR,7\u000fK\u0002\u0019\u0003/\u0003B!!'\u0002 6\u0011\u00111\u0014\u0006\u0004\u0003;[\u0015AC1o]>$\u0018\r^5p]&!\u0011\u0011UAN\u0005\u001d!\u0018-\u001b7sK\u000e\fAc^1ji&3gj\u001c;J]&$\u0018.\u00197ju\u0016$\u0017!D4sC\n$\u0015\r^1DQVt7\u000eF\u0001\u0000Q\r\u0001\u00111\u0016\t\u0005\u0003[\u000b\t,\u0004\u0002\u00020*\u0019\u0011Q\u0014\u0012\n\t\u0005M\u0016q\u0016\u0002\f\u0013:$XM\u001d8bY\u0006\u0003\u0018\u000e")
@InternalApi
public class InputStreamAdapter
extends InputStream {
    private final BlockingQueue<InputStreamSinkStage.StreamToAdapterMessage> sharedBuffer;
    private final Function1<InputStreamSinkStage.AdapterToStageMessage, BoxedUnit> sendToStage;
    private final FiniteDuration readTimeout;
    private boolean isInitialized;
    private boolean isActive;
    private boolean isStageAlive;
    private Option<ByteString> detachedChunk;

    public boolean isInitialized() {
        return this.isInitialized;
    }

    public void isInitialized_$eq(boolean x$1) {
        this.isInitialized = x$1;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public void isActive_$eq(boolean x$1) {
        this.isActive = x$1;
    }

    public boolean isStageAlive() {
        return this.isStageAlive;
    }

    public void isStageAlive_$eq(boolean x$1) {
        this.isStageAlive = x$1;
    }

    public IOException subscriberClosedException() {
        return new IOException("Reactive stream is terminated, no reads are possible");
    }

    public Option<ByteString> detachedChunk() {
        return this.detachedChunk;
    }

    public void detachedChunk_$eq(Option<ByteString> x$1) {
        this.detachedChunk = x$1;
    }

    private <T> T executeIfNotClosed(Function0<T> f) throws IOException {
        if (!this.isActive()) {
            throw this.subscriberClosedException();
        }
        this.waitIfNotInitialized();
        return (T)f.apply();
    }

    @Override
    public int read() throws IOException {
        int n;
        byte[] a = new byte[1];
        int n2 = this.read(a, 0, 1);
        switch (n2) {
            case 1: {
                n = a[0] & 0xFF;
                break;
            }
            case -1: {
                n = -1;
                break;
            }
            default: {
                throw new IllegalStateException(new StringBuilder(17).append("Invalid length [").append(n2).append("]").toString());
            }
        }
        return n;
    }

    @Override
    public int read(byte[] a) throws IOException {
        return this.read(a, 0, a.length);
    }

    @Override
    public int read(byte[] a, int begin, int length) throws IOException {
        Predef$.MODULE$.require(a.length > 0, (Function0 & Serializable)() -> "array size must be >= 0");
        Predef$.MODULE$.require(begin >= 0, (Function0 & Serializable)() -> "begin must be >= 0");
        Predef$.MODULE$.require(length > 0, (Function0 & Serializable)() -> "length must be > 0");
        Predef$.MODULE$.require(begin + length <= a.length, (Function0 & Serializable)() -> "begin + length must be smaller or equal to the array length");
        return BoxesRunTime.unboxToInt(this.executeIfNotClosed((Function0)(JFunction0.mcI.sp & Serializable)() -> {
            int n;
            if (this.isStageAlive()) {
                int n2;
                Option<ByteString> option = this.detachedChunk();
                if (None$.MODULE$.equals(option)) {
                    int n3;
                    try {
                        int n4;
                        InputStreamSinkStage.StreamToAdapterMessage streamToAdapterMessage = $this.sharedBuffer.poll($this.readTimeout.toMillis(), TimeUnit.MILLISECONDS);
                        if (streamToAdapterMessage instanceof InputStreamSinkStage.Data) {
                            InputStreamSinkStage.Data data = (InputStreamSinkStage.Data)streamToAdapterMessage;
                            ByteString data2 = data.data();
                            this.detachedChunk_$eq((Option<ByteString>)new Some((Object)data2));
                            n4 = this.readBytes(a, begin, length);
                        } else if (InputStreamSinkStage$Finished$.MODULE$.equals(streamToAdapterMessage)) {
                            this.isStageAlive_$eq(false);
                            n4 = -1;
                        } else {
                            if (streamToAdapterMessage instanceof InputStreamSinkStage.Failed) {
                                InputStreamSinkStage.Failed failed = (InputStreamSinkStage.Failed)streamToAdapterMessage;
                                Throwable ex = failed.cause();
                                this.isStageAlive_$eq(false);
                                throw new IOException(ex);
                            }
                            if (streamToAdapterMessage == null) {
                                throw new IOException("Timeout on waiting for new data");
                            }
                            if (InputStreamSinkStage$Initialized$.MODULE$.equals(streamToAdapterMessage)) {
                                throw new IllegalStateException("message 'Initialized' must come first");
                            }
                            throw new MatchError((Object)streamToAdapterMessage);
                        }
                        n3 = n4;
                    }
                    catch (InterruptedException ex) {
                        throw new IOException(ex);
                    }
                    n2 = n3;
                } else if (option instanceof Some) {
                    n2 = this.readBytes(a, begin, length);
                } else {
                    throw new MatchError(option);
                }
                n = n2;
            } else {
                n = -1;
            }
            return n;
        }));
    }

    private int readBytes(byte[] a, int begin, int length) {
        Predef$.MODULE$.require(this.detachedChunk().nonEmpty(), (Function0 & Serializable)() -> "Chunk must be pulled from shared buffer");
        int availableInChunk = ((SeqOps)this.detachedChunk().get()).size();
        int readBytes = this.getData(a, begin, length, 0);
        Object object = readBytes >= availableInChunk ? this.sendToStage.apply((Object)InputStreamSinkStage$ReadElementAcknowledgement$.MODULE$) : BoxedUnit.UNIT;
        return readBytes;
    }

    @Override
    public void close() throws IOException {
        this.executeIfNotClosed((Function0)(JFunction0.mcV.sp & Serializable)() -> {
            Object object = this.isStageAlive() ? $this.sendToStage.apply((Object)InputStreamSinkStage$Close$.MODULE$) : BoxedUnit.UNIT;
            this.isActive_$eq(false);
        });
    }

    /*
     * Enabled aggressive block sorting
     */
    private int getData(byte[] arr, int begin, int length, int gotBytes) {
        int n;
        ByteString data;
        while (true) {
            Option<ByteString> option;
            if (!((option = this.grabDataChunk()) instanceof Some)) {
                if (!None$.MODULE$.equals(option)) throw new MatchError(option);
                return gotBytes;
            }
            Some some = (Some)option;
            data = (ByteString)some.value();
            int size = data.size();
            if (size > length) break;
            data.copyToArray((Object)arr, begin, size);
            this.detachedChunk_$eq((Option<ByteString>)None$.MODULE$);
            if (size == length) {
                n = gotBytes + size;
                return n;
            }
            gotBytes += size;
            length -= size;
            begin += size;
        }
        data.copyToArray((Object)arr, begin, length);
        this.detachedChunk_$eq((Option<ByteString>)new Some((Object)data.drop(length)));
        n = gotBytes + length;
        return n;
    }

    private void waitIfNotInitialized() {
        block3: {
            if (this.isInitialized()) break block3;
            InputStreamSinkStage.StreamToAdapterMessage streamToAdapterMessage = this.sharedBuffer.poll(this.readTimeout.toMillis(), TimeUnit.MILLISECONDS);
            if (InputStreamSinkStage$Initialized$.MODULE$.equals(streamToAdapterMessage)) {
                this.isInitialized_$eq(true);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                if (streamToAdapterMessage == null) {
                    throw new IOException(new StringBuilder(57).append("Timeout after ").append(this.readTimeout).append(" waiting for Initialized message from stage").toString());
                }
                Predef$.MODULE$.require(false, (Function0 & Serializable)() -> new StringBuilder(52).append("First message must be Initialized notification, got ").append(streamToAdapterMessage).toString());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    private Option<ByteString> grabDataChunk() {
        Option<ByteString> option;
        Option<ByteString> option2 = this.detachedChunk();
        if (None$.MODULE$.equals(option2)) {
            Option<ByteString> option3;
            InputStreamSinkStage.StreamToAdapterMessage streamToAdapterMessage = (InputStreamSinkStage.StreamToAdapterMessage)this.sharedBuffer.poll();
            if (streamToAdapterMessage instanceof InputStreamSinkStage.Data) {
                InputStreamSinkStage.Data data = (InputStreamSinkStage.Data)streamToAdapterMessage;
                ByteString data2 = data.data();
                this.detachedChunk_$eq((Option<ByteString>)new Some((Object)data2));
                option3 = this.detachedChunk();
            } else if (InputStreamSinkStage$Finished$.MODULE$.equals(streamToAdapterMessage)) {
                this.isStageAlive_$eq(false);
                option3 = None$.MODULE$;
            } else {
                if (streamToAdapterMessage instanceof InputStreamSinkStage.Failed) {
                    InputStreamSinkStage.Failed failed = (InputStreamSinkStage.Failed)streamToAdapterMessage;
                    Throwable e = failed.cause();
                    throw new IOException(e);
                }
                option3 = None$.MODULE$;
            }
            option = option3;
        } else if (option2 instanceof Some) {
            option = this.detachedChunk();
        } else {
            throw new MatchError(option2);
        }
        return option;
    }

    public InputStreamAdapter(BlockingQueue<InputStreamSinkStage.StreamToAdapterMessage> sharedBuffer, Function1<InputStreamSinkStage.AdapterToStageMessage, BoxedUnit> sendToStage, FiniteDuration readTimeout) {
        this.sharedBuffer = sharedBuffer;
        this.sendToStage = sendToStage;
        this.readTimeout = readTimeout;
        this.isInitialized = false;
        this.isActive = true;
        this.isStageAlive = true;
        this.detachedChunk = None$.MODULE$;
    }
}

