/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.booter.local;

import com.xebialabs.deployit.booter.local.GlobalContextManager;
import com.xebialabs.deployit.booter.local.LocalGlobalContextManager;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import java.io.File;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;

final class GlobalContext {
    private static final Map<String, Value> context = new ConcurrentHashMap<String, Value>();
    private static final AtomicReference<GlobalContextManager> globalContextManagerReference = new AtomicReference<GlobalContextManager>(new LocalGlobalContextManager().withContext(context));
    public static final File DEFAULTS = new File("conf", "deployit-defaults.properties");

    private GlobalContext() {
    }

    static void setManager(GlobalContextManager globalContextManager) {
        globalContextManagerReference.set(globalContextManager.withContext(context));
    }

    static GlobalContextManager getManager() {
        return globalContextManagerReference.get();
    }

    static void register(PropertyDescriptor pd, String defaultValue) {
        if (defaultValue == null && !pd.isHidden()) {
            return;
        }
        context.put(pd.getFqn(), new Value(pd.getDescription(), defaultValue));
    }

    public static void register(PropertyDescriptor pd, PropertyDescriptor inheritedFrom) {
        context.put(pd.getFqn(), new InheritedValue(pd.getDescription(), inheritedFrom.getFqn(), pd.isHidden()));
    }

    static String lookup(PropertyDescriptor pd) {
        return GlobalContext.lookup(pd.getFqn());
    }

    private static String lookup(String key) {
        Value value = context.get(key);
        if (value == null) {
            return null;
        }
        return value.getValue();
    }

    static class ExplicitValue
    extends Value {
        ExplicitValue(String description, String value) {
            super(description, value);
        }

        @Override
        boolean isExplicit() {
            return true;
        }
    }

    static class Value {
        final String description;
        final String value;

        Value(String description, String value) {
            this.description = description;
            this.value = value;
        }

        boolean isExplicit() {
            return false;
        }

        boolean isShouldWrite() {
            return true;
        }

        public String getValue() {
            return this.value;
        }
    }

    static class InheritedValue
    extends Value {
        private final String superTypeProperty;
        private final boolean shouldWrite;

        InheritedValue(String description, String superTypeProperty, boolean shouldWrite) {
            super(description, "");
            this.superTypeProperty = superTypeProperty;
            this.shouldWrite = shouldWrite;
        }

        @Override
        public String getValue() {
            return GlobalContext.lookup(this.superTypeProperty);
        }

        @Override
        boolean isShouldWrite() {
            return this.shouldWrite;
        }

        String getSuperTypeProperty() {
            return this.superTypeProperty;
        }
    }
}

