/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.booter.local.generator;

import com.xebialabs.deployit.booter.local.TypeDefinitions;
import com.xebialabs.deployit.booter.local.generator.TypeGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import nl.javadude.scannit.Scannit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypeGenerators {
    private static final Logger logger = LoggerFactory.getLogger(TypeGenerators.class);
    private final Map<String, TypeGenerator> generatorsByName = new HashMap<String, TypeGenerator>();

    public TypeGenerators(Scannit scannit) {
        this.scanTypeGenerators(scannit);
    }

    private void scanTypeGenerators(Scannit scannit) {
        scannit.getSubTypesOf(TypeGenerator.class).forEach(g -> {
            TypeGenerator typeGenerator = null;
            try {
                typeGenerator = (TypeGenerator)g.newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            this.generatorsByName.put(typeGenerator.getName(), typeGenerator);
        });
    }

    public void generateTypeDefinitions(TypeDefinitions typeDefinitions) {
        this.generatorsByName.values().forEach(tg -> this.executeWithDependencies(typeDefinitions, (TypeGenerator)tg, (List<String>)new ArrayList<String>(), (List<String>)new ArrayList<String>()));
    }

    private void executeWithDependencies(TypeDefinitions typeDefinitions, TypeGenerator typeGenerator, List<String> alreadyExecuted, List<String> wanted) {
        if (alreadyExecuted.contains(typeGenerator.getName())) {
            return;
        }
        if (wanted.contains(typeGenerator.getName())) {
            throw new RuntimeException("There is a circular dependency in TypeGenerators " + Arrays.toString(wanted.toArray(new String[wanted.size()])));
        }
        wanted.add(typeGenerator.getName());
        if (alreadyExecuted.containsAll(typeGenerator.dependsOn())) {
            this.execute(typeDefinitions, typeGenerator, alreadyExecuted, wanted);
        } else {
            typeGenerator.dependsOn().forEach(dep -> this.executeWithDependencies(typeDefinitions, this.typeGeneratorByName((String)dep), alreadyExecuted, wanted));
        }
    }

    private void execute(TypeDefinitions typeDefinitions, TypeGenerator typeGenerator, List<String> alreadyExecuted, List<String> wanted) {
        logger.info("Executing " + typeGenerator.getName());
        alreadyExecuted.add(typeGenerator.getName());
        wanted.remove(typeGenerator.getName());
        typeGenerator.generateAndRegister(typeDefinitions);
    }

    private TypeGenerator typeGeneratorByName(String name) {
        return Optional.ofNullable(this.generatorsByName.get(name)).orElseThrow(() -> new RuntimeException("Type generator " + name + " is not found"));
    }
}

