/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.engine;

import org.apache.camel.AsyncProducer;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.FailedToCreateProducerException;
import org.apache.camel.impl.engine.DefaultProducerCache;
import org.apache.camel.support.service.ServiceHelper;

public class EmptyProducerCache
extends DefaultProducerCache {
    private final Object source;
    private final ExtendedCamelContext ecc;

    public EmptyProducerCache(Object source, CamelContext camelContext) {
        super(source, camelContext, -1);
        this.source = source;
        this.ecc = (ExtendedCamelContext)camelContext.adapt(ExtendedCamelContext.class);
        this.setExtendedStatistics(false);
    }

    @Override
    public AsyncProducer acquireProducer(Endpoint endpoint) {
        AsyncProducer answer;
        try {
            boolean startingRoutes;
            answer = endpoint.createAsyncProducer();
            boolean bl = startingRoutes = this.ecc.isSetupRoutes() || this.ecc.getRouteController().isStartingRoutes();
            if (startingRoutes && answer.isSingleton()) {
                this.getCamelContext().addService((Object)answer);
            } else {
                ServiceHelper.startService((Object)answer);
            }
        }
        catch (Exception e) {
            throw new FailedToCreateProducerException(endpoint, (Throwable)e);
        }
        return answer;
    }

    @Override
    public void releaseProducer(Endpoint endpoint, AsyncProducer producer) {
        ServiceHelper.stopAndShutdownService((Object)producer);
    }

    @Override
    public int getCapacity() {
        return 0;
    }

    @Override
    public String toString() {
        return "EmptyProducerCache for source: " + this.source;
    }
}

