/*
 * Decompiled with CFR 0.152.
 */
package pureconfig;

import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import pureconfig.error.CannotConvert;
import pureconfig.error.ExceptionThrown;
import pureconfig.error.FailureReason;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.math.Ordering;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichChar$;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.Try$;
import scala.util.control.NonFatal$;
import scala.util.matching.Regex;

public final class DurationUtils$ {
    public static final DurationUtils$ MODULE$ = new DurationUtils$();
    private static final Function1<String, Either<FailureReason, Duration>> fromString = (Function1 & Serializable)string -> {
        Right right;
        String string2 = string;
        String string3 = "Undefined";
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            right = package$.MODULE$.Right().apply((Object)Duration$.MODULE$.Undefined());
        } else {
            try {
                right = package$.MODULE$.Right().apply((Object)MODULE$.parseDuration((String)MODULE$.addDefaultUnit().apply(MODULE$.justAMinute().apply(MODULE$.itsGreekToMe().apply(string)))));
            }
            catch (Throwable throwable) {
                Option option;
                Left left;
                Throwable throwable2 = throwable;
                if (throwable2 instanceof NumberFormatException) {
                    NumberFormatException numberFormatException = (NumberFormatException)throwable2;
                    String err = new StringBuilder(58).append(numberFormatException.getMessage()).append(". (try a number followed by any of ns, us, ms, s, m, h, d)").toString();
                    left = package$.MODULE$.Left().apply((Object)new CannotConvert((String)string, "Duration", err));
                } else if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    Throwable t = (Throwable)option.get();
                    left = package$.MODULE$.Left().apply((Object)new ExceptionThrown(t));
                } else {
                    throw throwable;
                }
                right = left;
            }
        }
        return right;
    };
    private static final List<Tuple2<TimeUnit, String>> timeUnitLabels = (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)TimeUnit.DAYS), (Object)"d day"), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)TimeUnit.HOURS), (Object)"h hour"), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)TimeUnit.MINUTES), (Object)"min minute"), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)TimeUnit.SECONDS), (Object)"s sec second"), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)TimeUnit.MILLISECONDS), (Object)"ms milli millisecond"), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)TimeUnit.MICROSECONDS), (Object)"\u00b5s micro microsecond"), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)TimeUnit.NANOSECONDS), (Object)"ns nano nanosecond"), (List)Nil$.MODULE$)))))));
    private static final Map<String, TimeUnit> timeUnit = timeUnitLabels.flatMap((Function1 & Serializable)x0$1 -> {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TimeUnit unit = (TimeUnit)((Object)((Object)tuple2._1()));
        String names = (String)tuple2._2();
        List list = MODULE$.expandLabels(names).map((Function1 & Serializable)x$2 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x$2), (Object)unit));
        return list;
    }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    private static final Regex onlyNumberRegex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("\\s*[+-]?[0-9]+\\s*$"));
    private static final Regex fauxMuRegex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("([0-9])(\\s*)us(\\s*)$"));
    private static final Regex shortMinuteRegex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("([0-9])(\\s*)m(\\s*)$"));
    private static final Function1<String, String> addDefaultUnit = (Function1 & Serializable)s -> MODULE$.onlyNumberRegex().unapplySeq((CharSequence)s).isDefined() ? new StringBuilder(3).append((String)s).append(" ms").toString() : s;
    private static final Function1<String, String> itsGreekToMe = (Function1 & Serializable)x$5 -> MODULE$.fauxMuRegex().replaceSomeIn((CharSequence)x$5, (Function1 & Serializable)m -> new Some((Object)new StringBuilder(2).append(m.group(1)).append(m.group(2)).append("\u00b5s").append(m.group(3)).toString()));
    private static final Function1<String, String> justAMinute = (Function1 & Serializable)x$6 -> MODULE$.shortMinuteRegex().replaceSomeIn((CharSequence)x$6, (Function1 & Serializable)m -> new Some((Object)new StringBuilder(7).append(m.group(1)).append(m.group(2)).append("minutes").append(m.group(3)).toString()));
    private static final Vector<Tuple2<Object, String>> timeUnitsToLabels = (Vector)((SeqOps)package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)86400000000000L)), (Object)"d"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)3600000000000L)), (Object)"h"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)60000000000L)), (Object)"m"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)1000000000L)), (Object)"s"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)1000000L)), (Object)"ms"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)1000L)), (Object)"us")}))).sortBy((Function1 & Serializable)x$7 -> BoxesRunTime.boxToLong((long)x$7._1$mcJ$sp()), ((Ordering)Predef$.MODULE$.implicitly((Object)Ordering.Long$.MODULE$)).reverse());

    public Function1<String, Either<FailureReason, Duration>> fromString() {
        return fromString;
    }

    private List<String> words(String s) {
        return Predef$.MODULE$.wrapRefArray((Object[])s.trim().split("\\s+")).toList();
    }

    private List<String> expandLabels(String labels) {
        List<String> list = this.words(labels);
        if (!(list instanceof .colon.colon)) {
            throw new MatchError(list);
        }
        .colon.colon colon2 = (.colon.colon)list;
        String hd = (String)colon2.head();
        List rest = colon2.next$access$1();
        Tuple2 tuple2 = new Tuple2((Object)hd, (Object)rest);
        Tuple2 tuple22 = tuple2;
        String hd2 = (String)tuple22._1();
        List rest2 = (List)tuple22._2();
        String string = hd2;
        return rest2.flatMap((Function1 & Serializable)s -> (List)new .colon.colon(s, (List)new .colon.colon((Object)new StringBuilder(1).append((String)s).append("s").toString(), (List)Nil$.MODULE$))).$colon$colon((Object)string);
    }

    public Map<String, TimeUnit> timeUnit() {
        return timeUnit;
    }

    public Duration parseDuration(String s) {
        Duration.Infinite infinite;
        block13: {
            String s1;
            block11: {
                block12: {
                    s1 = StringOps$.MODULE$.filterNot$extension(Predef$.MODULE$.augmentString(s), (Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)RichChar$.MODULE$.isWhitespace$extension(Predef$.MODULE$.charWrapper(BoxesRunTime.unboxToChar((Object)x$3)))));
                    String string = s1;
                    switch (string == null ? 0 : string.hashCode()) {
                        case -1283193487: {
                            if (!"MinusInf".equals(string)) break block11;
                            break block12;
                        }
                        case 73665: {
                            if ("Inf".equals(string)) {
                                break;
                            }
                            break block11;
                        }
                        case 1354678: {
                            if ("+Inf".equals(string)) {
                                break;
                            }
                            break block11;
                        }
                        case 1414260: {
                            if (!"-Inf".equals(string)) break block11;
                            break block12;
                        }
                        case 1189350343: {
                            if ("PlusInf".equals(string)) {
                                break;
                            }
                            break block11;
                        }
                        default: {
                            break block11;
                        }
                    }
                    infinite = Duration$.MODULE$.Inf();
                    break block13;
                }
                infinite = Duration$.MODULE$.MinusInf();
                break block13;
            }
            String unitName = StringOps$.MODULE$.reverse$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.takeWhile$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.reverse$extension(Predef$.MODULE$.augmentString(s1))), (Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)RichChar$.MODULE$.isLetter$extension(Predef$.MODULE$.charWrapper(BoxesRunTime.unboxToChar((Object)x$4)))))));
            Option option = this.timeUnit().get((Object)unitName);
            if (!(option instanceof Some)) {
                throw new NumberFormatException(new StringBuilder(13).append("format error ").append(s).toString());
            }
            Some some = (Some)option;
            TimeUnit unit = (TimeUnit)((Object)some.value());
            String valueStr = StringOps$.MODULE$.dropRight$extension(Predef$.MODULE$.augmentString(s1), unitName.length());
            Duration duration = (Duration)Try$.MODULE$.apply((Function0 & Serializable)() -> Duration$.MODULE$.apply(Long.parseLong(valueStr), unit)).getOrElse((Function0 & Serializable)() -> Duration$.MODULE$.apply(Double.parseDouble(valueStr), unit));
            infinite = duration;
        }
        return infinite;
    }

    private Regex onlyNumberRegex() {
        return onlyNumberRegex;
    }

    private Regex fauxMuRegex() {
        return fauxMuRegex;
    }

    private Regex shortMinuteRegex() {
        return shortMinuteRegex;
    }

    private Function1<String, String> addDefaultUnit() {
        return addDefaultUnit;
    }

    private Function1<String, String> itsGreekToMe() {
        return itsGreekToMe;
    }

    private Function1<String, String> justAMinute() {
        return justAMinute;
    }

    public String fromDuration(Duration d) {
        String string;
        Duration duration = d;
        if (duration instanceof FiniteDuration) {
            FiniteDuration finiteDuration = (FiniteDuration)duration;
            string = this.fromFiniteDuration(finiteDuration);
        } else {
            Duration.Infinite infinite = Duration$.MODULE$.Inf();
            Duration duration2 = duration;
            if (!(infinite != null ? !infinite.equals(duration2) : duration2 != null)) {
                string = "Inf";
            } else {
                Duration.Infinite infinite2 = Duration$.MODULE$.MinusInf();
                Duration duration3 = duration;
                if (!(infinite2 != null ? !infinite2.equals(duration3) : duration3 != null)) {
                    string = "MinusInf";
                } else if (duration == Duration$.MODULE$.Undefined()) {
                    string = "Undefined";
                } else {
                    throw new MatchError((Object)duration);
                }
            }
        }
        return string;
    }

    private final String UndefinedDuration() {
        return "Undefined";
    }

    public String fromFiniteDuration(FiniteDuration d) {
        long l = d.toNanos();
        String string = 0L == l ? "0" : (String)this.timeUnitsToLabels().collectFirst((PartialFunction)new Serializable(l){
            private static final long serialVersionUID = 0L;
            private final long x1$1;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Tuple2<Object, String>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 != null) {
                    long unitInNanos = A1._1$mcJ$sp();
                    String unitLabel = (String)A1._2();
                    if (this.x1$1 >= unitInNanos && this.x1$1 % unitInNanos == 0L) {
                        object = new StringBuilder(0).append(this.x1$1 / unitInNanos).append(unitLabel).toString();
                        return (B1)object;
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Tuple2<Object, String> x1) {
                long unitInNanos;
                Tuple2<Object, String> tuple2 = x1;
                boolean bl = tuple2 != null && this.x1$1 >= (unitInNanos = tuple2._1$mcJ$sp()) && this.x1$1 % unitInNanos == 0L;
                return bl;
            }
            {
                this.x1$1 = x1$1;
            }
        }).getOrElse((Function0 & Serializable)() -> new StringBuilder(2).append(l).append("ns").toString());
        return string;
    }

    private final long microsecondInNanos() {
        return 1000L;
    }

    private final long millisecondInNanos() {
        return 1000000L;
    }

    private final long secondInNanos() {
        return 1000000000L;
    }

    private final long minuteInNanos() {
        return 60000000000L;
    }

    private final long hourInNanos() {
        return 3600000000000L;
    }

    private final long dayInNanos() {
        return 86400000000000L;
    }

    private final Vector<Tuple2<Object, String>> timeUnitsToLabels() {
        return timeUnitsToLabels;
    }

    private DurationUtils$() {
    }
}

