/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache;

import com.github.benmanes.caffeine.cache.Buffer;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.UnsafeAccess;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.checkerframework.checker.nullness.qual.Nullable;

abstract class StripedBuffer<E>
implements Buffer<E> {
    static final VarHandle TABLE_BUSY;
    static final Probe PROBE;
    static final int NCPU;
    static final int MAXIMUM_TABLE_SIZE;
    static final int ATTEMPTS = 3;
    volatile Buffer<E> @Nullable [] table;
    volatile int tableBusy;

    StripedBuffer() {
    }

    final boolean casTableBusy() {
        return TABLE_BUSY.compareAndSet(this, 0, 1);
    }

    static final int advanceProbe(int probe) {
        probe ^= probe << 13;
        probe ^= probe >>> 17;
        probe ^= probe << 5;
        PROBE.set(probe);
        return probe;
    }

    protected abstract Buffer<E> create(E var1);

    @Override
    public int offer(E e) {
        Buffer<E> buffer;
        int mask;
        int result = 0;
        boolean uncontended = true;
        Buffer<E>[] buffers = this.table;
        if (buffers == null || (mask = buffers.length - 1) < 0 || (buffer = buffers[PROBE.get() & mask]) == null || !(uncontended = (result = buffer.offer(e)) != -1)) {
            this.expandOrRetry(e, uncontended);
        }
        return result;
    }

    @Override
    public void drainTo(Consumer<E> consumer) {
        Buffer<E>[] buffers = this.table;
        if (buffers == null) {
            return;
        }
        for (Buffer<E> buffer : buffers) {
            if (buffer == null) continue;
            buffer.drainTo(consumer);
        }
    }

    @Override
    public int reads() {
        Buffer<E>[] buffers = this.table;
        if (buffers == null) {
            return 0;
        }
        int reads = 0;
        for (Buffer<E> buffer : buffers) {
            if (buffer == null) continue;
            reads += buffer.reads();
        }
        return reads;
    }

    @Override
    public int writes() {
        Buffer<E>[] buffers = this.table;
        if (buffers == null) {
            return 0;
        }
        int writes = 0;
        for (Buffer<E> buffer : buffers) {
            if (buffer == null) continue;
            writes += buffer.writes();
        }
        return writes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void expandOrRetry(E e, boolean wasUncontended) {
        int h = PROBE.get();
        if (h == 0) {
            PROBE.initialize();
            h = PROBE.get();
            wasUncontended = true;
        }
        boolean collide = false;
        for (int attempt = 0; attempt < 3; ++attempt) {
            Buffer[] rs;
            int n;
            Buffer<E>[] buffers = this.table;
            if (this.table != null && (n = buffers.length) > 0) {
                Buffer<E> buffer = buffers[n - 1 & h];
                if (buffer == null) {
                    if (this.tableBusy == 0 && this.casTableBusy()) {
                        boolean created = false;
                        try {
                            int j;
                            int mask;
                            rs = this.table;
                            if (this.table != null && (mask = rs.length) > 0 && rs[j = mask - 1 & h] == null) {
                                rs[j] = this.create(e);
                                created = true;
                            }
                        }
                        finally {
                            this.tableBusy = 0;
                        }
                        if (!created) continue;
                        break;
                    }
                    collide = false;
                } else if (!wasUncontended) {
                    wasUncontended = true;
                } else {
                    if (buffer.offer(e) != -1) break;
                    if (n >= MAXIMUM_TABLE_SIZE || this.table != buffers) {
                        collide = false;
                    } else if (!collide) {
                        collide = true;
                    } else if (this.tableBusy == 0 && this.casTableBusy()) {
                        try {
                            if (this.table == buffers) {
                                this.table = Arrays.copyOf(buffers, n << 1);
                            }
                        }
                        finally {
                            this.tableBusy = 0;
                        }
                        collide = false;
                        continue;
                    }
                }
                h = StripedBuffer.advanceProbe(h);
                continue;
            }
            if (this.tableBusy != 0 || this.table != buffers || !this.casTableBusy()) continue;
            boolean init = false;
            try {
                if (this.table == buffers) {
                    rs = new Buffer[]{this.create(e)};
                    this.table = rs;
                    init = true;
                }
            }
            finally {
                this.tableBusy = 0;
            }
            if (init) break;
        }
    }

    static {
        NCPU = Runtime.getRuntime().availableProcessors();
        MAXIMUM_TABLE_SIZE = 4 * Caffeine.ceilingPowerOfTwo(NCPU);
        try {
            TABLE_BUSY = MethodHandles.lookup().findVarHandle(StripedBuffer.class, "tableBusy", Integer.TYPE);
        }
        catch (ReflectiveOperationException e) {
            throw new ExceptionInInitializerError(e);
        }
        Probe probe = null;
        List<Supplier<Probe>> suppliers = List.of(UnsafeProbe::new, VarHandleProbe::new, ThreadLocalProbe::new);
        for (Supplier<Probe> supplier : suppliers) {
            try {
                probe = supplier.get();
                break;
            }
            catch (Throwable throwable) {
            }
        }
        PROBE = Objects.requireNonNull(probe, "Unable to determine a probe strategy");
    }

    static final class ThreadLocalProbe
    implements Probe {
        static final ThreadLocal<int[]> threadHashCode = ThreadLocal.withInitial(() -> new int[1]);

        ThreadLocalProbe() {
        }

        @Override
        public int get() {
            return threadHashCode.get()[0];
        }

        @Override
        public void set(int probe) {
            ThreadLocalProbe.threadHashCode.get()[0] = probe;
        }

        @Override
        public void initialize() {
            int hash;
            ThreadLocalProbe.threadHashCode.get()[0] = hash = 1 | ThreadLocalRandom.current().nextInt();
        }
    }

    static final class VarHandleProbe
    implements Probe {
        static final VarHandle PROBE;

        VarHandleProbe() {
        }

        @Override
        public int get() {
            return PROBE.get(Thread.currentThread());
        }

        @Override
        public void set(int probe) {
            PROBE.set(Thread.currentThread(), probe);
        }

        @Override
        public void initialize() {
            ThreadLocalRandom.current();
        }

        static {
            try {
                PROBE = MethodHandles.privateLookupIn(Thread.class, MethodHandles.lookup()).findVarHandle(Thread.class, "threadLocalRandomProbe", Integer.TYPE);
            }
            catch (ReflectiveOperationException e) {
                throw new ExceptionInInitializerError(e);
            }
        }
    }

    static final class UnsafeProbe
    implements Probe {
        static final long PROBE = UnsafeAccess.objectFieldOffset(Thread.class, "threadLocalRandomProbe");

        UnsafeProbe() {
        }

        @Override
        public int get() {
            return UnsafeAccess.UNSAFE.getInt(Thread.currentThread(), PROBE);
        }

        @Override
        public void set(int probe) {
            UnsafeAccess.UNSAFE.putInt(Thread.currentThread(), PROBE, probe);
        }

        @Override
        public void initialize() {
            ThreadLocalRandom.current();
        }
    }

    static interface Probe {
        public int get();

        public void set(int var1);

        public void initialize();
    }
}

