/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overthere.ssh;

import com.xebialabs.overthere.CmdLine;
import com.xebialabs.overthere.CmdLineArgument;
import com.xebialabs.overthere.ConnectionOptions;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.OverthereProcess;
import com.xebialabs.overthere.RuntimeIOException;
import com.xebialabs.overthere.spi.AddressPortMapper;
import com.xebialabs.overthere.spi.BaseOverthereConnection;
import com.xebialabs.overthere.ssh.RegularExpressionPasswordResponseProvider;
import com.xebialabs.overthere.ssh.SshConnectionBuilder;
import com.xebialabs.overthere.ssh.SshConnectionType;
import com.xebialabs.overthere.ssh.SshFile;
import com.xebialabs.overthere.ssh.SshProcess;
import com.xebialabs.overthere.util.OverthereUtils;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.schmizz.keepalive.KeepAliveProvider;
import net.schmizz.sshj.Config;
import net.schmizz.sshj.DefaultConfig;
import net.schmizz.sshj.SSHClient;
import net.schmizz.sshj.common.Factory;
import net.schmizz.sshj.common.SSHException;
import net.schmizz.sshj.connection.ConnectionException;
import net.schmizz.sshj.connection.channel.direct.Session;
import net.schmizz.sshj.transport.TransportException;
import net.schmizz.sshj.transport.verification.HostKeyVerifier;
import net.schmizz.sshj.transport.verification.PromiscuousVerifier;
import net.schmizz.sshj.userauth.keyprovider.KeyProvider;
import net.schmizz.sshj.userauth.keyprovider.PKCS5KeyFile;
import net.schmizz.sshj.userauth.method.AuthKeyboardInteractive;
import net.schmizz.sshj.userauth.method.AuthMethod;
import net.schmizz.sshj.userauth.method.AuthPassword;
import net.schmizz.sshj.userauth.method.ChallengeResponseProvider;
import net.schmizz.sshj.userauth.password.PasswordFinder;
import net.schmizz.sshj.userauth.password.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class SshConnection
extends BaseOverthereConnection {
    public static final String PTY_PATTERN = "([\\w-]+):(\\d+):(\\d+):(\\d+):(\\d+)";
    public static final String NOCD_PSEUDO_COMMAND = "nocd";
    protected String protocolAndConnectionType;
    protected String host;
    protected int port;
    protected String localAddress;
    protected int localPort;
    protected String username;
    protected String password;
    protected String interactiveKeyboardAuthPromptRegex;
    protected String privateKey;
    protected String privateKeyFile;
    protected String passphrase;
    protected boolean allocateDefaultPty;
    protected boolean openShellBeforeExecute;
    protected int transportTimeoutMillis;
    protected String allocatePty;
    protected int heartbeatInterval;
    protected SSHClient sshClient;
    private static final Pattern ptyPattern = Pattern.compile("([\\w-]+):(\\d+):(\\d+):(\\d+):(\\d+)");
    private static final Config config = new DefaultConfig();
    protected Factory<SSHClient> sshClientFactory;
    private static Logger logger = LoggerFactory.getLogger(SshConnection.class);

    public SshConnection(String protocol, ConnectionOptions options, AddressPortMapper mapper) {
        super(protocol, options, mapper, true);
        ArrayList<PKCS5KeyFile.Factory> current = config.getFileKeyProviderFactories();
        current = new ArrayList<PKCS5KeyFile.Factory>(current);
        current.add(new PKCS5KeyFile.Factory());
        config.setFileKeyProviderFactories(current);
        this.sshClientFactory = new Factory<SSHClient>(){

            public SSHClient create() {
                return new SSHClient(config);
            }
        };
        SshConnectionType connectionType = options.getOptionalEnum("connectionType", SshConnectionType.class);
        this.protocolAndConnectionType = connectionType != null ? protocol + ":" + connectionType.toString().toLowerCase() : protocol;
        String unmappedAddress = (String)options.get("address");
        int unmappedPort = options.getInteger("port", 22);
        InetSocketAddress addressPort = mapper.map(InetSocketAddress.createUnresolved(unmappedAddress, unmappedPort));
        this.host = addressPort.getHostName();
        this.port = addressPort.getPort();
        this.localAddress = (String)options.getOptional("localAddress");
        this.localPort = options.getInteger("localPort", 0);
        this.username = (String)options.get("username");
        this.password = (String)options.getOptional(ConnectionOptions.PASSWORD);
        this.interactiveKeyboardAuthPromptRegex = options.get("interactiveKeyboardAuthRegex", ".*Password:[ ]?");
        this.privateKey = (String)options.getOptional(SshConnectionBuilder.PRIVATE_KEY);
        this.privateKeyFile = (String)options.getOptional("privateKeyFile");
        this.passphrase = (String)options.getOptional(SshConnectionBuilder.PASSPHRASE);
        this.allocateDefaultPty = options.getBoolean("allocateDefaultPty", false);
        this.heartbeatInterval = options.getInteger("heartbeatInterval", 0);
        if (this.allocateDefaultPty) {
            logger.warn("The allocateDefaultPty connection option has been deprecated in favour of the allocatePty option. See https://github.com/xebialabs/overthere#ssh_allocatePty");
        }
        this.allocatePty = (String)options.getOptional("allocatePty");
        this.openShellBeforeExecute = options.getBoolean("openShellBeforeExecute", false);
        this.transportTimeoutMillis = options.getInteger("transportTimeoutMillis", 30000);
    }

    protected void connect() {
        config.setKeepAliveProvider(KeepAliveProvider.KEEP_ALIVE);
        SSHClient client = (SSHClient)this.sshClientFactory.create();
        try {
            client.setSocketFactory(this.mapper.socketFactory());
            client.setConnectTimeout(this.connectionTimeoutMillis);
            client.addHostKeyVerifier((HostKeyVerifier)new PromiscuousVerifier());
            client.setTimeout(this.socketTimeoutMillis);
            client.getConnection().getKeepAlive().setKeepAliveInterval(this.heartbeatInterval);
            client.getTransport().setTimeoutMs(this.transportTimeoutMillis);
            try {
                if (this.localAddress == null) {
                    client.connect(this.host, this.port);
                } else {
                    client.connect(this.host, this.port, InetAddress.getByName(this.localAddress), this.localPort);
                }
            }
            catch (IOException e) {
                throw new RuntimeIOException("Cannot connect to " + this.host + ":" + this.port, e);
            }
            if (!this.onlyOneNotNull(this.privateKey, this.privateKeyFile, this.password)) {
                logger.warn("You should only set one connection options between: {}, {}, {}. They are evaluated in this order, and latter would have no effect on the connection.", new Object[]{SshConnectionBuilder.PRIVATE_KEY, "privateKeyFile", ConnectionOptions.PASSWORD});
            }
            if (this.privateKey != null) {
                KeyProvider keys;
                try {
                    keys = this.passphrase == null ? client.loadKeys(this.privateKey, null, null) : client.loadKeys(this.privateKey, null, this.getPassphraseFinder());
                }
                catch (IOException e) {
                    throw new RuntimeIOException("The supplied key is not in a recognized format", e);
                }
                client.authPublickey(this.username, new KeyProvider[]{keys});
            } else if (this.privateKeyFile != null) {
                KeyProvider keys;
                try {
                    keys = this.passphrase == null ? client.loadKeys(this.privateKeyFile) : client.loadKeys(this.privateKeyFile, this.getPassphraseFinder());
                }
                catch (IOException e) {
                    throw new RuntimeIOException("Cannot read key from private key file " + this.privateKeyFile, e);
                }
                client.authPublickey(this.username, new KeyProvider[]{keys});
            } else if (this.password != null) {
                PasswordFinder passwordFinder = this.getPasswordFinder();
                client.auth(this.username, new AuthMethod[]{new AuthPassword(passwordFinder), new AuthKeyboardInteractive((ChallengeResponseProvider)new RegularExpressionPasswordResponseProvider(passwordFinder, this.interactiveKeyboardAuthPromptRegex))});
            }
            this.sshClient = client;
            this.connected();
        }
        catch (SSHException e) {
            try {
                if (client.isConnected()) {
                    client.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new RuntimeIOException("Cannot connect to " + this, e);
        }
    }

    private PasswordFinder getPasswordFinder() {
        return new PasswordFinder(){

            public char[] reqPassword(Resource<?> resource) {
                return SshConnection.this.password.toCharArray();
            }

            public boolean shouldRetry(Resource<?> resource) {
                return false;
            }
        };
    }

    private PasswordFinder getPassphraseFinder() {
        return new PasswordFinder(){

            public char[] reqPassword(Resource<?> resource) {
                return SshConnection.this.passphrase.toCharArray();
            }

            public boolean shouldRetry(Resource<?> resource) {
                return false;
            }
        };
    }

    private boolean onlyOneNotNull(Object ... objs) {
        int guard = 0;
        for (Object obj : objs) {
            guard += obj != null ? 1 : 0;
        }
        return guard == 1;
    }

    @Override
    public void doClose() {
        if (this.sshClient == null) {
            return;
        }
        try {
            this.sshClient.disconnect();
        }
        catch (Exception e) {
            logger.error("Unexpected exception received while disconnecting from " + this, (Throwable)e);
        }
        finally {
            this.sshClient = null;
        }
    }

    protected SSHClient getSshClient() {
        OverthereUtils.checkState(this.sshClient != null, "Not (yet) connected", new Object[0]);
        return this.sshClient;
    }

    @Override
    public OverthereFile getFile(OverthereFile parent, String child) throws RuntimeIOException {
        this.checkParentFile(parent);
        return this.getFile(OverthereUtils.constructPath(parent, child));
    }

    @Override
    protected OverthereFile getFileForTempFile(OverthereFile parent, String name) {
        this.checkParentFile(parent);
        return this.getFile(parent, name);
    }

    protected void checkParentFile(OverthereFile parent) {
        if (!(parent instanceof SshFile)) {
            throw new IllegalStateException("parent is not a file on an SSH host");
        }
        if (parent.getConnection() != this) {
            throw new IllegalStateException("parent is not a file in this connection");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OverthereProcess startProcess(CmdLine origCmd) {
        OverthereUtils.checkNotNull(origCmd, "Cannot execute null command line", new Object[0]);
        OverthereUtils.checkArgument(origCmd.getArguments().size() > 0, "Cannot execute empty command line", new Object[0]);
        CmdLine cmd = this.processCommandLine(origCmd);
        String obfuscatedCmd = origCmd.toCommandLine(this.os, true);
        logger.info("Starting command [{}] on [{}]", (Object)obfuscatedCmd, (Object)this);
        try {
            Session session;
            if (this.openShellBeforeExecute) {
                session = null;
                try {
                    logger.debug("Creating a temporary shell to allow for deferred home dir creation.");
                    session = this.getSshClient().startSession();
                    Session.Shell shell = session.startShell();
                    shell.close();
                }
                finally {
                    OverthereUtils.closeQuietly((Closeable)session);
                }
            }
            session = this.getSshClient().startSession();
            if (this.allocatePty != null && !this.allocatePty.isEmpty()) {
                if (this.allocateDefaultPty) {
                    logger.warn("The allocatePty and allocateDefaultPty connection options have both been set for the connection {}. Ignoring allocateDefaultPty and using allocatePty.", (Object)this);
                }
                Matcher matcher = ptyPattern.matcher(this.allocatePty);
                OverthereUtils.checkArgument(matcher.matches(), "Value for allocatePty [%s] does not match pattern \"([\\w-]+):(\\d+):(\\d+):(\\d+):(\\d+)\"", this.allocatePty);
                String term = matcher.group(1);
                int cols = Integer.valueOf(matcher.group(2));
                int rows = Integer.valueOf(matcher.group(3));
                int width = Integer.valueOf(matcher.group(4));
                int height = Integer.valueOf(matcher.group(5));
                logger.debug("Allocating PTY {}:{}:{}:{}:{}", new Object[]{term, cols, rows, width, height});
                session.allocatePTY(term, cols, rows, width, height, Collections.emptyMap());
            } else if (this.allocateDefaultPty) {
                logger.debug("Allocating default PTY");
                session.allocateDefaultPTY();
            }
            return this.createProcess(session, cmd);
        }
        catch (SSHException e) {
            throw new RuntimeIOException(String.format("Cannot start command [%s] on [%s]", obfuscatedCmd, this), e);
        }
    }

    protected CmdLine processCommandLine(CmdLine cmd) {
        CmdLine processedCmd;
        logger.trace("Checking whether to prefix command line with cd: {}", (Object)cmd);
        if (this.startsWithPseudoCommand(cmd, NOCD_PSEUDO_COMMAND)) {
            logger.trace("Not prefixing command line with cd statement because the nocd pseudo command was present, but the pseudo command will be stripped");
            processedCmd = SshConnection.stripPrefixedPseudoCommand(cmd);
        } else if (this.getWorkingDirectory() != null) {
            logger.trace("Prefixing command line with cd statement because the current working directory was set");
            logger.trace("Replacing: {}", (Object)cmd);
            processedCmd = new CmdLine();
            processedCmd.addArgument("cd");
            processedCmd.addArgument(this.workingDirectory.getPath());
            processedCmd.addRaw(this.os.getCommandSeparator());
            for (CmdLineArgument a : cmd.getArguments()) {
                processedCmd.add(a);
            }
        } else {
            logger.trace("Not prefixing command line with cd statement because the current working directory was not set");
            processedCmd = cmd;
        }
        logger.trace("Processed command line for cd                  : {}", (Object)processedCmd);
        return processedCmd;
    }

    protected boolean startsWithPseudoCommand(CmdLine commandLine, String pseudoCommand) {
        return commandLine.getArguments().size() >= 2 && commandLine.getArguments().get(0).toString(this.os, false).equals(pseudoCommand);
    }

    protected SshProcess createProcess(Session session, CmdLine commandLine) throws TransportException, ConnectionException {
        return new SshProcess(this, this.os, session, commandLine);
    }

    @Override
    public String toString() {
        return this.protocolAndConnectionType + "://" + this.username + "@" + this.host + ":" + this.port;
    }

    protected static CmdLine stripPrefixedPseudoCommand(CmdLine commandLine) {
        return new CmdLine().add(commandLine.getArguments().subList(1, commandLine.getArguments().size()));
    }

    protected static CmdLine prefixWithPseudoCommand(CmdLine commandLine, String pseudoCommand) {
        CmdLine nosudoCommandLine = new CmdLine();
        nosudoCommandLine.addArgument(pseudoCommand);
        nosudoCommandLine.add(commandLine.getArguments());
        return nosudoCommandLine;
    }
}

