/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.cli;

import com.xebialabs.deployit.booter.remote.DeployitCommunicator;
import com.xebialabs.deployit.booter.remote.resteasy.DeployitClientException;
import com.xebialabs.deployit.cli.CliOptions;
import com.xebialabs.deployit.cli.ScriptEngineBuilder;
import com.xebialabs.deployit.cli.UnbufferedPrintWriter;
import com.xebialabs.deployit.cli.help.HelpScanner;
import com.xebialabs.deployit.cli.util.Closeables;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.util.List;
import java.util.Set;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import javax.script.SimpleScriptContext;
import jline.console.ConsoleReader;
import org.python.core.Py;
import org.python.core.PyBaseExceptionDerived;
import org.python.core.PyException;

public class Interpreter {
    private final Set<String> cliObjectNames;
    private final ScriptEngine scriptEngine;
    private final CliOptions options;
    private final ScriptContext scriptContext;
    private final ConsoleReader consoleReader;
    private final DeployitCommunicator communicator;

    public Interpreter(ConsoleReader consoleReader, ScriptEngineBuilder scriptEngineBuilder, DeployitCommunicator communicator, CliOptions options, Set<String> cliObjectNames) {
        this.consoleReader = consoleReader;
        this.communicator = communicator;
        this.scriptEngine = scriptEngineBuilder.build();
        this.options = options;
        this.scriptContext = new SimpleScriptContext();
        ScriptContext context = this.scriptEngine.getContext();
        this.scriptContext.setWriter(new UnbufferedPrintWriter(System.out));
        this.scriptContext.setErrorWriter(new UnbufferedPrintWriter(System.err));
        this.scriptContext.setBindings(context.getBindings(100), 200);
        this.cliObjectNames = cliObjectNames;
    }

    void interpret() {
        block9: {
            try {
                if (!this.options.getScriptArgs().isEmpty()) {
                    String[] value = this.options.getScriptArgs().toArray(new String[0]);
                    this.scriptContext.setAttribute("javax.script.argv", value, 100);
                }
                if (this.options.interpretSourceFile()) {
                    this.evaluateFile(this.options.getSourceFileName());
                    break block9;
                }
                try {
                    this.advancedRepl(this.consoleReader);
                }
                catch (Exception e) {
                    throw new IllegalStateException("The REPL gave an exception!", e);
                }
            }
            catch (FileNotFoundException e) {
                System.err.println("File " + this.options.getSourceFileName() + " could not be read, reason:" + e.getMessage());
                System.exit(1);
            }
            catch (ScriptException e) {
                int exitCode;
                if (this.sysExitInvoked(e)) {
                    exitCode = this.getSysExitCode(e);
                } else {
                    this.printScriptException(e);
                    exitCode = 1;
                }
                System.exit(exitCode);
            }
        }
    }

    public void evaluateFile(String fileName) throws FileNotFoundException, ScriptException {
        this.scriptContext.setAttribute("javax.script.filename", fileName, 100);
        FileReader reader = new FileReader(fileName);
        try {
            this.evaluate(reader);
        }
        finally {
            Closeables.closeQuietly(reader);
        }
    }

    private boolean sysExitInvoked(ScriptException e) {
        return e.getCause() instanceof PyException && ((PyException)e.getCause()).type.equals((Object)Py.SystemExit);
    }

    private int getSysExitCode(ScriptException e) {
        return ((PyBaseExceptionDerived)((PyException)e.getCause()).value).getMessage().asInt();
    }

    public Object evaluate(Reader reader) throws ScriptException {
        this.evaluateBuiltins();
        return this.scriptEngine.eval(reader, this.scriptContext);
    }

    Object evaluate(String expression) throws ScriptException {
        if (expression == null) {
            return null;
        }
        return this.scriptEngine.eval(expression, this.scriptContext);
    }

    private void advancedRepl(ConsoleReader consoleReader) throws Exception {
        this.evaluateBuiltins();
        while (true) {
            String line;
            String trimmed;
            String string = trimmed = (line = consoleReader.readLine(this.getPrompt())) != null ? line.trim() : null;
            if (trimmed == null || trimmed.startsWith("quit") || trimmed.startsWith("exit")) break;
            if (trimmed.startsWith("help")) {
                HelpScanner.printHelp();
                continue;
            }
            try {
                Object evaluationResult = this.evaluate(line);
                if (evaluationResult instanceof String) {
                    System.out.println((String)evaluationResult);
                    continue;
                }
                if (evaluationResult == null) continue;
                System.out.println(evaluationResult.getClass().getSimpleName() + ": " + evaluationResult);
            }
            catch (ScriptException e) {
                this.printScriptException(e);
            }
        }
        this.exit();
    }

    private void evaluateBuiltins() {
        try {
            this.evaluate("import __builtin__");
            this.cliObjectNames.forEach(cliObject -> {
                try {
                    this.evaluate(String.format("__builtin__.%s = %s", cliObject, cliObject));
                }
                catch (ScriptException e) {
                    this.printScriptException(e);
                }
            });
        }
        catch (ScriptException e) {
            this.printScriptException(e);
        }
    }

    private void printScriptException(ScriptException e) {
        Throwable cause = e.getCause();
        if (cause == null) {
            System.err.println(e);
        } else if (cause instanceof PyException) {
            if (cause.getCause() == null) {
                System.err.println(cause);
            } else if (cause.getCause() instanceof DeployitClientException) {
                this.printValidationMessages((DeployitClientException)cause.getCause());
            } else {
                System.err.println(cause.getCause());
            }
        } else {
            System.err.println(cause);
        }
    }

    private void printValidationMessages(DeployitClientException exception) {
        Object entity = exception.getEntity();
        if (entity instanceof ConfigurationItem) {
            this.printCiValidation((ConfigurationItem)entity);
        } else if (entity instanceof List) {
            ((List)entity).forEach(this::printCiValidation);
        } else {
            System.err.println((Object)exception);
        }
    }

    private void printCiValidation(ConfigurationItem ci) {
        List validationMessages = ci.get$validationMessages();
        if (!validationMessages.isEmpty()) {
            System.out.printf("Configuration item '%s' contained validation errors:%n", ci.getId());
            validationMessages.forEach(message -> System.out.printf("- property '%s': %s%n", message.getPropertyName(), message.getMessage()));
        }
    }

    protected void exit() {
        System.out.println("Bye bye!");
    }

    String getPrompt() {
        String username = this.communicator.getHttpClientHolder().getUserName();
        if (username != null) {
            return username + " > ";
        }
        return "deployit > ";
    }

    public ScriptContext getScriptContext() {
        return this.scriptContext;
    }
}

