/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.plugin.manager.rest.api;

import com.xebialabs.deployit.core.rest.secured.AbstractSecuredResource;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import com.xebialabs.plugin.manager.Plugin;
import com.xebialabs.plugin.manager.PluginId;
import com.xebialabs.plugin.manager.PluginId$;
import com.xebialabs.plugin.manager.PluginId$Artifact$;
import com.xebialabs.plugin.manager.PluginId$LocalFile$;
import com.xebialabs.plugin.manager.metadata.ArtifactId;
import com.xebialabs.plugin.manager.metadata.ArtifactId$;
import com.xebialabs.plugin.manager.metadata.ArtifactId$ArtifactIdOps$;
import com.xebialabs.plugin.manager.metadata.ExtendedMetadata;
import com.xebialabs.plugin.manager.metadata.PluginMetadata;
import com.xebialabs.plugin.manager.metadata.Version;
import com.xebialabs.plugin.manager.metadata.Version$;
import com.xebialabs.plugin.manager.repository.PluginsRepository;
import com.xebialabs.plugin.manager.rest.api.PluginResource;
import com.xebialabs.plugin.manager.rest.api.PluginSource$;
import com.xebialabs.plugin.manager.rest.api.ValidationResult;
import com.xebialabs.plugin.manager.rest.dto.PluginDto;
import com.xebialabs.plugin.manager.rest.dto.PluginDto$;
import com.xebialabs.plugin.manager.rest.dto.PluginDtoList;
import com.xebialabs.plugin.manager.rest.dto.RepositoryDto;
import com.xebialabs.plugin.manager.service.PluginService;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.apache.commons.io.IOUtils;
import org.jboss.resteasy.plugins.providers.multipart.MultipartFormDataInput;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import scala.;
import scala.$less$colon$less$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.LinearSeqOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.io.Codec$;
import scala.reflect.ScalaSignature;
import scala.reflect.io.File$;
import scala.reflect.io.Path$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@Controller
@ScalaSignature(bytes="\u0006\u0005\t\u0015b\u0001B\u000b\u0017\u0001\rB\u0001b\r\u0001\u0003\u0006\u0004%\t\u0001\u000e\u0005\tw\u0001\u0011\t\u0011)A\u0005k!)A\b\u0001C\u0001{!9q\n\u0001b\u0001\n\u0003\u0001\u0006BB-\u0001A\u0003%\u0011\u000bC\u0004[\u0001\t\u0007I1A.\t\r\u0011\u0004\u0001\u0015!\u0003]\u0011\u0015)\u0007\u0001\"\u0011g\u0011\u0015\u0011\b\u0001\"\u0011t\u0011\u001d\ty\u0003\u0001C!\u0003cAq!a\u0011\u0001\t\u0003\n)\u0005\u0003\u0004\u0002L\u0001!\tE\u001a\u0005\b\u0003\u001b\u0002A\u0011IA(\u0011\u001d\t\u0019\u0006\u0001C!\u0003+Bq!!\u0017\u0001\t\u0003\nY\u0006C\u0004\u0002f\u0001!\t%a\u001a\t\u000f\u0005=\u0004\u0001\"\u0003\u0002r!I\u00111\u0018\u0001\u0012\u0002\u0013%\u0011Q\u0018\u0005\b\u0003+\u0004A\u0011BAl\u0011\u001d\t9\u000f\u0001C\u0001\u0003S\u0014!\u0003\u00157vO&t'+Z:pkJ\u001cW-S7qY*\u0011q\u0003G\u0001\u0004CBL'BA\r\u001b\u0003\u0011\u0011Xm\u001d;\u000b\u0005ma\u0012aB7b]\u0006<WM\u001d\u0006\u0003;y\ta\u0001\u001d7vO&t'BA\u0010!\u0003%AXMY5bY\u0006\u00147OC\u0001\"\u0003\r\u0019w.\\\u0002\u0001'\r\u0001Ae\f\t\u0003K5j\u0011A\n\u0006\u0003O!\nqa]3dkJ,GM\u0003\u0002\u001aS)\u0011!fK\u0001\u0005G>\u0014XM\u0003\u0002-=\u0005AA-\u001a9m_fLG/\u0003\u0002/M\t9\u0012IY:ue\u0006\u001cGoU3dkJ,GMU3t_V\u00148-\u001a\t\u0003aEj\u0011AF\u0005\u0003eY\u0011a\u0002\u00157vO&t'+Z:pkJ\u001cW-A\u0007qYV<\u0017N\\*feZL7-Z\u000b\u0002kA\u0011a'O\u0007\u0002o)\u0011\u0001HG\u0001\bg\u0016\u0014h/[2f\u0013\tQtGA\u0007QYV<\u0017N\\*feZL7-Z\u0001\u000fa2,x-\u001b8TKJ4\u0018nY3!\u0003\u0019a\u0014N\\5u}Q\u0011ah\u0010\t\u0003a\u0001AQaM\u0002A\u0002UB#aA!\u0011\u0005\tkU\"A\"\u000b\u0005\u0011+\u0015AC1o]>$\u0018\r^5p]*\u0011aiR\u0001\bM\u0006\u001cGo\u001c:z\u0015\tA\u0015*A\u0003cK\u0006t7O\u0003\u0002K\u0017\u0006y1\u000f\u001d:j]\u001e4'/Y7fo>\u00148NC\u0001M\u0003\ry'oZ\u0005\u0003\u001d\u000e\u0013\u0011\"Q;u_^L'/\u001a3\u0002!\u0011\u000bE+R0U\u00136+uLR(S\u001b\u0006#V#A)\u0011\u0005I;V\"A*\u000b\u0005Q+\u0016\u0001\u00027b]\u001eT\u0011AV\u0001\u0005U\u00064\u0018-\u0003\u0002Y'\n11\u000b\u001e:j]\u001e\f\u0011\u0003R!U\u000b~#\u0016*T#`\r>\u0013V*\u0011+!\u0003\t)7-F\u0001]!\ti&-D\u0001_\u0015\ty\u0006-\u0001\u0006d_:\u001cWO\u001d:f]RT\u0011!Y\u0001\u0006g\u000e\fG.Y\u0005\u0003Gz\u0013\u0001#\u0012=fGV$\u0018n\u001c8D_:$X\r\u001f;\u0002\u0007\u0015\u001c\u0007%\u0001\u0003mSN$H#A4\u0011\u0005!\u0004X\"A5\u000b\u0005)R'BA6m\u0003\t\u00118O\u0003\u0002n]\u0006\u0011qo\u001d\u0006\u0002_\u0006)!.\u0019<bq&\u0011\u0011/\u001b\u0002\t%\u0016\u001c\bo\u001c8tK\u00069\u0011N\\:uC2dG\u0003B4u\u0003\u0013AQ!^\u0005A\u0002Y\fQ!\u001b8qkR\u00042a^A\u0003\u001b\u0005A(BA={\u0003%iW\u000f\u001c;ja\u0006\u0014HO\u0003\u0002|y\u0006I\u0001O]8wS\u0012,'o\u001d\u0006\u0003{z\fq\u0001\u001d7vO&t7OC\u0002\u0000\u0003\u0003\t\u0001B]3ti\u0016\f7/\u001f\u0006\u0004\u0003\u0007Y\u0015!\u00026c_N\u001c\u0018bAA\u0004q\n1R*\u001e7uSB\f'\u000f\u001e$pe6$\u0015\r^1J]B,H\u000fC\u0004\u0002\f%\u0001\r!!\u0004\u0002\u0011AdWoZ5o\u0013\u0012\u0004B!a\u0004\u0002\u001e9!\u0011\u0011CA\r!\r\t\u0019\u0002Y\u0007\u0003\u0003+Q1!a\u0006#\u0003\u0019a$o\\8u}%\u0019\u00111\u00041\u0002\rA\u0013X\rZ3g\u0013\rA\u0016q\u0004\u0006\u0004\u00037\u0001\u0007\u0006CA\u0005\u0003G\tY#!\f\u0011\t\u0005\u0015\u0012qE\u0007\u0002U&\u0019\u0011\u0011\u00066\u0003\u0015E+XM]=QCJ\fW.A\u0003wC2,X-\t\u0002\u0002\f\u0005IQO\\5ogR\fG\u000e\u001c\u000b\nO\u0006M\u0012qGA\u001e\u0003\u007fAq!!\u000e\u000b\u0001\u0004\ti!\u0001\u0007sKB|7/\u001b;pefLE\rC\u0004\u0002:)\u0001\r!!\u0004\u0002\u000f\u001d\u0014x.\u001e9JI\"9\u0011Q\b\u0006A\u0002\u00055\u0011AC1si&4\u0017m\u0019;JI\"9\u0011\u0011\t\u0006A\u0002\u00055\u0011a\u0002<feNLwN\\\u0001\u0007g\u0016\f'o\u00195\u0015\u0007\u001d\f9\u0005C\u0004\u0002J-\u0001\r!!\u0004\u0002\u000bE,XM]=\u0002!1L7\u000f\u001e*fa>\u001c\u0018\u000e^8sS\u0016\u001c\u0018\u0001E;qI\u0006$XMU3q_NLGo\u001c:z)\r9\u0017\u0011\u000b\u0005\b\u0003ki\u0001\u0019AA\u0007\u00039a\u0017n\u001d;SKB|7/\u001b;pef$2aZA,\u0011\u001d\t)D\u0004a\u0001\u0003\u001b\tQ#\u001b8ti\u0006dGN\u0012:p[J+\u0007o\\:ji>\u0014\u0018\u0010F\u0005h\u0003;\ny&!\u0019\u0002d!9\u0011QG\bA\u0002\u00055\u0001bBA\u001d\u001f\u0001\u0007\u0011Q\u0002\u0005\b\u0003{y\u0001\u0019AA\u0007\u0011\u001d\t\te\u0004a\u0001\u0003\u001b\tqaZ3u\u0019><w\u000eF\u0004h\u0003S\nY'!\u001c\t\u000f\u0005U\u0002\u00031\u0001\u0002\u000e!9\u0011\u0011\b\tA\u0002\u00055\u0001bBA\u001f!\u0001\u0007\u0011QB\u0001\to&$\bNU3q_V!\u00111OA>)\u0019\t)(a+\u0002.R!\u0011qOAH!\u0011\tI(a\u001f\r\u0001\u00119\u0011QP\tC\u0002\u0005}$!\u0001+\u0012\t\u0005\u0005\u0015\u0011\u0012\t\u0005\u0003\u0007\u000b))D\u0001a\u0013\r\t9\t\u0019\u0002\b\u001d>$\b.\u001b8h!\u0011\t\u0019)a#\n\u0007\u00055\u0005MA\u0002B]fDq!!%\u0012\u0001\u0004\t\u0019*\u0001\u0004bGRLwN\u001c\t\t\u0003\u0007\u000b)*!'\u0002&&\u0019\u0011q\u00131\u0003\u0013\u0019+hn\u0019;j_:\f\u0004\u0003BAN\u0003Ck!!!(\u000b\u0007\u0005}%$\u0001\u0006sKB|7/\u001b;pefLA!a)\u0002\u001e\n\t\u0002\u000b\\;hS:\u001c(+\u001a9pg&$xN]=\u0011\u000bu\u000b9+a\u001e\n\u0007\u0005%fL\u0001\u0004GkR,(/\u001a\u0005\b\u0003k\t\u0002\u0019AA\u0007\u0011%\ty+\u0005I\u0001\u0002\u0004\t\t,\u0001\u0005ekJ\fG/[8o!\u0011\t\u0019,a.\u000e\u0005\u0005U&bAAX=&!\u0011\u0011XA[\u0005!!UO]1uS>t\u0017AE<ji\"\u0014V\r]8%I\u00164\u0017-\u001e7uII*B!a0\u0002TV\u0011\u0011\u0011\u0019\u0016\u0005\u0003c\u000b\u0019m\u000b\u0002\u0002FB!\u0011qYAh\u001b\t\tIM\u0003\u0003\u0002L\u00065\u0017!C;oG\",7m[3e\u0015\t!\u0005-\u0003\u0003\u0002R\u0006%'!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u00129\u0011Q\u0010\nC\u0002\u0005}\u0014!C<ji\"\u0014V\r]81+\u0011\tI.a8\u0015\t\u0005m\u0017Q\u001d\u000b\u0005\u0003;\f\t\u000f\u0005\u0003\u0002z\u0005}GaBA?'\t\u0007\u0011q\u0010\u0005\b\u0003#\u001b\u0002\u0019AAr!!\t\u0019)!&\u0002\u001a\u0006u\u0007bBA\u001b'\u0001\u0007\u0011QB\u0001\fi>\u0004F.^4j]\u0012#x.\u0006\u0002\u0002lBA\u00111QAK\u0003[\u0014Y\u0001\u0005\u0005\u0002\u0004\u0006=\u00181_A\u0000\u0013\r\t\t\u0010\u0019\u0002\u0007)V\u0004H.\u001a\u001a\u0011\t\u0005U\u00181`\u0007\u0003\u0003oT1!!?\u001b\u0003!iW\r^1eCR\f\u0017\u0002BA\u007f\u0003o\u0014!\"\u0011:uS\u001a\f7\r^%e!\u0019\t\u0019I!\u0001\u0003\u0006%\u0019!1\u00011\u0003\r=\u0003H/[8o!\u0011\t)Pa\u0002\n\t\t%\u0011q\u001f\u0002\u000f!2,x-\u001b8NKR\fG-\u0019;b!\u0011\u0011iAa\u0005\u000e\u0005\t=!b\u0001B\t1\u0005\u0019A\r^8\n\t\tU!q\u0002\u0002\n!2,x-\u001b8Ei>D3\u0001\u0001B\r!\u0011\u0011YB!\t\u000e\u0005\tu!b\u0001B\u0010\u0013\u0006Q1\u000f^3sK>$\u0018\u0010]3\n\t\t\r\"Q\u0004\u0002\u000b\u0007>tGO]8mY\u0016\u0014\b")
public class PluginResourceImpl
extends AbstractSecuredResource
implements PluginResource {
    private final PluginService pluginService;
    private final String DATE_TIME_FORMAT;
    private final ExecutionContext ec;

    public PluginService pluginService() {
        return this.pluginService;
    }

    public String DATE_TIME_FORMAT() {
        return this.DATE_TIME_FORMAT;
    }

    public ExecutionContext ec() {
        return this.ec;
    }

    @Override
    public Response list() {
        this.checkPermission(PlatformPermissions.ADMIN);
        return Response.ok((Object)new PluginDtoList(this.pluginService().extend(this.pluginService().listInstalled())), (String)"application/json").build();
    }

    @Override
    public Response install(MultipartFormDataInput input, @QueryParam(value="pluginId") String pluginId) {
        Option option;
        Response response;
        Option option2;
        this.checkPermission(PlatformPermissions.ADMIN);
        Map uploadForm = input.getFormDataMap();
        java.util.List inputParts = (java.util.List)uploadForm.get("file");
        String string = pluginId;
        if (string != null && !(option2 = PluginId$.MODULE$.patternVersionWithNightly().unapplySeq((CharSequence)string)).isEmpty() && option2.get() != null && ((List)option2.get()).lengthCompare(2) == 0) {
            String name = (String)((LinearSeqOps)option2.get()).apply(0);
            String versionWithNightly = (String)((LinearSeqOps)option2.get()).apply(1);
            response = this.tryInstall$1(pluginId, name, versionWithNightly, inputParts);
        } else if (string != null && !(option = PluginId$.MODULE$.pattern().unapplySeq((CharSequence)string)).isEmpty() && option.get() != null && ((List)option.get()).lengthCompare(2) == 0) {
            String name = (String)((LinearSeqOps)option.get()).apply(0);
            String version = (String)((LinearSeqOps)option.get()).apply(1);
            response = this.tryInstall$1(pluginId, name, version, inputParts);
        } else {
            response = this.tryInstallLocal$1(pluginId, inputParts);
        }
        return response;
    }

    @Override
    public Response uninstall(String repositoryId, String groupId, String artifactId, String version) {
        this.checkPermission(PlatformPermissions.ADMIN);
        Enumeration.Value pluginSource = PluginSource$.MODULE$.withName(repositoryId);
        None$ optionalVersion = version.isEmpty() ? None$.MODULE$ : new Some((Object)version.split("/")[1]);
        return (Response)this.pluginService().uninstall(pluginSource, groupId, artifactId, (Option<String>)optionalVersion).map((Function1 & Serializable)x$1 -> Response.ok().build()).fold((Function1 & Serializable)err -> {
            throw err;
        }, (Function1 & Serializable)ok -> ok);
    }

    @Override
    public Response search(String query) {
        this.checkPermission(PlatformPermissions.ADMIN);
        return Response.ok((Object)new PluginDtoList((Seq<PluginDto>)((IterableOnceOps)this.pluginService().search(query).map(this.toPluginDto())).toSeq()), (String)"application/json").build();
    }

    @Override
    public Response listRepositories() {
        this.checkPermission(PlatformPermissions.ADMIN);
        return Response.ok((Object)new RepositoryDto((Seq<PluginsRepository>)this.pluginService().repositories().values().toSeq()), (String)"application/json").build();
    }

    @Override
    public Response updateRepository(String repositoryId) {
        this.checkPermission(PlatformPermissions.ADMIN);
        String lastDownloaded = (String)this.withRepo(repositoryId, this.withRepo$default$2(), (Function1 & Serializable)x$2 -> x$2.update().map((Function1 & Serializable)x$3 -> DateTimeFormat.forPattern((String)this.DATE_TIME_FORMAT()).print((ReadableInstant)x$3), this.ec()));
        return Response.ok(Collections.singletonMap("lastDownloaded", lastDownloaded)).build();
    }

    @Override
    public Response listRepository(String repositoryId) {
        this.checkPermission(PlatformPermissions.ADMIN);
        return Response.ok((Object)new PluginDtoList((Seq<PluginDto>)((IterableOnceOps)((IterableOps)this.withRepo(repositoryId, this.withRepo$default$2(), (Function1 & Serializable)x$4 -> x$4.list())).map(this.toPluginDto())).toSeq()), (String)"application/json").build();
    }

    @Override
    public Response installFromRepository(String repositoryId, String groupId, String artifactId, String version) {
        this.checkPermission(PlatformPermissions.ADMIN);
        PluginId.Artifact artifact = PluginId$Artifact$.MODULE$.apply(repositoryId, groupId, artifactId, version, PluginId$Artifact$.MODULE$.apply$default$5());
        return (Response)this.pluginService().installFromRepository(artifact).map((Function1 & Serializable)x$5 -> Response.ok((Object)artifact, (String)"application/json").build()).fold((Function1 & Serializable)err -> {
            throw err;
        }, (Function1 & Serializable)ok -> ok);
    }

    @Override
    public Response getLogo(String repositoryId, String groupId, String artifactId) {
        this.checkPermission(PlatformPermissions.ADMIN);
        return (Response)this.pluginService().getLogo(repositoryId, artifactId).map((Function1 & Serializable)logoFile -> {
            FileInputStream input = File$.MODULE$.apply(Path$.MODULE$.jfile2path(logoFile), Codec$.MODULE$.fallbackSystemCodec()).inputStream();
            StreamingOutput stream = new StreamingOutput(null, input){
                private final FileInputStream input$1;

                public void write(OutputStream output) {
                    output.write(IOUtils.toByteArray((InputStream)this.input$1));
                    this.input$1.close();
                }
                {
                    this.input$1 = input$1;
                }
            };
            return Response.ok((Object)stream, (String)"application/octet-stream").build();
        }).getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException(new StringBuilder(43).append("Couldn't find logo for '").append(groupId).append(":").append(artifactId).append("' in repository '").append(repositoryId).append("'").toString());
        });
    }

    private <T> T withRepo(String repositoryId, Duration duration, Function1<PluginsRepository, Future<T>> action) {
        return this.withRepo0(repositoryId, (Function1 & Serializable)repository -> Await$.MODULE$.result((Awaitable)action.apply(repository), duration));
    }

    private <T> Duration withRepo$default$2() {
        return new package.DurationInt(package$.MODULE$.DurationInt(30)).seconds();
    }

    private <T> T withRepo0(String repositoryId, Function1<PluginsRepository, T> action) {
        Option option = this.pluginService().repositories().get((Object)repositoryId);
        if (None$.MODULE$.equals(option)) {
            throw new NotFoundException(new StringBuilder(28).append("Unknown plugin repository '").append(repositoryId).append("'").toString());
        }
        if (!(option instanceof Some)) {
            throw new MatchError((Object)option);
        }
        Some some = (Some)option;
        PluginsRepository repository = (PluginsRepository)some.value();
        Object object = action.apply((Object)repository);
        return (T)object;
    }

    public Function1<Tuple2<ArtifactId, Option<PluginMetadata>>, PluginDto> toPluginDto() {
        return (Function1 & Serializable)tuple -> new PluginDto((ArtifactId)tuple._1(), (Option<PluginMetadata>)((Option)tuple._2()), PluginDto$.MODULE$.apply$default$3());
    }

    private final Response installOfficial$1(PluginId pluginId, java.util.List inputParts) {
        inputParts.forEach(part -> {
            InputStream is = (InputStream)part.getBody(InputStream.class, null);
            this.pluginService().install(new Plugin(pluginId, (Option<ExtendedMetadata>)None$.MODULE$, is));
        });
        return Response.ok().build();
    }

    private final Response tryInstallLocal$1(String pluginId, java.util.List inputParts) {
        Response response;
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> PluginId$LocalFile$.MODULE$.apply(pluginId));
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            PluginId.LocalFile localFile = (PluginId.LocalFile)success.value();
            this.installOfficial$1(localFile, inputParts);
            response = Response.ok().build();
        } else if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable exception = failure.exception();
            response = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new ValidationResult(exception.getMessage())).build();
        } else {
            throw new MatchError((Object)try_);
        }
        return response;
    }

    private final Response tryInstall$1(String pluginId, String basename, String version, java.util.List inputParts) {
        Response response;
        scala.collection.immutable.Map<ArtifactId, Option<PluginMetadata>> searchResults = this.pluginService().searchOfficial(basename);
        if (searchResults.size() == 1) {
            PluginId.Artifact artifact = ArtifactId$ArtifactIdOps$.MODULE$.toArtifact$extension(ArtifactId$.MODULE$.ArtifactIdOps((ArtifactId)((Tuple2)searchResults.head())._1()));
            Version x$1 = (Version)Version$.MODULE$.fromString(version).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
            String x$2 = artifact.copy$default$1();
            String x$3 = artifact.copy$default$2();
            String x$4 = artifact.copy$default$3();
            String x$5 = artifact.copy$default$5();
            Option<String> x$6 = artifact.copy$default$6();
            response = this.installOfficial$1(artifact.copy(x$2, x$3, x$4, x$1, x$5, x$6), inputParts);
        } else {
            response = this.tryInstallLocal$1(pluginId, inputParts);
        }
        return response;
    }

    @Autowired
    public PluginResourceImpl(PluginService pluginService) {
        this.pluginService = pluginService;
        this.DATE_TIME_FORMAT = "MM-dd-YYYY hh:mm:ss z";
        this.ec = pluginService.pluginManager().ec();
    }
}

