/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config.inject;

import io.smallrye.config.Converters;
import io.smallrye.config.SmallRyeConfig;
import io.smallrye.config.inject.ConfigExtension;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import javax.enterprise.inject.spi.InjectionPoint;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.eclipse.microprofile.config.spi.Converter;

public class ConfigProducerUtil {
    private ConfigProducerUtil() {
    }

    public static <T> T getValue(InjectionPoint injectionPoint, Config config) {
        Object converted;
        String name = ConfigProducerUtil.getName(injectionPoint);
        if (name == null) {
            return null;
        }
        SmallRyeConfig src = (SmallRyeConfig)config;
        Converter<T> converter = ConfigProducerUtil.resolveConverter(injectionPoint, src);
        String rawValue = src.getRawValue(name);
        if (rawValue == null) {
            rawValue = ConfigProducerUtil.getDefaultValue(injectionPoint);
        }
        if (rawValue == null) {
            try {
                converted = converter.convert("");
            }
            catch (IllegalArgumentException ignored) {
                throw ConfigProducerUtil.propertyNotFound(name);
            }
        } else {
            converted = converter.convert(rawValue);
        }
        if (converted == null) {
            throw ConfigProducerUtil.propertyNotFound(name);
        }
        return (T)converted;
    }

    private static NoSuchElementException propertyNotFound(String name) {
        return new NoSuchElementException("Required property " + name + " not found");
    }

    private static <T> Converter<T> resolveConverter(InjectionPoint injectionPoint, SmallRyeConfig src) {
        return ConfigProducerUtil.resolveConverter(injectionPoint.getType(), src);
    }

    private static <T> Converter<T> resolveConverter(Type type, SmallRyeConfig src) {
        Class<T> rawType = ConfigProducerUtil.rawTypeOf(type);
        if (type instanceof ParameterizedType) {
            ParameterizedType paramType = (ParameterizedType)type;
            Type[] typeArgs = paramType.getActualTypeArguments();
            if (rawType == List.class) {
                return Converters.newCollectionConverter(ConfigProducerUtil.resolveConverter(typeArgs[0], src), ArrayList::new);
            }
            if (rawType == Set.class) {
                return Converters.newCollectionConverter(ConfigProducerUtil.resolveConverter(typeArgs[0], src), HashSet::new);
            }
            if (rawType == Optional.class) {
                return Converters.newOptionalConverter(ConfigProducerUtil.resolveConverter(typeArgs[0], src));
            }
        }
        return src.getConverter(rawType);
    }

    private static <T> Class<T> rawTypeOf(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return ConfigProducerUtil.rawTypeOf(((ParameterizedType)type).getRawType());
        }
        if (type instanceof GenericArrayType) {
            return Array.newInstance(ConfigProducerUtil.rawTypeOf(((GenericArrayType)type).getGenericComponentType()), 0).getClass();
        }
        throw new IllegalArgumentException("Type has no raw type class: " + type);
    }

    public static String getName(InjectionPoint injectionPoint) {
        for (Annotation qualifier : injectionPoint.getQualifiers()) {
            if (!qualifier.annotationType().equals(ConfigProperty.class)) continue;
            ConfigProperty configProperty = (ConfigProperty)qualifier;
            return ConfigExtension.getConfigKey(injectionPoint, configProperty);
        }
        return null;
    }

    private static String getDefaultValue(InjectionPoint injectionPoint) {
        for (Annotation qualifier : injectionPoint.getQualifiers()) {
            if (!qualifier.annotationType().equals(ConfigProperty.class)) continue;
            String str = ((ConfigProperty)qualifier).defaultValue();
            if (!"org.eclipse.microprofile.config.configproperty.unconfigureddvalue".equals(str)) {
                return str;
            }
            Class rawType = ConfigProducerUtil.rawTypeOf(injectionPoint.getType());
            if (rawType.isPrimitive()) {
                if (rawType == Character.TYPE) {
                    return null;
                }
                if (rawType == Boolean.TYPE) {
                    return "false";
                }
                return "0";
            }
            return null;
        }
        return null;
    }
}

