/*
 * Decompiled with CFR 0.152.
 */
package akka.cluster;

import akka.annotation.InternalApi;
import akka.cluster.Cluster$;
import akka.cluster.Gossip$;
import akka.cluster.GossipOverview;
import akka.cluster.Member;
import akka.cluster.Member$;
import akka.cluster.MemberStatus;
import akka.cluster.MemberStatus$Down$;
import akka.cluster.MemberStatus$Removed$;
import akka.cluster.Reachability;
import akka.cluster.UniqueAddress;
import akka.cluster.VectorClock;
import akka.cluster.VectorClock$Node$;
import java.io.Serializable;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Set;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.SortedSet;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\r\u0005rAB#G\u0011\u00031%J\u0002\u0004M\r\"\u0005a)\u0014\u0005\u00069\u0006!\tAX\u0003\u0005?\u0006\u0001\u0001\rC\u0004d\u0003\t\u0007I\u0011\u00013\t\rA\f\u0001\u0015!\u0003f\u0011\u001d\t\u0018A1A\u0005\u0002IDqAa8\u0002A\u0003%1\u000fC\u0004\u0003b\u0006!\tAa9\t\u000f\t\u001d\u0018\u0001\"\u0001\u0003j\"I!\u0011]\u0001\u0002\u0002\u0013\u0005%Q\u001e\u0005\n\u0005o\f\u0011\u0013!C\u0001\u0005_B\u0011B!?\u0002#\u0003%\tA!\u001e\t\u0013\tm\u0018!%A\u0005\u0002\tm\u0004\"\u0003B\u007f\u0003\u0005\u0005I\u0011\u0011B\u0000\u0011%\u0019\t\"AI\u0001\n\u0003\u0011y\u0007C\u0005\u0004\u0014\u0005\t\n\u0011\"\u0001\u0003v!I1QC\u0001\u0012\u0002\u0013\u0005!1\u0010\u0005\n\u0007/\t\u0011\u0011!C\u0005\u000731Q\u0001\u0014$C\rRD\u0011\"a\u0002\u0014\u0005+\u0007I\u0011\u00013\t\u0013\u0005%1C!E!\u0002\u0013)\u0007BCA\u0006'\tU\r\u0011\"\u0001\u0002\u000e!Q\u0011QC\n\u0003\u0012\u0003\u0006I!a\u0004\t\u0015\u0005]1C!f\u0001\n\u0003\tI\u0002\u0003\u0006\u0002\"M\u0011\t\u0012)A\u0005\u00037A!\"a\t\u0014\u0005+\u0007I\u0011AA\u0013\u0011)\t\te\u0005B\tB\u0003%\u0011q\u0005\u0005\u00079N!\t!a\u0011\t\u000f\u000553\u0003\"\u0003\u0002P!Q\u0011qK\n\t\u0006\u0004%I!!\u0017\t\u0015\u0005\u00154\u0003#b\u0001\n\u0003\t9\u0007C\u0004\u0002rM!\t!a\u001d\t\u000f\u0005E4\u0003\"\u0001\u0002\b\"9\u0011QR\n\u0005\u0002\u0005=\u0005bBAJ'\u0011\u0005\u0011Q\u0013\u0005\b\u00033\u001bB\u0011AAN\u0011\u001d\tij\u0005C\u0001\u0003?Cq!a*\u0014\t\u0003\tI\u000bC\u0004\u0002.N!\t!a,\t\u000f\u0005U6\u0003\"\u0001\u00028\"Q\u00111X\n\t\u0006\u0004%\t!!0\t\u000f\u0005\u00157\u0003\"\u0001\u0002H\"9\u0011\u0011\\\n\u0005\u0002\u0005m\u0007bBAs'\u0011\u0005\u0011q\r\u0005\b\u0003O\u001cB\u0011AAu\u0011\u001d\tYi\u0005C\u0001\u0003gDq!a>\u0014\t\u0003\tI\u0010C\u0004\u0002~N!\t!a@\t\u000f\t=1\u0003\"\u0001\u0003\u0012!9!qC\n\u0005\u0002\te\u0001b\u0002B\u0010'\u0011\u0005!\u0011\u0005\u0005\b\u0005K\u0019B\u0011\u0001B\u0014\u0011\u001d\u0011ic\u0005C\u0001\u0005_AqA!\u000e\u0014\t\u0003\u00119\u0004C\u0004\u0003FM!\tEa\u0012\t\u0013\t%3#!A\u0005\u0002\t-\u0003\"\u0003B+'E\u0005I\u0011\u0001B,\u0011%\u0011igEI\u0001\n\u0003\u0011y\u0007C\u0005\u0003tM\t\n\u0011\"\u0001\u0003v!I!\u0011P\n\u0012\u0002\u0013\u0005!1\u0010\u0005\n\u0005\u007f\u001a\u0012\u0011!C!\u0005\u0003C\u0011B!$\u0014\u0003\u0003%\tAa$\t\u0013\t]5#!A\u0005\u0002\te\u0005\"\u0003BS'\u0005\u0005I\u0011\tBT\u0011%\u0011\tlEA\u0001\n\u0003\u0011\u0019\fC\u0005\u00038N\t\t\u0011\"\u0011\u0003:\"I!QX\n\u0002\u0002\u0013\u0005#q\u0018\u0005\n\u0005\u0003\u001c\u0012\u0011!C!\u0005\u0007\faaR8tg&\u0004(BA$I\u0003\u001d\u0019G.^:uKJT\u0011!S\u0001\u0005C.\\\u0017\r\u0005\u0002L\u00035\taI\u0001\u0004H_N\u001c\u0018\u000e]\n\u0004\u00039#\u0006CA(S\u001b\u0005\u0001&\"A)\u0002\u000bM\u001c\u0017\r\\1\n\u0005M\u0003&AB!osJ+g\r\u0005\u0002V56\taK\u0003\u0002X1\u0006\u0011\u0011n\u001c\u0006\u00023\u0006!!.\u0019<b\u0013\tYfK\u0001\u0007TKJL\u0017\r\\5{C\ndW-\u0001\u0004=S:LGOP\u0002\u0001)\u0005Q%!\u0003+j[\u0016\u001cH/Y7q!\ty\u0015-\u0003\u0002c!\n!Aj\u001c8h\u00031)W\u000e\u001d;z\u001b\u0016l'-\u001a:t+\u0005)\u0007c\u00014l[6\tqM\u0003\u0002iS\u0006I\u0011.\\7vi\u0006\u0014G.\u001a\u0006\u0003UB\u000b!bY8mY\u0016\u001cG/[8o\u0013\tawMA\u0005T_J$X\rZ*fiB\u00111J\\\u0005\u0003_\u001a\u0013a!T3nE\u0016\u0014\u0018!D3naRLX*Z7cKJ\u001c\b%A\u0003f[B$\u00180F\u0001t!\tY5c\u0005\u0003\u0014\u001dVD\bCA(w\u0013\t9\bKA\u0004Qe>$Wo\u0019;\u0011\u0007e\f\u0019A\u0004\u0002{\u007f:\u00111P`\u0007\u0002y*\u0011Q0X\u0001\u0007yI|w\u000e\u001e \n\u0003EK1!!\u0001Q\u0003\u001d\u0001\u0018mY6bO\u0016L1aWA\u0003\u0015\r\t\t\u0001U\u0001\b[\u0016l'-\u001a:t\u0003!iW-\u001c2feN\u0004\u0013\u0001C8wKJ4\u0018.Z<\u0016\u0005\u0005=\u0001cA&\u0002\u0012%\u0019\u00111\u0003$\u0003\u001d\u001d{7o]5q\u001fZ,'O^5fo\u0006IqN^3sm&,w\u000fI\u0001\bm\u0016\u00148/[8o+\t\tY\u0002E\u0002L\u0003;I1!a\bG\u0005-1Vm\u0019;pe\u000ecwnY6\u0002\u0011Y,'o]5p]\u0002\n!\u0002^8nEN$xN\\3t+\t\t9\u0003\u0005\u0005\u0002*\u0005E\u0012qGA\u001f\u001d\u0011\tY#!\f\u0011\u0005m\u0004\u0016bAA\u0018!\u00061\u0001K]3eK\u001aLA!a\r\u00026\t\u0019Q*\u00199\u000b\u0007\u0005=\u0002\u000bE\u0002L\u0003sI1!a\u000fG\u00055)f.[9vK\u0006#GM]3tgB\u0019\u0011qH\u0002\u000f\u0005-\u0003\u0011a\u0003;p[\n\u001cHo\u001c8fg\u0002\"\u0012b]A#\u0003\u000f\nI%a\u0013\t\r\u0005\u001dA\u00041\u0001f\u0011%\tY\u0001\bI\u0001\u0002\u0004\ty\u0001C\u0005\u0002\u0018q\u0001\n\u00111\u0001\u0002\u001c!I\u00111\u0005\u000f\u0011\u0002\u0003\u0007\u0011qE\u0001\u0011CN\u001cXM\u001d;J]Z\f'/[1oiN$\"!!\u0015\u0011\u0007=\u000b\u0019&C\u0002\u0002VA\u0013A!\u00168ji\u0006QQ.Z7cKJ\u001cX*\u00199\u0016\u0005\u0005m\u0003cBA\u0015\u0003c\t9$\u001c\u0015\u0004=\u0005}\u0003cA(\u0002b%\u0019\u00111\r)\u0003\u0013Q\u0014\u0018M\\:jK:$\u0018!C5t\u001bVdG/\u001b#d+\t\tI\u0007E\u0002P\u0003WJ1!!\u001cQ\u0005\u001d\u0011un\u001c7fC:D3aHA0\u0003-!3m\u001c7p]\u0012\u0002H.^:\u0015\u0007M\f)\bC\u0004\u0002x\u0001\u0002\r!!\u001f\u0002\t9|G-\u001a\t\u0005\u0003w\n\tID\u0002L\u0003{J1!a G\u0003-1Vm\u0019;pe\u000ecwnY6\n\t\u0005\r\u0015Q\u0011\u0002\u0005\u001d>$WMC\u0002\u0002\u0000\u0019#2a]AE\u0011\u0019\tY)\ta\u0001[\u00061Q.Z7cKJ\fAa]3f]R\u00191/!%\t\u000f\u0005]$\u00051\u0001\u00028\u0005AqN\u001c7z'\u0016,g\u000eF\u0002t\u0003/Cq!a\u001e$\u0001\u0004\t9$A\u0005dY\u0016\f'oU3f]R\t1/\u0001\u0004tK\u0016t')_\u000b\u0003\u0003C\u0003b!!\u000b\u0002$\u0006]\u0012\u0002BAS\u0003k\u00111aU3u\u0003)\u0019X-\u001a8Cs:{G-\u001a\u000b\u0005\u0003S\nY\u000bC\u0004\u0002x\u0019\u0002\r!a\u000e\u0002\u00135,'oZ3TK\u0016tGcA:\u00022\"1\u00111W\u0014A\u0002M\fA\u0001\u001e5bi\u0006)Q.\u001a:hKR\u00191/!/\t\r\u0005M\u0006\u00061\u0001t\u0003\u0011\u0012X-Y2iC\nLG.\u001b;z\u000bb\u001cG.\u001e3j]\u001e$un\u001e8fI>\u00137/\u001a:wKJ\u001cXCAA`!\rY\u0015\u0011Y\u0005\u0004\u0003\u00074%\u0001\u0004*fC\u000eD\u0017MY5mSRL\u0018AD1mY\u0012\u000bG/Y\"f]R,'o]\u000b\u0003\u0003\u0013\u0004b!!\u000b\u0002$\u0006-\u0007\u0003BAg\u0003't1aSAh\u0013\r\t\tNR\u0001\u0010\u00072,8\u000f^3s'\u0016$H/\u001b8hg&!\u0011Q[Al\u0005)!\u0015\r^1DK:$XM\u001d\u0006\u0004\u0003#4\u0015\u0001C1mYJ{G.Z:\u0016\u0005\u0005u\u0007CBA\u0015\u0003G\u000by\u000e\u0005\u0003\u0002*\u0005\u0005\u0018\u0002BAr\u0003k\u0011aa\u0015;sS:<\u0017AE5t'&tw\r\\3u_:\u001cE.^:uKJ\f1\"[:SK\u0006\u001c\u0007.\u00192mKR1\u0011\u0011NAv\u0003_Dq!!<.\u0001\u0004\t9$A\u0006ge>l\u0017\t\u001a3sKN\u001c\bbBAy[\u0001\u0007\u0011qG\u0001\ni>\fE\r\u001a:fgN$2!\\A{\u0011\u001d\t9H\fa\u0001\u0003o\t\u0011\u0002[1t\u001b\u0016l'-\u001a:\u0015\t\u0005%\u00141 \u0005\b\u0003oz\u0003\u0019AA\u001c\u0003%\u0011X-\\8wK\u0006cG\u000eF\u0003t\u0005\u0003\u0011Y\u0001C\u0004\u0003\u0004A\u0002\rA!\u0002\u0002\u000b9|G-Z:\u0011\u000be\u00149!a\u000e\n\t\t%\u0011Q\u0001\u0002\t\u0013R,'/\u00192mK\"1!Q\u0002\u0019A\u0002\u0001\f\u0001C]3n_Z\fG\u000eV5nKN$\u0018-\u001c9\u0002\rU\u0004H-\u0019;f)\r\u0019(1\u0003\u0005\u0007\u0005+\t\u0004\u0019A3\u0002\u001dU\u0004H-\u0019;fI6+WNY3sg\u00061!/Z7pm\u0016$Ra\u001dB\u000e\u0005;Aq!a\u001e3\u0001\u0004\t9\u0004\u0003\u0004\u0003\u000eI\u0002\r\u0001Y\u0001\u000b[\u0006\u00148.Q:E_^tGcA:\u0003$!1\u00111R\u001aA\u00025\fQ\u0001\u001d:v]\u0016$2a\u001dB\u0015\u0011\u001d\u0011Y\u0003\u000ea\u0001\u0003s\n1B]3n_Z,GMT8eK\u0006y\u0001O];oKR{WNY:u_:,7\u000fF\u0002t\u0005cAqAa\r6\u0001\u0004\ti$A\tsK6|g/Z#be2LWM\u001d+iC:\f!b]3f]\u0012Kw-Z:u+\t\u0011I\u0004E\u0003P\u0005w\u0011y$C\u0002\u0003>A\u0013Q!\u0011:sCf\u00042a\u0014B!\u0013\r\u0011\u0019\u0005\u0015\u0002\u0005\u0005f$X-\u0001\u0005u_N#(/\u001b8h)\t\ty.\u0001\u0003d_BLH#C:\u0003N\t=#\u0011\u000bB*\u0011!\t9\u0001\u000fI\u0001\u0002\u0004)\u0007\"CA\u0006qA\u0005\t\u0019AA\b\u0011%\t9\u0002\u000fI\u0001\u0002\u0004\tY\u0002C\u0005\u0002$a\u0002\n\u00111\u0001\u0002(\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\nTC\u0001B-U\r)'1L\u0016\u0003\u0005;\u0002BAa\u0018\u0003j5\u0011!\u0011\r\u0006\u0005\u0005G\u0012)'A\u0005v]\u000eDWmY6fI*\u0019!q\r)\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003l\t\u0005$!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012TC\u0001B9U\u0011\tyAa\u0017\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%gU\u0011!q\u000f\u0016\u0005\u00037\u0011Y&\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\tu$\u0006BA\u0014\u00057\nQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXC\u0001BB!\u0011\u0011)Ia#\u000e\u0005\t\u001d%b\u0001BE1\u0006!A.\u00198h\u0013\u0011\t\u0019Oa\"\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\tE\u0005cA(\u0003\u0014&\u0019!Q\u0013)\u0003\u0007%sG/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\tm%\u0011\u0015\t\u0004\u001f\nu\u0015b\u0001BP!\n\u0019\u0011I\\=\t\u0013\t\rv(!AA\u0002\tE\u0015a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0003*B1!1\u0016BW\u00057k\u0011![\u0005\u0004\u0005_K'\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$B!!\u001b\u00036\"I!1U!\u0002\u0002\u0003\u0007!1T\u0001\u0013aJ|G-^2u\u000b2,W.\u001a8u\u001d\u0006lW\r\u0006\u0003\u0003\u0004\nm\u0006\"\u0003BR\u0005\u0006\u0005\t\u0019\u0001BI\u0003!A\u0017m\u001d5D_\u0012,GC\u0001BI\u0003\u0019)\u0017/^1mgR!\u0011\u0011\u000eBc\u0011%\u0011\u0019\u000bRA\u0001\u0002\u0004\u0011Y\nK\u0002\u0014\u0005\u0013\u0004BAa3\u0003P6\u0011!Q\u001a\u0006\u0004\u0005OB\u0015\u0002\u0002Bi\u0005\u001b\u00141\"\u00138uKJt\u0017\r\\!qS\":1C!6\u0003\\\nu\u0007cA(\u0003X&\u0019!\u0011\u001c)\u0003!M+'/[1m-\u0016\u00148/[8o+&#\u0015!\u0002<bYV,g$A\u0001\u0002\r\u0015l\u0007\u000f^=!\u0003\u0015\t\u0007\u000f\u001d7z)\r\u0019(Q\u001d\u0005\u0007\u0003\u000fA\u0001\u0019A3\u0002\u0015Y\u001cGn\\2l\u001d\u0006lW\r\u0006\u0003\u0002`\n-\bbBA<\u0013\u0001\u0007\u0011q\u0007\u000b\ng\n=(\u0011\u001fBz\u0005kDa!a\u0002\u000b\u0001\u0004)\u0007\"CA\u0006\u0015A\u0005\t\u0019AA\b\u0011%\t9B\u0003I\u0001\u0002\u0004\tY\u0002C\u0005\u0002$)\u0001\n\u00111\u0001\u0002(\u0005y\u0011\r\u001d9ms\u0012\"WMZ1vYR$#'A\bbaBd\u0017\u0010\n3fM\u0006,H\u000e\u001e\u00134\u0003=\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u0012\"\u0014aB;oCB\u0004H.\u001f\u000b\u0005\u0007\u0003\u0019i\u0001E\u0003P\u0007\u0007\u00199!C\u0002\u0004\u0006A\u0013aa\u00149uS>t\u0007CC(\u0004\n\u0015\fy!a\u0007\u0002(%\u001911\u0002)\u0003\rQ+\b\u000f\\35\u0011!\u0019yADA\u0001\u0002\u0004\u0019\u0018a\u0001=%a\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uII\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\u001a\u0014a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$C'\u0001\u0007xe&$XMU3qY\u0006\u001cW\r\u0006\u0002\u0004\u001cA!!QQB\u000f\u0013\u0011\u0019yBa\"\u0003\r=\u0013'.Z2u\u0001")
@InternalApi
public final class Gossip
implements Product,
Serializable {
    private static final long serialVersionUID = 1L;
    private transient Map<UniqueAddress, Member> membersMap;
    private transient boolean isMultiDc;
    private Reachability reachabilityExcludingDownedObservers;
    private final SortedSet<Member> members;
    private final GossipOverview overview;
    private final VectorClock version;
    private final Map<UniqueAddress, Object> tombstones;
    private volatile transient byte bitmap$trans$0;
    private volatile boolean bitmap$0;

    public static Map<UniqueAddress, Object> $lessinit$greater$default$4() {
        return Gossip$.MODULE$.$lessinit$greater$default$4();
    }

    public static VectorClock $lessinit$greater$default$3() {
        return Gossip$.MODULE$.$lessinit$greater$default$3();
    }

    public static GossipOverview $lessinit$greater$default$2() {
        return Gossip$.MODULE$.$lessinit$greater$default$2();
    }

    public static Option<Tuple4<SortedSet<Member>, GossipOverview, VectorClock, Map<UniqueAddress, Object>>> unapply(Gossip gossip) {
        return Gossip$.MODULE$.unapply(gossip);
    }

    public static Map<UniqueAddress, Object> apply$default$4() {
        return Gossip$.MODULE$.apply$default$4();
    }

    public static VectorClock apply$default$3() {
        return Gossip$.MODULE$.apply$default$3();
    }

    public static GossipOverview apply$default$2() {
        return Gossip$.MODULE$.apply$default$2();
    }

    public static Gossip apply(SortedSet<Member> sortedSet, GossipOverview gossipOverview, VectorClock vectorClock, Map<UniqueAddress, Object> map) {
        return Gossip$.MODULE$.apply(sortedSet, gossipOverview, vectorClock, map);
    }

    public static String vclockName(UniqueAddress uniqueAddress) {
        return Gossip$.MODULE$.vclockName(uniqueAddress);
    }

    public static Gossip apply(SortedSet<Member> sortedSet) {
        return Gossip$.MODULE$.apply(sortedSet);
    }

    public static Gossip empty() {
        return Gossip$.MODULE$.empty();
    }

    public static SortedSet<Member> emptyMembers() {
        return Gossip$.MODULE$.emptyMembers();
    }

    public Iterator<String> productElementNames() {
        return Product.productElementNames$((Product)this);
    }

    public SortedSet<Member> members() {
        return this.members;
    }

    public GossipOverview overview() {
        return this.overview;
    }

    public VectorClock version() {
        return this.version;
    }

    public Map<UniqueAddress, Object> tombstones() {
        return this.tombstones;
    }

    private void assertInvariants() {
        Gossip.ifTrueThrow$1((Function0)(JFunction0.mcZ.sp & Serializable)() -> this.members().exists((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)Gossip.$anonfun$assertInvariants$2(x$1))), new StringBuilder(36).append("Live members must not have status [").append(MemberStatus$Removed$.MODULE$).append("]").toString(), String.valueOf(this.members().filter((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)Gossip.$anonfun$assertInvariants$3(x$2)))));
        scala.collection.immutable.Set inReachabilityButNotMember = (scala.collection.immutable.Set)this.overview().reachability().allObservers().diff((Set)this.members().map((Function1 & Serializable)x$3 -> x$3.uniqueAddress(), Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms())));
        Gossip.ifTrueThrow$1((Function0)(JFunction0.mcZ.sp & Serializable)() -> inReachabilityButNotMember.nonEmpty(), "Nodes not part of cluster in reachability table", inReachabilityButNotMember.mkString(", "));
        scala.collection.immutable.Set inReachabilityVersionsButNotMember = (scala.collection.immutable.Set)this.overview().reachability().versions().keySet().diff((Set)this.members().map((Function1 & Serializable)x$4 -> x$4.uniqueAddress(), Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms())));
        Gossip.ifTrueThrow$1((Function0)(JFunction0.mcZ.sp & Serializable)() -> inReachabilityVersionsButNotMember.nonEmpty(), "Nodes not part of cluster in reachability versions table", inReachabilityVersionsButNotMember.mkString(", "));
        scala.collection.immutable.Set seenButNotMember = (scala.collection.immutable.Set)this.overview().seen().diff((Set)this.members().map((Function1 & Serializable)x$5 -> x$5.uniqueAddress(), Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms())));
        Gossip.ifTrueThrow$1((Function0)(JFunction0.mcZ.sp & Serializable)() -> seenButNotMember.nonEmpty(), "Nodes not part of cluster have marked the Gossip as seen", seenButNotMember.mkString(", "));
    }

    private Map<UniqueAddress, Member> membersMap$lzycompute() {
        Gossip gossip = this;
        synchronized (gossip) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.membersMap = this.members().iterator().map((Function1 & Serializable)m -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)m.uniqueAddress()), m)).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.membersMap;
    }

    private Map<UniqueAddress, Member> membersMap() {
        return (byte)(this.bitmap$trans$0 & 1) == 0 ? this.membersMap$lzycompute() : this.membersMap;
    }

    private boolean isMultiDc$lzycompute() {
        Gossip gossip = this;
        synchronized (gossip) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                boolean bl;
                if (this.members().size() <= 1) {
                    bl = false;
                } else {
                    String dc1 = ((Member)this.members().head()).dataCenter();
                    bl = this.members().exists((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)Gossip.$anonfun$isMultiDc$1(dc1, x$6)));
                }
                this.isMultiDc = bl;
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.isMultiDc;
    }

    public boolean isMultiDc() {
        return (byte)(this.bitmap$trans$0 & 2) == 0 ? this.isMultiDc$lzycompute() : this.isMultiDc;
    }

    public Gossip $colon$plus(String node) {
        VectorClock x$1 = this.version().$colon$plus(node);
        SortedSet<Member> x$2 = this.copy$default$1();
        GossipOverview x$3 = this.copy$default$2();
        Map<UniqueAddress, Object> x$4 = this.copy$default$4();
        return this.copy(x$2, x$3, x$1, x$4);
    }

    public Gossip $colon$plus(Member member) {
        return this.members().contains((Object)member) ? this : this.copy((SortedSet<Member>)((SortedSet)this.members().$plus((Object)member)), this.copy$default$2(), this.copy$default$3(), this.copy$default$4());
    }

    public Gossip seen(UniqueAddress node) {
        Gossip gossip;
        if (this.seenByNode(node)) {
            gossip = this;
        } else {
            GossipOverview x$1 = this.overview().copy((scala.collection.immutable.Set<UniqueAddress>)((scala.collection.immutable.Set)this.overview().seen().$plus((Object)node)), this.overview().copy$default$2());
            SortedSet<Member> x$2 = this.copy$default$1();
            VectorClock x$3 = this.copy$default$3();
            Map<UniqueAddress, Object> x$4 = this.copy$default$4();
            gossip = this.copy(x$2, x$1, x$3, x$4);
        }
        return gossip;
    }

    public Gossip onlySeen(UniqueAddress node) {
        GossipOverview x$1 = this.overview().copy((scala.collection.immutable.Set<UniqueAddress>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new UniqueAddress[]{node}))), this.overview().copy$default$2());
        SortedSet<Member> x$2 = this.copy$default$1();
        VectorClock x$3 = this.copy$default$3();
        Map<UniqueAddress, Object> x$4 = this.copy$default$4();
        return this.copy(x$2, x$1, x$3, x$4);
    }

    public Gossip clearSeen() {
        GossipOverview x$1 = this.overview().copy((scala.collection.immutable.Set<UniqueAddress>)Predef$.MODULE$.Set().empty(), this.overview().copy$default$2());
        SortedSet<Member> x$2 = this.copy$default$1();
        VectorClock x$3 = this.copy$default$3();
        Map<UniqueAddress, Object> x$4 = this.copy$default$4();
        return this.copy(x$2, x$1, x$3, x$4);
    }

    public scala.collection.immutable.Set<UniqueAddress> seenBy() {
        return this.overview().seen();
    }

    public boolean seenByNode(UniqueAddress node) {
        return this.overview().seen().apply((Object)node);
    }

    public Gossip mergeSeen(Gossip that) {
        GossipOverview x$1 = this.overview().copy((scala.collection.immutable.Set<UniqueAddress>)((scala.collection.immutable.Set)this.overview().seen().union(that.overview().seen())), this.overview().copy$default$2());
        SortedSet<Member> x$2 = this.copy$default$1();
        VectorClock x$3 = this.copy$default$3();
        Map<UniqueAddress, Object> x$4 = this.copy$default$4();
        return this.copy(x$2, x$1, x$3, x$4);
    }

    public Gossip merge(Gossip that) {
        Map mergedTombstones = (Map)this.tombstones().$plus$plus(that.tombstones());
        VectorClock mergedVClock = (VectorClock)mergedTombstones.keys().foldLeft((Object)this.version().merge(that.version()), (Function2 & Serializable)(vclock, node) -> vclock.prune(VectorClock$Node$.MODULE$.apply(Gossip$.MODULE$.vclockName((UniqueAddress)node))));
        SortedSet mergedMembers = (SortedSet)Gossip$.MODULE$.emptyMembers().union(Member$.MODULE$.pickHighestPriority((scala.collection.immutable.Set<Member>)this.members(), (scala.collection.immutable.Set<Member>)that.members(), (Map<UniqueAddress, Object>)mergedTombstones));
        Reachability mergedReachability = this.overview().reachability().merge((scala.collection.immutable.Set<UniqueAddress>)((scala.collection.immutable.Set)mergedMembers.map((Function1 & Serializable)x$7 -> x$7.uniqueAddress(), Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()))), that.overview().reachability());
        scala.collection.immutable.Set mergedSeen = Predef$.MODULE$.Set().empty();
        return new Gossip((SortedSet<Member>)mergedMembers, new GossipOverview((scala.collection.immutable.Set<UniqueAddress>)mergedSeen, mergedReachability), mergedVClock, (Map<UniqueAddress, Object>)mergedTombstones);
    }

    private Reachability reachabilityExcludingDownedObservers$lzycompute() {
        Gossip gossip = this;
        synchronized (gossip) {
            if (!this.bitmap$0) {
                SortedSet downed = (SortedSet)this.members().collect((PartialFunction)new Serializable(null){
                    private static final long serialVersionUID = 0L;

                    public final <A1 extends Member, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        A1 A1 = x1;
                        MemberStatus memberStatus = A1.status();
                        MemberStatus$Down$ memberStatus$Down$ = MemberStatus$Down$.MODULE$;
                        Object object = !(memberStatus != null ? !memberStatus.equals(memberStatus$Down$) : memberStatus$Down$ != null) ? A1 : function1.apply(x1);
                        return (B1)object;
                    }

                    public final boolean isDefinedAt(Member x1) {
                        Member member = x1;
                        MemberStatus memberStatus = member.status();
                        MemberStatus$Down$ memberStatus$Down$ = MemberStatus$Down$.MODULE$;
                        boolean bl = !(memberStatus != null ? !memberStatus.equals(memberStatus$Down$) : memberStatus$Down$ != null);
                        return bl;
                    }
                }, Member$.MODULE$.ordering());
                this.reachabilityExcludingDownedObservers = this.overview().reachability().removeObservers((scala.collection.immutable.Set<UniqueAddress>)((scala.collection.immutable.Set)downed.map((Function1 & Serializable)x$8 -> x$8.uniqueAddress(), Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()))));
                this.bitmap$0 = true;
            }
        }
        return this.reachabilityExcludingDownedObservers;
    }

    public Reachability reachabilityExcludingDownedObservers() {
        return !this.bitmap$0 ? this.reachabilityExcludingDownedObservers$lzycompute() : this.reachabilityExcludingDownedObservers;
    }

    public scala.collection.immutable.Set<String> allDataCenters() {
        return (scala.collection.immutable.Set)this.members().map((Function1 & Serializable)x$9 -> x$9.dataCenter(), (Ordering)Ordering.String$.MODULE$);
    }

    public scala.collection.immutable.Set<String> allRoles() {
        return (scala.collection.immutable.Set)this.members().flatMap((Function1 & Serializable)x$10 -> x$10.roles(), (Ordering)Ordering.String$.MODULE$);
    }

    public boolean isSingletonCluster() {
        return this.members().size() == 1;
    }

    public boolean isReachable(UniqueAddress fromAddress, UniqueAddress toAddress) {
        return !this.hasMember(toAddress) ? false : this.overview().reachability().isReachable(fromAddress, toAddress);
    }

    public Member member(UniqueAddress node) {
        return (Member)this.membersMap().getOrElse((Object)node, (Function0 & Serializable)() -> Member$.MODULE$.removed(node));
    }

    public boolean hasMember(UniqueAddress node) {
        return this.membersMap().contains((Object)node);
    }

    public Gossip removeAll(Iterable<UniqueAddress> nodes2, long removalTimestamp) {
        return (Gossip)nodes2.foldLeft((Object)this, (Function2 & Serializable)(gossip, node) -> gossip.remove((UniqueAddress)node, removalTimestamp));
    }

    public Gossip update(SortedSet<Member> updatedMembers) {
        return this.copy((SortedSet<Member>)((SortedSet)updatedMembers.union((Set)this.members().diff(updatedMembers))), this.copy$default$2(), this.copy$default$3(), this.copy$default$4());
    }

    public Gossip remove(UniqueAddress node, long removalTimestamp) {
        scala.collection.immutable.Set newSeen = (scala.collection.immutable.Set)this.overview().seen().$minus((Object)node);
        UniqueAddress uniqueAddress = node;
        Reachability newReachability = this.overview().reachability().remove((Iterable<UniqueAddress>)package$.MODULE$.Nil().$colon$colon((Object)uniqueAddress));
        GossipOverview newOverview = this.overview().copy((scala.collection.immutable.Set<UniqueAddress>)newSeen, newReachability);
        VectorClock newVersion = this.version().prune(VectorClock$Node$.MODULE$.apply(Gossip$.MODULE$.vclockName(node)));
        SortedSet newMembers = (SortedSet)this.members().filterNot((Function1 & Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)Gossip.$anonfun$remove$1(node, x$11)));
        Map newTombstones = (Map)this.tombstones().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)node), (Object)BoxesRunTime.boxToLong((long)removalTimestamp)));
        VectorClock x$1 = newVersion;
        SortedSet x$2 = newMembers;
        GossipOverview x$3 = newOverview;
        Map x$4 = newTombstones;
        return this.copy((SortedSet<Member>)x$2, x$3, x$1, (Map<UniqueAddress, Object>)x$4);
    }

    public Gossip markAsDown(Member member) {
        SortedSet newMembers = (SortedSet)this.members().$minus((Object)member).$plus((Object)member.copy(MemberStatus$Down$.MODULE$));
        scala.collection.immutable.Set newSeen = (scala.collection.immutable.Set)this.overview().seen().$minus((Object)member.uniqueAddress());
        GossipOverview newOverview = this.overview().copy((scala.collection.immutable.Set<UniqueAddress>)newSeen, this.overview().copy$default$2());
        return this.copy((SortedSet<Member>)newMembers, newOverview, this.copy$default$3(), this.copy$default$4());
    }

    public Gossip prune(String removedNode) {
        Gossip gossip;
        VectorClock newVersion = this.version().prune(removedNode);
        if (newVersion == this.version()) {
            gossip = this;
        } else {
            VectorClock x$1 = newVersion;
            SortedSet<Member> x$2 = this.copy$default$1();
            GossipOverview x$3 = this.copy$default$2();
            Map<UniqueAddress, Object> x$4 = this.copy$default$4();
            gossip = this.copy(x$2, x$3, x$1, x$4);
        }
        return gossip;
    }

    public Gossip pruneTombstones(long removeEarlierThan) {
        Gossip gossip;
        Map newTombstones = (Map)this.tombstones().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)Gossip.$anonfun$pruneTombstones$1(removeEarlierThan, x0$1)));
        if (newTombstones.size() == this.tombstones().size()) {
            gossip = this;
        } else {
            Map x$1 = newTombstones;
            SortedSet<Member> x$2 = this.copy$default$1();
            GossipOverview x$3 = this.copy$default$2();
            VectorClock x$4 = this.copy$default$3();
            gossip = this.copy(x$2, x$3, x$4, (Map<UniqueAddress, Object>)x$1);
        }
        return gossip;
    }

    public byte[] seenDigest() {
        return this.overview().seenDigest();
    }

    public String toString() {
        return new StringBuilder(60).append("Gossip(members = [").append(this.members().mkString(", ")).append("], overview = ").append(this.overview()).append(", version = ").append(this.version()).append(", tombstones = ").append(this.tombstones()).append(")").toString();
    }

    public Gossip copy(SortedSet<Member> members, GossipOverview overview, VectorClock version, Map<UniqueAddress, Object> tombstones) {
        return new Gossip(members, overview, version, tombstones);
    }

    public SortedSet<Member> copy$default$1() {
        return this.members();
    }

    public GossipOverview copy$default$2() {
        return this.overview();
    }

    public VectorClock copy$default$3() {
        return this.version();
    }

    public Map<UniqueAddress, Object> copy$default$4() {
        return this.tombstones();
    }

    public String productPrefix() {
        return "Gossip";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.members();
                break;
            }
            case 1: {
                object = this.overview();
                break;
            }
            case 2: {
                object = this.version();
                break;
            }
            case 3: {
                object = this.tombstones();
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Gossip;
    }

    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "members";
                break;
            }
            case 1: {
                string = "overview";
                break;
            }
            case 2: {
                string = "version";
                break;
            }
            case 3: {
                string = "tombstones";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Gossip)) return false;
        boolean bl = true;
        if (!bl) return false;
        Gossip gossip = (Gossip)x$1;
        SortedSet<Member> sortedSet = this.members();
        SortedSet<Member> sortedSet2 = gossip.members();
        if (sortedSet == null) {
            if (sortedSet2 != null) {
                return false;
            }
        } else if (!sortedSet.equals(sortedSet2)) return false;
        GossipOverview gossipOverview = this.overview();
        GossipOverview gossipOverview2 = gossip.overview();
        if (gossipOverview == null) {
            if (gossipOverview2 != null) {
                return false;
            }
        } else if (!((Object)gossipOverview).equals(gossipOverview2)) return false;
        VectorClock vectorClock = this.version();
        VectorClock vectorClock2 = gossip.version();
        if (vectorClock == null) {
            if (vectorClock2 != null) {
                return false;
            }
        } else if (!((Object)vectorClock).equals(vectorClock2)) return false;
        Map<UniqueAddress, Object> map = this.tombstones();
        Map<UniqueAddress, Object> map2 = gossip.tombstones();
        if (map == null) {
            if (map2 == null) return true;
            return false;
        } else {
            if (!map.equals(map2)) return false;
            return true;
        }
    }

    private static final void ifTrueThrow$1(Function0 func, String expected, String actual) {
        if (func.apply$mcZ$sp()) {
            throw new IllegalArgumentException(new StringBuilder(14).append(expected).append(", but found [").append(actual).append("]").toString());
        }
    }

    public static final /* synthetic */ boolean $anonfun$assertInvariants$2(Member x$1) {
        MemberStatus memberStatus = x$1.status();
        MemberStatus$Removed$ memberStatus$Removed$ = MemberStatus$Removed$.MODULE$;
        return !(memberStatus != null ? !memberStatus.equals(memberStatus$Removed$) : memberStatus$Removed$ != null);
    }

    public static final /* synthetic */ boolean $anonfun$assertInvariants$3(Member x$2) {
        MemberStatus memberStatus = x$2.status();
        MemberStatus$Removed$ memberStatus$Removed$ = MemberStatus$Removed$.MODULE$;
        return !(memberStatus != null ? !memberStatus.equals(memberStatus$Removed$) : memberStatus$Removed$ != null);
    }

    public static final /* synthetic */ boolean $anonfun$isMultiDc$1(String dc1$1, Member x$6) {
        String string = x$6.dataCenter();
        String string2 = dc1$1;
        return string == null ? string2 != null : !string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$remove$1(UniqueAddress node$2, Member x$11) {
        UniqueAddress uniqueAddress = x$11.uniqueAddress();
        UniqueAddress uniqueAddress2 = node$2;
        return !(uniqueAddress != null ? !((Object)uniqueAddress).equals(uniqueAddress2) : uniqueAddress2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$pruneTombstones$1(long removeEarlierThan$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        long timestamp = tuple2._2$mcJ$sp();
        boolean bl = timestamp > removeEarlierThan$1;
        return bl;
    }

    public Gossip(SortedSet<Member> members, GossipOverview overview, VectorClock version, Map<UniqueAddress, Object> tombstones) {
        block0: {
            this.members = members;
            this.overview = overview;
            this.version = version;
            this.tombstones = tombstones;
            Product.$init$((Product)this);
            if (!Cluster$.MODULE$.isAssertInvariantsEnabled()) break block0;
            this.assertInvariants();
        }
    }
}

