/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.netty.ahessian.io;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelOutboundHandler;
import io.netty.channel.ChannelPromise;
import io.netty.util.AttributeKey;
import java.io.IOException;
import java.io.OutputStream;
import java.net.SocketAddress;
import org.rzo.netty.ahessian.io.CRCOutputStream;
import org.rzo.netty.ahessian.io.OutputStreamBuffer;
import org.rzo.netty.ahessian.stopable.StopableHandler;

public class OutputStreamHandler
extends ChannelInboundHandlerAdapter
implements StopableHandler,
ChannelOutboundHandler {
    volatile OutputStreamBuffer _buffer = null;
    private boolean _stopEnabled = true;
    boolean _crcCheck = false;
    public static AttributeKey<OutputStreamBuffer> OUTSTREAM = AttributeKey.valueOf((String)"OUTSTREAM");
    private static AttributeKey<OutputStreamHandler> OUTENCODER = AttributeKey.valueOf((String)"OUTENCODER");

    public OutputStreamHandler() {
    }

    public OutputStreamHandler(boolean crcCheck) {
        this._crcCheck = crcCheck;
    }

    public static OutputStream getOutputStream(ChannelHandlerContext ctx) {
        return (OutputStream)ctx.channel().attr(OUTSTREAM).get();
    }

    public static OutputStreamHandler getOutputEncoder(ChannelHandlerContext ctx) {
        return (OutputStreamHandler)ctx.channel().attr(OUTENCODER).get();
    }

    public OutputStreamBuffer getBuffer() {
        return this._buffer;
    }

    @Override
    public boolean isStopEnabled() {
        return this._stopEnabled;
    }

    @Override
    public void setStopEnabled(boolean stopEnabled) {
        this._stopEnabled = stopEnabled;
    }

    @Override
    public void stop() {
        try {
            this._buffer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this._buffer = null;
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        this.doChannelActive(ctx);
        ctx.fireChannelActive();
    }

    private void doChannelActive(ChannelHandlerContext ctx) {
        if (this._buffer == null) {
            this._buffer = this._crcCheck ? new CRCOutputStream(ctx) : new OutputStreamBuffer(ctx);
            ctx.channel().attr(OUTSTREAM).set((Object)this._buffer);
        } else {
            this._buffer.setContext(ctx);
        }
        ctx.channel().attr(OUTENCODER).set((Object)this);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.doChannelInactive();
        ctx.fireChannelInactive();
    }

    private void doChannelInactive() throws IOException {
        if (this._buffer != null) {
            this._buffer.close();
        }
    }

    public void bind(ChannelHandlerContext ctx, SocketAddress localAddress, ChannelPromise promise) throws Exception {
        ctx.bind(localAddress, promise);
    }

    public void connect(ChannelHandlerContext ctx, SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) throws Exception {
        this.doChannelActive(ctx);
        ctx.connect(remoteAddress, localAddress, promise);
    }

    public void disconnect(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        this.doChannelInactive();
        ctx.disconnect(promise);
    }

    public void close(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        ctx.close(promise);
    }

    public void deregister(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        ctx.deregister(promise);
    }

    public void read(ChannelHandlerContext ctx) throws Exception {
        ctx.read();
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        ctx.write(msg, promise);
    }

    public void flush(ChannelHandlerContext ctx) throws Exception {
        ctx.flush();
    }
}

