/*
 * Decompiled with CFR 0.152.
 */
package kamon.metric;

import java.io.Serializable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import kamon.metric.Instrument;
import kamon.metric.MeasurementUnit;
import kamon.metric.Metric;
import kamon.metric.MetricSnapshot;
import kamon.metric.Tagging;
import kamon.package$;
import kamon.package$AtomicGetOrElseUpdateOnTrieMap$;
import kamon.status.Status;
import kamon.tag.TagSet;
import kamon.tag.TagSet$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.JavaConverters$;
import scala.collection.concurrent.TrieMap;
import scala.collection.concurrent.TrieMap$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0005\u0015\u0005aa\u0002<x!\u0003\r\n\u0001 \u0005\b\u0007O\u0002a\u0011AB5\u0011\u001d\u0019Y\b\u0001D\u0001\u0007SBqaa \u0001\r\u0003!I\u0010C\u0004\u0005`\u00011\t\u0001b?\t\u000f\u0011\r\u0004A\"\u0001\u0005~\u001e9\u00111G<\t\u0002\u0005UbA\u0002<x\u0011\u0003\t9\u0004C\u0004\u0002:\u001d!\t!a\u000f\u0007\u0013\u0005ur\u0001%A\u0012\u0002\u0005}b!\u0003Ba\u000fA\u0005\u0019\u0013\u0001Bb\r%\u0011Ym\u0002I\u0001$\u0003\u0011iMB\u0005\u0003X\u001e\u0001\n1%\u0001\u0003Z\u001aI!\u0011]\u0004\u0011\u0002G\u0005!1\u001d\u0004\n\u0003#:\u0001\u0013aI\u0011\u0005WDq!!\u001f\u000f\r\u0003\tY\bC\u0004\u0002\u0006:1\t!a\"\b\u000f\u00055s\u0001#\u0001\u0002P\u00199\u0011\u0011K\u0004\t\u0002\u0005M\u0003bBA\u001d%\u0011\u0005\u0011Q\u000b\u0004\u0007\u0003/\u0012\u0002)!\u0017\t\u0015\u0005eDC!f\u0001\n\u0003\tY\b\u0003\u0006\u0002\u0004R\u0011\t\u0012)A\u0005\u0003{B!\"!\"\u0015\u0005+\u0007I\u0011AAD\u0011)\tI\n\u0006B\tB\u0003%\u0011\u0011\u0012\u0005\b\u0003s!B\u0011AAN\u0011%\t)\u000bFA\u0001\n\u0003\t9\u000bC\u0005\u0002.R\t\n\u0011\"\u0001\u00020\"I\u0011Q\u0019\u000b\u0012\u0002\u0013\u0005\u0011q\u0019\u0005\n\u0003\u0017$\u0012\u0011!C!\u0003\u001bD\u0011\"a7\u0015\u0003\u0003%\t!!8\t\u0013\u0005\u0015H#!A\u0005\u0002\u0005\u001d\b\"CAz)\u0005\u0005I\u0011IA{\u0011%\u0011\u0019\u0001FA\u0001\n\u0003\u0011)\u0001C\u0005\u0003\u0010Q\t\t\u0011\"\u0011\u0003\u0012!I!Q\u0003\u000b\u0002\u0002\u0013\u0005#q\u0003\u0005\n\u00053!\u0012\u0011!C!\u00057A\u0011B!\b\u0015\u0003\u0003%\tEa\b\b\u0013\t\r\"#!A\t\u0002\t\u0015b!CA,%\u0005\u0005\t\u0012\u0001B\u0014\u0011\u001d\tId\nC\u0001\u0005\u007fA\u0011B!\u0007(\u0003\u0003%)Ea\u0007\t\u0013\t\u0005s%!A\u0005\u0002\n\r\u0003\"\u0003B%O\u0005\u0005I\u0011\u0011B&\u0011%\u0011ifJA\u0001\n\u0013\u0011yF\u0002\u0004\u0003hI\u0001%\u0011\u000e\u0005\u000b\u0003sj#Q3A\u0005\u0002\u0005m\u0004BCAB[\tE\t\u0015!\u0003\u0002~!Q\u0011QQ\u0017\u0003\u0016\u0004%\t!a\"\t\u0015\u0005eUF!E!\u0002\u0013\tI\t\u0003\u0006\u0003l5\u0012)\u001a!C\u0001\u0005[B!B!\u001e.\u0005#\u0005\u000b\u0011\u0002B8\u0011\u001d\tI$\fC\u0001\u0005oB\u0011\"!*.\u0003\u0003%\tA!!\t\u0013\u00055V&%A\u0005\u0002\u0005=\u0006\"CAc[E\u0005I\u0011AAd\u0011%\u0011I)LI\u0001\n\u0003\u0011Y\tC\u0005\u0002L6\n\t\u0011\"\u0011\u0002N\"I\u00111\\\u0017\u0002\u0002\u0013\u0005\u0011Q\u001c\u0005\n\u0003Kl\u0013\u0011!C\u0001\u0005\u001fC\u0011\"a=.\u0003\u0003%\t%!>\t\u0013\t\rQ&!A\u0005\u0002\tM\u0005\"\u0003B\b[\u0005\u0005I\u0011\tBL\u0011%\u0011)\"LA\u0001\n\u0003\u00129\u0002C\u0005\u0003\u001a5\n\t\u0011\"\u0011\u0003\u001c!I!QD\u0017\u0002\u0002\u0013\u0005#1T\u0004\n\u0005?\u0013\u0012\u0011!E\u0001\u0005C3\u0011Ba\u001a\u0013\u0003\u0003E\tAa)\t\u000f\u0005e2\t\"\u0001\u0003,\"I!\u0011D\"\u0002\u0002\u0013\u0015#1\u0004\u0005\n\u0005\u0003\u001a\u0015\u0011!CA\u0005[C\u0011B!\u0013D\u0003\u0003%\tI!.\t\u0013\tu3)!A\u0005\n\t}cA\u0003Bx\u000fA\u0005\u0019\u0013A=\u0003r\"9!Q_%\u0007\u0002\t]XABB\b\u000f\u0001\u0019\t\"\u0002\u0004\u0004\n\u001e\u000111\u0012\u0004\b\u0007\u001b:\u0011\u0011AB(\u0011)\u00199'\u0014BC\u0002\u0013\u00051\u0011\u000e\u0005\u000b\u0007sj%\u0011!Q\u0001\n\r-\u0004BCB>\u001b\n\u0015\r\u0011\"\u0001\u0004j!Q1QP'\u0003\u0002\u0003\u0006Iaa\u001b\t\u0015\r}TJ!b\u0001\n\u0003\u0019\t\t\u0003\u0006\u0004\u00046\u0013\t\u0011)A\u0005\u0007;B!b!\"N\u0005\u0003\u0005\u000b\u0011BBD\u0011)\u0019\u0019,\u0014B\u0001B\u0003%1Q\u0017\u0005\b\u0003siE\u0011ABc\u0011%\u0019\u0019.\u0014b\u0001\n\u0013\u0019)\u000e\u0003\u0005\u000585\u0003\u000b\u0011BBl\u0011\u001d!I$\u0014C!\twAq\u0001\"\u000fN\t\u0003\")\u0005C\u0004\u0005:5#\t\u0005b\u0013\t\u000f\u0011]S\n\"\u0011\u0005Z!9AqL'\u0005B\u0011\u0005\u0004b\u0002C2\u001b\u0012\u0005CQ\r\u0005\b\u0005klE\u0011\tC5\u0011\u001d!y'\u0014C\u0001\tcBq\u0001b!N\t\u0003!)\tC\u0004\u0005\u001863\t\u0002\"'\t\u000f\u0011\u0005VJ\"\u0005\u0005$\"9AqW'\u0005\n\u0011e\u0006b\u0002C_\u001b\u0012%Aq\u0018\u0005\b\t\u0007lE\u0011\u0002Cc\u0011\u001d!Y-\u0014C\u0005\t\u001b4aa!:N\t\r\u001d\bBCBuQ\n\u0015\r\u0011\"\u0001\u0004l\"Q1q\u001e5\u0003\u0002\u0003\u0006Ia!<\t\u0015\rE\bN!b\u0001\n\u0003\u0019\u0019\u0010\u0003\u0006\u0005\u0010!\u0014\t\u0011)A\u0005\u0007kD!\u0002\"\u0005i\u0005\u0003\u0007I\u0011\u0001C\n\u0011)!)\u0002\u001bBA\u0002\u0013\u0005Aq\u0003\u0005\u000b\t7A'\u0011!Q!\n\t\u001d\u0001bBA\u001dQ\u0012\u0005AQ\u0005\u0004\f\u0007o9\u0001\u0013aA\u0001\u0007s!\u0019\u0010C\u0004\u0004>E$\taa\u0010\t\u000f\r\u001d\u0013O\"\u0005\u0004J!9A\u0011]9\u0005\u0002\r}\u0002b\u0002Crc\u0012\u0005AQ\u001d\u0002\u0007\u001b\u0016$(/[2\u000b\u0005aL\u0018AB7fiJL7MC\u0001{\u0003\u0015Y\u0017-\\8o\u0007\u0001)R!`A\u000b\u0003S\u0019B\u0001\u0001@\u0002\nA\u0019q0!\u0002\u000e\u0005\u0005\u0005!BAA\u0002\u0003\u0015\u00198-\u00197b\u0013\u0011\t9!!\u0001\u0003\r\u0005s\u0017PU3g!\u0019\tY!!\u0004\u0002\u00125\tq/C\u0002\u0002\u0010]\u0014q\u0001V1hO&tw\r\u0005\u0003\u0002\u0014\u0005UA\u0002\u0001\u0003\b\u0003/\u0001!\u0019AA\r\u0005\u0011Ien\u001d;\u0012\t\u0005m\u0011\u0011\u0005\t\u0004\u007f\u0006u\u0011\u0002BA\u0010\u0003\u0003\u0011qAT8uQ&tw\r\u0005\u0005\u0002\f\u0005\r\u0012\u0011CA\u0014\u0013\r\t)c\u001e\u0002\u000b\u0013:\u001cHO];nK:$\b\u0003BA\n\u0003S!q!a\u000b\u0001\u0005\u0004\tiC\u0001\u0003TKR$\u0018\u0003BA\u000e\u0003_\u00012!!\r\u000f\u001d\r\tYAB\u0001\u0007\u001b\u0016$(/[2\u0011\u0007\u0005-qa\u0005\u0002\b}\u00061A(\u001b8jiz\"\"!!\u000e\u0003\u000f\r{WO\u001c;feN!\u0011B`A!!\u001d\tY\u0001AA\"\u0003\u000f\u0002B!a\u0003\u0002F%\u0019\u0011QH<\u0011\u0007\u0005%CCD\u0002\u0002LEi\u0011aB\u0001\t'\u0016$H/\u001b8hgB\u0019\u00111\n\n\u0003\u0011M+G\u000f^5oON\u001c\"A\u0005@\u0015\u0005\u0005=#A\u0005$peZ\u000bG.^3J]N$(/^7f]R\u001c\u0002\u0002\u0006@\u00020\u0005m\u0013\u0011\r\t\u0004\u007f\u0006u\u0013\u0002BA0\u0003\u0003\u0011q\u0001\u0015:pIV\u001cG\u000f\u0005\u0003\u0002d\u0005Md\u0002BA3\u0003_rA!a\u001a\u0002n5\u0011\u0011\u0011\u000e\u0006\u0004\u0003WZ\u0018A\u0002\u001fs_>$h(\u0003\u0002\u0002\u0004%!\u0011\u0011OA\u0001\u0003\u001d\u0001\u0018mY6bO\u0016LA!!\u001e\u0002x\ta1+\u001a:jC2L'0\u00192mK*!\u0011\u0011OA\u0001\u0003\u0011)h.\u001b;\u0016\u0005\u0005u\u0004\u0003BA\u0006\u0003\u007fJ1!!!x\u0005=iU-Y:ve\u0016lWM\u001c;V]&$\u0018!B;oSR\u0004\u0013AE1vi>,\u0006\u000fZ1uK&sG/\u001a:wC2,\"!!#\u0011\t\u0005-\u0015QS\u0007\u0003\u0003\u001bSA!a$\u0002\u0012\u0006!A/[7f\u0015\t\t\u0019*\u0001\u0003kCZ\f\u0017\u0002BAL\u0003\u001b\u0013\u0001\u0002R;sCRLwN\\\u0001\u0014CV$x.\u00169eCR,\u0017J\u001c;feZ\fG\u000e\t\u000b\u0007\u0003;\u000b\t+a)\u0011\u0007\u0005}E#D\u0001\u0013\u0011\u001d\tI(\u0007a\u0001\u0003{Bq!!\"\u001a\u0001\u0004\tI)\u0001\u0003d_BLHCBAO\u0003S\u000bY\u000bC\u0005\u0002zi\u0001\n\u00111\u0001\u0002~!I\u0011Q\u0011\u000e\u0011\u0002\u0003\u0007\u0011\u0011R\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\t\tL\u000b\u0003\u0002~\u0005M6FAA[!\u0011\t9,!1\u000e\u0005\u0005e&\u0002BA^\u0003{\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\t\u0005}\u0016\u0011A\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAb\u0003s\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII*\"!!3+\t\u0005%\u00151W\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005=\u0007\u0003BAi\u0003/l!!a5\u000b\t\u0005U\u0017\u0011S\u0001\u0005Y\u0006tw-\u0003\u0003\u0002Z\u0006M'AB*ue&tw-\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002`B\u0019q0!9\n\t\u0005\r\u0018\u0011\u0001\u0002\u0004\u0013:$\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003S\fy\u000fE\u0002\u0000\u0003WLA!!<\u0002\u0002\t\u0019\u0011I\\=\t\u0013\u0005Ex$!AA\u0002\u0005}\u0017a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002xB1\u0011\u0011`A\u0000\u0003Sl!!a?\u000b\t\u0005u\u0018\u0011A\u0001\u000bG>dG.Z2uS>t\u0017\u0002\u0002B\u0001\u0003w\u0014\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!!q\u0001B\u0007!\ry(\u0011B\u0005\u0005\u0005\u0017\t\tAA\u0004C_>dW-\u00198\t\u0013\u0005E\u0018%!AA\u0002\u0005%\u0018A\u00059s_\u0012,8\r^#mK6,g\u000e\u001e(b[\u0016$B!a4\u0003\u0014!I\u0011\u0011\u001f\u0012\u0002\u0002\u0003\u0007\u0011q\\\u0001\tQ\u0006\u001c\bnQ8eKR\u0011\u0011q\\\u0001\ti>\u001cFO]5oOR\u0011\u0011qZ\u0001\u0007KF,\u0018\r\\:\u0015\t\t\u001d!\u0011\u0005\u0005\n\u0003c,\u0013\u0011!a\u0001\u0003S\f!CR8s-\u0006dW/Z%ogR\u0014X/\\3oiB\u0019\u0011qT\u0014\u0014\u000b\u001d\u0012IC!\u000e\u0011\u0015\t-\"\u0011GA?\u0003\u0013\u000bi*\u0004\u0002\u0003.)!!qFA\u0001\u0003\u001d\u0011XO\u001c;j[\u0016LAAa\r\u0003.\t\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\u001c\u001a\u0011\t\t]\"QH\u0007\u0003\u0005sQAAa\u000f\u0002\u0012\u0006\u0011\u0011n\\\u0005\u0005\u0003k\u0012I\u0004\u0006\u0002\u0003&\u0005)\u0011\r\u001d9msR1\u0011Q\u0014B#\u0005\u000fBq!!\u001f+\u0001\u0004\ti\bC\u0004\u0002\u0006*\u0002\r!!#\u0002\u000fUt\u0017\r\u001d9msR!!Q\nB-!\u0015y(q\nB*\u0013\u0011\u0011\t&!\u0001\u0003\r=\u0003H/[8o!\u001dy(QKA?\u0003\u0013KAAa\u0016\u0002\u0002\t1A+\u001e9mKJB\u0011Ba\u0017,\u0003\u0003\u0005\r!!(\u0002\u0007a$\u0003'\u0001\u0007xe&$XMU3qY\u0006\u001cW\r\u0006\u0002\u0003bA!\u0011\u0011\u001bB2\u0013\u0011\u0011)'a5\u0003\r=\u0013'.Z2u\u0005e1uN\u001d#jgR\u0014\u0018NY;uS>t\u0017J\\:ueVlWM\u001c;\u0014\u00115r\u0018qFA.\u0003C\nA\u0002Z=oC6L7MU1oO\u0016,\"Aa\u001c\u0011\t\u0005-!\u0011O\u0005\u0004\u0005g:(\u0001\u0004#z]\u0006l\u0017n\u0019*b]\u001e,\u0017!\u00043z]\u0006l\u0017n\u0019*b]\u001e,\u0007\u0005\u0006\u0005\u0003z\tm$Q\u0010B@!\r\ty*\f\u0005\b\u0003s\"\u0004\u0019AA?\u0011\u001d\t)\t\u000ea\u0001\u0003\u0013CqAa\u001b5\u0001\u0004\u0011y\u0007\u0006\u0005\u0003z\t\r%Q\u0011BD\u0011%\tI(\u000eI\u0001\u0002\u0004\ti\bC\u0005\u0002\u0006V\u0002\n\u00111\u0001\u0002\n\"I!1N\u001b\u0011\u0002\u0003\u0007!qN\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134+\t\u0011iI\u000b\u0003\u0003p\u0005MF\u0003BAu\u0005#C\u0011\"!=<\u0003\u0003\u0005\r!a8\u0015\t\t\u001d!Q\u0013\u0005\n\u0003cl\u0014\u0011!a\u0001\u0003S$B!a4\u0003\u001a\"I\u0011\u0011\u001f \u0002\u0002\u0003\u0007\u0011q\u001c\u000b\u0005\u0005\u000f\u0011i\nC\u0005\u0002r\u0006\u000b\t\u00111\u0001\u0002j\u0006Ibi\u001c:ESN$(/\u001b2vi&|g.\u00138tiJ,X.\u001a8u!\r\tyjQ\n\u0006\u0007\n\u0015&Q\u0007\t\r\u0005W\u00119+! \u0002\n\n=$\u0011P\u0005\u0005\u0005S\u0013iCA\tBEN$(/Y2u\rVt7\r^5p]N\"\"A!)\u0015\u0011\te$q\u0016BY\u0005gCq!!\u001fG\u0001\u0004\ti\bC\u0004\u0002\u0006\u001a\u0003\r!!#\t\u000f\t-d\t1\u0001\u0003pQ!!q\u0017B`!\u0015y(q\nB]!%y(1XA?\u0003\u0013\u0013y'\u0003\u0003\u0003>\u0006\u0005!A\u0002+va2,7\u0007C\u0005\u0003\\\u001d\u000b\t\u00111\u0001\u0003z\t)q)Y;hKN!!B Bc!\u001d\tY\u0001\u0001Bd\u0003\u000f\u0002B!a\u0003\u0003J&\u0019!\u0011Y<\u0003\u0013!K7\u000f^8he\u0006l7\u0003B\u0006\u007f\u0005\u001f\u0004r!a\u0003\u0001\u0005#\u0014)\u000e\u0005\u0003\u0002\f\tM\u0017b\u0001BfoB\u0019\u0011\u0011J\u0017\u0003\u000bQKW.\u001a:\u0014\t1q(1\u001c\t\b\u0003\u0017\u0001!Q\u001cBk!\u0011\tYAa8\n\u0007\t]wO\u0001\u0007SC:<WmU1na2,'o\u0005\u0003\u000e}\n\u0015\bcBA\u0006\u0001\t\u001d(Q\u001b\t\u0005\u0003\u0017\u0011I/C\u0002\u0003b^\u001c\"A\u0004@*\u00079iCC\u0001\u0007T]\u0006\u00048\u000f[8ui&tw-\u0006\u0004\u0003t\u000e\u00051QA\n\u0003\u0013z\f\u0001b\u001d8baNDw\u000e\u001e\u000b\u0005\u0005s\u001cY\u0001\u0005\u0005\u0002\f\tm(q`B\u0002\u0013\r\u0011ip\u001e\u0002\u000f\u001b\u0016$(/[2T]\u0006\u00048\u000f[8u!\u0011\t\u0019b!\u0001\u0005\u000f\u0005-\u0012J1\u0001\u0002.A!\u00111CB\u0003\t\u001d\u00199!\u0013b\u0001\u0007\u0013\u0011Aa\u00158baF!\u00111DAu\u0011\u001d\u0019iA\u0013a\u0001\u0005\u000f\t!B]3tKR\u001cF/\u0019;f\u00059\u0011\u0016n\u00195J]N$(/^7f]R,\u0002ba\u0005\u0004\u001c\r\r21\u0007\n\t\u0007+\u0019Ib!\n\u00046\u001911qC\u0004\u0001\u0007'\u0011A\u0002\u0010:fM&tW-\\3oiz\u0002B!a\u0005\u0004\u001c\u00119\u0011qC&C\u0002\ru\u0011\u0003BA\u000e\u0007?\u0001\u0002\"a\u0003\u0002$\re1\u0011\u0005\t\u0005\u0003'\u0019\u0019\u0003B\u0004\u0002,-\u0013\r!!\f\u0011\r\r\u001d2QFB\u0019\u001d\u0011\tYa!\u000b\n\u0007\r-r/\u0001\u0006J]N$(/^7f]RLAAa<\u00040)\u001911F<\u0011\t\u0005M11\u0007\u0003\b\u0007\u000fY%\u0019AB\u0005!%\tY%]B\r\u0007C\u0019\tD\u0001\u000bCCN,W*\u001a;sS\u000e\fU\u000f^8Va\u0012\fG/Z\u000b\t\u0007w!\u0019\u000eb7\u0005`N\u0011\u0011O`\u0001\u0007I%t\u0017\u000e\u001e\u0013\u0015\u0005\r\u0005\u0003cA@\u0004D%!1QIA\u0001\u0005\u0011)f.\u001b;\u0002\u0015\t\f7/Z'fiJL7-\u0006\u0002\u0004LAI\u00111J'\u0005R\u0012eGQ\u001c\u0002\u000b\u0005\u0006\u001cX-T3ue&\u001cW\u0003CB)\u0007/\u001ayf!\u001a\u0014\r5s81KB1!\u001d\tY\u0001AB+\u0007;\u0002B!a\u0005\u0004X\u00119\u0011qC'C\u0002\re\u0013\u0003BA\u000e\u00077\u0002\u0002\"a\u0003\u0002$\rU3Q\f\t\u0005\u0003'\u0019y\u0006B\u0004\u0002,5\u0013\r!!\f\u0011\u000f\u0005E\u0012j!\u0018\u0004dA!\u00111CB3\t\u001d\u00199!\u0014b\u0001\u0007\u0013\tAA\\1nKV\u001111\u000e\t\u0005\u0007[\u001a)H\u0004\u0003\u0004p\rE\u0004\u0003BA4\u0003\u0003IAaa\u001d\u0002\u0002\u00051\u0001K]3eK\u001aLA!!7\u0004x)!11OA\u0001\u0003\u0015q\u0017-\\3!\u0003-!Wm]2sSB$\u0018n\u001c8\u0002\u0019\u0011,7o\u0019:jaRLwN\u001c\u0011\u0002\u0011M,G\u000f^5oON,\"a!\u0018\u0002\u0013M,G\u000f^5oON\u0004\u0013!E5ogR\u0014X/\\3oi\n+\u0018\u000e\u001c3feBI\u00111\n'\u0004V\ru31\r\u0002\u0012\u0013:\u001cHO];nK:$()^5mI\u0016\u0014X\u0003CBG\u0007/\u001byja)\u0011\u0013}\u001cyia%\u0004&\u000eE\u0016\u0002BBI\u0003\u0003\u0011\u0011BR;oGRLwN\u001c\u001a\u0011\u0013\u0005-Sj!&\u0004\u001e\u000e\u0005\u0006\u0003BA\n\u0007/#q!a\u0006M\u0005\u0004\u0019I*\u0005\u0003\u0002\u001c\rm\u0005\u0003CA\u0006\u0003G\u0019)j!(\u0011\t\u0005M1q\u0014\u0003\b\u0003Wa%\u0019AA\u0017!\u0011\t\u0019ba)\u0005\u000f\r\u001dAJ1\u0001\u0004\nA!1qUBW\u001b\t\u0019IKC\u0002\u0004,f\f1\u0001^1h\u0013\u0011\u0019yk!+\u0003\rQ\u000bwmU3u!%\tYeSBK\u0007;\u001b\t+A\u0005tG\",G-\u001e7feB!1qWBa\u001b\t\u0019IL\u0003\u0003\u0004<\u000eu\u0016AC2p]\u000e,(O]3oi*!1qXAI\u0003\u0011)H/\u001b7\n\t\r\r7\u0011\u0018\u0002\u0019'\u000eDW\rZ;mK\u0012,\u00050Z2vi>\u00148+\u001a:wS\u000e,G\u0003DBd\u0007\u0013\u001cYm!4\u0004P\u000eE\u0007#CA&\u001b\u000eU3QLB2\u0011\u001d\u00199G\u0016a\u0001\u0007WBqaa\u001fW\u0001\u0004\u0019Y\u0007C\u0004\u0004\u0000Y\u0003\ra!\u0018\t\u000f\r\u0015e\u000b1\u0001\u0004\b\"911\u0017,A\u0002\rU\u0016\u0001D0j]N$(/^7f]R\u001cXCABl!!\u0019In!8\u0004&\u000e\u0005XBABn\u0015\u0011\u0019Y,a?\n\t\r}71\u001c\u0002\b)JLW-T1q!\r\u0019\u0019\u000f[\u0007\u0002\u001b\ny\u0011J\\:ueVlWM\u001c;F]R\u0014\u0018p\u0005\u0002i}\u0006Q\u0011N\\:ueVlWM\u001c;\u0016\u0005\r5\b#CA&\u0017\u000eU3QLB2\u0003-Ign\u001d;sk6,g\u000e\u001e\u0011\u0002!M\u001c\u0007.\u001a3vY\u0016$\u0017i\u0019;j_:\u001cXCAB{!\u0019\u00199p!@\u0005\u00025\u00111\u0011 \u0006\u0005\u0007w\fY0A\u0004nkR\f'\r\\3\n\t\r}8\u0011 \u0002\u0007\u0005V4g-\u001a:1\t\u0011\rA1\u0002\t\u0007\u0007o#)\u0001\"\u0003\n\t\u0011\u001d1\u0011\u0018\u0002\u0010'\u000eDW\rZ;mK\u00124U\u000f^;sKB!\u00111\u0003C\u0006\t-!i\u0001\\A\u0001\u0002\u0003\u0015\ta!\u0003\u0003\u0007}##'A\ttG\",G-\u001e7fI\u0006\u001bG/[8og\u0002\nAC]3n_Z,wJ\u001c(fqR\u001cf.\u00199tQ>$XC\u0001B\u0004\u0003a\u0011X-\\8wK>sg*\u001a=u':\f\u0007o\u001d5pi~#S-\u001d\u000b\u0005\u0007\u0003\"I\u0002C\u0005\u0002r:\f\t\u00111\u0001\u0003\b\u0005)\"/Z7pm\u0016|eNT3yiNs\u0017\r]:i_R\u0004\u0003fA8\u0005 A\u0019q\u0010\"\t\n\t\u0011\r\u0012\u0011\u0001\u0002\tm>d\u0017\r^5mKRA1\u0011\u001dC\u0014\tS!)\u0004C\u0004\u0004jB\u0004\ra!<\t\u000f\rE\b\u000f1\u0001\u0005,A11q_B\u007f\t[\u0001D\u0001b\f\u00054A11q\u0017C\u0003\tc\u0001B!a\u0005\u00054\u0011aAQ\u0002C\u0015\u0003\u0003\u0005\tQ!\u0001\u0004\n!9A\u0011\u00039A\u0002\t\u001d\u0011!D0j]N$(/^7f]R\u001c\b%A\u0004xSRDG+Y4\u0015\r\rUCQ\bC!\u0011\u001d!y$\u0017a\u0001\u0007W\n1a[3z\u0011\u001d!\u0019%\u0017a\u0001\u0007W\nQA^1mk\u0016$ba!\u0016\u0005H\u0011%\u0003b\u0002C 5\u0002\u000711\u000e\u0005\b\t\u0007R\u0006\u0019\u0001B\u0004)\u0019\u0019)\u0006\"\u0014\u0005P!9AqH.A\u0002\r-\u0004b\u0002C\"7\u0002\u0007A\u0011\u000b\t\u0004\u007f\u0012M\u0013\u0002\u0002C+\u0003\u0003\u0011A\u0001T8oO\u0006Aq/\u001b;i)\u0006<7\u000f\u0006\u0003\u0004V\u0011m\u0003b\u0002C/9\u0002\u00071QU\u0001\u0005i\u0006<7/A\u0006xSRDw.\u001e;UC\u001e\u001cHCAB+\u0003\u0019\u0011X-\\8wKR!!q\u0001C4\u0011\u001d!iF\u0018a\u0001\u0007K#B\u0001b\u001b\u0005nAA\u00111\u0002B~\u0007;\u001a\u0019\u0007C\u0004\u0004\u000e}\u0003\rAa\u0002\u0002\u0011M\u001c\u0007.\u001a3vY\u0016$\u0002\"!;\u0005t\u0011UDq\u0010\u0005\b\u0007S\u0004\u0007\u0019AB+\u0011\u001d!9\b\u0019a\u0001\ts\na!Y2uS>t\u0007\u0003BAi\twJA\u0001\" \u0002T\nA!+\u001e8oC\ndW\rC\u0004\u0005\u0002\u0002\u0004\r!!#\u0002\u0011%tG/\u001a:wC2\faa\u001d;biV\u001cHC\u0001CD!\u0011!I\tb%\u000f\t\u0011-EqR\u0007\u0003\t\u001bS1\u0001b!z\u0013\u0011!\t\n\"$\u0002\rM#\u0018\r^;t\u0013\r1HQ\u0013\u0006\u0005\t##i)\u0001\bj]N$(/^7f]R$\u0016\u0010]3\u0016\u0005\u0011m\u0005\u0003BB\u0014\t;KA\u0001b(\u00040\t!A+\u001f9f\u0003M\u0011W/\u001b7e\u001b\u0016$(/[2T]\u0006\u00048\u000f[8u)\u0019!Y\u0007\"*\u0005(\"1\u0001p\u0019a\u0001\u0007'Bq\u0001\"+d\u0001\u0004!Y+A\u0006j]N$(/^7f]R\u001c\bCBA2\t[#\t,\u0003\u0003\u00050\u0006]$aA*fcB11q\u0005CZ\u0007GJA\u0001\".\u00040\tA1K\\1qg\"|G/\u0001\tm_>\\W\u000f]%ogR\u0014X/\\3oiR!1Q\u000bC^\u0011\u001d!i\u0006\u001aa\u0001\u0007K\u000b!C\\3x\u0013:\u001cHO];nK:$XI\u001c;ssR!1\u0011\u001dCa\u0011\u001d!i&\u001aa\u0001\u0007K\u000ba\u0003\u001e:jO\u001e,'\u000fR3gCVdGoU2iK\u0012,H.\u001a\u000b\u0005\u0007\u0003\"9\rC\u0004\u0005J\u001a\u0004\ra!9\u0002\u000b\u0015tGO]=\u0002#\rdW-\u00198vaN#\u0018\r\\3F]R\u0014\u0018\u0010\u0006\u0003\u0004B\u0011=\u0007b\u0002CeO\u0002\u00071\u0011\u001d\t\u0005\u0003'!\u0019\u000eB\u0004\u0002\u0018E\u0014\r\u0001\"6\u0012\t\u0005mAq\u001b\t\t\u0003\u0017\t\u0019\u0003\"5\u0005ZB!\u00111\u0003Cn\t\u001d\tY#\u001db\u0001\u0003[\u0001B!a\u0005\u0005`\u001291qA9C\u0002\r%\u0011a\u00043fM\u0006,H\u000e^*dQ\u0016$W\u000f\\3\u0002\u0015\u0005,Ho\\+qI\u0006$X\r\u0006\u0004\u0005R\u0012\u001dH\u0011\u001f\u0005\b\tS,\b\u0019\u0001Cv\u0003!\u0019wN\\:v[\u0016\u0014\bcB@\u0005n\u0012E7\u0011I\u0005\u0005\t_\f\tAA\u0005Gk:\u001cG/[8oc!9A\u0011Q;A\u0002\u0005%%C\u0002C{\to$\tN\u0002\u0004\u0004\u0018\u001d\u0001A1\u001f\t\n\u0003\u0017\nH\u0011\u001bCm\t;,\"!a\n\u0015\u0005\u0005EA\u0003\u0002B\u0004\t\u007fDq\u0001\"\u0018\u0006\u0001\u0004\u0019)\u000b")
public interface Metric<Inst extends Instrument<Inst, Sett>, Sett extends Settings>
extends Tagging<Inst> {
    public String name();

    public String description();

    public Sett settings();

    public Inst withoutTags();

    public boolean remove(TagSet var1);

    public static abstract class BaseMetric<Inst extends Instrument<Inst, Sett>, Sett extends Settings, Snap>
    implements Metric<Inst, Sett>,
    Snapshotting<Sett, Snap> {
        private final String name;
        private final String description;
        private final Sett settings;
        private final Function2<BaseMetric<Inst, Sett, Snap>, TagSet, Inst> instrumentBuilder;
        private final ScheduledExecutorService scheduler;
        private final TrieMap<TagSet, InstrumentEntry> _instruments;

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public String description() {
            return this.description;
        }

        @Override
        public Sett settings() {
            return this.settings;
        }

        private TrieMap<TagSet, InstrumentEntry> _instruments() {
            return this._instruments;
        }

        @Override
        public Inst withTag(String key, String value) {
            return this.lookupInstrument(TagSet$.MODULE$.of(key, value));
        }

        @Override
        public Inst withTag(String key, boolean value) {
            return this.lookupInstrument(TagSet$.MODULE$.of(key, Predef$.MODULE$.boolean2Boolean(value)));
        }

        @Override
        public Inst withTag(String key, long value) {
            return this.lookupInstrument(TagSet$.MODULE$.of(key, Predef$.MODULE$.long2Long(value)));
        }

        @Override
        public Inst withTags(TagSet tags) {
            return this.lookupInstrument(tags);
        }

        @Override
        public Inst withoutTags() {
            return this.lookupInstrument(TagSet$.MODULE$.Empty());
        }

        @Override
        public synchronized boolean remove(TagSet tags) {
            return this._instruments().get((Object)tags).map((Function1 & Serializable)entry -> {
                entry.removeOnNextSnapshot_$eq(true);
                return (Buffer)entry.scheduledActions().dropWhile((Function1 & Serializable)sa -> BoxesRunTime.boxToBoolean((boolean)BaseMetric.$anonfun$remove$2(sa)));
            }).nonEmpty();
        }

        @Override
        public synchronized MetricSnapshot<Sett, Snap> snapshot(boolean resetState) {
            ObjectRef instrumentSnapshots = ObjectRef.create((Object)List$.MODULE$.empty());
            this._instruments().foreach((Function1 & Serializable)x0$1 -> {
                BaseMetric.$anonfun$snapshot$1(this, resetState, instrumentSnapshots, x0$1);
                return BoxedUnit.UNIT;
            });
            return this.buildMetricSnapshot(this, (Seq<Instrument.Snapshot<Snap>>)((List)instrumentSnapshots.elem));
        }

        public synchronized Object schedule(Inst instrument, Runnable action, Duration interval) {
            return this._instruments().get((Object)instrument.tags()).map((Function1 & Serializable)entry -> {
                ScheduledFuture<?> scheduledAction = $this.scheduler.scheduleAtFixedRate(action, interval.toNanos(), interval.toNanos(), TimeUnit.NANOSECONDS);
                return (Buffer)entry.scheduledActions().$plus$eq(scheduledAction);
            });
        }

        public Status.Metric status() {
            return new Status.Metric(this.name(), this.description(), this.settings().unit(), this.instrumentType(), (Seq<Status.Instrument>)((IterableOnceOps)this._instruments().keys().map((Function1 & Serializable)t -> new Status.Instrument((TagSet)t))).toSeq());
        }

        public abstract Instrument.Type instrumentType();

        public abstract MetricSnapshot<Sett, Snap> buildMetricSnapshot(Metric<Inst, Sett> var1, Seq<Instrument.Snapshot<Snap>> var2);

        private Inst lookupInstrument(TagSet tags) {
            InstrumentEntry entry2 = package$AtomicGetOrElseUpdateOnTrieMap$.MODULE$.atomicGetOrElseUpdate$extension(package$.MODULE$.AtomicGetOrElseUpdateOnTrieMap(this._instruments()), tags, (Function0 & Serializable)() -> this.newInstrumentEntry(tags), (Function1 & Serializable)entry -> {
                this.cleanupStaleEntry(entry);
                return BoxedUnit.UNIT;
            }, (Function1 & Serializable)entry -> {
                this.triggerDefaultSchedule(entry);
                return BoxedUnit.UNIT;
            });
            entry2.removeOnNextSnapshot_$eq(false);
            return entry2.instrument();
        }

        private InstrumentEntry newInstrumentEntry(TagSet tags) {
            Buffer scheduledActions = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(Collections.synchronizedList(new ArrayList())).asScala();
            Instrument instrument = (Instrument)this.instrumentBuilder.apply((Object)this, (Object)tags);
            ((BaseMetricAutoUpdate)((Object)instrument)).defaultSchedule();
            return new InstrumentEntry(this, instrument, scheduledActions, false);
        }

        private void triggerDefaultSchedule(InstrumentEntry entry) {
            ((BaseMetricAutoUpdate)entry.instrument()).defaultSchedule();
        }

        private void cleanupStaleEntry(InstrumentEntry entry) {
            entry.scheduledActions().foreach((Function1 & Serializable)sa -> BoxesRunTime.boxToBoolean((boolean)sa.cancel(false)));
        }

        public static final /* synthetic */ boolean $anonfun$remove$2(ScheduledFuture sa) {
            sa.cancel(false);
            return true;
        }

        public static final /* synthetic */ void $anonfun$snapshot$1(BaseMetric $this, boolean resetState$1, ObjectRef instrumentSnapshots$1, Tuple2 x0$1) {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TagSet tags = (TagSet)tuple2._1();
            InstrumentEntry entry = (InstrumentEntry)tuple2._2();
            Object instrumentSnapshot = ((Instrument.Snapshotting)entry.instrument()).snapshot(resetState$1);
            Object object = entry.removeOnNextSnapshot() && resetState$1 ? $this._instruments().remove((Object)tags) : BoxedUnit.UNIT;
            Instrument.Snapshot snapshot = new Instrument.Snapshot(tags, instrumentSnapshot);
            instrumentSnapshots$1.elem = ((List)instrumentSnapshots$1.elem).$colon$colon(snapshot);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }

        public BaseMetric(String name, String description, Sett settings, Function2<BaseMetric<Inst, Sett, Snap>, TagSet, Inst> instrumentBuilder, ScheduledExecutorService scheduler) {
            this.name = name;
            this.description = description;
            this.settings = settings;
            this.instrumentBuilder = instrumentBuilder;
            this.scheduler = scheduler;
            this._instruments = TrieMap$.MODULE$.empty();
        }

        public class InstrumentEntry {
            private final Inst instrument;
            private final Buffer<ScheduledFuture<?>> scheduledActions;
            private volatile boolean removeOnNextSnapshot;
            public final /* synthetic */ BaseMetric $outer;

            public Inst instrument() {
                return this.instrument;
            }

            public Buffer<ScheduledFuture<?>> scheduledActions() {
                return this.scheduledActions;
            }

            public boolean removeOnNextSnapshot() {
                return this.removeOnNextSnapshot;
            }

            public void removeOnNextSnapshot_$eq(boolean x$1) {
                this.removeOnNextSnapshot = x$1;
            }

            public /* synthetic */ BaseMetric kamon$metric$Metric$BaseMetric$InstrumentEntry$$$outer() {
                return this.$outer;
            }

            /*
             * WARNING - Possible parameter corruption
             */
            public InstrumentEntry(Inst instrument, Buffer<ScheduledFuture<?>> scheduledActions, boolean removeOnNextSnapshot) {
                this.instrument = instrument;
                this.scheduledActions = scheduledActions;
                this.removeOnNextSnapshot = removeOnNextSnapshot;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = (BaseMetric)$outer;
            }
        }
    }

    public static interface BaseMetricAutoUpdate<Inst extends Instrument<Inst, Sett>, Sett extends Settings, Snap> {
        public BaseMetric<Inst, Sett, Snap> baseMetric();

        public static /* synthetic */ void defaultSchedule$(BaseMetricAutoUpdate $this) {
            $this.defaultSchedule();
        }

        default public void defaultSchedule() {
        }

        public static /* synthetic */ Instrument autoUpdate$(BaseMetricAutoUpdate $this, Function1 consumer, Duration interval) {
            return $this.autoUpdate(consumer, interval);
        }

        default public Inst autoUpdate(Function1<Inst, BoxedUnit> consumer, Duration interval) {
            BaseMetricAutoUpdate instrument = this;
            Runnable action = new Runnable(null, consumer, instrument){
                private final Function1 consumer$1;
                private final BaseMetricAutoUpdate instrument$1;

                public void run() {
                    this.consumer$1.apply((Object)this.instrument$1);
                }
                {
                    this.consumer$1 = consumer$1;
                    this.instrument$1 = instrument$1;
                }
            };
            this.baseMetric().schedule((Instrument)((Object)instrument), action, interval);
            return (Inst)((Instrument)((Object)this));
        }

        public static void $init$(BaseMetricAutoUpdate $this) {
        }
    }

    public static interface Counter
    extends Metric<kamon.metric.Counter, Settings.ForValueInstrument> {
    }

    public static interface Gauge
    extends Metric<kamon.metric.Gauge, Settings.ForValueInstrument> {
    }

    public static interface Histogram
    extends Metric<kamon.metric.Histogram, Settings.ForDistributionInstrument> {
    }

    public static interface RangeSampler
    extends Metric<kamon.metric.RangeSampler, Settings.ForDistributionInstrument> {
    }

    public static interface Settings {
        public MeasurementUnit unit();

        public Duration autoUpdateInterval();
    }

    public static interface Snapshotting<Sett extends Settings, Snap> {
        public MetricSnapshot<Sett, Snap> snapshot(boolean var1);
    }

    public static interface Timer
    extends Metric<kamon.metric.Timer, Settings.ForDistributionInstrument> {
    }
}

