/*
 * Decompiled with CFR 0.152.
 */
package kamon.metric;

import com.typesafe.config.Config;
import java.io.Serializable;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.ScheduledExecutorService;
import kamon.metric.Distribution;
import kamon.metric.DynamicRange;
import kamon.metric.Instrument;
import kamon.metric.Instrument$Type$;
import kamon.metric.MeasurementUnit;
import kamon.metric.MeasurementUnit$;
import kamon.metric.Metric;
import kamon.metric.MetricFactory;
import kamon.metric.MetricFactory$;
import kamon.metric.MetricSnapshot;
import kamon.metric.PeriodSnapshot;
import kamon.package$;
import kamon.package$AtomicGetOrElseUpdateOnTrieMap$;
import kamon.status.Status;
import kamon.util.Clock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.concurrent.TrieMap;
import scala.collection.concurrent.TrieMap$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0005\t5f\u0001B\u0010!\u0001\u0015B\u0001\u0002\f\u0001\u0003\u0002\u0003\u0006I!\f\u0005\tm\u0001\u0011\t\u0011)A\u0005o!A\u0011\t\u0001B\u0001B\u0003%!\tC\u0003H\u0001\u0011\u0005\u0001\nC\u0004O\u0001\t\u0007I\u0011B(\t\ra\u0003\u0001\u0015!\u0003Q\u0011\u001dI\u0006A1A\u0005\niCa! \u0001!\u0002\u0013Y\u0006\"CA\f\u0001\u0001\u0007I\u0011BA\r\u0011%\t9\u0003\u0001a\u0001\n\u0013\tI\u0003\u0003\u0005\u00026\u0001\u0001\u000b\u0015BA\u000e\u0011%\ty\u0004\u0001a\u0001\n\u0013\t\t\u0005C\u0005\u0002J\u0001\u0001\r\u0011\"\u0003\u0002L!A\u0011q\n\u0001!B\u0013\t\u0019\u0005C\u0004\u0002T\u0001!\t!!\u0016\t\u000f\u0005\u0015\u0005\u0001\"\u0001\u0002\b\"9\u0011q\u0013\u0001\u0005\u0002\u0005e\u0005bBA[\u0001\u0011\u0005\u0011q\u0017\u0005\b\u0003\u000f\u0004A\u0011AAe\u0011\u001d\tY\u000e\u0001C\u0001\u0003;Dq!a9\u0001\t\u0013\t)\u000fC\u0004\u0003\"\u0001!IAa\t\t\u000f\t]\u0002\u0001\"\u0003\u0003:!9!\u0011\u000b\u0001\u0005\n\tM\u0003b\u0002B/\u0001\u0011%!q\f\u0005\b\u0005S\u0002A\u0011\u0002B6\u0011\u001d\u0011)\b\u0001C\u0005\u0005oBqA!!\u0001\t\u0003\u0011\u0019\tC\u0004\u0003\u0016\u0002!\tAa&\t\u000f\t%\u0006\u0001\"\u0001\u0003,\nqQ*\u001a;sS\u000e\u0014VmZ5tiJL(BA\u0011#\u0003\u0019iW\r\u001e:jG*\t1%A\u0003lC6|gn\u0001\u0001\u0014\u0005\u00011\u0003CA\u0014+\u001b\u0005A#\"A\u0015\u0002\u000bM\u001c\u0017\r\\1\n\u0005-B#AB!osJ+g-\u0001\u0004d_:4\u0017n\u001a\t\u0003]Qj\u0011a\f\u0006\u0003YAR!!\r\u001a\u0002\u0011QL\b/Z:bM\u0016T\u0011aM\u0001\u0004G>l\u0017BA\u001b0\u0005\u0019\u0019uN\u001c4jO\u0006I1o\u00195fIVdWM\u001d\t\u0003q}j\u0011!\u000f\u0006\u0003um\n!bY8oGV\u0014(/\u001a8u\u0015\taT(\u0001\u0003vi&d'\"\u0001 \u0002\t)\fg/Y\u0005\u0003\u0001f\u0012\u0001dU2iK\u0012,H.\u001a3Fq\u0016\u001cW\u000f^8s'\u0016\u0014h/[2f\u0003\u0015\u0019Gn\\2l!\t\u0019U)D\u0001E\u0015\ta$%\u0003\u0002G\t\n)1\t\\8dW\u00061A(\u001b8jiz\"B!S&M\u001bB\u0011!\nA\u0007\u0002A!)A\u0006\u0002a\u0001[!)a\u0007\u0002a\u0001o!)\u0011\t\u0002a\u0001\u0005\u00069q\f\\8hO\u0016\u0014X#\u0001)\u0011\u0005E3V\"\u0001*\u000b\u0005M#\u0016!B:mMRR'\"A+\u0002\u0007=\u0014x-\u0003\u0002X%\n1Aj\\4hKJ\f\u0001b\u00187pO\u001e,'\u000fI\u0001\t?6,GO]5dgV\t1\f\u0005\u0003]A\nlW\"A/\u000b\u0005ir&BA0)\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003Cv\u0013q\u0001\u0016:jK6\u000b\u0007\u000f\u0005\u0002dU:\u0011A\r\u001b\t\u0003K\"j\u0011A\u001a\u0006\u0003O\u0012\na\u0001\u0010:p_Rt\u0014BA5)\u0003\u0019\u0001&/\u001a3fM&\u00111\u000e\u001c\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005%D\u0003G\u00028|\u0003\u001b\t\u0019\u0002E\u0004pmf\fY!!\u0005\u000f\u0005A$hBA9t\u001d\t)'/C\u0001$\u0013\t\t#%\u0003\u0002vA\u00051Q*\u001a;sS\u000eL!a\u001e=\u0003\u0015\t\u000b7/Z'fiJL7M\u0003\u0002vAA\u0011!p\u001f\u0007\u0001\t%a\b\"!A\u0001\u0002\u000b\u0005aPA\u0002`IE\n\u0011bX7fiJL7m\u001d\u0011\u0012\u0007}\f)\u0001E\u0002(\u0003\u0003I1!a\u0001)\u0005\u001dqu\u000e\u001e5j]\u001e\u00042aJA\u0004\u0013\r\tI\u0001\u000b\u0002\u0004\u0003:L\bc\u0001>\u0002\u000e\u0011Q\u0011q\u0002\u0005\u0002\u0002\u0003\u0005)\u0011\u0001@\u0003\u0007}##\u0007E\u0002{\u0003'!!\"!\u0006\t\u0003\u0003\u0005\tQ!\u0001\u007f\u0005\ryFeM\u0001\u0015?2\f7\u000f^*oCB\u001c\bn\u001c;J]N$\u0018M\u001c;\u0016\u0005\u0005m\u0001\u0003BA\u000f\u0003Gi!!a\b\u000b\u0007\u0005\u0005R(\u0001\u0003uS6,\u0017\u0002BA\u0013\u0003?\u0011q!\u00138ti\u0006tG/\u0001\r`Y\u0006\u001cHo\u00158baNDw\u000e^%ogR\fg\u000e^0%KF$B!a\u000b\u00022A\u0019q%!\f\n\u0007\u0005=\u0002F\u0001\u0003V]&$\b\"CA\u001a\u0015\u0005\u0005\t\u0019AA\u000e\u0003\rAH%M\u0001\u0016?2\f7\u000f^*oCB\u001c\bn\u001c;J]N$\u0018M\u001c;!Q\rY\u0011\u0011\b\t\u0004O\u0005m\u0012bAA\u001fQ\tAao\u001c7bi&dW-\u0001\u0005`M\u0006\u001cGo\u001c:z+\t\t\u0019\u0005E\u0002K\u0003\u000bJ1!a\u0012!\u00055iU\r\u001e:jG\u001a\u000b7\r^8ss\u0006aqLZ1di>\u0014\u0018p\u0018\u0013fcR!\u00111FA'\u0011%\t\u0019$DA\u0001\u0002\u0004\t\u0019%A\u0005`M\u0006\u001cGo\u001c:zA!\u001aa\"!\u000f\u0002\u000f\r|WO\u001c;feRQ\u0011qKA0\u0003G\ni'!\u001f\u0011\t\u0005e\u00131\f\b\u0003\u0015RL1!!\u0018y\u0005\u001d\u0019u.\u001e8uKJDa!!\u0019\u0010\u0001\u0004\u0011\u0017\u0001\u00028b[\u0016Dq!!\u001a\u0010\u0001\u0004\t9'A\u0006eKN\u001c'/\u001b9uS>t\u0007\u0003B\u0014\u0002j\tL1!a\u001b)\u0005\u0019y\u0005\u000f^5p]\"9\u0011qN\bA\u0002\u0005E\u0014\u0001B;oSR\u0004RaJA5\u0003g\u00022ASA;\u0013\r\t9\b\t\u0002\u0010\u001b\u0016\f7/\u001e:f[\u0016tG/\u00168ji\"9\u00111P\bA\u0002\u0005u\u0014AE1vi>,\u0006\u000fZ1uK&sG/\u001a:wC2\u0004RaJA5\u0003\u007f\u0002B!!\b\u0002\u0002&!\u00111QA\u0010\u0005!!UO]1uS>t\u0017!B4bk\u001e,GCCAE\u0003\u001f\u000b\t*a%\u0002\u0016B!\u0011\u0011LAF\u0013\r\ti\t\u001f\u0002\u0006\u000f\u0006,x-\u001a\u0005\u0007\u0003C\u0002\u0002\u0019\u00012\t\u000f\u0005\u0015\u0004\u00031\u0001\u0002h!9\u0011q\u000e\tA\u0002\u0005E\u0004bBA>!\u0001\u0007\u0011QP\u0001\nQ&\u001cHo\\4sC6$B\"a'\u0002\"\u0006\r\u0016QUAT\u0003g\u0003B!!\u0017\u0002\u001e&\u0019\u0011q\u0014=\u0003\u0013!K7\u000f^8he\u0006l\u0007BBA1#\u0001\u0007!\rC\u0004\u0002fE\u0001\r!a\u001a\t\u000f\u0005=\u0014\u00031\u0001\u0002r!9\u0011\u0011V\tA\u0002\u0005-\u0016\u0001\u00043z]\u0006l\u0017n\u0019*b]\u001e,\u0007#B\u0014\u0002j\u00055\u0006c\u0001&\u00020&\u0019\u0011\u0011\u0017\u0011\u0003\u0019\u0011Kh.Y7jGJ\u000bgnZ3\t\u000f\u0005m\u0014\u00031\u0001\u0002~\u0005)A/[7feRQ\u0011\u0011XA`\u0003\u0003\f\u0019-!2\u0011\t\u0005e\u00131X\u0005\u0004\u0003{C(!\u0002+j[\u0016\u0014\bBBA1%\u0001\u0007!\rC\u0004\u0002fI\u0001\r!a\u001a\t\u000f\u0005%&\u00031\u0001\u0002,\"9\u00111\u0010\nA\u0002\u0005u\u0014\u0001\u0004:b]\u001e,7+Y7qY\u0016\u0014H\u0003DAf\u0003#\f\u0019.!6\u0002X\u0006e\u0007\u0003BA-\u0003\u001bL1!a4y\u00051\u0011\u0016M\\4f'\u0006l\u0007\u000f\\3s\u0011\u0019\t\tg\u0005a\u0001E\"9\u0011QM\nA\u0002\u0005\u001d\u0004bBA8'\u0001\u0007\u0011\u0011\u000f\u0005\b\u0003S\u001b\u0002\u0019AAV\u0011\u001d\tYh\u0005a\u0001\u0003{\n1B]3d_:4\u0017nZ;sKR!\u00111FAp\u0011\u0019\t\t\u000f\u0006a\u0001[\u0005Ia.Z<D_:4\u0017nZ\u0001\u0017m\u0006d\u0017\u000eZ1uK&s7\u000f\u001e:v[\u0016tG\u000fV=qKV!\u0011q]Aw)\u0011\tIO!\u0002\u0015\r\u0005-\u0018\u0011_Az!\rQ\u0018Q\u001e\u0003\u0007\u0003_,\"\u0019\u0001@\u0003\u0003QCa!!\u0019\u0016\u0001\u0004\u0011\u0007bBA{+\u0001\u0007\u0011q_\u0001\u000fS:\u001cHO];nK:$H+\u001f9f!\u0011\tI0a@\u000f\u0007)\u000bY0C\u0002\u0002~\u0002\n!\"\u00138tiJ,X.\u001a8u\u0013\u0011\u0011\tAa\u0001\u0003\tQK\b/\u001a\u0006\u0004\u0003{\u0004\u0003bB\u0011\u0016\t\u0003\u0007!q\u0001\t\u0006O\t%!QB\u0005\u0004\u0005\u0017A#\u0001\u0003\u001fcs:\fW.\u001a 1\r\t=!q\u0003B\u000f!\u001dQ%\u0011\u0003B\u000b\u00057I1Aa\u0005!\u0005\u0019iU\r\u001e:jGB\u0019!Pa\u0006\u0005\u0017\te!QAA\u0001\u0002\u0003\u0015\tA \u0002\u0004?\u0012\"\u0004c\u0001>\u0003\u001e\u0011Y!q\u0004B\u0003\u0003\u0003\u0005\tQ!\u0001\u007f\u0005\ryF%N\u0001\u0013S6\u0004H.Z7f]R\fG/[8o\u001d\u0006lW\rF\u0002c\u0005KAa!\t\fA\u0002\t\u001d\u0002G\u0002B\u0015\u0005[\u0011\u0019\u0004E\u0004K\u0005#\u0011YC!\r\u0011\u0007i\u0014i\u0003B\u0006\u00030\t\u0015\u0012\u0011!A\u0001\u0006\u0003q(aA0%mA\u0019!Pa\r\u0005\u0017\tU\"QEA\u0001\u0002\u0003\u0015\tA \u0002\u0004?\u0012:\u0014aE2iK\u000e\\\u0017J\\:ueVlWM\u001c;UsB,G\u0003CA\u0016\u0005w\u0011iDa\u0010\t\r\u0005\u0005t\u00031\u0001c\u0011\u001d\t)p\u0006a\u0001\u0003oDa!I\fA\u0002\t\u0005\u0003G\u0002B\"\u0005\u000f\u0012i\u0005E\u0004K\u0005#\u0011)Ea\u0013\u0011\u0007i\u00149\u0005B\u0006\u0003J\t}\u0012\u0011!A\u0001\u0006\u0003q(aA0%qA\u0019!P!\u0014\u0005\u0017\t=#qHA\u0001\u0002\u0003\u0015\tA \u0002\u0004?\u0012J\u0014\u0001E2iK\u000e\\G)Z:de&\u0004H/[8o)!\tYC!\u0016\u0003X\te\u0003BBA11\u0001\u0007!\r\u0003\u0004\u0002fa\u0001\rA\u0019\u0005\b\u00057B\u0002\u0019AA4\u0003M\u0001(o\u001c<jI\u0016$G)Z:de&\u0004H/[8o\u0003%\u0019\u0007.Z2l+:LG\u000f\u0006\u0005\u0002,\t\u0005$1\rB3\u0011\u0019\t\t'\u0007a\u0001E\"9\u0011qN\rA\u0002\u0005M\u0004b\u0002B43\u0001\u0007\u0011\u0011O\u0001\raJ|g/\u001b3fIVs\u0017\u000e^\u0001\u0010G\",7m[!vi>,\u0006\u000fZ1uKRA\u00111\u0006B7\u0005_\u0012\t\b\u0003\u0004\u0002bi\u0001\rA\u0019\u0005\b\u0003wR\u0002\u0019AA@\u0011\u001d\u0011\u0019H\u0007a\u0001\u0003{\n!\u0004\u001d:pm&$W\rZ!vi>,\u0006\u000fZ1uK&sG/\u001a:wC2\f\u0011c\u00195fG.$\u0015P\\1nS\u000e\u0014\u0016M\\4f)!\tYC!\u001f\u0003|\tu\u0004BBA17\u0001\u0007!\rC\u0004\u0002*n\u0001\r!!,\t\u000f\t}4\u00041\u0001\u0002,\u0006!\u0002O]8wS\u0012,G\rR=oC6L7MU1oO\u0016\f\u0001b\u001d8baNDw\u000e\u001e\u000b\u0005\u0005\u000b\u0013Y\tE\u0002K\u0005\u000fK1A!#!\u00059\u0001VM]5pINs\u0017\r]:i_RDqA!$\u001d\u0001\u0004\u0011y)\u0001\u0006sKN,Go\u0015;bi\u0016\u00042a\nBI\u0013\r\u0011\u0019\n\u000b\u0002\b\u0005>|G.Z1o\u0003\u0019\u0019H/\u0019;vgR\u0011!\u0011\u0014\t\u0005\u00057\u0013)K\u0004\u0003\u0003\u001e\n\u0005VB\u0001BP\u0015\r\u0011)JI\u0005\u0005\u0005G\u0013y*\u0001\u0004Ti\u0006$Xo]\u0005\u0004?\t\u001d&\u0002\u0002BR\u0005?\u000bQa\u00197fCJ$\"!a\u000b")
public class MetricRegistry {
    private final ScheduledExecutorService scheduler;
    private final Clock clock;
    private final Logger _logger;
    private final TrieMap<String, Metric.BaseMetric<?, ?, ?>> _metrics;
    private volatile Instant _lastSnapshotInstant;
    private volatile MetricFactory _factory;

    private Logger _logger() {
        return this._logger;
    }

    private TrieMap<String, Metric.BaseMetric<?, ?, ?>> _metrics() {
        return this._metrics;
    }

    private Instant _lastSnapshotInstant() {
        return this._lastSnapshotInstant;
    }

    private void _lastSnapshotInstant_$eq(Instant x$1) {
        this._lastSnapshotInstant = x$1;
    }

    private MetricFactory _factory() {
        return this._factory;
    }

    private void _factory_$eq(MetricFactory x$1) {
        this._factory = x$1;
    }

    public Metric.Counter counter(String name, Option<String> description, Option<MeasurementUnit> unit, Option<Duration> autoUpdateInterval) {
        Metric.Counter metric = (Metric.Counter)this.validateInstrumentType((Function0 & Serializable)() -> package$AtomicGetOrElseUpdateOnTrieMap$.MODULE$.atomicGetOrElseUpdate$extension(package$.MODULE$.AtomicGetOrElseUpdateOnTrieMap(this._metrics()), name, (Function0 & Serializable)() -> this._factory().counter(name, description, unit, autoUpdateInterval)), name, Instrument$Type$.MODULE$.Counter());
        this.checkDescription(metric.name(), metric.description(), description);
        this.checkUnit(metric.name(), ((Metric.Settings.ForValueInstrument)metric.settings()).unit(), unit);
        this.checkAutoUpdate(metric.name(), ((Metric.Settings.ForValueInstrument)metric.settings()).autoUpdateInterval(), autoUpdateInterval);
        return metric;
    }

    public Metric.Gauge gauge(String name, Option<String> description, Option<MeasurementUnit> unit, Option<Duration> autoUpdateInterval) {
        Metric.Gauge metric = (Metric.Gauge)this.validateInstrumentType((Function0 & Serializable)() -> package$AtomicGetOrElseUpdateOnTrieMap$.MODULE$.atomicGetOrElseUpdate$extension(package$.MODULE$.AtomicGetOrElseUpdateOnTrieMap(this._metrics()), name, (Function0 & Serializable)() -> this._factory().gauge(name, description, unit, autoUpdateInterval)), name, Instrument$Type$.MODULE$.Gauge());
        this.checkDescription(metric.name(), metric.description(), description);
        this.checkUnit(metric.name(), ((Metric.Settings.ForValueInstrument)metric.settings()).unit(), unit);
        this.checkAutoUpdate(metric.name(), ((Metric.Settings.ForValueInstrument)metric.settings()).autoUpdateInterval(), autoUpdateInterval);
        return metric;
    }

    public Metric.Histogram histogram(String name, Option<String> description, Option<MeasurementUnit> unit, Option<DynamicRange> dynamicRange, Option<Duration> autoUpdateInterval) {
        Metric.Histogram metric = (Metric.Histogram)this.validateInstrumentType((Function0 & Serializable)() -> package$AtomicGetOrElseUpdateOnTrieMap$.MODULE$.atomicGetOrElseUpdate$extension(package$.MODULE$.AtomicGetOrElseUpdateOnTrieMap(this._metrics()), name, (Function0 & Serializable)() -> this._factory().histogram(name, description, unit, dynamicRange, autoUpdateInterval)), name, Instrument$Type$.MODULE$.Histogram());
        this.checkDescription(metric.name(), metric.description(), description);
        this.checkUnit(metric.name(), ((Metric.Settings.ForDistributionInstrument)metric.settings()).unit(), unit);
        this.checkDynamicRange(metric.name(), ((Metric.Settings.ForDistributionInstrument)metric.settings()).dynamicRange(), dynamicRange);
        this.checkAutoUpdate(metric.name(), ((Metric.Settings.ForDistributionInstrument)metric.settings()).autoUpdateInterval(), autoUpdateInterval);
        return metric;
    }

    public Metric.Timer timer(String name, Option<String> description, Option<DynamicRange> dynamicRange, Option<Duration> autoUpdateInterval) {
        Metric.Timer metric = (Metric.Timer)this.validateInstrumentType((Function0 & Serializable)() -> package$AtomicGetOrElseUpdateOnTrieMap$.MODULE$.atomicGetOrElseUpdate$extension(package$.MODULE$.AtomicGetOrElseUpdateOnTrieMap(this._metrics()), name, (Function0 & Serializable)() -> this._factory().timer(name, description, (Option<MeasurementUnit>)new Some((Object)MeasurementUnit$.MODULE$.time().nanoseconds()), dynamicRange, autoUpdateInterval)), name, Instrument$Type$.MODULE$.Timer());
        this.checkDescription(metric.name(), metric.description(), description);
        this.checkDynamicRange(metric.name(), ((Metric.Settings.ForDistributionInstrument)metric.settings()).dynamicRange(), dynamicRange);
        this.checkAutoUpdate(metric.name(), ((Metric.Settings.ForDistributionInstrument)metric.settings()).autoUpdateInterval(), autoUpdateInterval);
        return metric;
    }

    public Metric.RangeSampler rangeSampler(String name, Option<String> description, Option<MeasurementUnit> unit, Option<DynamicRange> dynamicRange, Option<Duration> autoUpdateInterval) {
        Metric.RangeSampler metric = (Metric.RangeSampler)this.validateInstrumentType((Function0 & Serializable)() -> package$AtomicGetOrElseUpdateOnTrieMap$.MODULE$.atomicGetOrElseUpdate$extension(package$.MODULE$.AtomicGetOrElseUpdateOnTrieMap(this._metrics()), name, (Function0 & Serializable)() -> this._factory().rangeSampler(name, description, unit, dynamicRange, autoUpdateInterval)), name, Instrument$Type$.MODULE$.RangeSampler());
        this.checkDescription(metric.name(), metric.description(), description);
        this.checkUnit(metric.name(), ((Metric.Settings.ForDistributionInstrument)metric.settings()).unit(), unit);
        this.checkDynamicRange(metric.name(), ((Metric.Settings.ForDistributionInstrument)metric.settings()).dynamicRange(), dynamicRange);
        this.checkAutoUpdate(metric.name(), ((Metric.Settings.ForDistributionInstrument)metric.settings()).autoUpdateInterval(), autoUpdateInterval);
        return metric;
    }

    public void reconfigure(Config newConfig) {
        this._factory_$eq(MetricFactory$.MODULE$.from(newConfig, this.scheduler, this.clock));
    }

    private <T> T validateInstrumentType(Function0<Metric<?, ?>> metric, String name, Instrument.Type instrumentType) {
        Metric lookedUpMetric = (Metric)metric.apply();
        if (!instrumentType.implementation().isInstance(lookedUpMetric)) {
            throw new IllegalArgumentException(new StringBuilder(0).append(new StringBuilder(50).append("Cannot redefine metric [").append(name).append("] as a [").append(instrumentType.name()).append("], it was already ").toString()).append(new StringBuilder(18).append("registered as a [").append(this.implementationName((Metric)metric.apply())).append("]").toString()).toString());
        }
        return (T)lookedUpMetric;
    }

    private String implementationName(Metric<?, ?> metric) {
        String string;
        Metric<?, ?> metric2 = metric;
        if (metric2 instanceof Metric.Counter) {
            string = Instrument$Type$.MODULE$.Counter().name();
        } else if (metric2 instanceof Metric.Gauge) {
            string = Instrument$Type$.MODULE$.Gauge().name();
        } else if (metric2 instanceof Metric.Histogram) {
            string = Instrument$Type$.MODULE$.Histogram().name();
        } else if (metric2 instanceof Metric.RangeSampler) {
            string = Instrument$Type$.MODULE$.RangeSampler().name();
        } else if (metric2 instanceof Metric.Timer) {
            string = Instrument$Type$.MODULE$.Timer().name();
        } else {
            throw new MatchError(metric2);
        }
        return string;
    }

    private void checkInstrumentType(String name, Instrument.Type instrumentType, Metric<?, ?> metric) {
        if (!instrumentType.implementation().isInstance(metric)) {
            throw scala.sys.package$.MODULE$.error(new StringBuilder(68).append("Cannot redefine metric [").append(name).append("] as a [").append(instrumentType.name()).append("], it was already registered as a [").append(metric.getClass().getName()).append("]").toString());
        }
    }

    private void checkDescription(String name, String description, Option<String> providedDescription) {
        block0: {
            if (!providedDescription.exists((Function1 & Serializable)d -> BoxesRunTime.boxToBoolean((boolean)MetricRegistry.$anonfun$checkDescription$1(description, d)))) break block0;
            this._logger().warn(new StringBuilder(41).append("Ignoring new description [").append(providedDescription.getOrElse((Function0 & Serializable)() -> "")).append("] for metric [").append(name).append("]").toString());
        }
    }

    private void checkUnit(String name, MeasurementUnit unit, Option<MeasurementUnit> providedUnit) {
        block0: {
            if (!providedUnit.exists((Function1 & Serializable)u -> BoxesRunTime.boxToBoolean((boolean)MetricRegistry.$anonfun$checkUnit$1(unit, u)))) break block0;
            this._logger().warn(new StringBuilder(34).append("Ignoring new unit [").append(providedUnit.getOrElse((Function0 & Serializable)() -> "")).append("] for metric [").append(name).append("]").toString());
        }
    }

    private void checkAutoUpdate(String name, Duration autoUpdateInterval, Option<Duration> providedAutoUpdateInterval) {
        block0: {
            if (!providedAutoUpdateInterval.exists((Function1 & Serializable)u -> BoxesRunTime.boxToBoolean((boolean)MetricRegistry.$anonfun$checkAutoUpdate$1(autoUpdateInterval, u)))) break block0;
            this._logger().warn(new StringBuilder(50).append("Ignoring new auto-update interval [").append(providedAutoUpdateInterval.getOrElse((Function0 & Serializable)() -> "")).append("] for metric [").append(name).append("]").toString());
        }
    }

    private void checkDynamicRange(String name, DynamicRange dynamicRange, Option<DynamicRange> providedDynamicRange) {
        block0: {
            if (!providedDynamicRange.exists((Function1 & Serializable)dr -> BoxesRunTime.boxToBoolean((boolean)MetricRegistry.$anonfun$checkDynamicRange$1(dynamicRange, dr)))) break block0;
            this._logger().warn(new StringBuilder(43).append("Ignoring new dynamic range [").append(providedDynamicRange.getOrElse((Function0 & Serializable)() -> "")).append("] for metric [").append(name).append("]").toString());
        }
    }

    public synchronized PeriodSnapshot snapshot(boolean resetState) {
        ObjectRef counters = ObjectRef.create((Object)List$.MODULE$.empty());
        ObjectRef gauges = ObjectRef.create((Object)List$.MODULE$.empty());
        ObjectRef histograms = ObjectRef.create((Object)List$.MODULE$.empty());
        ObjectRef timers = ObjectRef.create((Object)List$.MODULE$.empty());
        ObjectRef rangeSamplers = ObjectRef.create((Object)List$.MODULE$.empty());
        this._metrics().foreach((Function1 & Serializable)x0$1 -> {
            MetricRegistry.$anonfun$snapshot$1(counters, resetState, gauges, histograms, timers, rangeSamplers, x0$1);
            return BoxedUnit.UNIT;
        });
        Instant periodStart = this._lastSnapshotInstant();
        Instant periodEnd = this.clock.instant();
        this._lastSnapshotInstant_$eq(periodEnd);
        return new PeriodSnapshot(periodStart, periodEnd, (Seq<MetricSnapshot<Metric.Settings.ForValueInstrument, Object>>)((List)counters.elem), (Seq<MetricSnapshot<Metric.Settings.ForValueInstrument, Object>>)((List)gauges.elem), (Seq<MetricSnapshot<Metric.Settings.ForDistributionInstrument, Distribution>>)((List)histograms.elem), (Seq<MetricSnapshot<Metric.Settings.ForDistributionInstrument, Distribution>>)((List)timers.elem), (Seq<MetricSnapshot<Metric.Settings.ForDistributionInstrument, Distribution>>)((List)rangeSamplers.elem));
    }

    public Status.MetricRegistry status() {
        return new Status.MetricRegistry((Seq<Status.Metric>)((IterableOnceOps)this._metrics().values().map((Function1 & Serializable)x$1 -> x$1.status())).toSeq());
    }

    public void clear() {
        this._metrics().values().foreach((Function1 & Serializable)metric -> {
            MetricRegistry.$anonfun$clear$1(metric);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$checkDescription$1(String description$6, String d) {
        String string = d;
        String string2 = description$6;
        return string == null ? string2 != null : !string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$checkUnit$1(MeasurementUnit unit$5, MeasurementUnit u) {
        MeasurementUnit measurementUnit = u;
        MeasurementUnit measurementUnit2 = unit$5;
        return measurementUnit == null ? measurementUnit2 != null : !((Object)measurementUnit).equals(measurementUnit2);
    }

    public static final /* synthetic */ boolean $anonfun$checkAutoUpdate$1(Duration autoUpdateInterval$6, Duration u) {
        Duration duration = u;
        Duration duration2 = autoUpdateInterval$6;
        return duration == null ? duration2 != null : !((Object)duration).equals(duration2);
    }

    public static final /* synthetic */ boolean $anonfun$checkDynamicRange$1(DynamicRange dynamicRange$4, DynamicRange dr) {
        DynamicRange dynamicRange = dr;
        DynamicRange dynamicRange2 = dynamicRange$4;
        return dynamicRange == null ? dynamicRange2 != null : !((Object)dynamicRange).equals(dynamicRange2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ void $anonfun$snapshot$1(ObjectRef counters$1, boolean resetState$1, ObjectRef gauges$1, ObjectRef histograms$1, ObjectRef timers$1, ObjectRef rangeSamplers$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        Metric.BaseMetric metric = (Metric.BaseMetric)tuple2._2();
        Metric.BaseMetric baseMetric = metric;
        if (baseMetric instanceof Metric.Counter) {
            Metric.BaseMetric baseMetric2 = baseMetric;
            MetricSnapshot metricSnapshot = baseMetric2.snapshot(resetState$1);
            counters$1.elem = ((List)counters$1.elem).$colon$colon(metricSnapshot);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (baseMetric instanceof Metric.Gauge) {
            Metric.BaseMetric baseMetric3 = baseMetric;
            MetricSnapshot metricSnapshot = baseMetric3.snapshot(resetState$1);
            gauges$1.elem = ((List)gauges$1.elem).$colon$colon(metricSnapshot);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (baseMetric instanceof Metric.Histogram) {
            Metric.BaseMetric baseMetric4 = baseMetric;
            MetricSnapshot metricSnapshot = baseMetric4.snapshot(resetState$1);
            histograms$1.elem = ((List)histograms$1.elem).$colon$colon(metricSnapshot);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (baseMetric instanceof Metric.Timer) {
            Metric.BaseMetric baseMetric5 = baseMetric;
            MetricSnapshot metricSnapshot = baseMetric5.snapshot(resetState$1);
            timers$1.elem = ((List)timers$1.elem).$colon$colon(metricSnapshot);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            if (!(baseMetric instanceof Metric.RangeSampler)) throw new MatchError((Object)baseMetric);
            Metric.BaseMetric baseMetric6 = baseMetric;
            MetricSnapshot metricSnapshot = baseMetric6.snapshot(resetState$1);
            rangeSamplers$1.elem = ((List)rangeSamplers$1.elem).$colon$colon(metricSnapshot);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$clear$1(Metric.BaseMetric metric) {
        metric.status().instruments().foreach((Function1 & Serializable)i -> BoxesRunTime.boxToBoolean((boolean)metric.remove(i.tags())));
    }

    public MetricRegistry(Config config, ScheduledExecutorService scheduler, Clock clock) {
        this.scheduler = scheduler;
        this.clock = clock;
        this._logger = LoggerFactory.getLogger(MetricRegistry.class);
        this._metrics = TrieMap$.MODULE$.empty();
        this._lastSnapshotInstant = clock.instant();
        this._factory = MetricFactory$.MODULE$.from(config, scheduler, clock);
    }
}

