/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.assertion;

import java.util.Arrays;
import java.util.Map;
import org.dbunit.DatabaseUnitException;
import org.dbunit.assertion.DbUnitAssert;
import org.dbunit.assertion.DefaultFailureHandler;
import org.dbunit.assertion.Difference;
import org.dbunit.assertion.FailureFactory;
import org.dbunit.assertion.FailureHandler;
import org.dbunit.assertion.JUnitFailureFactory;
import org.dbunit.assertion.comparer.value.DefaultValueComparerDefaults;
import org.dbunit.assertion.comparer.value.ValueComparer;
import org.dbunit.assertion.comparer.value.ValueComparerDefaults;
import org.dbunit.dataset.Column;
import org.dbunit.dataset.Columns;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.ITableMetaData;
import org.dbunit.dataset.datatype.DataType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbUnitAssertBase {
    private final Logger log = LoggerFactory.getLogger(DbUnitAssertBase.class);
    private FailureFactory junitFailureFactory = this.getJUnitFailureFactory();
    protected ValueComparerDefaults valueComparerDefaults = new DefaultValueComparerDefaults();

    protected FailureHandler getDefaultFailureHandler() {
        return this.getDefaultFailureHandler(null);
    }

    protected FailureHandler getDefaultFailureHandler(Column[] additionalColumnInfo) {
        DefaultFailureHandler failureHandler = new DefaultFailureHandler(additionalColumnInfo);
        if (this.junitFailureFactory != null) {
            failureHandler.setFailureFactory(this.junitFailureFactory);
        }
        return failureHandler;
    }

    private FailureFactory getJUnitFailureFactory() {
        try {
            Class.forName("junit.framework.Assert");
            return new JUnitFailureFactory();
        }
        catch (ClassNotFoundException e) {
            this.log.debug("JUnit does not seem to be on the classpath. " + e);
            return null;
        }
    }

    protected DbUnitAssert.ComparisonColumn[] getComparisonColumns(String expectedTableName, Column[] expectedColumns, Column[] actualColumns, FailureHandler failureHandler) {
        DbUnitAssert.ComparisonColumn[] result = new DbUnitAssert.ComparisonColumn[expectedColumns.length];
        int j = 0;
        while (j < expectedColumns.length) {
            Column expectedColumn = expectedColumns[j];
            Column actualColumn = actualColumns[j];
            result[j] = new DbUnitAssert.ComparisonColumn(expectedTableName, expectedColumn, actualColumn, failureHandler);
            ++j;
        }
        return result;
    }

    protected boolean skipCompare(String columnName, Object expectedValue, Object actualValue) {
        return false;
    }

    protected FailureHandler determineFailureHandler(FailureHandler failureHandler) {
        FailureHandler validFailureHandler;
        if (failureHandler == null) {
            this.log.debug("FailureHandler is null. Using default implementation");
            validFailureHandler = this.getDefaultFailureHandler();
        } else {
            validFailureHandler = failureHandler;
        }
        return validFailureHandler;
    }

    protected boolean compareRowCounts(ITable expectedTable, ITable actualTable, FailureHandler failureHandler, String expectedTableName) throws Error {
        boolean isTablesEmpty;
        int expectedRowsCount = expectedTable.getRowCount();
        int actualRowsCount = 0;
        boolean skipRowComparison = false;
        try {
            actualRowsCount = actualTable.getRowCount();
        }
        catch (UnsupportedOperationException exception) {
            skipRowComparison = true;
        }
        if (skipRowComparison) {
            isTablesEmpty = false;
        } else {
            if (expectedRowsCount != actualRowsCount) {
                String msg = "row count (table=" + expectedTableName + ")";
                Error error = failureHandler.createFailure(msg, String.valueOf(expectedRowsCount), String.valueOf(actualRowsCount));
                this.log.error(error.toString());
                throw error;
            }
            if (expectedRowsCount == 0 && actualRowsCount == 0) {
                this.log.debug("Tables are empty, hence equals.");
                isTablesEmpty = true;
            } else {
                isTablesEmpty = false;
            }
        }
        return isTablesEmpty;
    }

    protected void compareColumns(Column[] expectedColumns, Column[] actualColumns, ITableMetaData expectedMetaData, ITableMetaData actualMetaData, FailureHandler failureHandler) throws DataSetException, Error {
        Columns.ColumnDiff columnDiff = Columns.getColumnDiff(expectedMetaData, actualMetaData);
        if (columnDiff.hasDifference()) {
            String message = columnDiff.getMessage();
            Error error = failureHandler.createFailure(message, Columns.getColumnNamesAsString(expectedColumns), Columns.getColumnNamesAsString(actualColumns));
            this.log.error(error.toString());
            throw error;
        }
    }

    protected void compareTableCounts(String[] expectedNames, String[] actualNames, FailureHandler failureHandler) throws Error {
        if (expectedNames.length != actualNames.length) {
            throw failureHandler.createFailure("table count", String.valueOf(expectedNames.length), String.valueOf(actualNames.length));
        }
    }

    protected void compareTableNames(String[] expectedNames, String[] actualNames, FailureHandler failureHandler) throws Error {
        int i = 0;
        while (i < expectedNames.length) {
            if (!actualNames[i].equals(expectedNames[i])) {
                throw failureHandler.createFailure("tables", Arrays.asList(expectedNames).toString(), Arrays.asList(actualNames).toString());
            }
            ++i;
        }
    }

    protected String[] getSortedTableNames(IDataSet dataSet) throws DataSetException {
        this.log.debug("getSortedTableNames(dataSet={}) - start", (Object)dataSet);
        Object[] names = dataSet.getTableNames();
        if (!dataSet.isCaseSensitiveTableNames()) {
            int i = 0;
            while (i < names.length) {
                names[i] = ((String)names[i]).toUpperCase();
                ++i;
            }
        }
        Arrays.sort(names);
        return names;
    }

    public void assertWithValueComparer(IDataSet expectedDataSet, IDataSet actualDataSet, FailureHandler failureHandler, ValueComparer defaultValueComparer, Map<String, Map<String, ValueComparer>> tableColumnValueComparers) throws DatabaseUnitException {
        this.log.debug("assertWithValueComparer(expectedDataSet={}, actualDataSet={}, failureHandler={}, defaultValueComparer={}, tableColumnValueComparers={}) - start", new Object[]{expectedDataSet, actualDataSet, failureHandler, defaultValueComparer, tableColumnValueComparers});
        if (expectedDataSet == actualDataSet) {
            this.log.debug("The given datasets reference the same object. Skipping comparisons.");
            return;
        }
        FailureHandler validFailureHandler = this.determineFailureHandler(failureHandler);
        String[] expectedNames = this.getSortedTableNames(expectedDataSet);
        String[] actualNames = this.getSortedTableNames(actualDataSet);
        this.compareTableCounts(expectedNames, actualNames, validFailureHandler);
        this.compareTableNames(expectedNames, actualNames, validFailureHandler);
        this.compareTables(expectedDataSet, actualDataSet, expectedNames, validFailureHandler, defaultValueComparer, tableColumnValueComparers);
    }

    protected void compareTables(IDataSet expectedDataSet, IDataSet actualDataSet, String[] expectedNames, FailureHandler failureHandler, ValueComparer defaultValueComparer, Map<String, Map<String, ValueComparer>> tableColumnValueComparers) throws DatabaseUnitException {
        Map<String, Map<String, ValueComparer>> validTableColumnValueComparers = this.determineValidTableColumnValueComparers(tableColumnValueComparers);
        int i = 0;
        while (i < expectedNames.length) {
            String tableName = expectedNames[i];
            ITable expectedTable = expectedDataSet.getTable(tableName);
            ITable actualTable = actualDataSet.getTable(tableName);
            Map<String, ValueComparer> columnValueComparers = validTableColumnValueComparers.get(tableName);
            this.assertWithValueComparer(expectedTable, actualTable, failureHandler, defaultValueComparer, columnValueComparers);
            ++i;
        }
    }

    public void assertWithValueComparer(ITable expectedTable, ITable actualTable, FailureHandler failureHandler, ValueComparer defaultValueComparer, Map<String, ValueComparer> columnValueComparers) throws DatabaseUnitException {
        this.log.trace("assertWithValueComparer(expectedTable, actualTable, failureHandler, defaultValueComparer, columnValueComparers) - start");
        this.log.debug("assertWithValueComparer: expectedTable={}", (Object)expectedTable);
        this.log.debug("assertWithValueComparer: actualTable={}", (Object)actualTable);
        this.log.debug("assertWithValueComparer: failureHandler={}", (Object)failureHandler);
        this.log.debug("assertWithValueComparer: defaultValueComparer={}", (Object)defaultValueComparer);
        this.log.debug("assertWithValueComparer: columnValueComparers={}", columnValueComparers);
        if (expectedTable == actualTable) {
            this.log.debug("The given tables reference the same object. Skipping comparisons.");
            return;
        }
        FailureHandler validFailureHandler = this.determineFailureHandler(failureHandler);
        ITableMetaData expectedMetaData = expectedTable.getTableMetaData();
        ITableMetaData actualMetaData = actualTable.getTableMetaData();
        String expectedTableName = expectedMetaData.getTableName();
        boolean isTablesEmpty = this.compareRowCounts(expectedTable, actualTable, validFailureHandler, expectedTableName);
        if (isTablesEmpty) {
            return;
        }
        Column[] expectedColumns = Columns.getSortedColumns(expectedMetaData);
        Column[] actualColumns = Columns.getSortedColumns(actualMetaData);
        this.compareColumns(expectedColumns, actualColumns, expectedMetaData, actualMetaData, validFailureHandler);
        DbUnitAssert.ComparisonColumn[] comparisonCols = this.getComparisonColumns(expectedTableName, expectedColumns, actualColumns, validFailureHandler);
        this.compareData(expectedTable, actualTable, comparisonCols, validFailureHandler, defaultValueComparer, columnValueComparers);
    }

    protected void compareData(ITable expectedTable, ITable actualTable, DbUnitAssert.ComparisonColumn[] comparisonCols, FailureHandler failureHandler) throws DataSetException {
        ValueComparer defaultValueComparer = null;
        Map<String, ValueComparer> columnValueComparers = null;
        try {
            this.compareData(expectedTable, actualTable, comparisonCols, failureHandler, defaultValueComparer, columnValueComparers);
        }
        catch (DatabaseUnitException e) {
            throw new DataSetException(e);
        }
    }

    protected void compareData(ITable expectedTable, ITable actualTable, DbUnitAssert.ComparisonColumn[] comparisonCols, FailureHandler failureHandler, ValueComparer defaultValueComparer, Map<String, ValueComparer> columnValueComparers) throws DatabaseUnitException {
        this.log.debug("compareData(expectedTable={}, actualTable={}, comparisonCols={}, failureHandler={}, defaultValueComparer={}, columnValueComparers={}) - start", new Object[]{expectedTable, actualTable, comparisonCols, failureHandler, defaultValueComparer, columnValueComparers});
        if (expectedTable == null) {
            throw new IllegalArgumentException("The parameter 'expectedTable' is null");
        }
        if (actualTable == null) {
            throw new IllegalArgumentException("The parameter 'actualTable' is null");
        }
        if (comparisonCols == null) {
            throw new IllegalArgumentException("The parameter 'comparisonCols' is null");
        }
        if (failureHandler == null) {
            throw new IllegalArgumentException("The parameter 'failureHandler' is null");
        }
        ValueComparer validDefaultValueComparer = this.determineValidDefaultValueComparer(defaultValueComparer);
        String expectedTableName = expectedTable.getTableMetaData().getTableName();
        Map<String, ValueComparer> validColumnValueComparers = this.determineValidColumnValueComparers(columnValueComparers, expectedTableName);
        int rowNum = 0;
        while (rowNum < expectedTable.getRowCount()) {
            int columnCount = comparisonCols.length;
            int columnNum = 0;
            while (columnNum < columnCount) {
                this.compareData(expectedTable, actualTable, comparisonCols, failureHandler, validDefaultValueComparer, validColumnValueComparers, rowNum, columnNum);
                ++columnNum;
            }
            ++rowNum;
        }
    }

    protected void compareData(ITable expectedTable, ITable actualTable, DbUnitAssert.ComparisonColumn[] comparisonCols, FailureHandler failureHandler, ValueComparer defaultValueComparer, Map<String, ValueComparer> columnValueComparers, int rowNum, int columnNum) throws DatabaseUnitException {
        Object actualValue;
        DbUnitAssert.ComparisonColumn compareColumn = comparisonCols[columnNum];
        String columnName = compareColumn.getColumnName();
        DataType dataType = compareColumn.getDataType();
        Object expectedValue = expectedTable.getValue(rowNum, columnName);
        if (this.skipCompare(columnName, expectedValue, actualValue = actualTable.getValue(rowNum, columnName))) {
            this.log.trace("skipCompare: ignoring comparison {}={} on column={}", new Object[]{expectedValue, actualValue, columnName});
        } else {
            ValueComparer valueComparer = this.determineValueComparer(columnName, defaultValueComparer, columnValueComparers);
            this.log.debug("compareData: comparing actualValue={} to expectedValue={} with valueComparer={}", new Object[]{actualValue, expectedValue, valueComparer});
            String failMessage = valueComparer.compare(expectedTable, actualTable, rowNum, columnName, dataType, expectedValue, actualValue);
            this.failIfNecessary(expectedTable, actualTable, failureHandler, rowNum, columnName, expectedValue, actualValue, failMessage);
        }
    }

    protected void failIfNecessary(ITable expectedTable, ITable actualTable, FailureHandler failureHandler, int rowNum, String columnName, Object expectedValue, Object actualValue, String failMessage) {
        if (failMessage != null) {
            Difference diff = new Difference(expectedTable, actualTable, rowNum, columnName, expectedValue, actualValue, failMessage);
            failureHandler.handle(diff);
        }
    }

    protected ValueComparer determineValueComparer(String columnName, ValueComparer defaultValueComparer, Map<String, ValueComparer> columnValueComparers) {
        ValueComparer valueComparer = columnValueComparers.get(columnName);
        if (valueComparer == null) {
            this.log.debug("determineValueComparer: using defaultValueComparer='{}' as columnName='{}' not found in columnValueComparers='{}'", new Object[]{defaultValueComparer, columnName, columnValueComparers});
            valueComparer = defaultValueComparer;
        }
        return valueComparer;
    }

    protected ValueComparer determineValidDefaultValueComparer(ValueComparer defaultValueComparer) {
        ValueComparer validValueComparer;
        if (defaultValueComparer == null) {
            validValueComparer = this.valueComparerDefaults.getDefaultValueComparer();
            this.log.debug("determineValidDefaultValueComparer: using getDefaultValueComparer()={} as defaultValueComparer={}", (Object)validValueComparer, (Object)defaultValueComparer);
        } else {
            validValueComparer = defaultValueComparer;
        }
        return validValueComparer;
    }

    protected Map<String, Map<String, ValueComparer>> determineValidTableColumnValueComparers(Map<String, Map<String, ValueComparer>> tableColumnValueComparers) {
        Map<String, Map<String, ValueComparer>> validMap;
        if (tableColumnValueComparers == null) {
            validMap = this.valueComparerDefaults.getDefaultTableColumnValueComparerMap();
            this.log.debug("determineValidTableColumnValueComparers: using getDefaultTableColumnValueComparerMap()={} as tableColumnValueComparers={}", validMap, tableColumnValueComparers);
        } else {
            validMap = tableColumnValueComparers;
        }
        return validMap;
    }

    protected Map<String, ValueComparer> determineValidColumnValueComparers(Map<String, ValueComparer> columnValueComparers, String tableName) {
        Map<String, ValueComparer> validMap;
        if (columnValueComparers == null) {
            validMap = this.valueComparerDefaults.getDefaultColumnValueComparerMapForTable(tableName);
            this.log.debug("determineValidColumnValueComparers: using getDefaultValueComparerMap()={} as columnValueComparers={} for tableName={}", new Object[]{validMap, columnValueComparers, tableName});
        } else {
            validMap = columnValueComparers;
        }
        return validMap;
    }

    public void setValueComparerDefaults(ValueComparerDefaults valueComparerDefaults) {
        this.valueComparerDefaults = valueComparerDefaults;
    }
}

