/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.dataset;

import org.dbunit.database.QueryTableIterator;
import org.dbunit.dataset.AbstractDataSet;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.ForwardOnlyTable;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.ITableIterator;
import org.dbunit.dataset.ITableMetaData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ForwardOnlyDataSet
extends AbstractDataSet {
    private static final Logger logger = LoggerFactory.getLogger(ForwardOnlyDataSet.class);
    private final IDataSet _dataSet;
    private int _iteratorCount;

    public ForwardOnlyDataSet(IDataSet dataSet) {
        this._dataSet = dataSet;
    }

    @Override
    protected ITableIterator createIterator(boolean reversed) throws DataSetException {
        logger.debug("createIterator(reversed={}) - start", (Object)String.valueOf(reversed));
        if (reversed) {
            throw new UnsupportedOperationException("Reverse iterator not supported!");
        }
        if (this._iteratorCount > 0) {
            throw new UnsupportedOperationException("Only one iterator allowed!");
        }
        return new ForwardOnlyIterator(this._dataSet.iterator());
    }

    @Override
    public String[] getTableNames() throws DataSetException {
        throw new UnsupportedOperationException();
    }

    @Override
    public ITableMetaData getTableMetaData(String tableName) throws DataSetException {
        throw new UnsupportedOperationException();
    }

    @Override
    public ITable getTable(String tableName) throws DataSetException {
        throw new UnsupportedOperationException();
    }

    private class ForwardOnlyIterator
    implements ITableIterator {
        private final ITableIterator _iterator;

        public ForwardOnlyIterator(ITableIterator iterator) {
            this._iterator = iterator;
            ForwardOnlyDataSet forwardOnlyDataSet2 = ForwardOnlyDataSet.this;
            forwardOnlyDataSet2._iteratorCount = forwardOnlyDataSet2._iteratorCount + 1;
        }

        @Override
        public boolean next() throws DataSetException {
            if (this._iterator instanceof QueryTableIterator) {
                return ((QueryTableIterator)this._iterator).nextWithoutClosing();
            }
            return this._iterator.next();
        }

        @Override
        public ITableMetaData getTableMetaData() throws DataSetException {
            return this._iterator.getTableMetaData();
        }

        @Override
        public ITable getTable() throws DataSetException {
            return new ForwardOnlyTable(this._iterator.getTable());
        }
    }
}

