/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.dataset.filter;

import java.util.ArrayList;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.ITableIterator;
import org.dbunit.dataset.ITableMetaData;
import org.dbunit.dataset.filter.ITableFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTableFilter
implements ITableFilter {
    private static final Logger logger = LoggerFactory.getLogger(AbstractTableFilter.class);

    public abstract boolean isValidName(String var1) throws DataSetException;

    @Override
    public boolean accept(String tableName) throws DataSetException {
        logger.debug("accept(tableName={}) - start", (Object)tableName);
        return this.isValidName(tableName);
    }

    @Override
    public String[] getTableNames(IDataSet dataSet) throws DataSetException {
        logger.debug("getTableNames(dataSet={}) - start", (Object)dataSet);
        String[] tableNames = dataSet.getTableNames();
        ArrayList<String> nameList = new ArrayList<String>();
        int i = 0;
        while (i < tableNames.length) {
            String tableName = tableNames[i];
            if (this.accept(tableName)) {
                nameList.add(tableName);
            }
            ++i;
        }
        return nameList.toArray(new String[0]);
    }

    @Override
    public ITableIterator iterator(IDataSet dataSet, boolean reversed) throws DataSetException {
        logger.debug("iterator(dataSet={}, reversed={}) - start", (Object)dataSet, (Object)String.valueOf(reversed));
        return new FilterIterator(reversed ? dataSet.reverseIterator() : dataSet.iterator());
    }

    private class FilterIterator
    implements ITableIterator {
        private final Logger logger = LoggerFactory.getLogger(FilterIterator.class);
        private final ITableIterator _iterator;

        public FilterIterator(ITableIterator iterator) {
            this._iterator = iterator;
        }

        @Override
        public boolean next() throws DataSetException {
            this.logger.debug("next() - start");
            while (this._iterator.next()) {
                if (!AbstractTableFilter.this.accept(this._iterator.getTableMetaData().getTableName())) continue;
                return true;
            }
            return false;
        }

        @Override
        public ITableMetaData getTableMetaData() throws DataSetException {
            this.logger.debug("getTableMetaData() - start");
            return this._iterator.getTableMetaData();
        }

        @Override
        public ITable getTable() throws DataSetException {
            this.logger.debug("getTable() - start");
            return this._iterator.getTable();
        }
    }
}

