/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.configuration.internal.metadata;

import org.hibernate.MappingException;
import org.hibernate.mapping.JoinedSubclass;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.SingleTableSubclass;
import org.hibernate.mapping.Subclass;
import org.hibernate.mapping.UnionSubclass;

public enum InheritanceType {
    NONE,
    JOINED,
    SINGLE,
    TABLE_PER_CLASS;


    public static InheritanceType get(PersistentClass pc) {
        PersistentClass superclass = pc.getSuperclass();
        if (superclass == null) {
            return NONE;
        }
        Subclass subclass = (Subclass)superclass.getSubclassIterator().next();
        if (subclass instanceof SingleTableSubclass) {
            return SINGLE;
        }
        if (subclass instanceof JoinedSubclass) {
            return JOINED;
        }
        if (subclass instanceof UnionSubclass) {
            return TABLE_PER_CLASS;
        }
        throw new MappingException("Unknown subclass class: " + subclass.getClass());
    }
}

