/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit;

import java.util.Arrays;
import java.util.Map;
import org.dbunit.assertion.comparer.value.ValueComparer;
import org.dbunit.assertion.comparer.value.verifier.DefaultVerifyTableDefinitionVerifier;
import org.dbunit.assertion.comparer.value.verifier.VerifyTableDefinitionVerifier;

public class VerifyTableDefinition {
    private final String tableName;
    private final String[] columnExclusionFilters;
    private final String[] columnInclusionFilters;
    private final ValueComparer defaultValueComparer;
    private final Map<String, ValueComparer> columnValueComparers;
    private VerifyTableDefinitionVerifier verifyTableDefinitionVerifier = new DefaultVerifyTableDefinitionVerifier();

    public VerifyTableDefinition(String table, String[] excludeColumns) {
        this(table, excludeColumns, null, null, null);
    }

    public VerifyTableDefinition(String table, ValueComparer defaultValueComparer, Map<String, ValueComparer> columnValueComparers) {
        this(table, null, null, defaultValueComparer, columnValueComparers);
    }

    public VerifyTableDefinition(String table, String[] excludeColumns, ValueComparer defaultValueComparer, Map<String, ValueComparer> columnValueComparers) {
        this(table, excludeColumns, null, defaultValueComparer, columnValueComparers);
    }

    public VerifyTableDefinition(String table, String[] excludeColumns, String[] includeColumns) {
        this(table, excludeColumns, includeColumns, null, null);
    }

    public VerifyTableDefinition(String table, String[] excludeColumns, String[] includeColumns, ValueComparer defaultValueComparer, Map<String, ValueComparer> columnValueComparers) {
        if (table == null) {
            throw new IllegalArgumentException("table is null.");
        }
        this.tableName = table;
        this.columnExclusionFilters = excludeColumns;
        this.columnInclusionFilters = includeColumns;
        this.defaultValueComparer = defaultValueComparer;
        this.columnValueComparers = columnValueComparers;
        this.verifyTableDefinitionVerifier.verify(this);
    }

    public String getTableName() {
        return this.tableName;
    }

    public String[] getColumnExclusionFilters() {
        return this.columnExclusionFilters;
    }

    public String[] getColumnInclusionFilters() {
        return this.columnInclusionFilters;
    }

    public ValueComparer getDefaultValueComparer() {
        return this.defaultValueComparer;
    }

    public Map<String, ValueComparer> getColumnValueComparers() {
        return this.columnValueComparers;
    }

    public String toString() {
        String exclusionString = this.arrayToString(this.columnExclusionFilters);
        String inclusionString = this.arrayToString(this.columnInclusionFilters);
        StringBuilder sb = new StringBuilder(1000);
        sb.append("tableName='").append(this.tableName).append("'");
        sb.append(", columnExclusionFilters='").append(exclusionString).append("'");
        sb.append(", columnInclusionFilters='").append(inclusionString).append("'");
        sb.append(", defaultValueComparer='").append(this.defaultValueComparer).append("'");
        sb.append(", columnValueComparers='").append(this.columnValueComparers).append("'");
        return sb.toString();
    }

    protected String arrayToString(String[] array) {
        return array == null ? "" : Arrays.toString(array);
    }

    public VerifyTableDefinitionVerifier getVerifyTableDefinitionVerifier() {
        return this.verifyTableDefinitionVerifier;
    }

    public void setVerifyTableDefinitionVerifier(VerifyTableDefinitionVerifier verifyTableDefinitionVerifier) {
        this.verifyTableDefinitionVerifier = verifyTableDefinitionVerifier;
    }
}

