/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.services.compiler.LocalField;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.loader.ClassFactory;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.impl.sql.compile.BaseTypeCompiler;
import org.apache.derby.shared.common.error.StandardException;

public final class NumericTypeCompiler
extends BaseTypeCompiler {
    @Override
    public String interfaceName() {
        return "org.apache.derby.iapi.types.NumberDataValue";
    }

    @Override
    public String getCorrespondingPrimitiveTypeName() {
        int n = this.getStoredFormatIdFromTypeId();
        switch (n) {
            case 6: {
                return "double";
            }
            case 7: {
                return "int";
            }
            case 11: {
                return "long";
            }
            case 8: {
                return "float";
            }
            case 10: {
                return "short";
            }
            case 195: {
                return "byte";
            }
        }
        return null;
    }

    @Override
    public String getPrimitiveMethodName() {
        int n = this.getStoredFormatIdFromTypeId();
        switch (n) {
            case 6: {
                return "getDouble";
            }
            case 7: {
                return "getInt";
            }
            case 11: {
                return "getLong";
            }
            case 8: {
                return "getFloat";
            }
            case 10: {
                return "getShort";
            }
            case 195: {
                return "getByte";
            }
        }
        return null;
    }

    @Override
    public int getCastToCharWidth(DataTypeDescriptor dataTypeDescriptor) {
        int n = this.getStoredFormatIdFromTypeId();
        switch (n) {
            case 197: {
                return dataTypeDescriptor.getPrecision() + 2;
            }
            case 6: {
                return 54;
            }
            case 7: {
                return 11;
            }
            case 11: {
                return 20;
            }
            case 8: {
                return 25;
            }
            case 10: {
                return 6;
            }
            case 195: {
                return 4;
            }
        }
        return 0;
    }

    @Override
    public DataTypeDescriptor resolveArithmeticOperation(DataTypeDescriptor dataTypeDescriptor, DataTypeDescriptor dataTypeDescriptor2, String string) throws StandardException {
        int n;
        int n2;
        NumericTypeCompiler numericTypeCompiler;
        DataTypeDescriptor dataTypeDescriptor3;
        TypeId typeId = dataTypeDescriptor.getTypeId();
        TypeId typeId2 = dataTypeDescriptor2.getTypeId();
        boolean bl = true;
        if (!typeId2.isNumericTypeId()) {
            bl = false;
        }
        if ("mod".equals(string)) {
            switch (typeId.getJDBCTypeId()) {
                case -6: 
                case -5: 
                case 4: 
                case 5: {
                    break;
                }
                default: {
                    bl = false;
                }
            }
            switch (typeId2.getJDBCTypeId()) {
                case -6: 
                case -5: 
                case 4: 
                case 5: {
                    break;
                }
                default: {
                    bl = false;
                }
            }
        }
        if (!bl) {
            throw StandardException.newException("42Y95", string, dataTypeDescriptor.getTypeId().getSQLTypeName(), dataTypeDescriptor2.getTypeId().getSQLTypeName());
        }
        if (typeId2.typePrecedence() > typeId.typePrecedence()) {
            dataTypeDescriptor3 = dataTypeDescriptor2;
            numericTypeCompiler = (NumericTypeCompiler)this.getTypeCompiler(typeId2);
        } else {
            dataTypeDescriptor3 = dataTypeDescriptor;
            numericTypeCompiler = (NumericTypeCompiler)this.getTypeCompiler(typeId);
        }
        int n3 = numericTypeCompiler.getPrecision(string, dataTypeDescriptor, dataTypeDescriptor2);
        if (dataTypeDescriptor3.getTypeId().isDecimalTypeId()) {
            n2 = numericTypeCompiler.getScale(string, dataTypeDescriptor, dataTypeDescriptor2);
            int n4 = n = n2 > 0 ? n3 + 3 : n3 + 1;
            if (n < n3) {
                n = Integer.MAX_VALUE;
            }
        } else {
            n2 = 0;
            n = dataTypeDescriptor3.getMaximumWidth();
        }
        boolean bl2 = dataTypeDescriptor.isNullable() || dataTypeDescriptor2.isNullable();
        return new DataTypeDescriptor(dataTypeDescriptor3.getTypeId(), n3, n2, bl2, n);
    }

    @Override
    public boolean convertible(TypeId typeId, boolean bl) {
        return this.numberConvertible(typeId, bl);
    }

    @Override
    public boolean compatible(TypeId typeId) {
        return typeId.isNumericTypeId();
    }

    @Override
    public boolean storable(TypeId typeId, ClassFactory classFactory) {
        return this.numberStorable(this.getTypeId(), typeId, classFactory);
    }

    @Override
    String dataValueMethodName() {
        if (this.getStoredFormatIdFromTypeId() == 197) {
            return "getDecimalDataValue";
        }
        return super.dataValueMethodName();
    }

    @Override
    String nullMethodName() {
        int n = this.getStoredFormatIdFromTypeId();
        switch (n) {
            case 197: {
                return "getNullDecimal";
            }
            case 6: {
                return "getNullDouble";
            }
            case 7: {
                return "getNullInteger";
            }
            case 11: {
                return "getNullLong";
            }
            case 8: {
                return "getNullFloat";
            }
            case 10: {
                return "getNullShort";
            }
            case 195: {
                return "getNullByte";
            }
        }
        return null;
    }

    private int getPrecision(String string, DataTypeDescriptor dataTypeDescriptor, DataTypeDescriptor dataTypeDescriptor2) {
        long l;
        if (this.getStoredFormatIdFromTypeId() != 197) {
            return dataTypeDescriptor.getPrecision();
        }
        long l2 = dataTypeDescriptor.getScale();
        long l3 = dataTypeDescriptor2.getScale();
        long l4 = dataTypeDescriptor.getPrecision();
        long l5 = dataTypeDescriptor2.getPrecision();
        if (string == null) {
            l = (long)this.getScale(string, dataTypeDescriptor, dataTypeDescriptor2) + Math.max(l4 - l2, l5 - l3);
        } else if (string.equals("*")) {
            l = l4 + l5;
        } else if (string.equals("sum")) {
            l = l4 - l2 + l5 - l3 + (long)this.getScale(string, dataTypeDescriptor, dataTypeDescriptor2);
        } else if (string.equals("/")) {
            l = Math.min(31L, (long)this.getScale(string, dataTypeDescriptor, dataTypeDescriptor2) + l4 - l2 + l5);
        } else {
            l = (long)this.getScale(string, dataTypeDescriptor, dataTypeDescriptor2) + Math.max(l4 - l2, l5 - l3) + 1L;
            if (l > 31L) {
                l = 31L;
            }
        }
        if (l > Integer.MAX_VALUE) {
            l = Integer.MAX_VALUE;
        }
        l = Math.min(31L, l);
        return (int)l;
    }

    private int getScale(String string, DataTypeDescriptor dataTypeDescriptor, DataTypeDescriptor dataTypeDescriptor2) {
        long l = dataTypeDescriptor.getScale();
        long l2 = dataTypeDescriptor2.getScale();
        long l3 = dataTypeDescriptor.getPrecision();
        long l4 = "*".equals(string) ? l + l2 : ("/".equals(string) ? Math.max(31L - l3 + l - l2, 0L) : ("avg".equals(string) ? Math.max(Math.max(l, l2), 4L) : Math.max(l, l2)));
        if (l4 > Integer.MAX_VALUE) {
            l4 = Integer.MAX_VALUE;
        }
        l4 = Math.min(31L, l4);
        return (int)l4;
    }

    @Override
    public void generateDataValue(MethodBuilder methodBuilder, int n, LocalField localField) {
        if (this.getTypeId().isDecimalTypeId()) {
            methodBuilder.upCast("java.lang.Number");
        }
        super.generateDataValue(methodBuilder, n, localField);
    }
}

