/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlplatform.cluster.membership.storage;

import akka.actor.Address;
import akka.actor.Address$;
import akka.cluster.Cluster;
import com.xebialabs.xlplatform.cluster.DataSourceConfig;
import com.xebialabs.xlplatform.cluster.membership.storage.ClusterMembershipManagement;
import com.xebialabs.xlplatform.cluster.membership.storage.ClusterMembershipManagement$Success$;
import com.xebialabs.xlplatform.cluster.membership.storage.ClusterMembershipSQLManagement$;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.slf4j.Marker;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0005f!B\u000b\u0017\u0003\u0003\u0019\u0003\u0002\u0003\u001c\u0001\u0005\u0003\u0005\u000b\u0011B\u001c\t\u0011m\u0002!\u0011!Q\u0001\nqB\u0001\u0002\u0012\u0001\u0003\u0002\u0003\u0006I!\u0012\u0005\u0006\u0011\u0002!\t!\u0013\u0005\u0006\u001d\u00021\ta\u0014\u0005\b7\u0002\u0011\r\u0011\"\u0001]\u0011\u0019)\u0007\u0001)A\u0005;\"1a\r\u0001Q\u0005\n\u001dDQ\u0001\u001b\u0001\u0005B%Da!a\t\u0001\r\u0003y\u0005bBA\u0013\u0001\u0011\u0005\u0013q\u0005\u0005\u0007\u0003_\u0001a\u0011A(\t\u000f\u0005E\u0002\u0001\"\u0011\u00024!1\u0011Q\t\u0001\u0005\u0002=Cq!a\u0012\u0001\t\u0003\nI\u0005C\u0004\u0002T\u0001!\t!!\u0016\b\u0013\u0005\u0005e#!A\t\u0002\u0005\re\u0001C\u000b\u0017\u0003\u0003E\t!!\"\t\r!\u0013B\u0011AAD\u0011%\tIIEI\u0001\n\u0003\tYI\u0001\u0010DYV\u001cH/\u001a:NK6\u0014WM]:iSB\u001c\u0016\u000bT'b]\u0006<W-\\3oi*\u0011q\u0003G\u0001\bgR|'/Y4f\u0015\tI\"$\u0001\u0006nK6\u0014WM]:iSBT!a\u0007\u000f\u0002\u000f\rdWo\u001d;fe*\u0011QDH\u0001\u000bq2\u0004H.\u0019;g_Jl'BA\u0010!\u0003%AXMY5bY\u0006\u00147OC\u0001\"\u0003\r\u0019w.\\\u0002\u0001'\u0011\u0001AE\u000b\u0018\u0011\u0005\u0015BS\"\u0001\u0014\u000b\u0003\u001d\nQa]2bY\u0006L!!\u000b\u0014\u0003\r\u0005s\u0017PU3g!\tYC&D\u0001\u0017\u0013\ticCA\u000eDYV\u001cH/\u001a:NK6\u0014WM]:iSBl\u0015M\\1hK6,g\u000e\u001e\t\u0003_Qj\u0011\u0001\r\u0006\u0003cI\nQa\u001d7gi)T\u0011aM\u0001\tOJL'P\u001f7fI&\u0011Q\u0007\r\u0002\b\u0019><w-\u001b8h\u0003!!7oQ8oM&<\u0007C\u0001\u001d:\u001b\u0005Q\u0012B\u0001\u001e\u001b\u0005A!\u0015\r^1T_V\u00148-Z\"p]\u001aLw-A\u0002ui2\u0004\"!\u0010\"\u000e\u0003yR!a\u0010!\u0002\u0011\u0011,(/\u0019;j_:T!!\u0011\u0014\u0002\u0015\r|gnY;se\u0016tG/\u0003\u0002D}\tqa)\u001b8ji\u0016$UO]1uS>t\u0017\u0001\u00034bS24\u0015m\u001d;\u0011\u0005\u00152\u0015BA$'\u0005\u001d\u0011un\u001c7fC:\fa\u0001P5oSRtD\u0003\u0002&L\u00196\u0003\"a\u000b\u0001\t\u000bY\"\u0001\u0019A\u001c\t\u000bm\"\u0001\u0019\u0001\u001f\t\u000f\u0011#\u0001\u0013!a\u0001\u000b\u0006QAM]5wKJt\u0015-\\3\u0016\u0003A\u0003\"!\u0015-\u000f\u0005I3\u0006CA*'\u001b\u0005!&BA+#\u0003\u0019a$o\\8u}%\u0011qKJ\u0001\u0007!J,G-\u001a4\n\u0005eS&AB*ue&twM\u0003\u0002XM\u0005QA-\u0019;bg>,(oY3\u0016\u0003u\u0003\"AX2\u000e\u0003}S!\u0001Y1\u0002\u0007M\fHNC\u0001c\u0003\u0015Q\u0017M^1y\u0013\t!wL\u0001\u0006ECR\f7k\\;sG\u0016\f1\u0002Z1uCN|WO]2fA\u0005!\u0012N\\5uS\u0006d\u0017N_3ECR\f7k\\;sG\u0016$\u0012!X\u0001\re\u0016<\u0017n\u001d;feN+GN\u001a\u000b\u0004U\u0006=AcA6\u0002\u0006A\u0019A.\\8\u000e\u0003\u0001K!A\u001c!\u0003\r\u0019+H/\u001e:f!\t\u0001xP\u0004\u0002r{:\u0011!\u000f \b\u0003gnt!\u0001\u001e>\u000f\u0005ULhB\u0001<y\u001d\t\u0019v/C\u0001\"\u0013\ty\u0002%\u0003\u0002\u001e=%\u00111\u0004H\u0005\u00033iI!a\u0006\r\n\u0005y4\u0012aG\"mkN$XM]'f[\n,'o\u001d5ja6\u000bg.Y4f[\u0016tG/\u0003\u0003\u0002\u0002\u0005\r!A\u0002*fgVdGO\u0003\u0002\u007f-!9\u0011qA\u0005A\u0004\u0005%\u0011\u0001E3yK\u000e,H/[8o\u0007>tG/\u001a=u!\ra\u00171B\u0005\u0004\u0003\u001b\u0001%\u0001E#yK\u000e,H/[8o\u0007>tG/\u001a=u\u0011\u001d\t\t\"\u0003a\u0001\u0003'\tAa]3mMB!\u0011QCA\u0010\u001b\t\t9B\u0003\u0003\u0002\u001a\u0005m\u0011!B1di>\u0014(BAA\u000f\u0003\u0011\t7n[1\n\t\u0005\u0005\u0012q\u0003\u0002\b\u0003\u0012$'/Z:t\u0003=\u0011XmZ5ti\u0016\u00148+\u001a7g'Fd\u0017!\u00035fCJ$(-Z1u)\u0011\tI#!\f\u0015\u0007-\fY\u0003C\u0004\u0002\b-\u0001\u001d!!\u0003\t\u000f\u0005E1\u00021\u0001\u0002\u0014\u0005a\u0001.Z1si\n,\u0017\r^*rY\u0006yA.[:u\u0003\u000e$\u0018N^3TK\u0016$7\u000f\u0006\u0003\u00026\u0005eBcA6\u00028!9\u0011qA\u0007A\u0004\u0005%\u0001BB\u000e\u000e\u0001\u0004\tY\u0004\u0005\u0003\u0002>\u0005\u0005SBAA \u0015\rY\u00121D\u0005\u0005\u0003\u0007\nyDA\u0004DYV\u001cH/\u001a:\u0002%1L7\u000f^!di&4XmU3fIN\u001c\u0016\u000f\\\u0001\u000fI\u0016\u0014XmZ5ti\u0016\u00148+Z3e)\u0011\tY%a\u0014\u0015\u0007-\fi\u0005C\u0004\u0002\b=\u0001\u001d!!\u0003\t\u000f\u0005Es\u00021\u0001\u0002\u0014\u0005!1/Z3e\u000399\u0018\u000e\u001e5D_:tWm\u0019;j_:,B!a\u0016\u0002^Q!\u0011\u0011LA5!\u0011\tY&!\u0018\r\u0001\u00119\u0011q\f\tC\u0002\u0005\u0005$!A!\u0012\u0007=\f\u0019\u0007E\u0002&\u0003KJ1!a\u001a'\u0005\r\te.\u001f\u0005\b\u0003W\u0002\u0002\u0019AA7\u0003\u0005\u0011\u0007cB\u0013\u0002p\u0005M\u0014\u0011L\u0005\u0004\u0003c2#!\u0003$v]\u000e$\u0018n\u001c82!\u0011\t)(! \u000e\u0005\u0005]$b\u00011\u0002z)\u0011\u00111P\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002\u0000\u0005]$AC\"p]:,7\r^5p]\u0006q2\t\\;ti\u0016\u0014X*Z7cKJ\u001c\b.\u001b9T#2k\u0015M\\1hK6,g\u000e\u001e\t\u0003WI\u0019\"A\u0005\u0013\u0015\u0005\u0005\r\u0015a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$3'\u0006\u0002\u0002\u000e*\u001aQ)a$,\u0005\u0005E\u0005\u0003BAJ\u0003;k!!!&\u000b\t\u0005]\u0015\u0011T\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a''\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003?\u000b)JA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\u0004")
public abstract class ClusterMembershipSQLManagement
implements ClusterMembershipManagement,
Logging {
    private final DataSourceConfig dsConfig;
    private final FiniteDuration ttl;
    private final boolean failFast;
    private final DataSource datasource;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public static boolean $lessinit$greater$default$3() {
        return ClusterMembershipSQLManagement$.MODULE$.$lessinit$greater$default$3();
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    @Override
    public Future<ClusterMembershipManagement.Result> registerSeed(Address seed, ExecutionContext executionContext) {
        return ClusterMembershipManagement.registerSeed$(this, seed, executionContext);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        ClusterMembershipSQLManagement clusterMembershipSQLManagement = this;
        synchronized (clusterMembershipSQLManagement) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public abstract String driverName();

    public DataSource datasource() {
        return this.datasource;
    }

    private DataSource initializeDataSource() {
        this.logger().info((Function0 & Serializable)() -> new StringBuilder(60).append("Starting DataSource for cluster management: ").append($this.dsConfig).append(" (driverName = ").append(this.driverName()).append(")").toString());
        HikariConfig cfg = new HikariConfig();
        cfg.setInitializationFailTimeout(this.failFast ? 1L : -1L);
        cfg.setDriverClassName((String)this.dsConfig.driver().getOrElse((Function0 & Serializable)() -> this.driverName()));
        cfg.setJdbcUrl(this.dsConfig.url());
        cfg.setUsername(this.dsConfig.username());
        cfg.setPassword(this.dsConfig.password());
        cfg.setPoolName(this.dsConfig.poolName());
        cfg.setMaximumPoolSize(this.dsConfig.maxPoolSize());
        cfg.setConnectionTimeout(this.dsConfig.connectionTimeout());
        cfg.setMinimumIdle(this.dsConfig.minimumIdle());
        cfg.setIdleTimeout(this.dsConfig.idleTimeout());
        cfg.setLeakDetectionThreshold(this.dsConfig.leakConnectionThreshold());
        return new HikariDataSource(cfg);
    }

    @Override
    public Future<ClusterMembershipManagement.Result> registerSelf(Address self, ExecutionContext executionContext) {
        return Future$.MODULE$.apply((Function0 & Serializable)() -> (ClusterMembershipManagement.Result)this.withConnection((Function1 & Serializable)con -> {
            PreparedStatement ps = con.prepareStatement(this.registerSelfSql());
            ps.setString(1, self.protocol());
            ps.setString(2, self.system());
            ps.setString(3, (String)self.host().get());
            ps.setInt(4, BoxesRunTime.unboxToInt((Object)self.port().get()));
            ps.setLong(5, $this.ttl.toSeconds());
            ps.executeUpdate();
            con.commit();
            return ClusterMembershipManagement$Success$.MODULE$;
        }), executionContext);
    }

    public abstract String registerSelfSql();

    @Override
    public Future<ClusterMembershipManagement.Result> heartbeat(Address self, ExecutionContext executionContext) {
        return Future$.MODULE$.apply((Function0 & Serializable)() -> (ClusterMembershipManagement.Result)this.withConnection((Function1 & Serializable)con -> {
            PreparedStatement ps = con.prepareStatement(this.heartbeatSql());
            ps.setLong(1, $this.ttl.toSeconds());
            ps.setString(2, (String)self.host().get());
            ps.setInt(3, BoxesRunTime.unboxToInt((Object)self.port().get()));
            ps.executeUpdate();
            con.commit();
            return ClusterMembershipManagement$Success$.MODULE$;
        }), executionContext);
    }

    public abstract String heartbeatSql();

    @Override
    public Future<ClusterMembershipManagement.Result> listActiveSeeds(Cluster cluster, ExecutionContext executionContext) {
        return Future$.MODULE$.apply((Function0 & Serializable)() -> (ClusterMembershipManagement.Result)this.withConnection((Function1 & Serializable)con -> {
            PreparedStatement call = con.prepareStatement(this.listActiveSeedsSql());
            call.setString(1, cluster.selfAddress().protocol());
            call.setString(2, cluster.selfAddress().system());
            ResultSet set = call.executeQuery();
            Nil$ l = Nil$.MODULE$;
            while (set.next()) {
                ClusterMembershipManagement.Seed seed;
                ClusterMembershipManagement.Seed seed2 = seed = new ClusterMembershipManagement.Seed(Address$.MODULE$.apply(cluster.selfAddress().protocol(), cluster.selfAddress().system(), set.getString("host"), set.getInt("port")), set.getTimestamp("ttl").toInstant());
                l = l.$colon$colon((Object)seed2);
            }
            return new ClusterMembershipManagement.Data<Nil$>(l);
        }), executionContext);
    }

    public String listActiveSeedsSql() {
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n      |SELECT host, port, ttl\n      |FROM cluster_members\n      |WHERE protocol = ? AND system = ? AND ttl > CURRENT_TIMESTAMP ORDER BY ttl"));
    }

    @Override
    public Future<ClusterMembershipManagement.Result> deregisterSeed(Address seed, ExecutionContext executionContext) {
        return Future$.MODULE$.apply((Function0 & Serializable)() -> (ClusterMembershipManagement.Result)this.withConnection((Function1 & Serializable)con -> {
            PreparedStatement call = con.prepareStatement("DELETE FROM cluster_members WHERE host = ? AND port = ?");
            call.setString(1, (String)seed.host().get());
            call.setInt(2, BoxesRunTime.unboxToInt((Object)seed.port().get()));
            call.execute();
            con.commit();
            return ClusterMembershipManagement$Success$.MODULE$;
        }), executionContext);
    }

    public <A> A withConnection(Function1<Connection, A> b) {
        Object object;
        c.setAutoCommit(false);
        try (Connection c = this.datasource().getConnection();){
            try {
                object = b.apply((Object)c);
            }
            catch (SQLException e) {
                c.rollback();
                this.logger().error((Function0 & Serializable)() -> "Error", (Function0 & Serializable)() -> e);
                object = new ClusterMembershipManagement.Failure(e.getMessage());
            }
        }
        return (A)object;
    }

    public ClusterMembershipSQLManagement(DataSourceConfig dsConfig, FiniteDuration ttl, boolean failFast) {
        this.dsConfig = dsConfig;
        this.ttl = ttl;
        this.failFast = failFast;
        ClusterMembershipManagement.$init$(this);
        Logging.$init$((Logging)this);
        this.datasource = this.initializeDataSource();
    }
}

