/*
 * Decompiled with CFR 0.152.
 */
package org.python.icu.impl.number;

import org.python.icu.text.DecimalFormatSymbols;
import org.python.icu.util.Currency;
import org.python.icu.util.ULocale;

public class CustomSymbolCurrency
extends Currency {
    private static final long serialVersionUID = 2497493016770137670L;
    private String symbol1;
    private String symbol2;

    public static Currency resolve(Currency currency, ULocale locale2, DecimalFormatSymbols symbols2) {
        if (currency == null) {
            currency = symbols2.getCurrency();
        }
        if (currency == null) {
            return Currency.getInstance("XXX");
        }
        if (!currency.equals(symbols2.getCurrency())) {
            return currency;
        }
        String currency1Sym = symbols2.getCurrencySymbol();
        String currency2Sym = symbols2.getInternationalCurrencySymbol();
        String currency1 = currency.getName(symbols2.getULocale(), 0, null);
        String currency2 = currency.getCurrencyCode();
        if (!currency1.equals(currency1Sym) || !currency2.equals(currency2Sym)) {
            return new CustomSymbolCurrency(currency2, currency1Sym, currency2Sym);
        }
        return currency;
    }

    public CustomSymbolCurrency(String isoCode, String currency1Sym, String currency2Sym) {
        super(isoCode);
        this.symbol1 = currency1Sym;
        this.symbol2 = currency2Sym;
    }

    @Override
    public String getName(ULocale locale2, int nameStyle, boolean[] isChoiceFormat) {
        if (nameStyle == 0) {
            if (isChoiceFormat != null) {
                isChoiceFormat[0] = false;
            }
            return this.symbol1;
        }
        return super.getName(locale2, nameStyle, isChoiceFormat);
    }

    @Override
    public String getName(ULocale locale2, int nameStyle, String pluralCount, boolean[] isChoiceFormat) {
        return super.getName(locale2, nameStyle, pluralCount, isChoiceFormat);
    }

    @Override
    public String getCurrencyCode() {
        return this.symbol2;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.symbol1.hashCode() ^ this.symbol2.hashCode();
    }

    @Override
    public boolean equals(Object other) {
        return super.equals(other) && ((CustomSymbolCurrency)other).symbol1.equals(this.symbol1) && ((CustomSymbolCurrency)other).symbol2.equals(this.symbol2);
    }
}

