/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.ant;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.ProjectComponent;
import org.dbunit.DatabaseUnitException;
import org.dbunit.ant.DbUnitTaskStep;
import org.dbunit.ant.Query;
import org.dbunit.ant.QuerySet;
import org.dbunit.ant.Table;
import org.dbunit.database.DatabaseConfig;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.database.QueryDataSet;
import org.dbunit.dataset.CachedDataSet;
import org.dbunit.dataset.CompositeDataSet;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.ForwardOnlyDataSet;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.csv.CsvProducer;
import org.dbunit.dataset.excel.XlsDataSet;
import org.dbunit.dataset.stream.IDataSetProducer;
import org.dbunit.dataset.stream.StreamingDataSet;
import org.dbunit.dataset.xml.FlatDtdProducer;
import org.dbunit.dataset.xml.FlatXmlProducer;
import org.dbunit.dataset.xml.XmlProducer;
import org.dbunit.util.FileHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;

public abstract class AbstractStep
extends ProjectComponent
implements DbUnitTaskStep {
    private static final Logger logger = LoggerFactory.getLogger(AbstractStep.class);
    public static final String FORMAT_FLAT = "flat";
    public static final String FORMAT_XML = "xml";
    public static final String FORMAT_DTD = "dtd";
    public static final String FORMAT_CSV = "csv";
    public static final String FORMAT_XLS = "xls";
    private boolean ordered = false;

    protected IDataSet getDatabaseDataSet(IDatabaseConnection connection, List tables) throws DatabaseUnitException {
        if (logger.isDebugEnabled()) {
            logger.debug("getDatabaseDataSet(connection={}, tables={}) - start", new Object[]{connection, tables});
        }
        try {
            DatabaseConfig config = connection.getConfig();
            if (tables.size() == 0) {
                logger.debug("Retrieving the whole database because tables/queries have not been specified");
                return connection.createDataSet();
            }
            List queryDataSets = this.createQueryDataSet(tables, connection);
            IDataSet[] dataSetsArray = null;
            dataSetsArray = config.getProperty("http://www.dbunit.org/properties/resultSetTableFactory").getClass().getName().equals("org.dbunit.database.ForwardOnlyResultSetTableFactory") ? (IDataSet[])this.createForwardOnlyDataSetArray(queryDataSets) : queryDataSets.toArray(new IDataSet[queryDataSets.size()]);
            return new CompositeDataSet(dataSetsArray);
        }
        catch (SQLException e) {
            throw new DatabaseUnitException(e);
        }
    }

    private ForwardOnlyDataSet[] createForwardOnlyDataSetArray(List<QueryDataSet> dataSets) throws DataSetException, SQLException {
        ForwardOnlyDataSet[] forwardOnlyDataSets = new ForwardOnlyDataSet[dataSets.size()];
        for (int i = 0; i < dataSets.size(); ++i) {
            forwardOnlyDataSets[i] = new ForwardOnlyDataSet(dataSets.get(i));
        }
        return forwardOnlyDataSets;
    }

    private List createQueryDataSet(List tables, IDatabaseConnection connection) throws DataSetException, SQLException {
        logger.debug("createQueryDataSet(tables={}, connection={})", (Object)tables, (Object)connection);
        ArrayList<QueryDataSet> queryDataSets = new ArrayList<QueryDataSet>();
        QueryDataSet queryDataSet = new QueryDataSet(connection);
        for (Object item : tables) {
            if (item instanceof QuerySet) {
                if (queryDataSet.getTableNames().length > 0) {
                    queryDataSets.add(queryDataSet);
                }
                QueryDataSet newQueryDataSet = ((QuerySet)((Object)item)).getQueryDataSet(connection);
                queryDataSets.add(newQueryDataSet);
                queryDataSet = new QueryDataSet(connection);
                continue;
            }
            if (item instanceof Query) {
                Query queryItem = (Query)item;
                queryDataSet.addTable(queryItem.getName(), queryItem.getSql());
                continue;
            }
            if (item instanceof Table) {
                Table tableItem = (Table)item;
                queryDataSet.addTable(tableItem.getName());
                continue;
            }
            throw new IllegalArgumentException("Unsupported element type " + item.getClass().getName() + ".");
        }
        if (queryDataSet.getTableNames().length > 0) {
            queryDataSets.add(queryDataSet);
        }
        return queryDataSets;
    }

    protected IDataSet getSrcDataSet(File src, String format, boolean forwardonly) throws DatabaseUnitException {
        if (logger.isDebugEnabled()) {
            logger.debug("getSrcDataSet(src={}, format={}, forwardonly={}) - start", new Object[]{src, format, String.valueOf(forwardonly)});
        }
        try {
            IDataSetProducer producer = null;
            if (format.equalsIgnoreCase(FORMAT_XML)) {
                producer = new XmlProducer(AbstractStep.getInputSource(src));
            } else if (format.equalsIgnoreCase(FORMAT_CSV)) {
                producer = new CsvProducer(src);
            } else if (format.equalsIgnoreCase(FORMAT_FLAT)) {
                producer = new FlatXmlProducer(AbstractStep.getInputSource(src), true, true);
            } else if (format.equalsIgnoreCase(FORMAT_DTD)) {
                producer = new FlatDtdProducer(AbstractStep.getInputSource(src));
            } else {
                if (format.equalsIgnoreCase(FORMAT_XLS)) {
                    return new CachedDataSet(new XlsDataSet(src));
                }
                throw new IllegalArgumentException("Type must be either 'flat'(default), 'xml', 'csv', 'xls' or 'dtd' but was: " + format);
            }
            if (forwardonly) {
                return new StreamingDataSet(producer);
            }
            return new CachedDataSet(producer);
        }
        catch (IOException e) {
            throw new DatabaseUnitException(e);
        }
    }

    public boolean isDataFormat(String format) {
        logger.debug("isDataFormat(format={}) - start", (Object)format);
        return format.equalsIgnoreCase(FORMAT_FLAT) || format.equalsIgnoreCase(FORMAT_XML) || format.equalsIgnoreCase(FORMAT_CSV) || format.equalsIgnoreCase(FORMAT_XLS);
    }

    protected void checkDataFormat(String format) {
        logger.debug("checkDataFormat(format={}) - start", (Object)format);
        if (!this.isDataFormat(format)) {
            throw new IllegalArgumentException("format must be either 'flat'(default), 'xml', 'csv' or 'xls' but was: " + format);
        }
    }

    public static InputSource getInputSource(File file) throws MalformedURLException {
        InputSource source = FileHelper.createInputSource(file);
        return source;
    }

    public boolean isOrdered() {
        return this.ordered;
    }

    public void setOrdered(boolean ordered) {
        this.ordered = ordered;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("AbstractStep: ");
        result.append("ordered=").append(this.ordered);
        return result.toString();
    }
}

