/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.deploy.cache.actuator;

import ai.digital.configuration.central.deploy.CachesProperties;
import ai.digital.deploy.cache.actuator.CachesInfo;
import ai.digital.deploy.cache.actuator.Configured;
import ai.digital.deploy.cache.actuator.Evaluated;
import ai.digital.deploy.cache.config.CacheMode$;
import ai.digital.deploy.cache.config.CacheProvider;
import ai.digital.deploy.cache.service.CacheDataService;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.endpoint.annotation.DeleteOperation;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.boot.actuate.endpoint.annotation.Selector;
import org.springframework.boot.actuate.endpoint.web.WebEndpointResponse;
import org.springframework.context.annotation.DependsOn;
import org.springframework.stereotype.Component;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@Component
@DependsOn(value={"cacheMode"})
@Endpoint(id="jcaches")
@ScalaSignature(bytes="\u0006\u0005\t}b\u0001\u0002\b\u0010\u0001iA\u0001\"\u000b\u0001\u0003\u0002\u0003\u0006IA\u000b\u0005\t\u0005\u0002\u0011\t\u0011)A\u0005\u0007\"AA\n\u0001B\u0001B\u0003%Q\nC\u0003i\u0001\u0011\u0005\u0011\u000eC\u0003z\u0001\u0011\u0005!\u0010C\u0004\u0002\u0016\u0001!\t!a\u0006\t\u000f\u0005U\u0003\u0001\"\u0001\u0002X!9\u0011\u0011\u000e\u0001\u0005\u0002\u0005-\u0004bBA:\u0001\u0011%\u0011Q\u000f\u0005\b\u0003'\u0003A\u0011BAK\u0011\u001d\tI\n\u0001C\u0005\u00037Cq!!.\u0001\t\u0013\t9\fC\u0004\u0002\\\u0002!I!!8\u0003\u001f)\u001b\u0015m\u00195fg\u0016sG\r]8j]RT!\u0001E\t\u0002\u0011\u0005\u001cG/^1u_JT!AE\n\u0002\u000b\r\f7\r[3\u000b\u0005Q)\u0012A\u00023fa2|\u0017P\u0003\u0002\u0017/\u00059A-[4ji\u0006d'\"\u0001\r\u0002\u0005\u0005L7\u0001A\n\u0004\u0001m\t\u0003C\u0001\u000f \u001b\u0005i\"\"\u0001\u0010\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0001j\"AB!osJ+g\r\u0005\u0002#O5\t1E\u0003\u0002%K\u0005)1\u000f\u001c45U*\ta%\u0001\u0005he&T(\u0010\\3e\u0013\tA3EA\u0004M_\u001e<\u0017N\\4\u0002!\r\f7\r[3t!J|\u0007/\u001a:uS\u0016\u001c\bCA\u00162\u001b\u0005a#B\u0001\u000b.\u0015\tqs&A\u0004dK:$(/\u00197\u000b\u0005A*\u0012!D2p]\u001aLw-\u001e:bi&|g.\u0003\u00023Y\t\u00012)Y2iKN\u0004&o\u001c9feRLWm\u001d\u0015\u0003\u0003Q\u0002\"!\u000e!\u000e\u0003YR!a\u000e\u001d\u0002\u0015\u0005tgn\u001c;bi&|gN\u0003\u0002:u\u00059a-Y2u_JL(BA\u001e=\u0003\u0015\u0011W-\u00198t\u0015\tid(A\btaJLgn\u001a4sC6,wo\u001c:l\u0015\u0005y\u0014aA8sO&\u0011\u0011I\u000e\u0002\n\u0003V$xn^5sK\u0012\fQbY1dQ\u0016\u0004&o\u001c<jI\u0016\u0014\bC\u0001#H\u001b\u0005)%B\u0001$\u0012\u0003\u0019\u0019wN\u001c4jO&\u0011\u0001*\u0012\u0002\u000e\u0007\u0006\u001c\u0007.\u001a)s_ZLG-\u001a:)\t\t!$jS\u0001\te\u0016\fX/\u001b:fIf\t\u0001!A\tdC\u000eDW\rR1uCN+'O^5dKN\u00042AT*V\u001b\u0005y%B\u0001)R\u0003\u0011)H/\u001b7\u000b\u0003I\u000bAA[1wC&\u0011Ak\u0014\u0002\u0005\u0019&\u001cH\u000fM\u0002W=\u0016\u0004Ba\u0016.]I6\t\u0001L\u0003\u0002Z#\u000591/\u001a:wS\u000e,\u0017BA.Y\u0005A\u0019\u0015m\u00195f\t\u0006$\u0018mU3sm&\u001cW\r\u0005\u0002^=2\u0001A!C0\u0004\u0003\u0003\u0005\tQ!\u0001a\u0005\ryF%M\t\u0003Cn\u0001\"\u0001\b2\n\u0005\rl\"a\u0002(pi\"Lgn\u001a\t\u0003;\u0016$\u0011BZ\u0002\u0002\u0002\u0003\u0005)\u0011\u00011\u0003\u0007}##\u0007\u000b\u0002\u0004i\u00051A(\u001b8jiz\"BA\u001b7oaB\u00111\u000eA\u0007\u0002\u001f!)\u0011\u0006\u0002a\u0001U!\u0012A\u000e\u000e\u0005\u0006\u0005\u0012\u0001\ra\u0011\u0015\u0005]RR5\nC\u0003M\t\u0001\u0007\u0011\u000fE\u0002O'J\u00044a];x!\u00119&\f\u001e<\u0011\u0005u+H!C0q\u0003\u0003\u0005\tQ!\u0001a!\tiv\u000fB\u0005ga\u0006\u0005\t\u0011!B\u0001A\"\u0012\u0001\u000fN\u0001\u0005S:4w\u000eF\u0001|!\tYG0\u0003\u0002~\u001f\tQ1)Y2iKNLeNZ8)\u0005\u0015y\b\u0003BA\u0001\u0003#i!!a\u0001\u000b\u0007]\n)A\u0003\u0003\u0002\b\u0005%\u0011\u0001C3oIB|\u0017N\u001c;\u000b\t\u0005-\u0011QB\u0001\bC\u000e$X/\u0019;f\u0015\r\ty\u0001P\u0001\u0005E>|G/\u0003\u0003\u0002\u0014\u0005\r!!\u0004*fC\u0012|\u0005/\u001a:bi&|g.\u0001\u0006dC\u000eDW-\u00128uef$b!!\u0007\u0002.\u0005=\u0003\u0007BA\u000e\u0003S\u0001b!!\b\u0002$\u0005\u001dRBAA\u0010\u0015\u0011\t\t#!\u0002\u0002\u0007],'-\u0003\u0003\u0002&\u0005}!aE,fE\u0016sG\r]8j]R\u0014Vm\u001d9p]N,\u0007cA/\u0002*\u0011Q\u00111\u0006\u0004\u0002\u0002\u0003\u0005)\u0011\u00011\u0003\u0007}#3\u0007C\u0004\u00020\u0019\u0001\r!!\r\u0002\u0013\r\f7\r[3OC6,\u0007\u0003BA\u001a\u0003\u0003rA!!\u000e\u0002>A\u0019\u0011qG\u000f\u000e\u0005\u0005e\"bAA\u001e3\u00051AH]8pizJ1!a\u0010\u001e\u0003\u0019\u0001&/\u001a3fM&!\u00111IA#\u0005\u0019\u0019FO]5oO*\u0019\u0011qH\u000f)\t\u00055\u0012\u0011\n\t\u0005\u0003\u0003\tY%\u0003\u0003\u0002N\u0005\r!\u0001C*fY\u0016\u001cGo\u001c:\t\u000f\u0005Ec\u00011\u0001\u00022\u0005\u00191.Z=)\u0005\u0019y\u0018aC2mK\u0006\u00148)Y2iKN$\"!!\u0017\u0011\r\u0005u\u00111EA.!\ra\u0012QL\u0005\u0004\u0003?j\"\u0001B+oSRD3aBA2!\u0011\t\t!!\u001a\n\t\u0005\u001d\u00141\u0001\u0002\u0010\t\u0016dW\r^3Pa\u0016\u0014\u0018\r^5p]\u0006Q1\r\\3be\u000e\u000b7\r[3\u0015\t\u0005e\u0013Q\u000e\u0005\b\u0003_A\u0001\u0019AA\u0019Q\u0011\ti'!\u0013)\u0007!\t\u0019'\u0001\fxSRD7)Y2iKB\u0013xN^5eKJ\u001c\u0005.Z2l+\u0011\t9(! \u0015\t\u0005e\u0014\u0011\u0012\t\u0007\u0003;\t\u0019#a\u001f\u0011\u0007u\u000bi\bB\u0004\u0002\u0000%\u0011\r!!!\u0003\u0003-\u000b2!YAB!\ra\u0012QQ\u0005\u0004\u0003\u000fk\"aA!os\"A\u00111R\u0005\u0005\u0002\u0004\ti)A\u0003cY>\u001c7\u000eE\u0003\u001d\u0003\u001f\u000bI(C\u0002\u0002\u0012v\u0011\u0001\u0002\u00102z]\u0006lWMP\u0001\nO\u0016$8)Y2iKN,\"!a&\u0011\t9\u001b\u0016\u0011G\u0001\u0014O\u0016$8)Y2iK\u0012\u000bG/Y*feZL7-\u001a\u000b\u0005\u0003;\u000b\u0019\fE\u0003\u001d\u0003?\u000b\u0019+C\u0002\u0002\"v\u0011aa\u00149uS>t\u0007GBAS\u0003S\u000by\u000b\u0005\u0004X5\u0006\u001d\u0016Q\u0016\t\u0004;\u0006%FACAV\u0017\u0005\u0005\t\u0011!B\u0001A\n\u0019q\f\n\u001b\u0011\u0007u\u000by\u000b\u0002\u0006\u00022.\t\t\u0011!A\u0003\u0002\u0001\u00141a\u0018\u00136\u0011\u001d\tyc\u0003a\u0001\u0003c\t!dZ3u\u0007\u0006\u001c\u0007.\u001a#bi\u0006\u001cVM\u001d<jG\u0016\\U-\u001f+za\u0016$B!!/\u0002HB\"\u00111XAb!\u0019\t\u0019$!0\u0002B&!\u0011qXA#\u0005\u0015\u0019E.Y:t!\ri\u00161\u0019\u0003\f\u0003\u000bd\u0011\u0011!A\u0001\u0006\u0003\t\tIA\u0002`IaBq!!3\r\u0001\u0004\tY-A\u0002dIN\u0004d!!4\u0002R\u0006]\u0007CB,[\u0003\u001f\f)\u000eE\u0002^\u0003#$1\"a5\u0002H\u0006\u0005\t\u0011!B\u0001A\n\u0019q\f\n\u001c\u0011\u0007u\u000b9\u000eB\u0006\u0002Z\u0006\u001d\u0017\u0011!A\u0001\u0006\u0003\u0001'aA0%o\u0005iq-\u001a;DC\u000eDWMV1mk\u0016$\u0002\"a8\u0002j\u0006-\u0018\u0011 \u0019\u0005\u0003C\f)\u000f\u0005\u0004\u0002\u001e\u0005\r\u00121\u001d\t\u0004;\u0006\u0015HACAt\u001b\u0005\u0005\t\u0011!B\u0001A\n!q\fJ\u00194\u0011\u001d\t\t&\u0004a\u0001\u0003cAq!!<\u000e\u0001\u0004\ty/\u0001\u0004uCJ<W\r\u001e\u0019\u0005\u0003c\f)\u0010\u0005\u0004\u00024\u0005u\u00161\u001f\t\u0004;\u0006UH\u0001DA|\u0003W\f\t\u0011!A\u0003\u0002\u0005\u0005%\u0001B0%cABq!!3\u000e\u0001\u0004\tY\u0010\r\u0004\u0002~\n\u0005!q\u0001\t\u0007/j\u000byP!\u0002\u0011\u0007u\u0013\t\u0001B\u0006\u0003\u0004\u0005e\u0018\u0011!A\u0001\u0006\u0003\u0001'\u0001B0%cE\u00022!\u0018B\u0004\t-\u0011I!!?\u0002\u0002\u0003\u0005)\u0011\u00011\u0003\t}#\u0013G\r\u0015\b\u0001\t5!1\u0003B\u000b!\u0011\t\tAa\u0004\n\t\tE\u00111\u0001\u0002\t\u000b:$\u0007o\\5oi\u0006\u0011\u0011\u000eZ\u0011\u0003\u0005/\tqA[2bG\",7\u000fK\u0004\u0001\u00057\u0011ICa\u000b\u0011\t\tu!QE\u0007\u0003\u0005?Q1a\u000eB\u0011\u0015\r\u0011\u0019\u0003P\u0001\bG>tG/\u001a=u\u0013\u0011\u00119Ca\b\u0003\u0013\u0011+\u0007/\u001a8eg>s\u0017!\u0002<bYV,GF\u0001B\u0017C\t\u0011y#A\u0005dC\u000eDW-T8eK\"\u001a\u0001Aa\r\u0011\t\tU\"1H\u0007\u0003\u0005oQ1A!\u000f=\u0003)\u0019H/\u001a:f_RL\b/Z\u0005\u0005\u0005{\u00119DA\u0005D_6\u0004xN\\3oi\u0002")
public class JCachesEndpoint
implements Logging {
    @Autowired
    private final CachesProperties cachesProperties;
    @Autowired(required=false)
    private final CacheProvider cacheProvider;
    @Autowired
    private final List<CacheDataService<?, ?>> cacheDataServices;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        JCachesEndpoint jCachesEndpoint = this;
        synchronized (jCachesEndpoint) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    @ReadOperation
    public CachesInfo info() {
        return new CachesInfo(new Configured(this.cachesProperties.enabled()), new Evaluated(CacheMode$.MODULE$.getCacheMode(), this.cacheProvider != null ? this.cacheProvider.getType() : null, this.cacheProvider != null), this.getCaches());
    }

    @ReadOperation
    public WebEndpointResponse<?> cacheEntry(@Selector String cacheName, String key) {
        WebEndpointResponse notFoundResponse = new WebEndpointResponse(null, 404);
        return this.withCacheProviderCheck((Function0 & Serializable)() -> {
            Option<CacheDataService<?, ?>> option = this.getCacheDataService(cacheName);
            if (option instanceof Some) {
                Some some = (Some)option;
                CacheDataService cds = (CacheDataService)some.value();
                Class<?> keyType = this.getCacheDataServiceKeyType(cds);
                return this.getCacheValue(key, keyType, cds);
            }
            if (None$.MODULE$.equals(option)) {
                return notFoundResponse;
            }
            throw new MatchError(option);
        });
    }

    @DeleteOperation
    public WebEndpointResponse<BoxedUnit> clearCaches() {
        return this.withCacheProviderCheck((Function0 & Serializable)() -> {
            if ($this.cacheDataServices != null && !$this.cacheDataServices.isEmpty()) {
                $this.cacheDataServices.forEach(cacheDataService -> cacheDataService.clear());
                return new WebEndpointResponse(200);
            }
            return new WebEndpointResponse(400);
        });
    }

    @DeleteOperation
    public WebEndpointResponse<BoxedUnit> clearCache(@Selector String cacheName) {
        return this.withCacheProviderCheck((Function0 & Serializable)() -> {
            if ($this.cacheDataServices != null && !$this.cacheDataServices.isEmpty()) {
                Option option = CollectionConverters$.MODULE$.ListHasAsScala($this.cacheDataServices).asScala().find((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)JCachesEndpoint.$anonfun$clearCache$2(cacheName, x$1)));
                if (option instanceof Some) {
                    Some some = (Some)option;
                    CacheDataService cds = (CacheDataService)some.value();
                    cds.clear();
                    return new WebEndpointResponse(200);
                }
                if (None$.MODULE$.equals(option)) {
                    return new WebEndpointResponse(404);
                }
                throw new MatchError((Object)option);
            }
            return new WebEndpointResponse(400);
        });
    }

    private <K> WebEndpointResponse<K> withCacheProviderCheck(Function0<WebEndpointResponse<K>> block) {
        WebEndpointResponse webEndpointResponse;
        block3: {
            try {
                if (this.cacheProvider == null) {
                    webEndpointResponse = new WebEndpointResponse(400);
                    break block3;
                }
                webEndpointResponse = (WebEndpointResponse)block.apply();
            }
            catch (Exception e) {
                this.logger().error((Function0 & Serializable)() -> new StringBuilder(19).append("Exception occured. ").append(e.getMessage()).toString());
                webEndpointResponse = new WebEndpointResponse(500);
            }
        }
        return webEndpointResponse;
    }

    private List<String> getCaches() {
        ArrayList<String> caches;
        block0: {
            caches = new ArrayList<String>();
            if (this.cacheProvider == null || this.cacheDataServices == null || this.cacheDataServices.isEmpty()) break block0;
            this.cacheDataServices.forEach(cacheDataService -> caches.add(cacheDataService.cacheName()));
        }
        return caches;
    }

    private Option<CacheDataService<?, ?>> getCacheDataService(String cacheName) {
        if (this.cacheDataServices != null && !this.cacheDataServices.isEmpty()) {
            return CollectionConverters$.MODULE$.ListHasAsScala(this.cacheDataServices).asScala().find((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)JCachesEndpoint.$anonfun$getCacheDataService$1(cacheName, x$2)));
        }
        return None$.MODULE$;
    }

    private Class<?> getCacheDataServiceKeyType(CacheDataService<?, ?> cds) {
        Type[] genericTypes = cds.getClass().getGenericInterfaces();
        Type[] genericType = ((ParameterizedType)genericTypes[0]).getActualTypeArguments();
        return (Class)genericType[0];
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private WebEndpointResponse<?> getCacheValue(String key, Class<?> target, CacheDataService<?, ?> cds) {
        None$ none$;
        WebEndpointResponse notFoundResponse = new WebEndpointResponse(null, 404);
        Class<?> clazz = target;
        Class<?> clazz2 = target;
        Class<Integer> clazz3 = Integer.class;
        if (!(clazz2 != null ? !clazz2.equals(clazz3) : clazz3 != null)) {
            Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> Integer.valueOf(key));
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                Integer value = (Integer)success.value();
                none$ = cds.get(value);
            } else {
                Failure failure;
                if (!(try_ instanceof Failure) || !((failure = (Failure)try_).exception() instanceof NumberFormatException)) throw new MatchError((Object)try_);
                none$ = None$.MODULE$;
            }
        } else {
            Class<?> clazz4 = target;
            Class<String> clazz5 = String.class;
            if (clazz4 != null ? !clazz4.equals(clazz5) : clazz5 != null) throw new Exception("Unknown type for key");
            none$ = cds.get(key);
        }
        None$ result = none$;
        if (!result.isDefined()) return notFoundResponse;
        return new WebEndpointResponse(result.get(), 200);
    }

    public static final /* synthetic */ boolean $anonfun$clearCache$2(String cacheName$2, CacheDataService x$1) {
        return x$1.cacheName().equals(cacheName$2);
    }

    public static final /* synthetic */ boolean $anonfun$getCacheDataService$1(String cacheName$3, CacheDataService x$2) {
        return x$2.cacheName().equals(cacheName$3);
    }

    public JCachesEndpoint(@Autowired CachesProperties cachesProperties, @Autowired(required=false) CacheProvider cacheProvider, @Autowired List<CacheDataService<?, ?>> cacheDataServices) {
        this.cachesProperties = cachesProperties;
        this.cacheProvider = cacheProvider;
        this.cacheDataServices = cacheDataServices;
        Logging.$init$((Logging)this);
    }
}

