/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.dataset;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.dbunit.Assertion;
import org.dbunit.dataset.Column;
import org.dbunit.dataset.Columns;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.ITableIterator;
import org.dbunit.dataset.datatype.DataType;
import org.dbunit.dataset.datatype.TypeCastException;
import org.dbunit.util.QualifiedTableName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSetUtils {
    private static final Logger logger = LoggerFactory.getLogger(DataSetUtils.class);

    private DataSetUtils() {
    }

    public static void assertEquals(IDataSet expectedDataSet, IDataSet actualDataSet) throws Exception {
        logger.debug("assertEquals(expectedDataSet={}, actualDataSet={}) - start", (Object)expectedDataSet, (Object)actualDataSet);
        Assertion.assertEquals(expectedDataSet, actualDataSet);
    }

    public static void assertEquals(ITable expectedTable, ITable actualTable) throws Exception {
        logger.debug("assertEquals(expectedTable={}, actualTable={}) - start", (Object)expectedTable, (Object)actualTable);
        Assertion.assertEquals(expectedTable, actualTable);
    }

    public static String getQualifiedName(String prefix, String name) {
        logger.debug("getQualifiedName(prefix={}, name={}) - start", (Object)prefix, (Object)name);
        return new QualifiedTableName(name, prefix, null).getQualifiedName();
    }

    public static String getQualifiedName(String prefix, String name, String escapePattern) {
        if (logger.isDebugEnabled()) {
            logger.debug("getQualifiedName(prefix={}, name={}, escapePattern={}) - start", (Object[])new String[]{prefix, name, escapePattern});
        }
        return new QualifiedTableName(name, prefix, escapePattern).getQualifiedName();
    }

    public static String getEscapedName(String name, String escapePattern) {
        logger.debug("getEscapedName(name={}, escapePattern={}) - start", (Object)name, (Object)escapePattern);
        return new QualifiedTableName(name, null, escapePattern).getQualifiedName();
    }

    public static String getSqlValueString(Object value, DataType dataType) throws TypeCastException {
        logger.debug("getSqlValueString(value={}, dataType={}) - start", value, (Object)dataType);
        if (value == null || value == ITable.NO_VALUE) {
            return "NULL";
        }
        String stringValue = DataType.asString(value);
        if (dataType == DataType.DATE) {
            return "{d '" + stringValue + "'}";
        }
        if (dataType == DataType.TIME) {
            return "{t '" + stringValue + "'}";
        }
        if (dataType == DataType.TIMESTAMP) {
            return "{ts '" + stringValue + "'}";
        }
        if (!dataType.isNumber()) {
            if (stringValue.indexOf("'") < 0) {
                stringValue = "'" + stringValue + "'";
                return stringValue;
            }
            StringBuffer buffer = new StringBuffer(stringValue.length() * 2);
            StringTokenizer tokenizer = new StringTokenizer(stringValue, "'", true);
            buffer.append("'");
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                buffer.append(token);
                if (!token.equals("'")) continue;
                buffer.append("'");
            }
            buffer.append("'");
            return buffer.toString();
        }
        return stringValue;
    }

    public static Column getColumn(String columnName, Column[] columns) {
        logger.debug("getColumn(columnName={}, columns={}) - start", (Object)columnName, (Object)columns);
        return Columns.getColumn(columnName, columns);
    }

    public static ITable[] getTables(String[] names, IDataSet dataSet) throws DataSetException {
        logger.debug("getTables(names={}, dataSet={}) - start", (Object)names, (Object)dataSet);
        ITable[] tables = new ITable[names.length];
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            tables[i] = dataSet.getTable(name);
        }
        return tables;
    }

    public static ITable[] getTables(IDataSet dataSet) throws DataSetException {
        logger.debug("getTables(dataSet={}) - start", (Object)dataSet);
        return DataSetUtils.getTables(dataSet.iterator());
    }

    public static ITable[] getTables(ITableIterator iterator) throws DataSetException {
        logger.debug("getTables(iterator={}) - start", (Object)iterator);
        ArrayList<ITable> tableList = new ArrayList<ITable>();
        while (iterator.next()) {
            tableList.add(iterator.getTable());
        }
        return tableList.toArray(new ITable[0]);
    }

    public static String[] getReverseTableNames(IDataSet dataSet) throws DataSetException {
        logger.debug("getReverseTableNames(dataSet={}) - start", (Object)dataSet);
        return DataSetUtils.reverseStringArray(dataSet.getTableNames());
    }

    public static String[] reverseStringArray(String[] array) {
        logger.debug("reverseStringArray(array={}) - start", (Object[])array);
        String[] newArray = new String[array.length];
        for (int i = 0; i < array.length; ++i) {
            newArray[array.length - 1 - i] = array[i];
        }
        return newArray;
    }
}

