/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.util;

import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;
import org.infinispan.commons.util.ArrayMap;

public class HopscotchHashMap<K, V>
extends ArrayMap<K, V> {
    private static final int H = 32;
    private static final int MAX_REHASH_CYCLES = 100;
    private int[] hopinfo;
    private int a;
    private int b;
    private int M;
    private int m;
    private int wM;
    private int mask;

    public HopscotchHashMap(int initialCapacity) {
        initialCapacity = Math.max(32, initialCapacity);
        this.wM = Integer.numberOfLeadingZeros(initialCapacity - 1);
        this.M = 32 - this.wM;
        this.m = 1 << this.M;
        this.mask = this.m - 1;
        this.randomizeFunction();
        this.keys = new Object[this.m];
        this.values = new Object[this.m];
        this.hopinfo = new int[this.m];
    }

    private void randomizeFunction() {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        this.a = random.nextInt() | 1;
        this.b = random.nextInt() >>> this.M;
    }

    private int bin(int hashCode) {
        return this.a * hashCode + this.b >>> this.wM;
    }

    @Override
    public V get(Object key) {
        int offset;
        Objects.requireNonNull(key);
        int bin = this.bin(key.hashCode());
        Object storedKey = this.keys[bin];
        if (storedKey != null && storedKey.equals(key)) {
            return (V)this.values[bin];
        }
        for (int bininfo = this.hopinfo[bin] & 0xFFFFFFFE; bininfo != 0; bininfo &= ~(1 << offset)) {
            offset = Integer.numberOfTrailingZeros(bininfo);
            int bo = bin + offset & this.mask;
            storedKey = this.keys[bo];
            if (!storedKey.equals(key)) continue;
            return (V)this.values[bo];
        }
        return null;
    }

    @Override
    public V put(K key, V value) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(value);
        ++this.modCount;
        try {
            if (this.shouldGrow()) {
                return this.rehashAndPutInternal(key, value);
            }
            return this.putInternal(key, value);
        }
        catch (RehashException e) {
            return this.rehashAndPutInternal(key, value);
        }
    }

    private V rehashAndPutInternal(K key, V value) {
        Object[] oldKeys = this.keys;
        Object[] oldValues = this.values;
        for (int cycle = 0; cycle < 100; ++cycle) {
            this.randomizeFunction();
            try {
                this.rehash(oldKeys, oldValues);
                return this.putInternal(key, value);
            }
            catch (RehashException rehashException) {
                continue;
            }
        }
        throw new IllegalStateException("Did not manage to rehash table with " + this.size + " elements");
    }

    private void rehash(Object[] oldKeys, Object[] oldValues) throws RehashException {
        if (this.shouldGrow()) {
            this.m *= 2;
            this.mask = this.m - 1;
            ++this.M;
            --this.wM;
        }
        this.keys = new Object[this.m];
        this.values = new Object[this.m];
        if (this.m > this.hopinfo.length) {
            this.hopinfo = new int[this.m];
        } else {
            Arrays.fill(this.hopinfo, 0);
        }
        this.size = 0;
        for (int i = 0; i < oldKeys.length; ++i) {
            if (oldKeys[i] == null) continue;
            this.putInternal(oldKeys[i], oldValues[i]);
        }
    }

    private boolean shouldGrow() {
        return this.size * 2 >= this.m && this.wM > 1;
    }

    private V putInternal(Object key, Object value) throws RehashException {
        int offset;
        int bin = this.bin(key.hashCode());
        for (int bininfo = this.hopinfo[bin]; bininfo != 0; bininfo &= ~(1 << offset)) {
            offset = Integer.numberOfTrailingZeros(bininfo);
            int bo = bin + offset & this.mask;
            Object storedKey = this.keys[bo];
            if (!storedKey.equals(key)) continue;
            Object prev = this.values[bo];
            this.values[bo] = value;
            return (V)prev;
        }
        if (this.keys[bin] == null) {
            this.keys[bin] = key;
            this.values[bin] = value;
            this.hopinfo[bin] = this.hopinfo[bin] | 1;
            ++this.size;
            return null;
        }
        int empty = bin + 1 & this.mask;
        while (this.keys[empty] != null && empty != bin) {
            empty = empty + 1 & this.mask;
        }
        if (empty == bin) {
            assert (this.size == this.m);
            throw new RehashException();
        }
        while (true) {
            int headinfo;
            int distance;
            int head;
            if (empty > bin) {
                head = empty - 32 + 1;
                if (head <= bin) {
                    break;
                }
            } else {
                head = empty - 32 + 1 & this.mask;
            }
            do {
                headinfo = this.hopinfo[head];
            } while ((headinfo &= (1 << (distance = empty - head & this.mask)) - 1) == 0 && (head = head + 1 & this.mask) != empty);
            if (head == empty) {
                this.keys[empty] = null;
                this.values[empty] = null;
                throw new RehashException();
            }
            int offset2 = Integer.numberOfTrailingZeros(headinfo);
            int newEmpty = head + offset2 & this.mask;
            this.keys[empty] = this.keys[newEmpty];
            this.values[empty] = this.values[newEmpty];
            headinfo = this.hopinfo[head];
            this.hopinfo[head] = headinfo & ~(1 << offset2) | 1 << distance;
            empty = newEmpty;
        }
        this.keys[empty] = key;
        this.values[empty] = value;
        int offset3 = empty - bin & this.mask;
        this.hopinfo[bin] = this.hopinfo[bin] | 1 << offset3;
        ++this.size;
        return null;
    }

    @Override
    public V remove(Object key) {
        int bininfo;
        Objects.requireNonNull(key);
        ++this.modCount;
        int bin = this.bin(key.hashCode());
        int previnfo = bininfo = this.hopinfo[bin];
        while (bininfo != 0) {
            int offset = Integer.numberOfTrailingZeros(bininfo);
            int bo = bin + offset & this.mask;
            Object storedKey = this.keys[bo];
            if (storedKey.equals(key)) {
                Object prev = this.values[bo];
                if ((previnfo &= ~(1 << offset)) != 0 && offset == 0) {
                    offset = Integer.numberOfTrailingZeros(previnfo);
                    bo = bin + offset & this.mask;
                    this.keys[bin] = this.keys[bo];
                    this.values[bin] = this.values[bo];
                    previnfo = previnfo & ~(1 << offset) | 1;
                }
                this.keys[bo] = null;
                this.values[bo] = null;
                this.hopinfo[bin] = previnfo;
                --this.size;
                return (V)prev;
            }
            bininfo &= ~(1 << offset);
        }
        return null;
    }

    private static class RehashException
    extends Exception {
        public RehashException() {
            super(null, null, false, false);
        }
    }
}

