/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlplatform.synthetic.yaml;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonSchemaFactory;
import com.networknt.schema.SpecVersion;
import com.networknt.schema.ValidationMessage;
import com.xebialabs.xlplatform.synthetic.TypeSpecification;
import com.xebialabs.xlplatform.synthetic.yaml.JsonTypeSpecification;
import com.xebialabs.xlplatform.utils.ClassLoaderUtils$;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypeDefinitionYamlDocument {
    private static final Logger logger = LoggerFactory.getLogger(TypeDefinitionYamlDocument.class);
    public static final ObjectMapper YAML_PARSER = new ObjectMapper((JsonFactory)new YAMLFactory());
    private final List<TypeSpecification> types = new ArrayList<TypeSpecification>();

    private TypeDefinitionYamlDocument() {
    }

    public List<TypeSpecification> getTypes() {
        return this.types;
    }

    private void readTypes(JsonNode node) {
        if (node.has("types")) {
            JsonNode typeNodes = node.get("types");
            Iterator iter = typeNodes.fieldNames();
            while (iter.hasNext()) {
                String typeName = (String)iter.next();
                this.types.add(new JsonTypeSpecification(typeName, typeNodes.get(typeName)));
            }
        }
    }

    public static TypeDefinitionYamlDocument read(URL typeYaml) throws IOException {
        TypeDefinitionYamlDocument typeDefinitionYaml = new TypeDefinitionYamlDocument();
        JsonNode node = TypeDefinitionYamlDocument.readYaml(typeYaml);
        TypeDefinitionYamlDocument.validate(node, Optional.of(typeYaml.getFile()));
        typeDefinitionYaml.readTypes(node);
        return typeDefinitionYaml;
    }

    public static TypeDefinitionYamlDocument read(String yamlContent) throws IOException {
        TypeDefinitionYamlDocument typeDefinitionYaml = new TypeDefinitionYamlDocument();
        JsonNode node = TypeDefinitionYamlDocument.readYaml(yamlContent);
        TypeDefinitionYamlDocument.validate(node, Optional.empty());
        typeDefinitionYaml.readTypes(node);
        return typeDefinitionYaml;
    }

    private static JsonNode readYaml(URL yaml) throws IOException {
        return YAML_PARSER.readTree(yaml);
    }

    private static JsonNode readYaml(String yaml) throws IOException {
        return YAML_PARSER.readTree(yaml);
    }

    private static void validate(JsonNode node, Optional<String> file) throws IOException {
        Set<ValidationMessage> messages = TypeDefinitionYamlDocument.validateYaml(node);
        messages.forEach(message -> logger.error(message.toString()));
        if (!messages.isEmpty()) {
            if (file.isPresent()) {
                throw new IllegalArgumentException("One or more errors were found while parsing " + file.get());
            }
            throw new IllegalArgumentException("One or more errors were found while parsing type-definitions");
        }
    }

    public static Set<ValidationMessage> validateYaml(String file) throws IOException {
        return TypeDefinitionYamlDocument.validateYaml(TypeDefinitionYamlDocument.getResourceUrl(file));
    }

    public static Set<ValidationMessage> validateYaml(URL yaml) throws IOException {
        return TypeDefinitionYamlDocument.validateYaml(TypeDefinitionYamlDocument.readYaml(yaml));
    }

    private static Set<ValidationMessage> validateYaml(JsonNode yaml) throws IOException {
        JsonSchemaFactory factory = JsonSchemaFactory.builder((JsonSchemaFactory)JsonSchemaFactory.getInstance((SpecVersion.VersionFlag)SpecVersion.VersionFlag.V202012)).objectMapper(YAML_PARSER).build();
        JsonSchema schema = null;
        try {
            schema = factory.getSchema(TypeDefinitionYamlDocument.getResourceUrl("type-definition-schema.json").toURI());
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
        return schema.validate(yaml);
    }

    private static URL getResourceUrl(String file) {
        return ClassLoaderUtils$.MODULE$.classLoader().getResource(file);
    }
}

