/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.core;

import java.io.Serializable;
import org.springframework.util.Assert;

public final class AuthorizationGrantType
implements Serializable {
    private static final long serialVersionUID = 580L;
    public static final AuthorizationGrantType AUTHORIZATION_CODE = new AuthorizationGrantType("authorization_code");
    @Deprecated
    public static final AuthorizationGrantType IMPLICIT = new AuthorizationGrantType("implicit");
    public static final AuthorizationGrantType REFRESH_TOKEN = new AuthorizationGrantType("refresh_token");
    public static final AuthorizationGrantType CLIENT_CREDENTIALS = new AuthorizationGrantType("client_credentials");
    @Deprecated
    public static final AuthorizationGrantType PASSWORD = new AuthorizationGrantType("password");
    public static final AuthorizationGrantType JWT_BEARER = new AuthorizationGrantType("urn:ietf:params:oauth:grant-type:jwt-bearer");
    private final String value;

    public AuthorizationGrantType(String value) {
        Assert.hasText((String)value, (String)"value cannot be empty");
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AuthorizationGrantType that = (AuthorizationGrantType)obj;
        return this.getValue().equals(that.getValue());
    }

    public int hashCode() {
        return this.getValue().hashCode();
    }
}

