/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xldeploy.authentication.oidc.conf;

import ai.digital.deploy.sql.model.LoginProvider;
import com.nimbusds.jose.Algorithm;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.jwk.Curve;
import com.nimbusds.jose.jwk.ECKey;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.KeyUse;
import com.nimbusds.jose.jwk.OctetSequenceKey;
import com.nimbusds.jose.jwk.RSAKey;
import com.xebialabs.deployit.ServerConfiguration;
import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.engine.spi.exception.DeployitException;
import com.xebialabs.platform.sso.oidc.authentication.CustomOidcIdTokenDecoderFactory;
import com.xebialabs.platform.sso.oidc.exceptions.UnsupportedOidcConfigurationException;
import com.xebialabs.platform.sso.oidc.policy.ClaimsToGrantedAuthoritiesPolicy;
import com.xebialabs.platform.sso.oidc.policy.impl.DefaultClaimsToGrantedAuthoritiesPolicy;
import com.xebialabs.platform.sso.oidc.policy.impl.GrantedAuthoritiesExtractor;
import com.xebialabs.platform.sso.oidc.service.XLOidcUserService;
import com.xebialabs.platform.sso.oidc.web.CustomAuthorizationRequestResolver;
import com.xebialabs.platform.sso.oidc.web.OidcLogoutSuccessHandler;
import com.xebialabs.xldeploy.authentication.oidc.conf.OidcConfig;
import com.xebialabs.xldeploy.authentication.oidc.conf.OpenIdConnectConfig$;
import com.xebialabs.xldeploy.authentication.oidc.policy.impl.OidcUserProfileCreationPolicy;
import com.xebialabs.xlplatform.config.ConfigLoader$;
import com.xebialabs.xlplatform.config.ConfigurationHolder$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.nio.charset.StandardCharsets;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.converter.Converter;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.http.converter.FormHttpMessageConverter;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.DisabledException;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.oauth2.client.InMemoryOAuth2AuthorizedClientService;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientService;
import org.springframework.security.oauth2.client.endpoint.DefaultAuthorizationCodeTokenResponseClient;
import org.springframework.security.oauth2.client.endpoint.NimbusJwtClientAuthenticationParametersConverter;
import org.springframework.security.oauth2.client.endpoint.OAuth2AuthorizationCodeGrantRequestEntityConverter;
import org.springframework.security.oauth2.client.http.OAuth2ErrorResponseErrorHandler;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.oauth2.client.registration.ClientRegistrations;
import org.springframework.security.oauth2.client.registration.InMemoryClientRegistrationRepository;
import org.springframework.security.oauth2.client.web.AuthenticatedPrincipalOAuth2AuthorizedClientRepository;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.core.ClientAuthenticationMethod;
import org.springframework.security.oauth2.core.DelegatingOAuth2TokenValidator;
import org.springframework.security.oauth2.core.OAuth2TokenValidator;
import org.springframework.security.oauth2.core.http.converter.OAuth2AccessTokenResponseHttpMessageConverter;
import org.springframework.security.oauth2.jose.jws.JwsAlgorithm;
import org.springframework.security.oauth2.jose.jws.MacAlgorithm;
import org.springframework.security.oauth2.jose.jws.SignatureAlgorithm;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.jwt.JwtClaimValidator;
import org.springframework.security.oauth2.jwt.JwtDecoder;
import org.springframework.security.oauth2.jwt.JwtDecoderFactory;
import org.springframework.security.oauth2.jwt.JwtIssuerValidator;
import org.springframework.security.oauth2.jwt.JwtTimestampValidator;
import org.springframework.security.oauth2.jwt.NimbusJwtDecoder;
import org.springframework.security.oauth2.server.resource.authentication.JwtAuthenticationConverter;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.LoginUrlAuthenticationEntryPoint;
import org.springframework.security.web.authentication.SimpleUrlAuthenticationFailureHandler;
import org.springframework.security.web.authentication.session.SessionAuthenticationException;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestOperations;
import org.springframework.web.client.RestTemplate;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.mutable.ListBuffer;
import scala.jdk.CollectionConverters$;
import scala.jdk.FunctionConverters$;
import scala.jdk.FunctionWrappers;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Using;
import scala.util.Using$;

@ConditionalOnProperty(name={"deploy.server.security.auth.provider"}, havingValue="oidc")
@EnableWebSecurity
@Configuration
@ComponentScan(value={"com.xebialabs.xldeploy.auth.oidc.config"})
@ScalaSignature(bytes="\u0006\u0005\rmw!B\u00181\u0011\u0003id!B 1\u0011\u0003\u0001\u0005\"B$\u0002\t\u0003A\u0005bB%\u0002\u0005\u0004%\tA\u0013\u0005\u0007S\u0006\u0001\u000b\u0011B&\t\u000f)\f!\u0019!C\u0001W\"1\u00110\u0001Q\u0001\n1DqA_\u0001C\u0002\u0013\u00051\u0010C\u0004\u0002\u0004\u0005\u0001\u000b\u0011\u0002?\t\u0011\u0005\u0015\u0011A1A\u0005\u0002mDq!a\u0002\u0002A\u0003%APB\u0003@a\u0001\tI\u0001\u0003\u0004H\u0017\u0011\u0005\u00111\u0004\u0005\b\u0003?YA\u0011AA\u0011\u0011\u001d\tYd\u0003C\u0001\u0003{Aq!!\u0018\f\t\u0003\ti\u0004C\u0004\u0002b-!\t!a\u0019\t\u000f\u0005]4\u0002\"\u0001\u0002z!9\u0011qS\u0006\u0005\u0002\u0005e\u0005bBAc\u0017\u0011\u0005\u0011q\u0019\u0005\b\u0003/\\A\u0011AAm\u0011\u001d\t)p\u0003C\u0001\u0003oDqAa\u0004\f\t\u0003\u0011\t\u0002C\u0004\u0003(-!\tA!\u000b\t\u000f\tM2\u0002\"\u0001\u00036!9!1J\u0006\u0005\u0002\t5\u0003\"\u0003B1\u0017\t\u0007I\u0011\u0001B2\u0011!\u0011\th\u0003Q\u0001\n\t\u0015\u0004b\u0002B:\u0017\u0011\u0005!Q\u000f\u0005\b\u0005\u000b[A\u0011\u0001BD\u0011\u001d\u0011\tj\u0003C\u0001\u0005'CqA!)\f\t\u0003\u0011\u0019\u000bC\u0004\u0003..!\tAa,\t\u000f\t}6\u0002\"\u0003\u0003B\"9!1Y\u0006\u0005\n\t\u0015\u0007b\u0002Bk\u0017\u0011%!q\u001b\u0005\b\u0005O\\A\u0011\u0002Bu\u0011\u001d\u0011\u0019p\u0003C\u0005\u0005kDqA!@\f\t\u0013\u0011y\u0010C\u0004\u0004\u000e-!Iaa\u0004\t\u000f\ru1\u0002\"\u0003\u0004 !91QF\u0006\u0005\n\r=\u0002bBB\u001c\u0017\u0011%1\u0011\b\u0005\b\u0007\u001bZA\u0011BB(\u0011\u001d\u0019\u0019f\u0003C\u0005\u0007+Bqa!\u0019\f\t\u0013\u0019\u0019\u0007C\u0004\u0004z-!Iaa\u001f\u0002'=\u0003XM\\%e\u0007>tg.Z2u\u0007>tg-[4\u000b\u0005E\u0012\u0014\u0001B2p]\u001aT!a\r\u001b\u0002\t=LGm\u0019\u0006\u0003kY\na\"Y;uQ\u0016tG/[2bi&|gN\u0003\u00028q\u0005A\u0001\u0010\u001c3fa2|\u0017P\u0003\u0002:u\u0005I\u00010\u001a2jC2\f'm\u001d\u0006\u0002w\u0005\u00191m\\7\u0004\u0001A\u0011a(A\u0007\u0002a\t\u0019r\n]3o\u0013\u0012\u001cuN\u001c8fGR\u001cuN\u001c4jON\u0011\u0011!\u0011\t\u0003\u0005\u0016k\u0011a\u0011\u0006\u0002\t\u0006)1oY1mC&\u0011ai\u0011\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005i\u0014!F'B\u0007~\u000bEjR(S\u0013RCUjX'B!BKejR\u000b\u0002\u0017B!Aj\u0015,g\u001d\ti\u0015\u000b\u0005\u0002O\u00076\tqJ\u0003\u0002Qy\u00051AH]8pizJ!AU\"\u0002\rA\u0013X\rZ3g\u0013\t!VKA\u0002NCBT!AU\"\u0011\u0005]#W\"\u0001-\u000b\u0005eS\u0016a\u00016xg*\u00111\fX\u0001\u0005U>\u001cXM\u0003\u0002^=\u00061q.Y;uQJR!a\u00181\u0002\u0011M,7-\u001e:jifT!!\u00192\u0002\u001fM\u0004(/\u001b8hMJ\fW.Z<pe.T\u0011aY\u0001\u0004_J<\u0017BA3Y\u00051i\u0015mY!mO>\u0014\u0018\u000e\u001e5n!\tau-\u0003\u0002i+\n11\u000b\u001e:j]\u001e\fa#T!D?\u0006cui\u0014*J)\"ku,T!Q!&su\tI\u0001\u001c\u000bN\u000bu,\u0011'H\u001fJKE\u000bS'`\u0007V\u0013f+R0N\u0003B\u0003\u0016JT$\u0016\u00031\u0004B\u0001T*naB\u0011qK\\\u0005\u0003_b\u0013ABS<t\u00032<wN]5uQ6\u0004\"!]<\u000e\u0003IT!a\u001d;\u0002\u0007)<8N\u0003\u0002\\k*\u0011aOO\u0001\t]&l'-^:eg&\u0011\u0001P\u001d\u0002\u0006\u0007V\u0014h/Z\u0001\u001d\u000bN\u000bu,\u0011'H\u001fJKE\u000bS'`\u0007V\u0013f+R0N\u0003B\u0003\u0016JT$!\u0003E)5+Q0B\u0019\u001e{%+\u0013+I\u001b~k\u0015\tU\u000b\u0002yB!AjU7~!\tqx0D\u0001u\u0013\r\t\t\u0001\u001e\u0002\r\u0015^\u001b\u0016\t\\4pe&$\b.\\\u0001\u0013\u000bN\u000bu,\u0011'H\u001fJKE\u000bS'`\u001b\u0006\u0003\u0006%A\tS'\u0006{\u0016\tT$P%&#\u0006*T0N\u0003B\u000b!CU*B?\u0006cui\u0014*J)\"ku,T!QAM!1\"QA\u0006!\u0011\ti!a\u0006\u000e\u0005\u0005=!\u0002BA\t\u0003'\tQa\u001d7gi)T!!!\u0006\u0002\u0011\u001d\u0014\u0018N\u001f>mK\u0012LA!!\u0007\u0002\u0010\t9Aj\\4hS:<GCAA\u000f!\tq4\"\u0001\u0006pS\u0012\u001c7i\u001c8gS\u001e,\"!a\t\u0011\u0007y\n)#C\u0002\u0002(A\u0012!bT5eG\u000e{gNZ5hQ\ri\u00111\u0006\t\u0005\u0003[\t9$\u0004\u0002\u00020)!\u0011\u0011GA\u001a\u0003)\tgN\\8uCRLwN\u001c\u0006\u0004\u0003k\u0001\u0017aB2p]R,\u0007\u0010^\u0005\u0005\u0003s\tyC\u0001\u0003CK\u0006t\u0017!E8jI\u000edunZ5o!J|g/\u001b3feV\u0011\u0011q\b\t\u0005\u0003\u0003\n9&\u0004\u0002\u0002D)!\u0011QIA$\u0003\u0015iw\u000eZ3m\u0015\u0011\tI%a\u0013\u0002\u0007M\fHN\u0003\u0003\u0002N\u0005=\u0013A\u00023fa2|\u0017P\u0003\u0003\u0002R\u0005M\u0013a\u00023jO&$\u0018\r\u001c\u0006\u0003\u0003+\n!!Y5\n\t\u0005e\u00131\t\u0002\u000e\u0019><\u0017N\u001c)s_ZLG-\u001a:)\u00079\tY#\u0001\nm_\u000e\fG\u000eT8hS:\u0004&o\u001c<jI\u0016\u0014\bfA\b\u0002,\u0005a2\r\\5f]R\u0014VmZ5tiJ\fG/[8o%\u0016\u0004xn]5u_JLXCAA3!\u0011\t9'!\u001d\u000e\u0005\u0005%$\u0002BA6\u0003[\nAB]3hSN$(/\u0019;j_:T1!a\u001c]\u0003\u0019\u0019G.[3oi&!\u00111OA5\u0005\u0011Je.T3n_JL8\t\\5f]R\u0014VmZ5tiJ\fG/[8o%\u0016\u0004xn]5u_JL\bf\u0001\t\u0002,\u0005\u00013\r\\1j[N$vn\u0012:b]R,G-Q;uQ>\u0014\u0018\u000e^5fgB{G.[2z+\t\tY\b\u0005\u0003\u0002~\u0005EUBAA@\u0015\u0011\t\t)a!\u0002\t%l\u0007\u000f\u001c\u0006\u0005\u0003\u000b\u000b9)\u0001\u0004q_2L7-\u001f\u0006\u0004g\u0005%%\u0002BAF\u0003\u001b\u000b1a]:p\u0015\r\ty\tO\u0001\ta2\fGOZ8s[&!\u00111SA@\u0005\u001d\"UMZ1vYR\u001cE.Y5ngR{wI]1oi\u0016$\u0017)\u001e;i_JLG/[3t!>d\u0017nY=)\u0007E\tY#\u0001\u0012dkN$x.\\!vi\"|'/\u001b>bi&|gNU3rk\u0016\u001cHOU3t_24XM\u001d\u000b\u0005\u00037\u000b9\u000b\u0005\u0003\u0002\u001e\u0006\rVBAAP\u0015\u0011\t\t+a\"\u0002\u0007],'-\u0003\u0003\u0002&\u0006}%AI\"vgR|W.Q;uQ>\u0014\u0018N_1uS>t'+Z9vKN$(+Z:pYZ,'\u000fC\u0004\u0002bI\u0001\r!!+\u0011\t\u0005\u001d\u00141V\u0005\u0005\u0003[\u000bIG\u0001\u000fDY&,g\u000e\u001e*fO&\u001cHO]1uS>t'+\u001a9pg&$xN]=)\u0007I\tY\u0003K\u0002\u0013\u0003g\u0003B!!.\u0002B6\u0011\u0011q\u0017\u0006\u0005\u0003c\tIL\u0003\u0003\u0002<\u0006u\u0016a\u00024bGR|'/\u001f\u0006\u0004\u0003\u007f\u0003\u0017!\u00022fC:\u001c\u0018\u0002BAb\u0003o\u0013\u0011\"Q;u_^L'/\u001a3\u0002/\u0005,H\u000f[8sSj,Gm\u00117jK:$8+\u001a:wS\u000e,G\u0003BAe\u0003#\u0004B!a3\u0002N6\u0011\u0011QN\u0005\u0005\u0003\u001f\fiGA\u0013J]6+Wn\u001c:z\u001f\u0006+H\u000f\u001b\u001aBkRDwN]5{K\u0012\u001cE.[3oiN+'O^5dK\"9\u0011\u0011M\nA\u0002\u0005%\u0006fA\n\u0002,!\u001a1#a-\u0002#adw*\u001b3d+N,'oU3sm&\u001cW\r\u0006\u0003\u0002\\\u0006\u001d\b\u0003BAo\u0003Gl!!a8\u000b\t\u0005\u0005\u0018qQ\u0001\bg\u0016\u0014h/[2f\u0013\u0011\t)/a8\u0003#acu*\u001b3d+N,'oU3sm&\u001cW\rC\u0004\u0002xQ\u0001\r!!;\u0011\t\u0005-\u0018Q^\u0007\u0003\u0003\u0007KA!a<\u0002\u0004\n\u00013\t\\1j[N$vn\u0012:b]R,G-Q;uQ>\u0014\u0018\u000e^5fgB{G.[2zQ\r!\u00121\u0006\u0015\u0004)\u0005M\u0016AG1vi\"|'/\u001b>fI\u000ec\u0017.\u001a8u%\u0016\u0004xn]5u_JLH\u0003BA}\u0005\u0007\u0001B!a?\u0002\u00006\u0011\u0011Q \u0006\u0005\u0003C\u000bi'\u0003\u0003\u0003\u0002\u0005u(AN!vi\",g\u000e^5dCR,G\r\u0015:j]\u000eL\u0007/\u00197P\u0003V$\bNM!vi\"|'/\u001b>fI\u000ec\u0017.\u001a8u%\u0016\u0004xn]5u_JL\bbBAc+\u0001\u0007!Q\u0001\t\u0005\u0003\u0017\u00149!\u0003\u0003\u0003\n\u00055$!H(BkRD''Q;uQ>\u0014\u0018N_3e\u00072LWM\u001c;TKJ4\u0018nY3)\u0007U\tY\u0003K\u0002\u0016\u0003g\u000bQ#\u001b3U_.,g\u000eR3d_\u0012,'OR1di>\u0014\u00180\u0006\u0002\u0003\u0014A1!Q\u0003B\u000e\u0005?i!Aa\u0006\u000b\u0007\teA,A\u0002koRLAA!\b\u0003\u0018\t\t\"j\u001e;EK\u000e|G-\u001a:GC\u000e$xN]=\u0011\t\u0005\u001d$\u0011E\u0005\u0005\u0005G\tIG\u0001\nDY&,g\u000e\u001e*fO&\u001cHO]1uS>t\u0007f\u0001\f\u0002,\u0005Q!n\u001e;EK\u000e|G-\u001a:\u0016\u0005\t-\u0002\u0003\u0002B\u000b\u0005[IAAa\f\u0003\u0018\tQ!j\u001e;EK\u000e|G-\u001a:)\u0007]\tY#\u0001\u000ekoR\fU\u000f\u001e5f]RL7-\u0019;j_:\u001cuN\u001c<feR,'/\u0006\u0002\u00038A!!\u0011\bB#\u001b\t\u0011YDC\u00026\u0005{QAAa\u0010\u0003B\u0005A!/Z:pkJ\u001cWMC\u0002\u0003Dq\u000baa]3sm\u0016\u0014\u0018\u0002\u0002B$\u0005w\u0011!DS<u\u0003V$\b.\u001a8uS\u000e\fG/[8o\u0007>tg/\u001a:uKJD3\u0001GA\u0016\u0003\u0011\nW\u000f\u001e5pe&T\u0018\r^5p]\u000e{G-\u001a+pW\u0016t'+Z:q_:\u001cXm\u00117jK:$H\u0003\u0002B(\u00057\u0002BA!\u0015\u0003X5\u0011!1\u000b\u0006\u0005\u0005+\ni'\u0001\u0005f]\u0012\u0004x.\u001b8u\u0013\u0011\u0011IFa\u0015\u0003W\u0011+g-Y;mi\u0006+H\u000f[8sSj\fG/[8o\u0007>$W\rV8lK:\u0014Vm\u001d9p]N,7\t\\5f]RDq!!\u0019\u001a\u0001\u0004\tI\u000bK\u0002\u001a\u0003WA3!GAZ\u0003-Qwo\u001b*fg>dg/\u001a:\u0016\u0005\t\u0015\u0004c\u0002\"\u0003h\t}!1N\u0005\u0004\u0005S\u001a%!\u0003$v]\u000e$\u0018n\u001c82!\r\t(QN\u0005\u0004\u0005_\u0012(a\u0001&X\u0017\u0006a!n^6SKN|GN^3sA\u00059r.\u001b3d\u0019><\u0017N\u001c$bS2,(/\u001a%b]\u0012dWM]\u000b\u0003\u0005o\u0002BA!\u001f\u0003\u00005\u0011!1\u0010\u0006\u0004k\tu$bAAQ=&!!\u0011\u0011B>\u0005q\tU\u000f\u001e5f]RL7-\u0019;j_:4\u0015-\u001b7ve\u0016D\u0015M\u001c3mKJD3\u0001HA\u0016\u0003YAH\u000e\u001a'pO&tg)Y5mkJ,\u0007*\u00198eY\u0016\u0014XC\u0001BE!\u0011\u0011IHa#\n\t\t5%1\u0010\u0002&'&l\u0007\u000f\\3Ve2\fU\u000f\u001e5f]RL7-\u0019;j_:4\u0015-\u001b7ve\u0016D\u0015M\u001c3mKJD3!HA\u0016\u0003iy\u0007/\u001a8JI2{wm\\;u'V\u001c7-Z:t\u0011\u0006tG\r\\3s)\u0011\u0011)Ja'\u0011\t\u0005u%qS\u0005\u0005\u00053\u000byJ\u0001\rPS\u0012\u001cGj\\4pkR\u001cVoY2fgND\u0015M\u001c3mKJDq!!\u0019\u001f\u0001\u0004\tI\u000bK\u0002\u001f\u0003WA3AHAZ\u0003\u0001bwnZ5o+Jd\u0017)\u001e;iK:$\u0018nY1uS>tWI\u001c;ssB{\u0017N\u001c;\u0016\u0005\t\u0015\u0006\u0003\u0002B=\u0005OKAA!+\u0003|\t\u0001Cj\\4j]V\u0013H.Q;uQ\u0016tG/[2bi&|g.\u00128uef\u0004v.\u001b8uQ\ry\u00121F\u0001\u001e_&$7-V:feB\u0013xNZ5mK\u000e\u0013X-\u0019;j_:\u0004v\u000e\\5dsV\u0011!\u0011\u0017\t\u0005\u0005g\u0013I,\u0004\u0002\u00036*!\u0011\u0011\u0011B\\\u0015\r\t)IM\u0005\u0005\u0005w\u0013)LA\u000fPS\u0012\u001cWk]3s!J|g-\u001b7f\u0007J,\u0017\r^5p]B{G.[2zQ\r\u0001\u00131F\u0001\u0013G2LWM\u001c;SK\u001eL7\u000f\u001e:bi&|g.\u0006\u0002\u0003 \u0005ar-\u001a;DY&,g\u000e\u001e*fO&\u001cHO]1uS>t')^5mI\u0016\u0014XC\u0001Bd!\u0011\u0011IMa4\u000f\t\u0005\u001d$1Z\u0005\u0005\u0005\u001b\fI'\u0001\nDY&,g\u000e\u001e*fO&\u001cHO]1uS>t\u0017\u0002\u0002Bi\u0005'\u0014qAQ;jY\u0012,'O\u0003\u0003\u0003N\u0006%\u0014\u0001G2mS\u0016tG\u000f\u0013;uaJ+\u0017/^3ti\u001a\u000b7\r^8ssV\u0011!\u0011\u001c\t\u0005\u00057\u0014\u0019/\u0004\u0002\u0003^*!\u0011q\u000eBp\u0015\r\u0011\t\u000fY\u0001\u0005QR$\b/\u0003\u0003\u0003f\nu'\u0001G\"mS\u0016tG\u000f\u0013;uaJ+\u0017/^3ti\u001a\u000b7\r^8ss\u0006yq-\u001a;KoN\fEnZ8sSRDW\u000eF\u0003n\u0005W\u0014y\u000f\u0003\u0004\u0003n\u0012\u0002\rAZ\u0001\rU^\u001c\u0018\t\\4pe&$\b.\u001c\u0005\u0007\u0005c$\u0003\u0019\u00014\u0002\u0019A\u0014x\u000e]3sift\u0015-\\3\u0002\u001f\u001d,G/T1d\u00032<wN]5uQ6$RA\u0016B|\u0005wDaA!?&\u0001\u00041\u0017\u0001D7bG\u0006cwm\u001c:ji\"l\u0007B\u0002ByK\u0001\u0007a-A\u000bhKR\u001c\u0016n\u001a8biV\u0014X-\u00117h_JLG\u000f[7\u0015\r\r\u00051qAB\u0006!\r961A\u0005\u0004\u0007\u000bA&AE*jO:\fG/\u001e:f\u00032<wN]5uQ6Daa!\u0003'\u0001\u00041\u0017AE:jO:\fG/\u001e:f\u00032<wN]5uQ6DaA!='\u0001\u00041\u0017aE4fi\u000ec\u0017.\u001a8u\u0003V$\b.T3uQ>$WCAB\t!\u0011\u0019\u0019b!\u0007\u000e\u0005\rU!bAB\f9\u0006!1m\u001c:f\u0013\u0011\u0019Yb!\u0006\u00035\rc\u0017.\u001a8u\u0003V$\b.\u001a8uS\u000e\fG/[8o\u001b\u0016$\bn\u001c3\u00025\u001d,GOS<u\u001f\u0006+H\u000f\u001b\u001aU_.,gNV1mS\u0012\fGo\u001c:\u0016\u0005\r\u0005\u0002CBB\n\u0007G\u00199#\u0003\u0003\u0004&\rU!\u0001F(BkRD'\u0007V8lK:4\u0016\r\\5eCR|'\u000f\u0005\u0003\u0003\u0016\r%\u0012\u0002BB\u0016\u0005/\u00111AS<u\u0003e1\u0018\r\\5eCR,w*\u001b3d\u0007>tg-[4ve\u0006$\u0018n\u001c8\u0015\u0005\rE\u0002c\u0001\"\u00044%\u00191QG\"\u0003\tUs\u0017\u000e^\u0001\u001eO\u0016$XI\u001d:pe6+7o]1hK\u001a{'\u000f\u00157bG\u0016Dw\u000e\u001c3feR!11HB%!\u0011\u0019ida\u0012\u000e\u0005\r}\"\u0002BB!\u0007\u0007\nA\u0001\\1oO*\u00111QI\u0001\u0005U\u00064\u0018-C\u0002i\u0007\u007fAaaa\u0013+\u0001\u00041\u0017a\u00039mC\u000e,\u0007n\u001c7eKJ\faa]3u\u0015^\\G\u0003BB\u0019\u0007#BqAa0,\u0001\u0004\u0011y\"\u0001\u0006hKR\\U-\u001f)bSJ,\"aa\u0016\u0011\t\re3QL\u0007\u0003\u00077R1aXB\"\u0013\u0011\u0019yfa\u0017\u0003\u000f-+\u0017\u0010U1je\u0006Iq-\u001a;S'\u0006[U-\u001f\u000b\u0007\u0007K\u001aYga\u001c\u0011\u0007E\u001c9'C\u0002\u0004jI\u0014aAU*B\u0017\u0016L\bbBB7[\u0001\u00071qK\u0001\bW\u0016L\b+Y5s\u0011\u001d\u0019\t(\fa\u0001\u0007g\n\u0011\"\u00197h_JLG\u000f[7\u0011\u0007y\u001c)(C\u0002\u0004xQ\u0014\u0011\"\u00117h_JLG\u000f[7\u0002\u0013\u001d,G/R*B\u0017\u0016LH\u0003CB?\u0007\u0007\u001b)ia\"\u0011\u0007E\u001cy(C\u0002\u0004\u0002J\u0014Q!R\"LKfDqa!\u001c/\u0001\u0004\u00199\u0006C\u0004\u0004r9\u0002\raa\u001d\t\r\r%e\u00061\u0001q\u0003\u0015\u0019WO\u001d<fQ-Y1QRBQ\u0007G\u001bIka+\u0011\t\r=5QT\u0007\u0003\u0007#SAaa%\u0004\u0016\u0006I1m\u001c8eSRLwN\u001c\u0006\u0005\u0007/\u001bI*A\u0007bkR|7m\u001c8gS\u001e,(/\u001a\u0006\u0004\u00077\u0003\u0017\u0001\u00022p_RLAaa(\u0004\u0012\n)2i\u001c8eSRLwN\\1m\u001f:\u0004&o\u001c9feRL\u0018\u0001\u00028b[\u0016d#a!*\"\u0005\r\u001d\u0016\u0001\n3fa2|\u0017PL:feZ,'OL:fGV\u0014\u0018\u000e^=/CV$\bN\f9s_ZLG-\u001a:\u0002\u0017!\fg/\u001b8h-\u0006dW/Z\u0011\u0002g!\u001a1ba,\u0011\t\rE6qX\u0007\u0003\u0007gSAa!.\u00048\u0006i1m\u001c8gS\u001e,(/\u0019;j_:TA!!)\u0004:*!\u0011\u0011GB^\u0015\r\u0019iLX\u0001\u0007G>tg-[4\n\t\r\u000571\u0017\u0002\u0012\u000b:\f'\r\\3XK\n\u001cVmY;sSRL\bfA\u0006\u0004FB!\u0011QFBd\u0013\u0011\u0019I-a\f\u0003\u001b\r{gNZ5hkJ\fG/[8oQ\u001dY1QZBj\u0007+\u0004B!!\f\u0004P&!1\u0011[A\u0018\u00055\u0019u.\u001c9p]\u0016tGoU2b]\u0006)a/\u00197vK2\u00121q[\u0011\u0003\u00073\fqeY8n]a,'-[1mC\n\u001ch\u0006\u001f7eKBdw.\u001f\u0018bkRDgf\\5eG:\u001awN\u001c4jO\u0002")
public class OpenIdConnectConfig
implements Logging {
    private final Function1<ClientRegistration, JWK> jwkResolver;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public static Map<JwsAlgorithm, JWSAlgorithm> RSA_ALGORITHM_MAP() {
        return OpenIdConnectConfig$.MODULE$.RSA_ALGORITHM_MAP();
    }

    public static Map<JwsAlgorithm, JWSAlgorithm> ESA_ALGORITHM_MAP() {
        return OpenIdConnectConfig$.MODULE$.ESA_ALGORITHM_MAP();
    }

    public static Map<JwsAlgorithm, Curve> ESA_ALGORITHM_CURVE_MAPPING() {
        return OpenIdConnectConfig$.MODULE$.ESA_ALGORITHM_CURVE_MAPPING();
    }

    public static Map<MacAlgorithm, String> MAC_ALGORITHM_MAPPING() {
        return OpenIdConnectConfig$.MODULE$.MAC_ALGORITHM_MAPPING();
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        OpenIdConnectConfig openIdConnectConfig = this;
        synchronized (openIdConnectConfig) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    @Bean
    public OidcConfig oidcConfig() {
        return new OidcConfig(ConfigLoader$.MODULE$.loadWithDynamic(ConfigurationHolder$.MODULE$.get(), ConfigLoader$.MODULE$.loadWithDynamic$default$2()), ServerConfiguration.getInstance());
    }

    @Bean
    public LoginProvider oidcLoginProvider() {
        return new LoginProvider(this.oidcConfig().loginMethodDescription(), "." + this.oidcConfig().external_login(), "./logout", false);
    }

    @Bean
    public LoginProvider localLoginProvider() {
        return new LoginProvider("XL Deploy local login", "./login", "./logout", true);
    }

    @Bean
    public InMemoryClientRegistrationRepository clientRegistrationRepository() {
        return new InMemoryClientRegistrationRepository(new ClientRegistration[]{this.clientRegistration()});
    }

    @Bean
    public DefaultClaimsToGrantedAuthoritiesPolicy claimsToGrantedAuthoritiesPolicy() {
        return new DefaultClaimsToGrantedAuthoritiesPolicy(this.oidcConfig().rolesClaimName());
    }

    @Bean
    @Autowired
    public CustomAuthorizationRequestResolver customAuthorizationRequestResolver(ClientRegistrationRepository clientRegistrationRepository) {
        return new CustomAuthorizationRequestResolver(clientRegistrationRepository, "/oauth2/authorization", this.oidcConfig().additionalParameters());
    }

    @Bean
    @Autowired
    public InMemoryOAuth2AuthorizedClientService authorizedClientService(ClientRegistrationRepository clientRegistrationRepository) {
        return new InMemoryOAuth2AuthorizedClientService(clientRegistrationRepository);
    }

    @Bean
    @Autowired
    public XLOidcUserService xlOidcUserService(ClaimsToGrantedAuthoritiesPolicy claimsToGrantedAuthoritiesPolicy) {
        return new XLOidcUserService(claimsToGrantedAuthoritiesPolicy);
    }

    @Bean
    @Autowired
    public AuthenticatedPrincipalOAuth2AuthorizedClientRepository authorizedClientRepository(OAuth2AuthorizedClientService authorizedClientService) {
        return new AuthenticatedPrincipalOAuth2AuthorizedClientRepository(authorizedClientService);
    }

    @Bean
    public JwtDecoderFactory<ClientRegistration> idTokenDecoderFactory() {
        RestTemplate restTemplate = new RestTemplate();
        restTemplate.setRequestFactory(this.clientHttpRequestFactory());
        JwsAlgorithm jwsAlgorithm = this.getJwsAlgorithm(this.oidcConfig().idTokenJWSAlg(), "deploy.security.auth.providers.oidc.idTokenJWSAlg");
        CustomOidcIdTokenDecoderFactory idTokenDecoderFactory = new CustomOidcIdTokenDecoderFactory();
        idTokenDecoderFactory.setJwsAlgorithmResolver(x$1 -> jwsAlgorithm);
        idTokenDecoderFactory.setRestOperations((RestOperations)restTemplate);
        return idTokenDecoderFactory;
    }

    @Bean
    public JwtDecoder jwtDecoder() {
        NimbusJwtDecoder nimbusJwtDecoder;
        JwsAlgorithm jwsAlgorithm = this.getJwsAlgorithm(this.oidcConfig().accessTokenJWSAlg(), "deploy.security.auth.providers.oidc.access-token.jwsAlg");
        JwsAlgorithm jwsAlgorithm2 = jwsAlgorithm;
        if (jwsAlgorithm2 instanceof SignatureAlgorithm) {
            SignatureAlgorithm signatureAlgorithm = (SignatureAlgorithm)jwsAlgorithm2;
            String jwkSetUri = Strings.isNotBlank((String)this.oidcConfig().accessTokenKeyUri()) ? this.oidcConfig().accessTokenKeyUri() : this.clientRegistration().getProviderDetails().getJwkSetUri();
            nimbusJwtDecoder = NimbusJwtDecoder.withJwkSetUri((String)jwkSetUri).jwsAlgorithm(signatureAlgorithm).build();
        } else if (jwsAlgorithm2 instanceof MacAlgorithm) {
            MacAlgorithm macAlgorithm = (MacAlgorithm)jwsAlgorithm2;
            Checks.checkArgument((boolean)Strings.isNotBlank((String)this.oidcConfig().accessTokenSecretKey()), (String)"No configuration setting found for key 'deploy.security.auth.providers.oidc.access-token.secretKey'", (Object[])new Object[0]);
            SecretKeySpec secretKeySpec = new SecretKeySpec(this.oidcConfig().accessTokenSecretKey().getBytes(StandardCharsets.UTF_8), (String)OpenIdConnectConfig$.MODULE$.MAC_ALGORITHM_MAPPING().getOrElse((Object)macAlgorithm, (Function0 & Serializable)() -> {
                throw new IllegalArgumentException("'" + macAlgorithm.getName() + "' is not supported. Ensure you have configured a valid HMAC Algorithm.");
            }));
            nimbusJwtDecoder = NimbusJwtDecoder.withSecretKey((SecretKey)secretKeySpec).macAlgorithm(macAlgorithm).build();
        } else {
            throw new UnsupportedOidcConfigurationException("Failed to find a Signature Verifier. Ensure you have configured a valid JWS Algorithm.");
        }
        NimbusJwtDecoder jwtDecoder = nimbusJwtDecoder;
        jwtDecoder.setJwtValidator(this.getJwtOAuth2TokenValidator());
        return jwtDecoder;
    }

    @Bean
    public JwtAuthenticationConverter jwtAuthenticationConverter() {
        JwtAuthenticationConverter jwtAuthenticationConverter = new JwtAuthenticationConverter();
        jwtAuthenticationConverter.setPrincipalClaimName(this.oidcConfig().userNameClaimName());
        jwtAuthenticationConverter.setJwtGrantedAuthoritiesConverter((Converter)new GrantedAuthoritiesExtractor((ClaimsToGrantedAuthoritiesPolicy)this.claimsToGrantedAuthoritiesPolicy()));
        return jwtAuthenticationConverter;
    }

    @Bean
    @Autowired
    public DefaultAuthorizationCodeTokenResponseClient authorizationCodeTokenResponseClient(ClientRegistrationRepository clientRegistrationRepository) {
        DefaultAuthorizationCodeTokenResponseClient authorizationCodeTokenResponseClient;
        block1: {
            ClientRegistration clientRegistration;
            block0: {
                ListBuffer messageConverter = new ListBuffer();
                messageConverter.$plus$eq((Object)new FormHttpMessageConverter());
                messageConverter.$plus$eq((Object)new OAuth2AccessTokenResponseHttpMessageConverter());
                RestTemplate restTemplate = new RestTemplate(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)messageConverter.toList()).asJava());
                restTemplate.setRequestFactory(this.clientHttpRequestFactory());
                restTemplate.setErrorHandler((ResponseErrorHandler)new OAuth2ErrorResponseErrorHandler());
                authorizationCodeTokenResponseClient = new DefaultAuthorizationCodeTokenResponseClient();
                authorizationCodeTokenResponseClient.setRestOperations((RestOperations)restTemplate);
                clientRegistration = clientRegistrationRepository.findByRegistrationId(this.oidcConfig().registrationId());
                ClientAuthenticationMethod clientAuthenticationMethod = clientRegistration.getClientAuthenticationMethod();
                ClientAuthenticationMethod clientAuthenticationMethod2 = ClientAuthenticationMethod.CLIENT_SECRET_JWT;
                if (!(clientAuthenticationMethod == null ? clientAuthenticationMethod2 != null : !clientAuthenticationMethod.equals(clientAuthenticationMethod2))) break block0;
                ClientAuthenticationMethod clientAuthenticationMethod3 = clientRegistration.getClientAuthenticationMethod();
                ClientAuthenticationMethod clientAuthenticationMethod4 = ClientAuthenticationMethod.PRIVATE_KEY_JWT;
                if (clientAuthenticationMethod3 != null ? !clientAuthenticationMethod3.equals(clientAuthenticationMethod4) : clientAuthenticationMethod4 != null) break block1;
            }
            this.setJwk(clientRegistration);
            OAuth2AuthorizationCodeGrantRequestEntityConverter requestEntityConverter = new OAuth2AuthorizationCodeGrantRequestEntityConverter();
            requestEntityConverter.addParametersConverter((Converter)new NimbusJwtClientAuthenticationParametersConverter(FunctionWrappers.RichFunction1AsFunction$.MODULE$.asJavaFunction$extension(FunctionConverters$.MODULE$.enrichAsJavaFunction(this.jwkResolver()))));
            authorizationCodeTokenResponseClient.setRequestEntityConverter((Converter)requestEntityConverter);
        }
        return authorizationCodeTokenResponseClient;
    }

    public Function1<ClientRegistration, JWK> jwkResolver() {
        return this.jwkResolver;
    }

    @Bean
    public AuthenticationFailureHandler oidcLoginFailureHandler() {
        return (x$2, response, exception) -> {
            AuthenticationException authenticationException = exception;
            if (authenticationException instanceof BadCredentialsException ? true : authenticationException instanceof DisabledException) {
                response.sendRedirect("/login?error=" + authenticationException.getMessage());
                return;
            }
            if (authenticationException instanceof SessionAuthenticationException) {
                SessionAuthenticationException sessionAuthenticationException = (SessionAuthenticationException)authenticationException;
                response.sendRedirect("/login?error=" + sessionAuthenticationException.getMessage());
                return;
            }
            response.sendRedirect(this.oidcConfig().external_login());
        };
    }

    @Bean
    public SimpleUrlAuthenticationFailureHandler xldLoginFailureHandler() {
        return new SimpleUrlAuthenticationFailureHandler();
    }

    @Bean
    @Autowired
    public OidcLogoutSuccessHandler openIdLogoutSuccessHandler(ClientRegistrationRepository clientRegistrationRepository) {
        return new OidcLogoutSuccessHandler(clientRegistrationRepository, this.oidcConfig().postLogoutRedirectUri(), "/login");
    }

    @Bean
    public LoginUrlAuthenticationEntryPoint loginUrlAuthenticationEntryPoint() {
        return new LoginUrlAuthenticationEntryPoint(this.oidcConfig().external_login());
    }

    @Bean
    public OidcUserProfileCreationPolicy oidcUserProfileCreationPolicy() {
        return new OidcUserProfileCreationPolicy(this.oidcConfig().emailClaim(), this.oidcConfig().fullNameClaim());
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private ClientRegistration clientRegistration() {
        clientRegistrationBuilder = this.getClientRegistrationBuilder();
        authenticationMethod = this.getClientAuthMethod();
        clientRegistrationBuilder.clientId(this.oidcConfig().clientId()).clientAuthenticationMethod(authenticationMethod).authorizationGrantType(AuthorizationGrantType.AUTHORIZATION_CODE).redirectUri(this.oidcConfig().redirectUri()).userInfoUri("").scope(this.oidcConfig().scopes()).userNameAttributeName(this.oidcConfig().userNameClaimName());
        v0 = authenticationMethod;
        var3_3 = ClientAuthenticationMethod.NONE;
        if (!(v0 == null ? var3_3 != null : v0.equals(var3_3) == false)) ** GOTO lbl-1000
        v1 = authenticationMethod;
        var4_4 = ClientAuthenticationMethod.PRIVATE_KEY_JWT;
        if (v1 == null ? var4_4 != null : v1.equals(var4_4) == false) {
            Checks.checkArgument((boolean)Strings.isNotBlank((String)this.oidcConfig().clientSecret()), (String)this.getErrorMessageForPlaceholder("deploy.security.auth.providers.oidc.clientSecret"), (Object[])new Object[0]);
            v2 = clientRegistrationBuilder.clientSecret(this.oidcConfig().clientSecret());
        } else lbl-1000:
        // 2 sources

        {
            v2 = BoxedUnit.UNIT;
        }
        v3 = authenticationMethod;
        var5_5 = ClientAuthenticationMethod.PRIVATE_KEY_JWT;
        if (!(v3 != null ? v3.equals(var5_5) == false : var5_5 != null)) {
            if (Strings.isBlank((String)this.oidcConfig().keyStorePath())) {
                this.oidcConfig().keyStorePath_$eq(this.oidcConfig().defaultKeyStorePath());
                this.oidcConfig().keyStorePassword_$eq(this.oidcConfig().defaultKeyStorePassword());
            }
            Checks.checkArgument((boolean)Strings.isNotBlank((String)this.oidcConfig().keyStorePath()), (String)this.getErrorMessageForPlaceholder("deploy.security.auth.providers.oidc.clientAuthJwt.keyStore.path"), (Object[])new Object[0]);
            Checks.checkArgument((boolean)Strings.isNotBlank((String)this.oidcConfig().keyAlias()), (String)this.getErrorMessageForPlaceholder("deploy.security.auth.providers.oidc.clientAuthJwt.key.alias"), (Object[])new Object[0]);
        }
        v4 /* !! */  = Strings.isNotBlank((String)this.oidcConfig().userAuthorizationUri()) != false ? clientRegistrationBuilder.authorizationUri(this.oidcConfig().userAuthorizationUri()) : BoxedUnit.UNIT;
        v5 /* !! */  = Strings.isNotBlank((String)this.oidcConfig().accessTokenUri()) != false ? clientRegistrationBuilder.tokenUri(this.oidcConfig().accessTokenUri()) : BoxedUnit.UNIT;
        v6 /* !! */  = Strings.isNotBlank((String)this.oidcConfig().jwks_uri()) != false ? clientRegistrationBuilder.jwkSetUri(this.oidcConfig().jwks_uri()) : BoxedUnit.UNIT;
        clientRegistration = clientRegistrationBuilder.build();
        configurationMetadata = clientRegistration.getProviderDetails().getConfigurationMetadata();
        updatedConfigurationMetadata = new HashMap<String, String>(configurationMetadata);
        updatedConfigurationMetadata.put("rolesClaim", this.oidcConfig().rolesClaimName());
        v7 /* !! */  = Strings.isNotBlank((String)this.oidcConfig().logoutUri()) != false ? updatedConfigurationMetadata.put("end_session_endpoint", this.oidcConfig().logoutUri()) : BoxedUnit.UNIT;
        return ClientRegistration.withClientRegistration((ClientRegistration)clientRegistration).providerConfigurationMetadata(updatedConfigurationMetadata).build();
    }

    private ClientRegistration.Builder getClientRegistrationBuilder() {
        ClientRegistration.Builder builder;
        try {
            if (!this.oidcConfig().issuer().matches("\\S+")) {
                throw new UnsupportedOidcConfigurationException("Whitespace characters in issuer url [" + this.oidcConfig().issuer() + "] is not supported. Recommendation is to avoid using spaces in URLs, and instead use hyphens to separate words.");
            }
            builder = ClientRegistrations.fromOidcIssuerLocation((String)this.oidcConfig().issuer()).registrationId(this.oidcConfig().registrationId());
        }
        catch (RuntimeException re) {
            RuntimeException runtimeException = re;
            if (runtimeException instanceof IllegalArgumentException) {
                this.logger().warn((Function0 & Serializable)() -> "Unable to resolve Configuration with the provided Issuer of [" + this.oidcConfig().issuer() + "]");
            } else if (runtimeException instanceof UnsupportedOidcConfigurationException) {
                this.logger().warn((Function0 & Serializable)() -> re.getMessage());
            } else {
                throw new MatchError((Object)runtimeException);
            }
            this.validateOidcConfiguration();
            builder = ClientRegistration.withRegistrationId((String)this.oidcConfig().registrationId());
        }
        return builder;
    }

    private ClientHttpRequestFactory clientHttpRequestFactory() {
        SimpleClientHttpRequestFactory requestFactory;
        block0: {
            requestFactory = new SimpleClientHttpRequestFactory();
            if (!Strings.isNotBlank((String)this.oidcConfig().proxyHost())) break block0;
            requestFactory.setProxy(new Proxy(Proxy.Type.HTTP, new InetSocketAddress(this.oidcConfig().proxyHost(), Predef$.MODULE$.Integer2int(this.oidcConfig().proxyPort()))));
        }
        return requestFactory;
    }

    private JwsAlgorithm getJwsAlgorithm(String jwsAlgorithm, String propertyName) {
        Map jwsAlgorithms = (Map)Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])SignatureAlgorithm.values()), (Function1 & Serializable)v -> new Tuple2((Object)v.getName(), v), ClassTag$.MODULE$.apply(Tuple2.class))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()).$plus$plus((IterableOnce)Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])MacAlgorithm.values()), (Function1 & Serializable)v -> new Tuple2((Object)v.getName(), v), ClassTag$.MODULE$.apply(Tuple2.class))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        return (JwsAlgorithm)jwsAlgorithms.getOrElse((Object)jwsAlgorithm, (Function0 & Serializable)() -> {
            throw new IllegalArgumentException(propertyName + " value [" + jwsAlgorithm + "] is not supported. Ensure you have configured a valid JWS Algorithm.");
        });
    }

    private MacAlgorithm getMacAlgorithm(String macAlgorithm, String propertyName) {
        Map macAlgorithms = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])MacAlgorithm.values()), (Function1 & Serializable)v -> new Tuple2((Object)v.getName(), v), ClassTag$.MODULE$.apply(Tuple2.class))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        return (MacAlgorithm)macAlgorithms.getOrElse((Object)macAlgorithm, (Function0 & Serializable)() -> {
            throw new IllegalArgumentException(propertyName + " value [" + macAlgorithm + "] is not supported. Ensure you have configured a valid HMAC Algorithm.");
        });
    }

    private SignatureAlgorithm getSignatureAlgorithm(String signatureAlgorithm, String propertyName) {
        Map signatureAlgorithms = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])SignatureAlgorithm.values()), (Function1 & Serializable)v -> new Tuple2((Object)v.getName(), v), ClassTag$.MODULE$.apply(Tuple2.class))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        return (SignatureAlgorithm)signatureAlgorithms.getOrElse((Object)signatureAlgorithm, (Function0 & Serializable)() -> {
            throw new IllegalArgumentException(propertyName + " value [" + signatureAlgorithm + "] is not supported. Ensure you have configured a valid Signature Algorithm.");
        });
    }

    private ClientAuthenticationMethod getClientAuthMethod() {
        Map clientAuthMethods = (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"client_secret_basic"), (Object)ClientAuthenticationMethod.CLIENT_SECRET_BASIC), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"client_secret_post"), (Object)ClientAuthenticationMethod.CLIENT_SECRET_POST), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"client_secret_jwt"), (Object)ClientAuthenticationMethod.CLIENT_SECRET_JWT), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"private_key_jwt"), (Object)ClientAuthenticationMethod.PRIVATE_KEY_JWT), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"none"), (Object)ClientAuthenticationMethod.NONE)}));
        return (ClientAuthenticationMethod)clientAuthMethods.getOrElse((Object)this.oidcConfig().clientAuthMethod().toLowerCase(), (Function0 & Serializable)() -> {
            throw new IllegalArgumentException("clientAuthMethod value [" + this.oidcConfig().clientAuthMethod() + " is not supported. Ensure you have configured a valid client authentication method.]");
        });
    }

    private OAuth2TokenValidator<Jwt> getJwtOAuth2TokenValidator() {
        ArrayList<Object> validators = new ArrayList<Object>();
        validators.add(new JwtTimestampValidator());
        validators.add(new JwtIssuerValidator(Strings.isNotBlank((String)this.oidcConfig().accessTokenIssuer()) ? this.oidcConfig().accessTokenIssuer() : this.oidcConfig().issuer()));
        validators.add(new JwtClaimValidator("aud", aud -> aud.contains(Strings.isNotBlank((String)this.oidcConfig().accessTokenAudience()) ? this.oidcConfig().accessTokenAudience() : this.oidcConfig().clientId())));
        return new DelegatingOAuth2TokenValidator(validators);
    }

    private void validateOidcConfiguration() {
        Checks.checkArgument((boolean)Strings.isNotBlank((String)this.oidcConfig().userAuthorizationUri()), (String)this.getErrorMessageForPlaceholder("deploy.security.auth.providers.oidc.userAuthorizationUri"), (Object[])new Object[0]);
        Checks.checkArgument((boolean)Strings.isNotBlank((String)this.oidcConfig().accessTokenUri()), (String)this.getErrorMessageForPlaceholder("deploy.security.auth.providers.oidc.accessTokenUri"), (Object[])new Object[0]);
        Checks.checkArgument((boolean)Strings.isNotBlank((String)this.oidcConfig().jwks_uri()), (String)this.getErrorMessageForPlaceholder("deploy.security.auth.providers.oidc.keyRetrievalUri"), (Object[])new Object[0]);
        Checks.checkArgument((boolean)Strings.isNotBlank((String)this.oidcConfig().logoutUri()), (String)this.getErrorMessageForPlaceholder("deploy.security.auth.providers.oidc.logoutUri"), (Object[])new Object[0]);
    }

    private String getErrorMessageForPlaceholder(String placeholder) {
        return "No configuration setting found for key '" + placeholder + "'";
    }

    private void setJwk(ClientRegistration clientRegistration) {
        if (clientRegistration.getClientAuthenticationMethod().equals((Object)ClientAuthenticationMethod.CLIENT_SECRET_JWT)) {
            MacAlgorithm jwsAlgorithm = this.getMacAlgorithm(this.oidcConfig().clientAuthJWSAlg(), "deploy.security.auth.providers.oidc.clientAuthJwt.jwsAlg");
            MacAlgorithm macAlgorithm = jwsAlgorithm;
            if (macAlgorithm != null) {
                MacAlgorithm macAlgorithm2 = macAlgorithm;
                SecretKeySpec secretKey = new SecretKeySpec(clientRegistration.getClientSecret().getBytes(StandardCharsets.UTF_8), (String)OpenIdConnectConfig$.MODULE$.MAC_ALGORITHM_MAPPING().getOrElse((Object)macAlgorithm2, (Function0 & Serializable)() -> {
                    throw new IllegalArgumentException("'" + macAlgorithm2.getName() + "' is not supported. Ensure you have configured a valid HMAC Algorithm.");
                }));
                this.oidcConfig().jwk_$eq((JWK)new OctetSequenceKey.Builder((SecretKey)secretKey).algorithm(new Algorithm(macAlgorithm2.getName())).keyUse(KeyUse.SIGNATURE).keyID(UUID.randomUUID().toString()).build());
                return;
            }
            throw new UnsupportedOidcConfigurationException("Failed to find a Signature Verifier. Ensure you have configured a valid JWS Algorithm.");
        }
        if (clientRegistration.getClientAuthenticationMethod().equals((Object)ClientAuthenticationMethod.PRIVATE_KEY_JWT)) {
            SignatureAlgorithm jwsAlgorithm = this.getSignatureAlgorithm(this.oidcConfig().clientAuthJWSAlg(), "deploy.security.auth.providers.oidc.clientAuthJwt.jwsAlg");
            SignatureAlgorithm signatureAlgorithm = jwsAlgorithm;
            if (signatureAlgorithm != null) {
                KeyPair keyPair = this.getKeyPair();
                if (OpenIdConnectConfig$.MODULE$.RSA_ALGORITHM_MAP().contains((Object)jwsAlgorithm)) {
                    this.oidcConfig().jwk_$eq((JWK)this.getRSAKey(keyPair, (Algorithm)OpenIdConnectConfig$.MODULE$.RSA_ALGORITHM_MAP().apply((Object)jwsAlgorithm)));
                    return;
                }
                if (OpenIdConnectConfig$.MODULE$.ESA_ALGORITHM_MAP().contains((Object)jwsAlgorithm)) {
                    this.oidcConfig().jwk_$eq((JWK)this.getESAKey(keyPair, (Algorithm)OpenIdConnectConfig$.MODULE$.ESA_ALGORITHM_MAP().apply((Object)jwsAlgorithm), (Curve)OpenIdConnectConfig$.MODULE$.ESA_ALGORITHM_CURVE_MAPPING().apply((Object)jwsAlgorithm)));
                    return;
                }
                throw new UnsupportedOidcConfigurationException("Ensure you have configured a valid JWS Algorithm.");
            }
            throw new UnsupportedOidcConfigurationException("Failed to find a Signature Verifier. Ensure you have configured a valid JWS Algorithm.");
        }
        this.oidcConfig().jwk_$eq(null);
    }

    private KeyPair getKeyPair() {
        Try tryKeyPair;
        Try try_;
        File file = new File(this.oidcConfig().keyStorePath());
        if (!file.exists()) {
            throw new IllegalArgumentException("Cannot find keystore [" + this.oidcConfig().keyStorePath() + "]");
        }
        if (Strings.isBlank((String)this.oidcConfig().keyStorePassword())) {
            this.logger().warn((Function0 & Serializable)() -> "The keystore [" + this.oidcConfig().keyStorePath() + "] is not protected by a password. It is recommended to secure it using a password.");
        }
        if ((try_ = (tryKeyPair = Using$.MODULE$.apply((Function0 & Serializable)() -> new FileInputStream(file), (Function1 & Serializable)in -> {
            String kst = Strings.isNotBlank((String)this.oidcConfig().keyStoreType()) ? this.oidcConfig().keyStoreType() : KeyStore.getDefaultType();
            KeyStore keystore = KeyStore.getInstance(kst);
            char[] ksp = Strings.isNotBlank((String)this.oidcConfig().keyStorePassword()) ? this.oidcConfig().keyStorePassword().toCharArray() : null;
            keystore.load((InputStream)in, ksp);
            char[] kp = Strings.isNotBlank((String)this.oidcConfig().keyPassword()) ? this.oidcConfig().keyPassword().toCharArray() : null;
            PrivateKey privateKey = (PrivateKey)keystore.getKey(this.oidcConfig().keyAlias(), kp);
            Certificate cert = keystore.getCertificate(this.oidcConfig().keyAlias());
            PublicKey publicKey = cert.getPublicKey();
            return new KeyPair(publicKey, privateKey);
        }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$))) instanceof Success) {
            Success success = (Success)try_;
            KeyPair value = (KeyPair)success.value();
            return value;
        }
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable exception = failure.exception();
            throw new DeployitException(exception);
        }
        throw new MatchError((Object)try_);
    }

    private RSAKey getRSAKey(KeyPair keyPair, Algorithm algorithm) {
        RSAKey.Builder builder = new RSAKey.Builder((RSAPublicKey)keyPair.getPublic()).privateKey(keyPair.getPrivate()).algorithm(algorithm).keyUse(KeyUse.SIGNATURE);
        if (Strings.isNotBlank((String)this.oidcConfig().tokenKeyId())) {
            v0 = builder.keyID(this.oidcConfig().tokenKeyId());
        } else {
            this.logger().debug((Function0 & Serializable)() -> "Building RSAKey without token k-id. Token key Id not provided in configuration.");
            v0 = BoxedUnit.UNIT;
        }
        return builder.build();
    }

    private ECKey getESAKey(KeyPair keyPair, Algorithm algorithm, Curve curve) {
        ECKey.Builder builder = new ECKey.Builder(curve, (ECPublicKey)keyPair.getPublic()).privateKey((ECPrivateKey)keyPair.getPrivate()).algorithm(algorithm).keyUse(KeyUse.SIGNATURE);
        if (Strings.isNotBlank((String)this.oidcConfig().tokenKeyId())) {
            v0 = builder.keyID(this.oidcConfig().tokenKeyId());
        } else {
            this.logger().debug((Function0 & Serializable)() -> "Building ECKey without token k-id. Token key Id not provided in configuration.");
            v0 = BoxedUnit.UNIT;
        }
        return builder.build();
    }

    public OpenIdConnectConfig() {
        Logging.$init$((Logging)this);
        this.jwkResolver = (Function1 & Serializable)clientRegistration -> {
            if (clientRegistration.getClientAuthenticationMethod().equals((Object)ClientAuthenticationMethod.CLIENT_SECRET_JWT) || clientRegistration.getClientAuthenticationMethod().equals((Object)ClientAuthenticationMethod.PRIVATE_KEY_JWT)) {
                return this.oidcConfig().jwk();
            }
            return null;
        };
    }
}

