/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.bulkhead.internal;

import io.github.resilience4j.bulkhead.ThreadPoolBulkhead;
import io.github.resilience4j.bulkhead.ThreadPoolBulkheadConfig;
import io.github.resilience4j.bulkhead.ThreadPoolBulkheadRegistry;
import io.github.resilience4j.core.ConfigurationNotFoundException;
import io.github.resilience4j.core.RegistryStore;
import io.github.resilience4j.core.registry.AbstractRegistry;
import io.github.resilience4j.core.registry.InMemoryRegistryStore;
import io.github.resilience4j.core.registry.RegistryEventConsumer;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;

public final class InMemoryThreadPoolBulkheadRegistry
extends AbstractRegistry<ThreadPoolBulkhead, ThreadPoolBulkheadConfig>
implements ThreadPoolBulkheadRegistry {
    public InMemoryThreadPoolBulkheadRegistry() {
        this(Collections.emptyMap());
    }

    public InMemoryThreadPoolBulkheadRegistry(Map<String, ThreadPoolBulkheadConfig> configs) {
        this(configs, Collections.emptyMap());
    }

    public InMemoryThreadPoolBulkheadRegistry(Map<String, ThreadPoolBulkheadConfig> configs, Map<String, String> tags) {
        this(configs.getOrDefault("default", ThreadPoolBulkheadConfig.ofDefaults()), tags);
        this.configurations.putAll(configs);
    }

    public InMemoryThreadPoolBulkheadRegistry(Map<String, ThreadPoolBulkheadConfig> configs, RegistryEventConsumer<ThreadPoolBulkhead> registryEventConsumer) {
        this(configs, registryEventConsumer, Collections.emptyMap());
    }

    public InMemoryThreadPoolBulkheadRegistry(Map<String, ThreadPoolBulkheadConfig> configs, RegistryEventConsumer<ThreadPoolBulkhead> registryEventConsumer, Map<String, String> tags) {
        this(configs.getOrDefault("default", ThreadPoolBulkheadConfig.ofDefaults()), registryEventConsumer, tags);
        this.configurations.putAll(configs);
    }

    public InMemoryThreadPoolBulkheadRegistry(Map<String, ThreadPoolBulkheadConfig> configs, List<RegistryEventConsumer<ThreadPoolBulkhead>> registryEventConsumers) {
        this(configs, registryEventConsumers, Collections.emptyMap());
    }

    public InMemoryThreadPoolBulkheadRegistry(Map<String, ThreadPoolBulkheadConfig> configs, List<RegistryEventConsumer<ThreadPoolBulkhead>> registryEventConsumers, Map<String, String> tags) {
        this(configs.getOrDefault("default", ThreadPoolBulkheadConfig.ofDefaults()), registryEventConsumers, tags);
        this.configurations.putAll(configs);
    }

    public InMemoryThreadPoolBulkheadRegistry(ThreadPoolBulkheadConfig defaultConfig) {
        super((Object)defaultConfig);
    }

    public InMemoryThreadPoolBulkheadRegistry(ThreadPoolBulkheadConfig defaultConfig, Map<String, String> tags) {
        super((Object)defaultConfig, tags);
    }

    public InMemoryThreadPoolBulkheadRegistry(ThreadPoolBulkheadConfig defaultConfig, RegistryEventConsumer<ThreadPoolBulkhead> registryEventConsumer) {
        super((Object)defaultConfig, registryEventConsumer);
    }

    public InMemoryThreadPoolBulkheadRegistry(ThreadPoolBulkheadConfig defaultConfig, RegistryEventConsumer<ThreadPoolBulkhead> registryEventConsumer, Map<String, String> tags) {
        super((Object)defaultConfig, registryEventConsumer, tags);
    }

    public InMemoryThreadPoolBulkheadRegistry(ThreadPoolBulkheadConfig defaultConfig, List<RegistryEventConsumer<ThreadPoolBulkhead>> registryEventConsumers) {
        super((Object)defaultConfig, registryEventConsumers);
    }

    public InMemoryThreadPoolBulkheadRegistry(ThreadPoolBulkheadConfig defaultConfig, List<RegistryEventConsumer<ThreadPoolBulkhead>> registryEventConsumers, Map<String, String> tags) {
        super((Object)defaultConfig, registryEventConsumers, tags);
    }

    public InMemoryThreadPoolBulkheadRegistry(Map<String, ThreadPoolBulkheadConfig> configs, List<RegistryEventConsumer<ThreadPoolBulkhead>> registryEventConsumers, Map<String, String> tags, RegistryStore<ThreadPoolBulkhead> registryStore) {
        super((Object)configs.getOrDefault("default", ThreadPoolBulkheadConfig.ofDefaults()), registryEventConsumers, Optional.ofNullable(tags).orElse(Collections.emptyMap()), Optional.ofNullable(registryStore).orElse((RegistryStore<ThreadPoolBulkhead>)new InMemoryRegistryStore()));
        this.configurations.putAll(configs);
    }

    @Override
    public Set<ThreadPoolBulkhead> getAllBulkheads() {
        return new HashSet<ThreadPoolBulkhead>(this.entryMap.values());
    }

    @Override
    public ThreadPoolBulkhead bulkhead(String name) {
        return this.bulkhead(name, Collections.emptyMap());
    }

    @Override
    public ThreadPoolBulkhead bulkhead(String name, Map<String, String> tags) {
        return this.bulkhead(name, (ThreadPoolBulkheadConfig)this.getDefaultConfig(), tags);
    }

    @Override
    public ThreadPoolBulkhead bulkhead(String name, ThreadPoolBulkheadConfig config) {
        return this.bulkhead(name, config, Collections.emptyMap());
    }

    @Override
    public ThreadPoolBulkhead bulkhead(String name, ThreadPoolBulkheadConfig config, Map<String, String> tags) {
        return (ThreadPoolBulkhead)this.computeIfAbsent(name, () -> ThreadPoolBulkhead.of(name, Objects.requireNonNull(config, "Config must not be null"), this.getAllTags(tags)));
    }

    @Override
    public ThreadPoolBulkhead bulkhead(String name, Supplier<ThreadPoolBulkheadConfig> bulkheadConfigSupplier) {
        return this.bulkhead(name, bulkheadConfigSupplier, Collections.emptyMap());
    }

    @Override
    public ThreadPoolBulkhead bulkhead(String name, Supplier<ThreadPoolBulkheadConfig> bulkheadConfigSupplier, Map<String, String> tags) {
        return (ThreadPoolBulkhead)this.computeIfAbsent(name, () -> ThreadPoolBulkhead.of(name, Objects.requireNonNull((ThreadPoolBulkheadConfig)Objects.requireNonNull(bulkheadConfigSupplier, "Supplier must not be null").get(), "Config must not be null"), this.getAllTags(tags)));
    }

    @Override
    public ThreadPoolBulkhead bulkhead(String name, String configName) {
        return this.bulkhead(name, configName, Collections.emptyMap());
    }

    @Override
    public ThreadPoolBulkhead bulkhead(String name, String configName, Map<String, String> tags) {
        return (ThreadPoolBulkhead)this.computeIfAbsent(name, () -> ThreadPoolBulkhead.of(name, (ThreadPoolBulkheadConfig)this.getConfiguration(configName).orElseThrow(() -> new ConfigurationNotFoundException(configName)), this.getAllTags(tags)));
    }

    @Override
    public void close() throws Exception {
        for (ThreadPoolBulkhead bulkhead : this.getAllBulkheads()) {
            bulkhead.close();
        }
    }
}

