/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overthere.cifs;

import com.xebialabs.overthere.ConnectionOptions;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.spi.AddressPortMapper;
import com.xebialabs.overthere.spi.ProcessConnection;
import com.xebialabs.overthere.telnet.TelnetConnection;
import com.xebialabs.overthere.winrm.WinRmConnection;
import com.xebialabs.overthere.winrs.WinrsConnection;

public enum CifsConnectionType {
    TELNET,
    WINRM_INTERNAL,
    WINRM_NATIVE;


    public int getDefaultPort(ConnectionOptions options) {
        switch (this) {
            case TELNET: {
                return 23;
            }
            case WINRM_INTERNAL: 
            case WINRM_NATIVE: {
                if (!options.getBoolean("winrmEnableHttps", false)) {
                    return 5985;
                }
                return 5986;
            }
        }
        throw new IllegalArgumentException("Unknown CIFS connection type " + this);
    }

    public ProcessConnection getProcessConnection(ConnectionOptions options, AddressPortMapper mapper, OverthereFile workingDirectory) {
        return switch (this) {
            case TELNET -> new TelnetConnection(options, mapper, workingDirectory);
            case WINRM_INTERNAL -> new WinRmConnection(options, mapper, workingDirectory);
            case WINRM_NATIVE -> new WinrsConnection(options, mapper, workingDirectory);
            default -> throw new IllegalArgumentException("Unknown CIFS connection type " + this);
        };
    }
}

