/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.cluster;

import com.typesafe.config.Config;
import java.io.Serializable;
import org.apache.pekko.actor.Actor;
import org.apache.pekko.actor.ActorContext;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.ActorSelection$;
import org.apache.pekko.actor.Address;
import org.apache.pekko.actor.CoordinatedShutdown;
import org.apache.pekko.actor.CoordinatedShutdown$;
import org.apache.pekko.actor.SupervisorStrategy;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.cluster.Cluster;
import org.apache.pekko.cluster.Cluster$;
import org.apache.pekko.cluster.ClusterLogMarker$;
import org.apache.pekko.cluster.ClusterUserAction;
import org.apache.pekko.cluster.ConfigUtil$;
import org.apache.pekko.cluster.ConfigValidation;
import org.apache.pekko.cluster.InternalClusterAction;
import org.apache.pekko.cluster.Invalid;
import org.apache.pekko.cluster.JoinConfigCompatChecker;
import org.apache.pekko.cluster.JoinConfigCompatChecker$;
import org.apache.pekko.cluster.Valid$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Some;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\u0005mcAB\f\u0019\u0003\u0003A\u0002\u0005\u0003\u0005.\u0001\t\u0005\t\u0015!\u00030\u0011\u0015\u0019\u0004\u0001\"\u00015\u0011\u001dI\u0002A1A\u0005\u0002]Baa\u000f\u0001!\u0002\u0013A\u0004b\u0002\u001f\u0001\u0005\u0004%\t!\u0010\u0005\u0007\u0003\u0002\u0001\u000b\u0011\u0002 \t\u000f\t\u0003!\u0019!C\u0005\u0007\"1A\n\u0001Q\u0001\n\u0011Cq!\u0014\u0001C\u0002\u0013%1\t\u0003\u0004O\u0001\u0001\u0006I\u0001\u0012\u0005\b\u001f\u0002\u0011\r\u0011\"\u0003D\u0011\u0019\u0001\u0006\u0001)A\u0005\t\"A\u0011\u000b\u0001EC\u0002\u0013%!\u000b\u0003\u0005W\u0001!\u0015\r\u0011\"\u0003X\u0011\u0015\u0011\u0007\u0001\"\u0003d\u0011\u0015\u0019\b\u0001\"\u0002u\u0011\u0015Q\b\u0001\"\u0002|\u0011\u001d\tI\u0001\u0001C\u0003\u0003\u0017Aq!!\n\u0001\t\u000b\t9\u0003C\u0004\u00020\u0001!I!!\r\t\u000f\u0005]\u0002\u0001\"\u0003\u0002:!9\u0011Q\t\u0001\u0005\n\u0005\u001d#aD*fK\u0012tu\u000eZ3Qe>\u001cWm]:\u000b\u0005eQ\u0012aB2mkN$XM\u001d\u0006\u00037q\tQ\u0001]3lW>T!!\b\u0010\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005y\u0012aA8sON\u0019\u0001!I\u0014\u0011\u0005\t*S\"A\u0012\u000b\u0003\u0011\nQa]2bY\u0006L!AJ\u0012\u0003\r\u0005s\u0017PU3g!\tA3&D\u0001*\u0015\tQ#$A\u0003bGR|'/\u0003\u0002-S\t)\u0011i\u0019;pe\u00069\"n\\5o\u0007>tg-[4D_6\u0004\u0018\r^\"iK\u000e\\WM]\u0002\u0001!\t\u0001\u0014'D\u0001\u0019\u0013\t\u0011\u0004DA\fK_&t7i\u001c8gS\u001e\u001cu.\u001c9bi\u000eCWmY6fe\u00061A(\u001b8jiz\"\"!\u000e\u001c\u0011\u0005A\u0002\u0001\"B\u0017\u0003\u0001\u0004yS#\u0001\u001d\u0011\u0005AJ\u0014B\u0001\u001e\u0019\u0005\u001d\u0019E.^:uKJ\f\u0001b\u00197vgR,'\u000fI\u0001\fg\u0016dg-\u00113ee\u0016\u001c8/F\u0001?!\tAs(\u0003\u0002AS\t9\u0011\t\u001a3sKN\u001c\u0018\u0001D:fY\u001a\fE\r\u001a:fgN\u0004\u0013A\t&pS:$v.\u00138d_6\u0004\u0018\r^5cY\u0016\u001cuN\u001c4jOVsWM\u001c4pe\u000e,G-F\u0001E!\t)%*D\u0001G\u0015\t9\u0005*\u0001\u0003mC:<'\"A%\u0002\t)\fg/Y\u0005\u0003\u0017\u001a\u0013aa\u0015;sS:<\u0017a\t&pS:$v.\u00138d_6\u0004\u0018\r^5cY\u0016\u001cuN\u001c4jOVsWM\u001c4pe\u000e,G\rI\u0001\u001c-\u0006d\u0017\u000eZ1uK\u0012LenY8na\u0006$\u0018N\u00197f\u0007>tg-[4\u00029Y\u000bG.\u001b3bi\u0016$\u0017J\\2p[B\fG/\u001b2mK\u000e{gNZ5hA\u0005\u0019bj\u001c3f'\",H\u000fZ8x]^\u000b'O\\5oO\u0006!bj\u001c3f'\",H\u000fZ8x]^\u000b'O\\5oO\u0002\nqB\\3fIN\f5n[1D_:4\u0017nZ\u000b\u0002'B\u0011!\u0005V\u0005\u0003+\u000e\u0012qAQ8pY\u0016\fg.A\u0006bW.\fg+\u001a:tS>tW#\u0001-\u0011\u0005e\u0003gB\u0001._!\tY6%D\u0001]\u0015\tif&\u0001\u0004=e>|GOP\u0005\u0003?\u000e\na\u0001\u0015:fI\u00164\u0017BA&b\u0015\ty6%\u0001\u0007ti>\u0004xJ\u001d\"fG>lW\r\u0006\u0002eOB\u0011!%Z\u0005\u0003M\u000e\u0012A!\u00168ji\")\u0001n\u0004a\u0001S\u0006A!-\u001a5bm&|'\u000fE\u0002#U2L!a[\u0012\u0003\r=\u0003H/[8o!\ti\u0007O\u0004\u0002)]&\u0011q.K\u0001\u0006\u0003\u000e$xN]\u0005\u0003cJ\u0014qAU3dK&4XM\u0003\u0002pS\u0005\u0019\"/Z2fSZ,'j\\5o'\u0016,GMT8eKR\u0011A-\u001e\u0005\u0006mB\u0001\ra^\u0001\ng\u0016,GMT8eKN\u00042!\u0017=?\u0013\tI\u0018MA\u0002TKR\fAE]3dK&4X-\u00138ji*{\u0017N\\!dW&s7m\\7qCRL'\r\\3D_:4\u0017n\u001a\u000b\u0006Irt\u0018q\u0001\u0005\u0006{F\u0001\rAP\u0001\u0007U>Lg\u000eV8\t\r}\f\u0002\u0019AA\u0001\u0003\u0019y'/[4j]B\u0019\u0001&a\u0001\n\u0007\u0005\u0015\u0011F\u0001\u0005BGR|'OU3g\u0011\u0015A\u0017\u00031\u0001j\u0003\t\u0012XmY3jm\u0016Le.\u001b;K_&t\u0017iY6D_6\u0004\u0018\r^5cY\u0016\u001cuN\u001c4jORIA-!\u0004\u0002\u0010\u0005E\u00111\u0005\u0005\u0006{J\u0001\rA\u0010\u0005\u0007\u007fJ\u0001\r!!\u0001\t\u000f\u0005M!\u00031\u0001\u0002\u0016\u0005Y1m\u001c8gS\u001e\u001c\u0005.Z2l!\u0011\t9\"!\b\u000f\u0007A\nI\"C\u0002\u0002\u001ca\tQ#\u00138uKJt\u0017\r\\\"mkN$XM]!di&|g.\u0003\u0003\u0002 \u0005\u0005\"\u0001E\"p[B\fG/\u001b2mK\u000e{gNZ5h\u0015\r\tY\u0002\u0007\u0005\u0006QJ\u0001\r![\u0001\"e\u0016\u001cW-\u001b<f\u0013:LGOS8j]\u0006\u001b7.\u00168dQ\u0016\u001c7.\u001a3D_:4\u0017n\u001a\u000b\bI\u0006%\u00121FA\u0017\u0011\u0015i8\u00031\u0001?\u0011\u0019y8\u00031\u0001\u0002\u0002!)\u0001n\u0005a\u0001S\u00061Bn\\4J]&$(j\\5o\u0003\u000e\\'+Z2fSZ,G\rF\u0002e\u0003gAq!!\u000e\u0015\u0001\u0004\t\t!\u0001\u0003ge>l\u0017A\u000b7pO^\u000b'O\\5oO&sg/\u00197jI\u000e{gNZ5h\u0013\u001a\u0014\u0015\u0010]1tg\u000e{gNZ5h\u0007\",7m\u001b\u000b\u0004I\u0006m\u0002bBA\u001f+\u0001\u0007\u0011qH\u0001\bS:4\u0018\r\\5e!\r\u0001\u0014\u0011I\u0005\u0004\u0003\u0007B\"aB%om\u0006d\u0017\u000eZ\u0001\u0016Y><WI\u001d:pe&sg/\u00197jI\u000e{gNZ5h)\r!\u0017\u0011\n\u0005\b\u0003\u00172\u0002\u0019AA \u0003)1\u0018\r\\5eCRLwN\u001c\u0015\u0004\u0001\u0005=\u0003\u0003BA)\u0003/j!!a\u0015\u000b\u0007\u0005U#$\u0001\u0006b]:|G/\u0019;j_:LA!!\u0017\u0002T\tY\u0011J\u001c;fe:\fG.\u00119j\u0001")
@InternalApi
public abstract class SeedNodeProcess
implements Actor {
    private boolean needsAkkaConfig;
    private String akkaVersion;
    private final JoinConfigCompatChecker joinConfigCompatChecker;
    private final Cluster cluster;
    private final Address selfAddress;
    private final String JoinToIncompatibleConfigUnenforced;
    private final String ValidatedIncompatibleConfig;
    private final String NodeShutdownWarning;
    private ActorContext context;
    private ActorRef self;
    private volatile byte bitmap$0;

    public final ActorRef sender() {
        return Actor.sender$((Actor)this);
    }

    @InternalApi
    public void aroundReceive(PartialFunction<Object, BoxedUnit> receive2, Object msg) {
        Actor.aroundReceive$((Actor)this, receive2, (Object)msg);
    }

    @InternalApi
    public void aroundPreStart() {
        Actor.aroundPreStart$((Actor)this);
    }

    @InternalApi
    public void aroundPostStop() {
        Actor.aroundPostStop$((Actor)this);
    }

    @InternalApi
    public void aroundPreRestart(Throwable reason, Option<Object> message) {
        Actor.aroundPreRestart$((Actor)this, (Throwable)reason, message);
    }

    @InternalApi
    public void aroundPostRestart(Throwable reason) {
        Actor.aroundPostRestart$((Actor)this, (Throwable)reason);
    }

    public SupervisorStrategy supervisorStrategy() {
        return Actor.supervisorStrategy$((Actor)this);
    }

    public void preStart() throws Exception {
        Actor.preStart$((Actor)this);
    }

    public void postStop() throws Exception {
        Actor.postStop$((Actor)this);
    }

    public void preRestart(Throwable reason, Option<Object> message) throws Exception {
        Actor.preRestart$((Actor)this, (Throwable)reason, message);
    }

    public void postRestart(Throwable reason) throws Exception {
        Actor.postRestart$((Actor)this, (Throwable)reason);
    }

    public void unhandled(Object message) {
        Actor.unhandled$((Actor)this, (Object)message);
    }

    public ActorContext context() {
        return this.context;
    }

    public final ActorRef self() {
        return this.self;
    }

    public void org$apache$pekko$actor$Actor$_setter_$context_$eq(ActorContext x$1) {
        this.context = x$1;
    }

    public final void org$apache$pekko$actor$Actor$_setter_$self_$eq(ActorRef x$1) {
        this.self = x$1;
    }

    public Cluster cluster() {
        return this.cluster;
    }

    public Address selfAddress() {
        return this.selfAddress;
    }

    private String JoinToIncompatibleConfigUnenforced() {
        return this.JoinToIncompatibleConfigUnenforced;
    }

    private String ValidatedIncompatibleConfig() {
        return this.ValidatedIncompatibleConfig;
    }

    private String NodeShutdownWarning() {
        return this.NodeShutdownWarning;
    }

    private boolean needsAkkaConfig$lzycompute() {
        SeedNodeProcess seedNodeProcess = this;
        synchronized (seedNodeProcess) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.needsAkkaConfig = this.context().system().settings().config().getStringList("pekko.remote.accept-protocol-names").contains("akka");
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.needsAkkaConfig;
    }

    private boolean needsAkkaConfig() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.needsAkkaConfig$lzycompute();
        }
        return this.needsAkkaConfig;
    }

    private String akkaVersion$lzycompute() {
        SeedNodeProcess seedNodeProcess = this;
        synchronized (seedNodeProcess) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                Config cfg = this.context().system().settings().config();
                this.akkaVersion = cfg.hasPath("akka.version") ? cfg.getString("akka.version") : cfg.getString("pekko.remote.akka.version");
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.akkaVersion;
    }

    private String akkaVersion() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.akkaVersion$lzycompute();
        }
        return this.akkaVersion;
    }

    private void stopOrBecome(Option<PartialFunction<Object, BoxedUnit>> behavior) {
        Option<PartialFunction<Object, BoxedUnit>> option = behavior;
        if (option instanceof Some) {
            Some some = (Some)option;
            PartialFunction done2 = (PartialFunction)some.value();
            this.context().become(done2);
            return;
        }
        if (None$.MODULE$.equals(option)) {
            this.context().stop(this.self());
            return;
        }
        throw new MatchError(option);
    }

    public final void receiveJoinSeedNode(Set<Address> seedNodes) {
        Seq<String> requiredNonSensitiveKeys = JoinConfigCompatChecker$.MODULE$.removeSensitiveKeys(this.joinConfigCompatChecker.requiredKeys(), this.cluster().settings());
        Config configToValidate = JoinConfigCompatChecker$.MODULE$.filterWithKeys(requiredNonSensitiveKeys, this.context().system().settings().config());
        Config adjustedConfig = this.needsAkkaConfig() ? ConfigUtil$.MODULE$.addAkkaConfig(configToValidate, this.akkaVersion()) : configToValidate;
        seedNodes.foreach((Function1 & Serializable)a -> {
            SeedNodeProcess.$anonfun$receiveJoinSeedNode$1(this, adjustedConfig, a);
            return BoxedUnit.UNIT;
        });
    }

    public final void receiveInitJoinAckIncompatibleConfig(Address joinTo, ActorRef origin, Option<PartialFunction<Object, BoxedUnit>> behavior) {
        if (this.cluster().settings().ByPassConfigCompatCheck()) {
            this.logInitJoinAckReceived(origin);
            this.cluster().ClusterLogger().logWarning("Joining cluster with incompatible configurations. {}", this.JoinToIncompatibleConfigUnenforced());
            this.context().parent().$bang((Object)new ClusterUserAction.JoinTo(joinTo), this.self());
            this.stopOrBecome(behavior);
            return;
        }
        this.cluster().ClusterLogger().logError(ClusterLogMarker$.MODULE$.joinFailed(), new StringBuilder(72).append("Couldn't join seed nodes because of incompatible cluster configuration. ").append(this.NodeShutdownWarning()).toString());
        this.context().stop(this.self());
        ((CoordinatedShutdown)CoordinatedShutdown$.MODULE$.apply(this.context().system())).run((CoordinatedShutdown.Reason)CoordinatedShutdown.IncompatibleConfigurationDetectedReason$.MODULE$);
    }

    public final void receiveInitJoinAckCompatibleConfig(Address joinTo, ActorRef origin, InternalClusterAction.CompatibleConfig configCheck, Option<PartialFunction<Object, BoxedUnit>> behavior) {
        this.logInitJoinAckReceived(origin);
        boolean bl = false;
        Invalid invalid = null;
        ConfigValidation configValidation = this.joinConfigCompatChecker.check(configCheck.clusterConfig(), this.context().system().settings().config());
        if (Valid$.MODULE$.equals(configValidation)) {
            this.context().parent().$bang((Object)new ClusterUserAction.JoinTo(joinTo), this.self());
            this.stopOrBecome(behavior);
            return;
        }
        if (configValidation instanceof Invalid) {
            bl = true;
            invalid = (Invalid)configValidation;
            if (this.cluster().settings().ByPassConfigCompatCheck()) {
                this.logWarningInvalidConfigIfBypassConfigCheck(invalid);
                this.context().parent().$bang((Object)new ClusterUserAction.JoinTo(joinTo), this.self());
                this.stopOrBecome(behavior);
                return;
            }
        }
        if (bl) {
            this.logErrorInvalidConfig(invalid);
            this.context().stop(this.self());
            ((CoordinatedShutdown)CoordinatedShutdown$.MODULE$.apply(this.context().system())).run((CoordinatedShutdown.Reason)CoordinatedShutdown.IncompatibleConfigurationDetectedReason$.MODULE$);
            return;
        }
        throw new MatchError((Object)configValidation);
    }

    public final void receiveInitJoinAckUncheckedConfig(Address joinTo, ActorRef origin, Option<PartialFunction<Object, BoxedUnit>> behavior) {
        this.logInitJoinAckReceived(origin);
        this.cluster().ClusterLogger().logWarning("Joining a cluster without configuration compatibility check feature.");
        this.context().parent().$bang((Object)new ClusterUserAction.JoinTo(joinTo), this.self());
        this.stopOrBecome(behavior);
    }

    private void logInitJoinAckReceived(ActorRef from) {
        this.cluster().ClusterLogger().logInfo("Received InitJoinAck message from [{}] to [{}]", from, (Object)this.selfAddress());
    }

    private void logWarningInvalidConfigIfBypassConfigCheck(Invalid invalid) {
        this.cluster().ClusterLogger().logWarning("{}: {}. {}.", (Object)this.ValidatedIncompatibleConfig(), (Object)invalid.errorMessages().mkString(", "), (Object)this.JoinToIncompatibleConfigUnenforced());
    }

    private void logErrorInvalidConfig(Invalid validation) {
        this.cluster().ClusterLogger().logError("{}: {}. {}", (Object)this.ValidatedIncompatibleConfig(), (Object)validation.errorMessages().mkString(", "), (Object)this.NodeShutdownWarning());
    }

    public static final /* synthetic */ void $anonfun$receiveJoinSeedNode$1(SeedNodeProcess $this, Config adjustedConfig$1, Address a) {
        ActorSelection$.MODULE$.toScala($this.context().actorSelection($this.context().parent().path().toStringWithAddress(a))).$bang((Object)new InternalClusterAction.InitJoin(adjustedConfig$1), $this.self());
    }

    public SeedNodeProcess(JoinConfigCompatChecker joinConfigCompatChecker) {
        this.joinConfigCompatChecker = joinConfigCompatChecker;
        Actor.$init$((Actor)this);
        this.cluster = (Cluster)Cluster$.MODULE$.apply(this.context().system());
        this.selfAddress = this.cluster().selfAddress();
        this.JoinToIncompatibleConfigUnenforced = "Join will be performed because compatibility check is configured to not be enforced.";
        this.ValidatedIncompatibleConfig = "Cluster validated this node config, but sent back incompatible settings";
        this.NodeShutdownWarning = "It's recommended to perform a full cluster shutdown in order to deploy this new version. If a cluster shutdown isn't an option, you may want to disable this protection by setting 'pekko.cluster.configuration-compatibility-check.enforce-on-join = off'. Note that disabling it will allow the formation of a cluster with nodes having incompatible configuration settings. This node will be shutdown!";
        Statics.releaseFence();
    }
}

