/*
 * Decompiled with CFR 0.152.
 */
package com.hierynomus.msfscc.fileinformation;

import com.hierynomus.msfscc.FileAttributes;
import com.hierynomus.protocol.commons.EnumWithValue;
import java.util.Date;

public class FileInfo {
    private byte[] fileId;
    private String fileName;
    private final Date creationTime;
    private final Date lastAccessTime;
    private final Date lastWriteTime;
    private final Date changeTime;
    private long fileAttributes;
    private long fileSize;
    private long accessMask;

    FileInfo(String fileName, byte[] fileId, Date creationTime, Date lastAccessTime, Date lastWriteTime, Date changeTime, long fileAttributes, long fileSize, long accessMask) {
        this.fileName = fileName;
        this.fileId = fileId;
        this.creationTime = creationTime;
        this.lastAccessTime = lastAccessTime;
        this.lastWriteTime = lastWriteTime;
        this.changeTime = changeTime;
        this.fileAttributes = fileAttributes;
        this.fileSize = fileSize;
        this.accessMask = accessMask;
    }

    public byte[] getFileId() {
        return this.fileId;
    }

    public String getFileName() {
        return this.fileName;
    }

    public long getFileAttributes() {
        return this.fileAttributes;
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public long getAccessMask() {
        return this.accessMask;
    }

    public Date getCreationTime() {
        return this.copyOf(this.creationTime);
    }

    public Date getLastAccessTime() {
        return this.copyOf(this.lastAccessTime);
    }

    public Date getLastWriteTime() {
        return this.copyOf(this.lastWriteTime);
    }

    public Date getChangeTime() {
        return this.copyOf(this.changeTime);
    }

    private Date copyOf(Date date) {
        return date != null ? new Date(date.getTime()) : null;
    }

    public String toString() {
        return "FileInfo{fileName='" + this.fileName + '\'' + "fileSize='" + this.fileSize + '\'' + ", fileAttributes=" + EnumWithValue.EnumUtils.toEnumSet(this.fileAttributes, FileAttributes.class) + '}';
    }
}

