/*
 * Decompiled with CFR 0.152.
 */
package com.hierynomus.mssmb2.messages;

import com.hierynomus.mssmb2.SMB2MessageCommandCode;
import com.hierynomus.mssmb2.SMB2Packet;
import com.hierynomus.mssmb2.messages.SMB2ChangeNotifyResponse;
import com.hierynomus.mssmb2.messages.SMB2Close;
import com.hierynomus.mssmb2.messages.SMB2CreateResponse;
import com.hierynomus.mssmb2.messages.SMB2Echo;
import com.hierynomus.mssmb2.messages.SMB2Flush;
import com.hierynomus.mssmb2.messages.SMB2IoctlResponse;
import com.hierynomus.mssmb2.messages.SMB2Logoff;
import com.hierynomus.mssmb2.messages.SMB2NegotiateResponse;
import com.hierynomus.mssmb2.messages.SMB2QueryDirectoryResponse;
import com.hierynomus.mssmb2.messages.SMB2QueryInfoResponse;
import com.hierynomus.mssmb2.messages.SMB2ReadResponse;
import com.hierynomus.mssmb2.messages.SMB2SessionSetup;
import com.hierynomus.mssmb2.messages.SMB2SetInfoResponse;
import com.hierynomus.mssmb2.messages.SMB2TreeConnectResponse;
import com.hierynomus.mssmb2.messages.SMB2TreeDisconnect;
import com.hierynomus.mssmb2.messages.SMB2WriteResponse;
import com.hierynomus.protocol.commons.buffer.Buffer;
import com.hierynomus.smbj.common.Check;
import com.hierynomus.smbj.common.SMBBuffer;
import com.hierynomus.smbj.common.SMBRuntimeException;

public class SMB2ResponseMessageFactory {
    public static SMB2Packet read(SMBBuffer buffer) throws Buffer.BufferException {
        Check.ensureEquals(buffer.readRawBytes(4), new byte[]{-2, 83, 77, 66}, "Could not find SMB2 Packet header");
        buffer.skip(8);
        SMB2MessageCommandCode command = SMB2MessageCommandCode.lookup(buffer.readUInt16());
        buffer.rpos(0);
        switch (command) {
            case SMB2_NEGOTIATE: {
                return new SMB2NegotiateResponse().read(buffer);
            }
            case SMB2_SESSION_SETUP: {
                return new SMB2SessionSetup().read(buffer);
            }
            case SMB2_TREE_CONNECT: {
                return new SMB2TreeConnectResponse().read(buffer);
            }
            case SMB2_TREE_DISCONNECT: {
                return new SMB2TreeDisconnect().read(buffer);
            }
            case SMB2_LOGOFF: {
                return new SMB2Logoff().read(buffer);
            }
            case SMB2_CREATE: {
                return new SMB2CreateResponse().read(buffer);
            }
            case SMB2_CHANGE_NOTIFY: {
                return new SMB2ChangeNotifyResponse().read(buffer);
            }
            case SMB2_QUERY_DIRECTORY: {
                return new SMB2QueryDirectoryResponse().read(buffer);
            }
            case SMB2_ECHO: {
                return new SMB2Echo().read(buffer);
            }
            case SMB2_READ: {
                return new SMB2ReadResponse().read(buffer);
            }
            case SMB2_CLOSE: {
                return new SMB2Close().read(buffer);
            }
            case SMB2_FLUSH: {
                return new SMB2Flush().read(buffer);
            }
            case SMB2_WRITE: {
                return new SMB2WriteResponse().read(buffer);
            }
            case SMB2_IOCTL: {
                return new SMB2IoctlResponse().read(buffer);
            }
            case SMB2_QUERY_INFO: {
                return new SMB2QueryInfoResponse().read(buffer);
            }
            case SMB2_SET_INFO: {
                return new SMB2SetInfoResponse().read(buffer);
            }
        }
        throw new SMBRuntimeException("Unknown SMB2 Message Command type: " + (Object)((Object)command));
    }
}

