/*
 * Decompiled with CFR 0.152.
 */
package com.hierynomus.smbj.share;

import com.hierynomus.mserref.NtStatus;
import com.hierynomus.msfscc.FileInformationClass;
import com.hierynomus.msfscc.fileinformation.FileInfo;
import com.hierynomus.msfscc.fileinformation.FileInformationFactory;
import com.hierynomus.mssmb2.SMB2FileId;
import com.hierynomus.mssmb2.SMB2MessageCommandCode;
import com.hierynomus.mssmb2.messages.SMB2QueryDirectoryRequest;
import com.hierynomus.mssmb2.messages.SMB2QueryDirectoryResponse;
import com.hierynomus.protocol.commons.buffer.Buffer;
import com.hierynomus.protocol.commons.concurrent.Futures;
import com.hierynomus.smbj.common.SMBApiException;
import com.hierynomus.smbj.connection.Connection;
import com.hierynomus.smbj.session.Session;
import com.hierynomus.smbj.share.DiskEntry;
import com.hierynomus.smbj.share.TreeConnect;
import com.hierynomus.smbj.transport.TransportException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Directory
extends DiskEntry {
    private static final Logger logger = LoggerFactory.getLogger(Directory.class);

    public Directory(SMB2FileId fileId, TreeConnect treeConnect, String fileName) {
        super(treeConnect, fileId, fileName);
    }

    public List<FileInfo> list() throws TransportException, SMBApiException {
        Session session = this.treeConnect.getSession();
        Connection connection = session.getConnection();
        int index = 0;
        int newDataLength = -1;
        ArrayList<FileInfo> fileList = new ArrayList<FileInfo>();
        do {
            SMB2QueryDirectoryRequest qdr;
            Future qdFuture;
            SMB2QueryDirectoryResponse qdResp;
            if ((qdResp = (SMB2QueryDirectoryResponse)Futures.get(qdFuture = session.send(qdr = new SMB2QueryDirectoryRequest(connection.getNegotiatedProtocol().getDialect(), session.getSessionId(), this.treeConnect.getTreeId(), this.getFileId(), FileInformationClass.FileIdBothDirectoryInformation, EnumSet.of(SMB2QueryDirectoryRequest.SMB2QueryDirectoryFlags.SMB2_INDEX_SPECIFIED), index, null)), TransportException.Wrapper)).getHeader().getStatus() == NtStatus.STATUS_NO_MORE_FILES) {
                newDataLength = 0;
                continue;
            }
            if (qdResp.getHeader().getStatus() != NtStatus.STATUS_SUCCESS) {
                throw new SMBApiException(qdResp.getHeader().getStatus(), qdResp.getHeader().getStatusCode(), SMB2MessageCommandCode.SMB2_QUERY_DIRECTORY, "Query directory failed for " + this.fileName + "/" + this.fileId);
            }
            byte[] outputBuffer = qdResp.getOutputBuffer();
            newDataLength = outputBuffer.length;
            index += newDataLength;
            try {
                fileList.addAll(FileInformationFactory.parseFileInformationList(outputBuffer, FileInformationClass.FileIdBothDirectoryInformation));
            }
            catch (Buffer.BufferException e) {
                throw new TransportException(e);
            }
        } while (newDataLength > 65000);
        return fileList;
    }

    @Override
    public SMB2FileId getFileId() {
        return this.fileId;
    }

    @Override
    public void closeSilently() {
        try {
            this.close();
        }
        catch (Exception e) {
            logger.warn("File close failed for {},{},{}", new Object[]{this.fileName, this.treeConnect, this.fileId, e});
        }
    }

    public String toString() {
        return String.format("File{fileId=%s, fileName='%s'}", this.fileId, this.fileName);
    }
}

