/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.license.filter;

import com.xebialabs.license.filter.LicenseCheckFilter;
import java.io.IOException;
import java.util.Arrays;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class LicenseRegistrationCheckFilter
extends LicenseCheckFilter {
    private static final String ALLOWED_URL = "/deployit/server/license/reload";

    private boolean isAcceptedHtml(HttpServletRequest httpRequest) {
        String headerValue = httpRequest.getHeader("Accept");
        return headerValue != null && Arrays.asList(headerValue.split(",")).contains("text/html");
    }

    @Override
    public void doFilter(ServletRequest request2, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request2;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        String registerUrl = "/register";
        String uri = httpRequest.getRequestURI();
        boolean isDummy = this.licenseService.getLicense().isDummyLicense();
        boolean isRegisterBased = uri.startsWith(registerUrl);
        if (uri.equals(ALLOWED_URL)) {
            super.doFilter(request2, response, chain);
            return;
        }
        if (!isDummy && isRegisterBased) {
            httpResponse.sendRedirect("/");
            return;
        }
        if (isDummy && !isRegisterBased) {
            if (!this.isAcceptedHtml(httpRequest)) {
                httpResponse.setStatus(403);
            } else {
                httpResponse.sendRedirect(registerUrl);
            }
            return;
        }
        super.doFilter(request2, response, chain);
    }
}

