/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.upgrade;

import com.xebialabs.deployit.jcr.JcrTemplate;
import com.xebialabs.deployit.server.api.repository.RawRepository;
import com.xebialabs.deployit.server.api.upgrade.JcrUpgrade;
import com.xebialabs.deployit.server.api.upgrade.RepoType;
import com.xebialabs.deployit.server.api.upgrade.Upgrade;
import com.xebialabs.deployit.server.api.upgrade.UpgradeException;
import com.xebialabs.deployit.upgrade.RawRepositoryImpl;
import com.xebialabs.deployit.upgrade.UpgradeStrategy;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;

public class JcrUpgradeStrategy
implements UpgradeStrategy {
    private JcrTemplate jcrTemplate;

    @Autowired
    public JcrUpgradeStrategy(JcrTemplate jcrTemplate) {
        this.jcrTemplate = jcrTemplate;
    }

    public Set<Class<? extends Upgrade>> findApplicableUpgradeTypes() {
        return UpgradeStrategy.findApplicableUpgradeTypes((RepoType)RepoType.JCR);
    }

    public void doUpgrades(List<Upgrade> upgrades) {
        this.jcrTemplate.login();
        try {
            this.jcrTemplate.execute(session -> {
                upgrades.forEach(applicableUpgrade -> {
                    if (applicableUpgrade instanceof JcrUpgrade) {
                        ((JcrUpgrade)applicableUpgrade).setRepository((RawRepository)new RawRepositoryImpl(session));
                    }
                    if (!applicableUpgrade.doUpgrade()) {
                        throw new UpgradeException("Could not perform upgrade %s to upgrade to %s", new Object[]{applicableUpgrade.getClass(), applicableUpgrade.upgradeVersion()});
                    }
                });
                session.save();
                return null;
            });
        }
        finally {
            this.jcrTemplate.logout();
        }
    }
}

