/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.cli.descriptor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.crsh.cli.descriptor.ArgumentDescriptor;
import org.crsh.cli.descriptor.Description;
import org.crsh.cli.descriptor.Format;
import org.crsh.cli.descriptor.OptionDescriptor;
import org.crsh.cli.descriptor.ParameterDescriptor;
import org.crsh.cli.impl.Multiplicity;
import org.crsh.cli.impl.completion.CompletionMatcher;
import org.crsh.cli.impl.descriptor.IntrospectionException;
import org.crsh.cli.impl.invocation.CommandInvoker;
import org.crsh.cli.impl.invocation.InvocationMatch;
import org.crsh.cli.impl.invocation.InvocationMatcher;

public abstract class CommandDescriptor<T> {
    private final String name;
    private final Description description;
    private final Map<String, OptionDescriptor> optionMap;
    private final Set<String> shortOptionNames;
    private final Set<String> longOptionNames;
    private boolean listArgument;
    private final List<OptionDescriptor> options;
    private final List<ArgumentDescriptor> arguments;
    private final List<ParameterDescriptor> parameters;
    private final Map<String, OptionDescriptor> uOptionMap;
    private final Set<String> uShortOptionNames;
    private final Set<String> uLongOptionNames;
    private final List<OptionDescriptor> uOptions;
    private final List<ArgumentDescriptor> uArguments;
    private final List<ParameterDescriptor> uParameters;

    protected CommandDescriptor(String name, Description description) throws IntrospectionException {
        int nameLength = name.length();
        if (nameLength == 0) {
            throw new IntrospectionException("Command name cannot be null");
        }
        for (int i = 0; i < nameLength; ++i) {
            char c = name.charAt(i);
            if (i == 0) {
                if (Character.isLetter(c)) continue;
                throw new IntrospectionException("Invalid command name <" + name + "> does not start with a letter");
            }
            if (Character.isLetter(c) || Character.isDigit(c) || c == '_' || c == '-') continue;
            throw new IntrospectionException("Invalid command name <" + name + "> char " + c + " at position " + i + " is now allowed");
        }
        this.description = description;
        this.optionMap = new LinkedHashMap<String, OptionDescriptor>();
        this.arguments = new ArrayList<ArgumentDescriptor>();
        this.options = new ArrayList<OptionDescriptor>();
        this.name = name;
        this.parameters = new ArrayList<ParameterDescriptor>();
        this.listArgument = false;
        this.shortOptionNames = new HashSet<String>();
        this.longOptionNames = new HashSet<String>();
        this.uOptionMap = Collections.unmodifiableMap(this.optionMap);
        this.uParameters = Collections.unmodifiableList(this.parameters);
        this.uOptions = Collections.unmodifiableList(this.options);
        this.uArguments = Collections.unmodifiableList(this.arguments);
        this.uShortOptionNames = this.shortOptionNames;
        this.uLongOptionNames = this.longOptionNames;
    }

    protected void addParameter(ParameterDescriptor parameter) throws IntrospectionException, NullPointerException, IllegalArgumentException {
        if (parameter == null) {
            throw new NullPointerException("No null parameter accepted");
        }
        if (parameter instanceof OptionDescriptor) {
            OptionDescriptor option = (OptionDescriptor)parameter;
            for (String optionName : option.getNames()) {
                String name;
                if (optionName.length() == 1) {
                    name = "-" + optionName;
                    if (this.shortOptionNames.contains(name)) {
                        throw new IntrospectionException("Duplicate option " + name);
                    }
                    this.shortOptionNames.add(name);
                } else {
                    name = "--" + optionName;
                    if (this.longOptionNames.contains(name)) {
                        throw new IntrospectionException();
                    }
                    this.longOptionNames.add(name);
                }
                this.optionMap.put(name, option);
            }
            this.options.add(option);
            ListIterator<ParameterDescriptor> i = this.parameters.listIterator();
            while (i.hasNext()) {
                ParameterDescriptor next = i.next();
                if (!(next instanceof ArgumentDescriptor)) continue;
                i.previous();
                break;
            }
            i.add(parameter);
        } else if (parameter instanceof ArgumentDescriptor) {
            ArgumentDescriptor argument = (ArgumentDescriptor)parameter;
            if (argument.getMultiplicity() == Multiplicity.MULTI) {
                if (this.listArgument) {
                    throw new IntrospectionException();
                }
                this.listArgument = true;
            }
            this.arguments.add(argument);
            this.parameters.add(argument);
        } else {
            throw new AssertionError((Object)"Unreachable");
        }
    }

    public abstract CommandDescriptor<T> getOwner();

    public final int getDepth() {
        CommandDescriptor<T> owner = this.getOwner();
        return owner == null ? 0 : 1 + owner.getDepth();
    }

    public final void printUsage(Appendable to) throws IOException {
        this.print(Format.USAGE, to);
    }

    public final void printMan(Appendable to) throws IOException {
        this.print(Format.MAN, to);
    }

    public final void print(Format format, Appendable to) throws IOException {
        format.print(this, to);
    }

    public abstract Map<String, ? extends CommandDescriptor<T>> getSubordinates();

    public final CommandDescriptor<T> getSubordinate(String name) {
        return this.getSubordinates().get(name);
    }

    public final List<ParameterDescriptor> getParameters() {
        return this.uParameters;
    }

    public final Set<String> getOptionNames() {
        return this.uOptionMap.keySet();
    }

    public final Set<String> getShortOptionNames() {
        return this.uShortOptionNames;
    }

    public final Set<String> getLongOptionNames() {
        return this.uLongOptionNames;
    }

    public final Collection<OptionDescriptor> getOptions() {
        return this.uOptions;
    }

    public final OptionDescriptor getOption(String name) {
        return this.optionMap.get(name);
    }

    public final OptionDescriptor resolveOption(String name) {
        CommandDescriptor<T> owner;
        OptionDescriptor option = this.getOption(name);
        if (option == null && (owner = this.getOwner()) != null) {
            option = owner.resolveOption(name);
        }
        return option;
    }

    public final List<ArgumentDescriptor> getArguments() {
        return this.uArguments;
    }

    public final ArgumentDescriptor getArgument(int index) throws IllegalArgumentException {
        if (index < 0) {
            throw new IllegalArgumentException();
        }
        if (index >= this.arguments.size()) {
            throw new IllegalArgumentException();
        }
        return this.arguments.get(index);
    }

    public final String getName() {
        return this.name;
    }

    public final Description getDescription() {
        return this.description;
    }

    public final String getUsage() {
        return this.description != null ? this.description.getUsage() : "";
    }

    public abstract CommandInvoker<T, ?> getInvoker(InvocationMatch<T> var1);

    public final InvocationMatcher<T> matcher() {
        return new InvocationMatcher(this);
    }

    public final CompletionMatcher<T> completer() {
        return new CompletionMatcher(this);
    }
}

