/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.resteasy;

import javax.ws.rs.WebApplicationException;
import javax.ws.rs.ext.Provider;
import org.jboss.resteasy.annotations.interception.ServerInterceptor;
import org.jboss.resteasy.core.ResourceMethodInvoker;
import org.jboss.resteasy.core.ServerResponse;
import org.jboss.resteasy.spi.Failure;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.interception.PostProcessInterceptor;
import org.jboss.resteasy.spi.interception.PreProcessInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@ServerInterceptor
@Component
@Provider
public class PathInterceptor
implements PreProcessInterceptor,
PostProcessInterceptor {
    public static final ThreadLocal<String> PATH = new ThreadLocal();
    private static final Logger logger = LoggerFactory.getLogger(PathInterceptor.class);

    public static void cleanup() {
        try {
            PATH.remove();
        }
        catch (Exception e) {
            logger.error("Error cleaning up after PathInterceptor", (Throwable)e);
        }
    }

    public void postProcess(ServerResponse response) {
        PathInterceptor.cleanup();
    }

    public ServerResponse preProcess(HttpRequest request, ResourceMethodInvoker method) throws Failure, WebApplicationException {
        PATH.set(request.getUri().getPath());
        return null;
    }
}

