/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.resteasy;

import com.xebialabs.deployit.core.rest.resteasy.Workdir;
import com.xebialabs.deployit.core.rest.resteasy.WorkdirHolder;
import com.xebialabs.deployit.io.TemporaryFiles;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.ext.Provider;
import org.jboss.resteasy.annotations.interception.ServerInterceptor;
import org.jboss.resteasy.core.ResourceMethodInvoker;
import org.jboss.resteasy.core.ServerResponse;
import org.jboss.resteasy.spi.Failure;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.interception.PostProcessInterceptor;
import org.jboss.resteasy.spi.interception.PreProcessInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Provider
@Component
@ServerInterceptor
public class WorkdirPrePostProcessorInterceptor
implements PreProcessInterceptor,
PostProcessInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(WorkdirPrePostProcessorInterceptor.class);

    public void postProcess(ServerResponse response) {
        WorkdirPrePostProcessorInterceptor.cleanup();
    }

    public static void cleanup() {
        try {
            TemporaryFiles.clear();
            WorkdirHolder.clear();
        }
        catch (Exception e) {
            logger.error("Error cleaning up after WorkdirPrePostProcessorInterceptor", (Throwable)e);
        }
    }

    public ServerResponse preProcess(HttpRequest request, ResourceMethodInvoker method) throws Failure, WebApplicationException {
        if (method.getResourceClass().isAnnotationPresent(Workdir.class)) {
            logger.debug("Creating workdir for request...");
            WorkdirHolder.initWorkdir();
        }
        return null;
    }
}

