/*
 * Decompiled with CFR 0.152.
 */
package io.aeron;

import io.aeron.Subscription;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.agrona.collections.Int2ObjectHashMap;

class ActiveSubscriptions {
    private final Int2ObjectHashMap<List<Subscription>> subscriptionsByStreamIdMap = new Int2ObjectHashMap();

    ActiveSubscriptions() {
    }

    public void forEach(int streamId, Consumer<Subscription> consumer) {
        List subscriptions = (List)this.subscriptionsByStreamIdMap.get(streamId);
        if (null != subscriptions) {
            subscriptions.forEach(consumer);
        }
    }

    public void add(Subscription subscription) {
        ((List)this.subscriptionsByStreamIdMap.computeIfAbsent(subscription.streamId(), ignore -> new ArrayList())).add(subscription);
    }

    public void remove(Subscription subscription) {
        int streamId = subscription.streamId();
        List subscriptions = (List)this.subscriptionsByStreamIdMap.get(streamId);
        if (null != subscriptions && subscriptions.remove(subscription) && subscriptions.isEmpty()) {
            this.subscriptionsByStreamIdMap.remove(streamId);
        }
    }

    public void close() {
        this.subscriptionsByStreamIdMap.values().stream().flatMap(Collection::stream).collect(Collectors.toList()).forEach(Subscription::close);
    }
}

