/*
 * Decompiled with CFR 0.152.
 */
package akka.http.impl.engine.parsing;

import akka.NotUsed;
import akka.http.impl.engine.parsing.HttpHeaderParser;
import akka.http.impl.engine.parsing.HttpMessageParser;
import akka.http.impl.engine.parsing.HttpMessageParser$;
import akka.http.impl.engine.parsing.NotEnoughDataException$;
import akka.http.impl.engine.parsing.ParserOutput;
import akka.http.impl.engine.parsing.ParserOutput$MessageEnd$;
import akka.http.impl.engine.parsing.ParserOutput$NeedMoreData$;
import akka.http.impl.engine.parsing.ParserOutput$StreamEnd$;
import akka.http.impl.engine.parsing.ParsingException;
import akka.http.impl.engine.parsing.package$;
import akka.http.impl.model.parser.CharacterClasses$;
import akka.http.scaladsl.model.ContentType;
import akka.http.scaladsl.model.ContentTypes$;
import akka.http.scaladsl.model.EntityStreamException;
import akka.http.scaladsl.model.ErrorInfo;
import akka.http.scaladsl.model.HttpEntity;
import akka.http.scaladsl.model.HttpEntity$;
import akka.http.scaladsl.model.HttpEntity$LastChunk$;
import akka.http.scaladsl.model.HttpHeader;
import akka.http.scaladsl.model.HttpMessage$;
import akka.http.scaladsl.model.HttpProtocol;
import akka.http.scaladsl.model.HttpProtocols$;
import akka.http.scaladsl.model.IllegalHeaderException;
import akka.http.scaladsl.model.StatusCode;
import akka.http.scaladsl.model.StatusCodes$;
import akka.http.scaladsl.model.headers.Connection;
import akka.http.scaladsl.model.headers.Content$minusLength;
import akka.http.scaladsl.model.headers.Content$minusType;
import akka.http.scaladsl.model.headers.EmptyHeader$;
import akka.http.scaladsl.model.headers.Expect;
import akka.http.scaladsl.model.headers.Host;
import akka.http.scaladsl.model.headers.Tls$minusSession$minusInfo;
import akka.http.scaladsl.model.headers.Transfer$minusEncoding;
import akka.parboiled2.CharUtils$;
import akka.stream.TLSProtocol;
import akka.stream.scaladsl.Source;
import akka.util.ByteString;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ListBuffer;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class HttpMessageParser$class {
    public static final ListBuffer initialHeaderBuffer(HttpMessageParser $this) {
        return $this.settings().includeTlsSessionInfoHeader() && $this.akka$http$impl$engine$parsing$HttpMessageParser$$tlsSessionInfoHeader() != null ? new ListBuffer().$plus$eq((Object)$this.akka$http$impl$engine$parsing$HttpMessageParser$$tlsSessionInfoHeader()) : new ListBuffer();
    }

    public static final ParserOutput parseSessionBytes(HttpMessageParser $this, TLSProtocol.SessionBytes input) {
        if (input.session() != $this.akka$http$impl$engine$parsing$HttpMessageParser$$lastSession()) {
            $this.akka$http$impl$engine$parsing$HttpMessageParser$$lastSession_$eq(input.session());
            $this.akka$http$impl$engine$parsing$HttpMessageParser$$tlsSessionInfoHeader_$eq(new Tls$minusSession$minusInfo(input.session()));
        }
        return $this.parseBytes(input.bytes());
    }

    public static final ParserOutput parseBytes(HttpMessageParser $this, ByteString input) {
        if ($this.result().nonEmpty()) {
            throw new IllegalStateException("Unexpected `onPush`");
        }
        HttpMessageParser$class.run$1($this, $this.akka$http$impl$engine$parsing$HttpMessageParser$$state(), input);
        return $this.doPull();
    }

    /*
     * WARNING - void declaration
     */
    public static final ParserOutput doPull(HttpMessageParser $this) {
        Serializable serializable;
        if ($this.result().nonEmpty()) {
            void var1_1;
            ParserOutput head = (ParserOutput)$this.result().head();
            $this.result().remove(0);
            serializable = var1_1;
        } else {
            serializable = $this.terminated() ? ParserOutput$StreamEnd$.MODULE$ : ParserOutput$NeedMoreData$.MODULE$;
        }
        return serializable;
    }

    public static final boolean shouldComplete(HttpMessageParser $this) {
        Option option;
        block4: {
            block3: {
                block2: {
                    option = (Option)$this.completionHandling().apply();
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    ParserOutput.ErrorOutput x = (ParserOutput.ErrorOutput)some.x();
                    $this.emit(x);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block3;
                }
                if (!None$.MODULE$.equals(option)) break block4;
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            $this.terminated_$eq(true);
            return $this.result().isEmpty();
        }
        throw new MatchError((Object)option);
    }

    public static final HttpMessageParser.StateResult startNewMessage(HttpMessageParser $this, ByteString input, int offset) {
        Throwable throwable2;
        block3: {
            HttpMessageParser.StateResult stateResult;
            if (offset < input.length()) {
                $this.setCompletionHandling(HttpMessageParser$.MODULE$.CompletionIsMessageStartError());
            }
            try {
                stateResult = $this.parseMessage(input, offset);
            }
            catch (Throwable throwable2) {
                HttpMessageParser.StateResult stateResult2;
                Throwable throwable3 = throwable2;
                if (!NotEnoughDataException$.MODULE$.equals(throwable3)) break block3;
                stateResult = stateResult2 = $this.continue(input, offset, (Function2<ByteString, Object, HttpMessageParser.StateResult>)new Serializable($this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ HttpMessageParser $outer;

                    public final HttpMessageParser.StateResult apply(ByteString input, int offset) {
                        return this.$outer.startNewMessage(input, offset);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            return stateResult;
        }
        throw throwable2;
    }

    public static final int parseProtocol(HttpMessageParser $this, ByteString input, int cursor) {
        if (HttpMessageParser$class.c$1($this, 0, input, cursor) == 'H' && HttpMessageParser$class.c$1($this, 1, input, cursor) == 'T' && HttpMessageParser$class.c$1($this, 2, input, cursor) == 'T' && HttpMessageParser$class.c$1($this, 3, input, cursor) == 'P' && HttpMessageParser$class.c$1($this, 4, input, cursor) == '/' && HttpMessageParser$class.c$1($this, 5, input, cursor) == '1' && HttpMessageParser$class.c$1($this, 6, input, cursor) == '.') {
            HttpProtocol httpProtocol;
            char c = HttpMessageParser$class.c$1($this, 7, input, cursor);
            switch (c) {
                default: {
                    throw $this.onBadProtocol();
                }
                case '1': {
                    httpProtocol = HttpProtocols$.MODULE$.HTTP$div1$u002E1();
                    break;
                }
                case '0': {
                    httpProtocol = HttpProtocols$.MODULE$.HTTP$div1$u002E0();
                }
            }
            $this.akka$http$impl$engine$parsing$HttpMessageParser$$protocol_$eq(httpProtocol);
            return cursor + 8;
        }
        throw $this.onBadProtocol();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final HttpMessageParser.StateResult parseHeaderLines(HttpMessageParser $this, ByteString input, int lineStart, ListBuffer headers, int headerCount, Option ch, Option clh, Option cth, Option teh, boolean e100c, boolean hh) {
        while (true) {
            void var12_11;
            HttpHeader httpHeader;
            block24: {
                Host host2;
                block25: {
                    HttpMessageParser.StateResult stateResult;
                    HttpMessageParser.StateResult stateResult2;
                    block20: {
                        block23: {
                            HttpMessageParser.StateResult stateResult3;
                            block22: {
                                HttpMessageParser.StateResult stateResult4;
                                block21: {
                                    block19: {
                                        HttpHeader resultHeader;
                                        HttpHeader httpHeader2;
                                        if (headerCount >= $this.settings().maxHeaderCount()) {
                                            stateResult2 = $this.failMessageStart(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"HTTP message contains more than the configured limit of ", " headers"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)$this.settings().maxHeaderCount())})));
                                            return stateResult2;
                                        }
                                        int lineEnd = 0;
                                        try {
                                            HttpHeaderParser qual$1 = $this.headerParser();
                                            ByteString x$9 = input;
                                            int x$10 = lineStart;
                                            int x$11 = qual$1.parseHeaderLine$default$3(x$9, x$10);
                                            int x$12 = qual$1.parseHeaderLine$default$4(x$9, x$10);
                                            lineEnd = qual$1.parseHeaderLine(x$9, x$10, x$11, x$12);
                                            httpHeader2 = $this.headerParser().resultHeader();
                                        }
                                        catch (Throwable throwable) {
                                            HttpHeader httpHeader3;
                                            Throwable throwable2 = throwable;
                                            if (!NotEnoughDataException$.MODULE$.equals(throwable2)) throw throwable;
                                            httpHeader2 = httpHeader3 = null;
                                        }
                                        if ((httpHeader = (resultHeader = httpHeader2)) != null) break block19;
                                        stateResult = $this.continue(input, lineStart, (Function2<ByteString, Object, HttpMessageParser.StateResult>)new Serializable($this, headers, headerCount, ch, clh, cth, teh, e100c, hh){
                                            public static final long serialVersionUID = 0L;
                                            private final /* synthetic */ HttpMessageParser $outer;
                                            private final ListBuffer headers$1;
                                            private final int headerCount$1;
                                            private final Option ch$1;
                                            private final Option clh$1;
                                            private final Option cth$1;
                                            private final Option teh$1;
                                            private final boolean e100c$1;
                                            private final boolean hh$1;

                                            public final HttpMessageParser.StateResult apply(ByteString input, int lineStart) {
                                                return HttpMessageParser$class.akka$http$impl$engine$parsing$HttpMessageParser$$parseHeaderLinesAux(this.$outer, this.headers$1, this.headerCount$1, this.ch$1, this.clh$1, this.cth$1, this.teh$1, this.e100c$1, this.hh$1, input, lineStart);
                                            }
                                            {
                                                void var7_7;
                                                void var6_6;
                                                void var5_5;
                                                void var4_4;
                                                if ($outer == null) {
                                                    throw null;
                                                }
                                                this.$outer = $outer;
                                                this.headers$1 = headers$1;
                                                this.headerCount$1 = headerCount$1;
                                                this.ch$1 = var4_4;
                                                this.clh$1 = var5_5;
                                                this.cth$1 = var6_6;
                                                this.teh$1 = var7_7;
                                                this.e100c$1 = e100c$1;
                                                this.hh$1 = hh$1;
                                            }
                                        });
                                        break block20;
                                    }
                                    if (!EmptyHeader$.MODULE$.equals(httpHeader)) break block21;
                                    boolean close = HttpMessage$.MODULE$.connectionCloseExpected($this.akka$http$impl$engine$parsing$HttpMessageParser$$protocol(), (Option<Connection>)ch);
                                    $this.setCompletionHandling(HttpMessageParser$.MODULE$.CompletionIsEntityStreamError());
                                    stateResult = $this.parseEntity((List<HttpHeader>)headers.toList(), $this.akka$http$impl$engine$parsing$HttpMessageParser$$protocol(), input, (int)var12_11, (Option<Content$minusLength>)clh, (Option<Content$minusType>)cth, (Option<Transfer$minusEncoding>)teh, e100c, hh, close);
                                    break block20;
                                }
                                if (!(httpHeader instanceof Content$minusLength)) break block22;
                                Content$minusLength content$minusLength = (Content$minusLength)httpHeader;
                                Option option = clh;
                                if (None$.MODULE$.equals(option)) {
                                    clh = new Some((Object)content$minusLength);
                                    ++headerCount;
                                    lineStart = var12_11;
                                    continue;
                                }
                                if (option instanceof Some) {
                                    Some some = (Some)option;
                                    Content$minusLength content$minusLength2 = (Content$minusLength)some.x();
                                    Content$minusLength content$minusLength3 = content$minusLength;
                                    Content$minusLength content$minusLength4 = content$minusLength2;
                                    if (!(content$minusLength3 != null ? !((Object)content$minusLength3).equals(content$minusLength4) : content$minusLength4 != null)) {
                                        lineStart = var12_11;
                                        continue;
                                    }
                                }
                                stateResult = stateResult4 = $this.failMessageStart("HTTP message must not contain more than one Content-Length header");
                                break block20;
                            }
                            if (!(httpHeader instanceof Content$minusType)) break block23;
                            Content$minusType content$minusType = (Content$minusType)httpHeader;
                            Option option = cth;
                            if (None$.MODULE$.equals(option)) {
                                cth = new Some((Object)content$minusType);
                                ++headerCount;
                                lineStart = var12_11;
                                continue;
                            }
                            if (option instanceof Some) {
                                Some some = (Some)option;
                                Content$minusType content$minusType2 = (Content$minusType)some.x();
                                Content$minusType content$minusType3 = content$minusType;
                                Content$minusType content$minusType4 = content$minusType2;
                                if (!(content$minusType3 != null ? !((Object)content$minusType3).equals(content$minusType4) : content$minusType4 != null)) {
                                    lineStart = var12_11;
                                    continue;
                                }
                            }
                            stateResult = stateResult3 = $this.failMessageStart("HTTP message must not contain more than one Content-Type header");
                            break block20;
                        }
                        if (httpHeader instanceof Transfer$minusEncoding) {
                            Transfer$minusEncoding transfer$minusEncoding = (Transfer$minusEncoding)httpHeader;
                            Option option = teh;
                            if (None$.MODULE$.equals(option)) {
                                teh = new Some((Object)transfer$minusEncoding);
                                ++headerCount;
                                lineStart = var12_11;
                                continue;
                            }
                            if (!(option instanceof Some)) throw new MatchError((Object)option);
                            Some some = (Some)option;
                            Transfer$minusEncoding x = (Transfer$minusEncoding)some.x();
                            teh = new Some((Object)x.append(transfer$minusEncoding.encodings()));
                            lineStart = var12_11;
                            continue;
                        }
                        if (httpHeader instanceof Connection) {
                            Connection connection = (Connection)httpHeader;
                            Option option = ch;
                            if (None$.MODULE$.equals(option)) {
                                ch = new Some((Object)connection);
                                ++headerCount;
                                headers = headers.$plus$eq((Object)connection);
                                lineStart = var12_11;
                                continue;
                            }
                            if (!(option instanceof Some)) throw new MatchError((Object)option);
                            Some some = (Some)option;
                            Connection x = (Connection)some.x();
                            ch = new Some((Object)x.append(connection.tokens()));
                            lineStart = var12_11;
                            continue;
                        }
                        if (!(httpHeader instanceof Host)) break block24;
                        host2 = (Host)httpHeader;
                        if (!hh) break block25;
                        stateResult = $this.failMessageStart("HTTP message must not contain more than one Host header");
                    }
                    stateResult2 = stateResult;
                    return stateResult2;
                }
                hh = true;
                ++headerCount;
                headers = headers.$plus$eq((Object)host2);
                lineStart = var12_11;
                continue;
            }
            if (httpHeader instanceof Expect) {
                Expect expect = (Expect)httpHeader;
                e100c = true;
                ++headerCount;
                headers = headers.$plus$eq((Object)expect);
                lineStart = var12_11;
                continue;
            }
            ++headerCount;
            headers = headers.$plus$eq((Object)httpHeader);
            lineStart = var12_11;
        }
    }

    public static final ListBuffer parseHeaderLines$default$3(HttpMessageParser $this) {
        return $this.initialHeaderBuffer();
    }

    public static final int parseHeaderLines$default$4(HttpMessageParser $this) {
        return 0;
    }

    public static final Option parseHeaderLines$default$5(HttpMessageParser $this) {
        return None$.MODULE$;
    }

    public static final Option parseHeaderLines$default$6(HttpMessageParser $this) {
        return None$.MODULE$;
    }

    public static final Option parseHeaderLines$default$7(HttpMessageParser $this) {
        return None$.MODULE$;
    }

    public static final Option parseHeaderLines$default$8(HttpMessageParser $this) {
        return None$.MODULE$;
    }

    public static final boolean parseHeaderLines$default$9(HttpMessageParser $this) {
        return false;
    }

    public static final boolean parseHeaderLines$default$10(HttpMessageParser $this) {
        return false;
    }

    public static HttpMessageParser.StateResult akka$http$impl$engine$parsing$HttpMessageParser$$parseHeaderLinesAux(HttpMessageParser $this, ListBuffer headers, int headerCount, Option ch, Option clh, Option cth, Option teh, boolean e100c, boolean hh, ByteString input, int lineStart) {
        return $this.parseHeaderLines(input, lineStart, (ListBuffer<HttpHeader>)headers, headerCount, (Option<Connection>)ch, (Option<Content$minusLength>)clh, (Option<Content$minusType>)cth, (Option<Transfer$minusEncoding>)teh, e100c, hh);
    }

    public static final HttpMessageParser.StateResult parseFixedLengthBody(HttpMessageParser $this, long remainingBodyBytes, boolean isLastMessage, ByteString input, int bodyStart) {
        HttpMessageParser.StateResult stateResult;
        int remainingInputBytes = input.length() - bodyStart;
        if (remainingInputBytes > 0) {
            if ((long)remainingInputBytes < remainingBodyBytes) {
                $this.emit(new ParserOutput.EntityPart((ByteString)input.drop(bodyStart).compact()));
                long l = remainingBodyBytes - (long)remainingInputBytes;
                stateResult = $this.continue((Function2<ByteString, Object, HttpMessageParser.StateResult>)new Serializable($this, l, isLastMessage){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ HttpMessageParser $outer;
                    private final long eta$0$1$1;
                    private final boolean isLastMessage$1;

                    public final HttpMessageParser.StateResult apply(ByteString input, int bodyStart) {
                        return this.$outer.parseFixedLengthBody(this.eta$0$1$1, this.isLastMessage$1, input, bodyStart);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.eta$0$1$1 = eta$0$1$1;
                        this.isLastMessage$1 = isLastMessage$1;
                    }
                });
            } else {
                int offset = bodyStart + (int)remainingBodyBytes;
                $this.emit(new ParserOutput.EntityPart((ByteString)input.slice(bodyStart, offset).compact()));
                $this.emit(ParserOutput$MessageEnd$.MODULE$);
                $this.setCompletionHandling(HttpMessageParser$.MODULE$.CompletionOk());
                stateResult = isLastMessage ? $this.terminate() : $this.startNewMessage(input, offset);
            }
        } else {
            stateResult = $this.continue(input, bodyStart, (Function2<ByteString, Object, HttpMessageParser.StateResult>)new Serializable($this, remainingBodyBytes, isLastMessage){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ HttpMessageParser $outer;
                private final long remainingBodyBytes$1;
                private final boolean isLastMessage$1;

                public final HttpMessageParser.StateResult apply(ByteString input, int bodyStart) {
                    return this.$outer.parseFixedLengthBody(this.remainingBodyBytes$1, this.isLastMessage$1, input, bodyStart);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.remainingBodyBytes$1 = remainingBodyBytes$1;
                    this.isLastMessage$1 = isLastMessage$1;
                }
            });
        }
        return stateResult;
    }

    public static final HttpMessageParser.StateResult parseChunk(HttpMessageParser $this, ByteString input, int offset, boolean isLastMessage, long totalBytesRead) {
        Throwable throwable2;
        block2: {
            HttpMessageParser.StateResult stateResult;
            try {
                stateResult = HttpMessageParser$class.parseSize$1($this, offset, 0L, input, offset, isLastMessage, totalBytesRead);
            }
            catch (Throwable throwable2) {
                HttpMessageParser.StateResult stateResult2;
                Throwable throwable3 = throwable2;
                if (!NotEnoughDataException$.MODULE$.equals(throwable3)) break block2;
                stateResult = stateResult2 = $this.continue(input, offset, (Function2<ByteString, Object, HttpMessageParser.StateResult>)new Serializable($this, isLastMessage, totalBytesRead){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ HttpMessageParser $outer;
                    private final boolean isLastMessage$2;
                    private final long totalBytesRead$1;

                    public final HttpMessageParser.StateResult apply(ByteString x$4, int x$5) {
                        return this.$outer.parseChunk(x$4, x$5, this.isLastMessage$2, this.totalBytesRead$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.isLastMessage$2 = isLastMessage$2;
                        this.totalBytesRead$1 = totalBytesRead$1;
                    }
                });
            }
            return stateResult;
        }
        throw throwable2;
    }

    public static void emit(HttpMessageParser $this, ParserOutput output) {
        $this.result().$plus$eq((Object)output);
    }

    public static final HttpMessageParser.StateResult continue(HttpMessageParser $this, ByteString input, int offset, Function2 next) {
        Object object;
        int n = scala.math.package$.MODULE$.signum(offset - input.length());
        switch (n) {
            default: {
                throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
            }
            case 1: {
                throw new IllegalStateException();
            }
            case 0: {
                object = new Serializable($this, next){
                    public static final long serialVersionUID = 0L;
                    private final Function2 next$1;

                    public final HttpMessageParser.StateResult apply(ByteString x$6) {
                        return (HttpMessageParser.StateResult)this.next$1.apply((Object)x$6, (Object)BoxesRunTime.boxToInteger((int)0));
                    }
                    {
                        this.next$1 = next$1;
                    }
                };
                break;
            }
            case -1: {
                ByteString remaining = input.drop(offset);
                object = new Serializable($this, remaining, next){
                    public static final long serialVersionUID = 0L;
                    private final ByteString remaining$1;
                    private final Function2 next$1;

                    public final HttpMessageParser.StateResult apply(ByteString more) {
                        return (HttpMessageParser.StateResult)this.next$1.apply((Object)this.remaining$1.$plus$plus(more), (Object)BoxesRunTime.boxToInteger((int)0));
                    }
                    {
                        void var3_3;
                        this.remaining$1 = remaining$1;
                        this.next$1 = var3_3;
                    }
                };
            }
        }
        $this.akka$http$impl$engine$parsing$HttpMessageParser$$state_$eq((Function1)object);
        return HttpMessageParser$class.done($this);
    }

    public static final HttpMessageParser.StateResult continue(HttpMessageParser $this, Function2 next) {
        $this.akka$http$impl$engine$parsing$HttpMessageParser$$state_$eq((Function1)new Serializable($this, next){
            public static final long serialVersionUID = 0L;
            private final Function2 next$2;

            public final HttpMessageParser.StateResult apply(ByteString x$7) {
                return (HttpMessageParser.StateResult)this.next$2.apply((Object)x$7, (Object)BoxesRunTime.boxToInteger((int)0));
            }
            {
                this.next$2 = next$2;
            }
        });
        return HttpMessageParser$class.done($this);
    }

    public static final HttpMessageParser.StateResult failMessageStart(HttpMessageParser $this, String summary) {
        return $this.failMessageStart(summary, "");
    }

    public static final HttpMessageParser.StateResult failMessageStart(HttpMessageParser $this, String summary, String detail) {
        return $this.failMessageStart(StatusCodes$.MODULE$.BadRequest(), summary, detail);
    }

    public static final HttpMessageParser.StateResult failMessageStart(HttpMessageParser $this, StatusCode status) {
        return $this.failMessageStart(status, status.defaultMessage(), $this.failMessageStart$default$3());
    }

    public static final HttpMessageParser.StateResult failMessageStart(HttpMessageParser $this, StatusCode status, String summary, String detail) {
        return $this.failMessageStart(status, new ErrorInfo(summary, detail));
    }

    public static final HttpMessageParser.StateResult failMessageStart(HttpMessageParser $this, StatusCode status, ErrorInfo info) {
        $this.emit(new ParserOutput.MessageStartError(status, info));
        $this.setCompletionHandling(HttpMessageParser$.MODULE$.CompletionOk());
        return $this.terminate();
    }

    public static final String failMessageStart$default$3(HttpMessageParser $this) {
        return "";
    }

    public static final HttpMessageParser.StateResult failEntityStream(HttpMessageParser $this, String summary) {
        return $this.failEntityStream(summary, "");
    }

    public static final HttpMessageParser.StateResult failEntityStream(HttpMessageParser $this, String summary, String detail) {
        return $this.failEntityStream(new ErrorInfo(summary, detail));
    }

    public static final HttpMessageParser.StateResult failEntityStream(HttpMessageParser $this, ErrorInfo info) {
        $this.emit(new ParserOutput.EntityStreamError(info));
        $this.setCompletionHandling(HttpMessageParser$.MODULE$.CompletionOk());
        return $this.terminate();
    }

    public static final HttpMessageParser.StateResult terminate(HttpMessageParser $this) {
        $this.terminated_$eq(true);
        return HttpMessageParser$class.done($this);
    }

    private static HttpMessageParser.StateResult done(HttpMessageParser $this) {
        return null;
    }

    public static final ContentType contentType(HttpMessageParser $this, Option cth) {
        Option option;
        block4: {
            ContentType contentType;
            block3: {
                block2: {
                    option = cth;
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    Content$minusType x = (Content$minusType)some.x();
                    contentType = x.contentType();
                    break block3;
                }
                if (!None$.MODULE$.equals(option)) break block4;
                contentType = ContentTypes$.MODULE$.application$divoctet$minusstream();
            }
            return contentType;
        }
        throw new MatchError((Object)option);
    }

    public static final ParserOutput.StrictEntityCreator emptyEntity(HttpMessageParser $this, Option cth) {
        return new ParserOutput.StrictEntityCreator(cth.isDefined() ? HttpEntity$.MODULE$.empty(((Content$minusType)cth.get()).contentType()) : HttpEntity$.MODULE$.Empty());
    }

    public static final ParserOutput.StrictEntityCreator strictEntity(HttpMessageParser $this, Option cth, ByteString input, int bodyStart, int contentLength) {
        return new ParserOutput.StrictEntityCreator(new HttpEntity.Strict($this.contentType((Option<Content$minusType>)cth), input.slice(bodyStart, bodyStart + contentLength)));
    }

    public static final ParserOutput.StreamedEntityCreator defaultEntity(HttpMessageParser $this, Option cth, long contentLength) {
        return new ParserOutput.StreamedEntityCreator(new Serializable($this, cth, contentLength){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HttpMessageParser $outer;
            private final Option cth$2;
            private final long contentLength$1;

            public final HttpEntity.Default apply(Source<A, NotUsed> entityParts) {
                Source data = (Source)entityParts.collect((PartialFunction)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final <A1 extends A, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        Object object;
                        A1 A1 = x1;
                        if (A1 instanceof ParserOutput.EntityPart) {
                            ParserOutput.EntityPart entityPart = (ParserOutput.EntityPart)A1;
                            ByteString bytes = entityPart.data();
                            object = bytes;
                        } else {
                            if (A1 instanceof ParserOutput.EntityStreamError) {
                                ParserOutput.EntityStreamError entityStreamError = (ParserOutput.EntityStreamError)A1;
                                ErrorInfo info = entityStreamError.info();
                                throw new EntityStreamException(info);
                            }
                            object = function1.apply(x1);
                        }
                        return (B1)object;
                    }

                    public final boolean isDefinedAt(A x1) {
                        A a = x1;
                        boolean bl = a instanceof ParserOutput.EntityPart ? true : a instanceof ParserOutput.EntityStreamError;
                        return bl;
                    }
                });
                return new HttpEntity.Default(this.$outer.contentType((Option<Content$minusType>)this.cth$2), this.contentLength$1, HttpEntity$.MODULE$.limitableByteSource(data));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.cth$2 = cth$2;
                this.contentLength$1 = contentLength$1;
            }
        });
    }

    public static final ParserOutput.StreamedEntityCreator chunkedEntity(HttpMessageParser $this, Option cth) {
        return new ParserOutput.StreamedEntityCreator(new Serializable($this, cth){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HttpMessageParser $outer;
            private final Option cth$3;

            public final HttpEntity.Chunked apply(Source<A, NotUsed> entityChunks) {
                Source chunks = (Source)entityChunks.collect((PartialFunction)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final <A1 extends A, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                        Object object;
                        A1 A1 = x2;
                        if (A1 instanceof ParserOutput.EntityChunk) {
                            ParserOutput.EntityChunk entityChunk = (ParserOutput.EntityChunk)A1;
                            HttpEntity.ChunkStreamPart chunk = entityChunk.chunk();
                            object = chunk;
                        } else {
                            if (A1 instanceof ParserOutput.EntityStreamError) {
                                ParserOutput.EntityStreamError entityStreamError = (ParserOutput.EntityStreamError)A1;
                                ErrorInfo info = entityStreamError.info();
                                throw new EntityStreamException(info);
                            }
                            object = function1.apply(x2);
                        }
                        return (B1)object;
                    }

                    public final boolean isDefinedAt(A x2) {
                        A a = x2;
                        boolean bl = a instanceof ParserOutput.EntityChunk ? true : a instanceof ParserOutput.EntityStreamError;
                        return bl;
                    }
                });
                return new HttpEntity.Chunked(this.$outer.contentType((Option<Content$minusType>)this.cth$3), HttpEntity$.MODULE$.limitableChunkSource(chunks));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.cth$3 = cth$3;
            }
        });
    }

    public static final List addTransferEncodingWithChunkedPeeled(HttpMessageParser $this, List headers, Transfer$minusEncoding teh) {
        Option<Transfer$minusEncoding> option;
        block4: {
            List list;
            block3: {
                block2: {
                    Transfer$minusEncoding x;
                    option = teh.withChunkedPeeled();
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    Transfer$minusEncoding transfer$minusEncoding = x = (Transfer$minusEncoding)some.x();
                    list = headers.$colon$colon((Object)transfer$minusEncoding);
                    break block3;
                }
                if (!None$.MODULE$.equals(option)) break block4;
                list = headers;
            }
            return list;
        }
        throw new MatchError(option);
    }

    public static final void setCompletionHandling(HttpMessageParser $this, Function0 completionHandling) {
        $this.completionHandling_$eq((Function0<Option<ParserOutput.ErrorOutput>>)completionHandling);
    }

    private static final HttpMessageParser.StateResult run$1(HttpMessageParser $this, Function1 next, ByteString input$1) {
        Throwable throwable2;
        block6: {
            HttpMessageParser.StateResult stateResult;
            while (true) {
                Function1<ByteString, HttpMessageParser.StateResult> x;
                HttpMessageParser.StateResult stateResult2;
                try {
                    stateResult2 = (HttpMessageParser.StateResult)next.apply((Object)input$1);
                }
                catch (Throwable throwable2) {
                    HttpMessageParser.StateResult stateResult3;
                    Throwable throwable3 = throwable2;
                    if (throwable3 instanceof ParsingException) {
                        ParsingException parsingException = (ParsingException)throwable3;
                        stateResult3 = $this.failMessageStart(parsingException.status(), parsingException.info());
                    } else {
                        if (NotEnoughDataException$.MODULE$.equals(throwable3)) {
                            throw new IllegalStateException("unexpected NotEnoughDataException", NotEnoughDataException$.MODULE$);
                        }
                        if (!(throwable3 instanceof IllegalHeaderException)) break block6;
                        IllegalHeaderException illegalHeaderException = (IllegalHeaderException)throwable3;
                        ErrorInfo error = illegalHeaderException.info();
                        stateResult3 = $this.failMessageStart(StatusCodes$.MODULE$.BadRequest(), error);
                    }
                    stateResult2 = stateResult = stateResult3;
                }
                if (!(stateResult instanceof HttpMessageParser.Trampoline)) break;
                HttpMessageParser.Trampoline trampoline = (HttpMessageParser.Trampoline)stateResult;
                next = x = trampoline.f();
            }
            HttpMessageParser.StateResult stateResult4 = stateResult;
            return stateResult4;
        }
        throw throwable2;
    }

    private static final char c$1(HttpMessageParser $this, int ix, ByteString input$2, int cursor$3) {
        return package$.MODULE$.byteChar(input$2, cursor$3 + ix);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final HttpMessageParser.StateResult parseTrailer$1(HttpMessageParser $this, String extension2, int lineStart, List headers, int headerCount, ByteString input$3, boolean isLastMessage$2) {
        HttpMessageParser.StateResult stateResult;
        ErrorInfo errorInfo;
        block4: {
            HttpMessageParser.StateResult stateResult2;
            block5: {
                while (true) {
                    int lineEnd;
                    int n;
                    errorInfo = null;
                    try {
                        HttpHeaderParser qual$2 = $this.headerParser();
                        ByteString x$13 = input$3;
                        int x$14 = lineStart;
                        int x$15 = qual$2.parseHeaderLine$default$3(x$13, x$14);
                        int x$16 = qual$2.parseHeaderLine$default$4(x$13, x$14);
                        n = qual$2.parseHeaderLine(x$13, x$14, x$15, x$16);
                    }
                    catch (ParsingException parsingException) {
                        errorInfo = parsingException.info();
                        n = lineEnd = 0;
                    }
                    if (errorInfo != null) break block4;
                    HttpHeader httpHeader = $this.headerParser().resultHeader();
                    if (EmptyHeader$.MODULE$.equals(httpHeader)) {
                        HttpEntity.LastChunk lastChunk = extension2.isEmpty() && headers.isEmpty() ? HttpEntity$LastChunk$.MODULE$ : new HttpEntity.LastChunk(extension2, (scala.collection.immutable.Seq<HttpHeader>)headers);
                        $this.emit(new ParserOutput.EntityChunk(lastChunk));
                        $this.emit(ParserOutput$MessageEnd$.MODULE$);
                        $this.setCompletionHandling(HttpMessageParser$.MODULE$.CompletionOk());
                        stateResult2 = isLastMessage$2 ? $this.terminate() : $this.startNewMessage(input$3, lineEnd);
                        break block5;
                    }
                    if (headerCount >= $this.settings().maxHeaderCount()) break;
                    HttpHeader httpHeader2 = httpHeader;
                    ++headerCount;
                    headers = headers.$colon$colon((Object)httpHeader2);
                    lineStart = lineEnd;
                }
                stateResult2 = $this.failEntityStream(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Chunk trailer contains more than the configured limit of ", " headers"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)$this.settings().maxHeaderCount())})));
            }
            stateResult = stateResult2;
            return stateResult;
        }
        stateResult = $this.failEntityStream(errorInfo);
        return stateResult;
    }

    private static final List parseTrailer$default$3$1(HttpMessageParser $this) {
        return Nil$.MODULE$;
    }

    private static final int parseTrailer$default$4$1(HttpMessageParser $this) {
        return 0;
    }

    private static final HttpMessageParser.Trampoline result$1(HttpMessageParser $this, int terminatorLen, int chunkSize$1, String extension$1, int cursor$1, int chunkBodyEnd$1, ByteString input$3, boolean isLastMessage$2, long totalBytesRead$1) {
        $this.emit(new ParserOutput.EntityChunk(new HttpEntity.Chunk((ByteString)input$3.slice(cursor$1, chunkBodyEnd$1).compact(), extension$1)));
        return new HttpMessageParser.Trampoline((Function1<ByteString, HttpMessageParser.StateResult>)new Serializable($this, chunkSize$1, chunkBodyEnd$1, terminatorLen, input$3, isLastMessage$2, totalBytesRead$1){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HttpMessageParser $outer;
            private final int chunkSize$1;
            private final int chunkBodyEnd$1;
            private final int terminatorLen$1;
            private final ByteString input$3;
            private final boolean isLastMessage$2;
            private final long totalBytesRead$1;

            public final HttpMessageParser.StateResult apply(ByteString x$3) {
                return this.$outer.parseChunk(this.input$3, this.chunkBodyEnd$1 + this.terminatorLen$1, this.isLastMessage$2, this.totalBytesRead$1 + (long)this.chunkSize$1);
            }
            {
                void var5_5;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.chunkSize$1 = chunkSize$1;
                this.chunkBodyEnd$1 = chunkBodyEnd$1;
                this.terminatorLen$1 = terminatorLen$1;
                this.input$3 = var5_5;
                this.isLastMessage$2 = isLastMessage$2;
                this.totalBytesRead$1 = totalBytesRead$1;
            }
        });
    }

    private static final HttpMessageParser.StateResult parseChunkBody$1(HttpMessageParser $this, int chunkSize, String extension2, int cursor, ByteString input$3, boolean isLastMessage$2, long totalBytesRead$1) {
        HttpMessageParser.StateResult stateResult;
        if (chunkSize > 0) {
            int chunkBodyEnd = cursor + chunkSize;
            char c = package$.MODULE$.byteChar(input$3, chunkBodyEnd);
            switch (c) {
                case '\n': {
                    stateResult = HttpMessageParser$class.result$1($this, 1, chunkSize, extension2, cursor, chunkBodyEnd, input$3, isLastMessage$2, totalBytesRead$1);
                    break;
                }
                case '\r': {
                    if (package$.MODULE$.byteChar(input$3, chunkBodyEnd + 1) == '\n') {
                        stateResult = HttpMessageParser$class.result$1($this, 2, chunkSize, extension2, cursor, chunkBodyEnd, input$3, isLastMessage$2, totalBytesRead$1);
                        break;
                    }
                }
                default: {
                    stateResult = $this.failEntityStream("Illegal chunk termination");
                    break;
                }
            }
        } else {
            stateResult = HttpMessageParser$class.parseTrailer$1($this, extension2, cursor, HttpMessageParser$class.parseTrailer$default$3$1($this), HttpMessageParser$class.parseTrailer$default$4$1($this), input$3, isLastMessage$2);
        }
        return stateResult;
    }

    private static final String extension$2(HttpMessageParser $this, int cursor$2, int startIx$1, ByteString input$3) {
        return package$.MODULE$.asciiString(input$3, startIx$1, cursor$2);
    }

    private static final HttpMessageParser.StateResult parseChunkExtensions$1(HttpMessageParser $this, int chunkSize, int cursor, int startIx, ByteString input$3, boolean isLastMessage$2, long totalBytesRead$1) {
        HttpMessageParser.StateResult stateResult;
        block6: {
            while (cursor - startIx <= $this.settings().maxChunkExtLength()) {
                char c = package$.MODULE$.byteChar(input$3, cursor);
                switch (c) {
                    case '\n': {
                        stateResult = HttpMessageParser$class.parseChunkBody$1($this, chunkSize, HttpMessageParser$class.extension$2($this, cursor, startIx, input$3), cursor + 1, input$3, isLastMessage$2, totalBytesRead$1);
                        break block6;
                    }
                    case '\r': {
                        if (package$.MODULE$.byteChar(input$3, cursor + 1) == '\n') {
                            stateResult = HttpMessageParser$class.parseChunkBody$1($this, chunkSize, HttpMessageParser$class.extension$2($this, cursor, startIx, input$3), cursor + 2, input$3, isLastMessage$2, totalBytesRead$1);
                            break block6;
                        }
                    }
                    default: {
                        ++cursor;
                        break;
                    }
                }
            }
            stateResult = $this.failEntityStream(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"HTTP chunk extension length exceeds configured limit of ", " characters"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)$this.settings().maxChunkExtLength())})));
        }
        return stateResult;
    }

    private static final int parseChunkExtensions$default$3$1(HttpMessageParser $this, int chunkSize, int cursor) {
        return cursor;
    }

    private static final HttpMessageParser.StateResult parseSize$1(HttpMessageParser $this, int cursor, long size, ByteString input$3, int offset$1, boolean isLastMessage$2, long totalBytesRead$1) {
        HttpMessageParser.StateResult stateResult;
        block4: {
            while (size <= (long)$this.settings().maxChunkSize()) {
                HttpMessageParser.StateResult stateResult2;
                char c = package$.MODULE$.byteChar(input$3, cursor);
                if (BoxesRunTime.unboxToBoolean((Object)CharacterClasses$.MODULE$.HEXDIG().apply((Object)BoxesRunTime.boxToCharacter((char)c)))) {
                    size = size * 16L + (long)CharUtils$.MODULE$.hexValue(c);
                    ++cursor;
                    continue;
                }
                if (';' == c && cursor > offset$1) {
                    int x$17 = (int)size;
                    int x$18 = cursor + 1;
                    int x$19 = HttpMessageParser$class.parseChunkExtensions$default$3$1($this, x$17, x$18);
                    stateResult2 = HttpMessageParser$class.parseChunkExtensions$1($this, x$17, x$18, x$19, input$3, isLastMessage$2, totalBytesRead$1);
                } else {
                    stateResult2 = '\r' == c && cursor > offset$1 && package$.MODULE$.byteChar(input$3, cursor + 1) == '\n' ? HttpMessageParser$class.parseChunkBody$1($this, (int)size, "", cursor + 2, input$3, isLastMessage$2, totalBytesRead$1) : ('\n' == c && cursor > offset$1 ? HttpMessageParser$class.parseChunkBody$1($this, (int)size, "", cursor + 1, input$3, isLastMessage$2, totalBytesRead$1) : $this.failEntityStream(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Illegal character '", "' in chunk start"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{package$.MODULE$.escape(c)}))));
                }
                stateResult = stateResult2;
                break block4;
            }
            stateResult = $this.failEntityStream(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"HTTP chunk size exceeds the configured limit of ", " bytes"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)$this.settings().maxChunkSize())})));
        }
        return stateResult;
    }

    public static void $init$(HttpMessageParser $this) {
        $this.akka$http$impl$engine$parsing$HttpMessageParser$_setter_$result_$eq(new ListBuffer());
        $this.akka$http$impl$engine$parsing$HttpMessageParser$$state_$eq((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HttpMessageParser $outer;

            public final HttpMessageParser.StateResult apply(ByteString x$1) {
                return this.$outer.startNewMessage(x$1, 0);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        $this.akka$http$impl$engine$parsing$HttpMessageParser$$protocol_$eq(HttpProtocols$.MODULE$.HTTP$div1$u002E1());
        $this.completionHandling_$eq(HttpMessageParser$.MODULE$.CompletionOk());
        $this.terminated_$eq(false);
        $this.akka$http$impl$engine$parsing$HttpMessageParser$$lastSession_$eq(null);
        $this.akka$http$impl$engine$parsing$HttpMessageParser$$tlsSessionInfoHeader_$eq(null);
    }
}

