/*
 * Decompiled with CFR 0.152.
 */
package akka.http.impl.engine.rendering;

import akka.NotUsed;
import akka.annotation.InternalApi;
import akka.event.LoggingAdapter;
import akka.http.impl.engine.rendering.RenderSupport$;
import akka.http.impl.util.ByteArrayRendering;
import akka.http.impl.util.ByteStringRendering;
import akka.http.impl.util.EnhancedString$;
import akka.http.impl.util.Renderer;
import akka.http.impl.util.Renderer$;
import akka.http.impl.util.Rendering;
import akka.http.impl.util.Rendering$CrLf$;
import akka.http.impl.util.Rendering$Empty$;
import akka.http.impl.util.package$;
import akka.http.scaladsl.model.ContentType;
import akka.http.scaladsl.model.ContentTypes$;
import akka.http.scaladsl.model.HttpEntity;
import akka.http.scaladsl.model.HttpEntity$LastChunk$;
import akka.http.scaladsl.model.HttpHeader;
import akka.http.scaladsl.model.headers.Content$minusType$;
import akka.parboiled2.CharUtils$;
import akka.stream.Graph;
import akka.stream.SourceShape;
import akka.stream.scaladsl.GraphDSL;
import akka.stream.scaladsl.GraphDSL$;
import akka.stream.scaladsl.Sink$;
import akka.stream.scaladsl.Source;
import akka.stream.scaladsl.Source$;
import akka.util.ByteString;
import java.util.HashMap;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxedUnit;

@InternalApi
public final class RenderSupport$ {
    public static final RenderSupport$ MODULE$;
    private final byte[] DefaultStatusLineBytes;
    private final byte[] StatusLineStartBytes;
    private final byte[] ChunkedBytes;
    private final byte[] KeepAliveBytes;
    private final byte[] CloseBytes;
    private final HashMap<ContentType, byte[]> PreRenderedContentTypes;
    private final Renderer<Seq<HttpHeader>> trailerRenderer;
    private final ByteString defaultLastChunkBytes;

    static {
        new RenderSupport$();
    }

    public byte[] DefaultStatusLineBytes() {
        return this.DefaultStatusLineBytes;
    }

    public byte[] StatusLineStartBytes() {
        return this.StatusLineStartBytes;
    }

    public byte[] ChunkedBytes() {
        return this.ChunkedBytes;
    }

    public byte[] KeepAliveBytes() {
        return this.KeepAliveBytes;
    }

    public byte[] CloseBytes() {
        return this.CloseBytes;
    }

    public Rendering$CrLf$ CrLf() {
        return Rendering$CrLf$.MODULE$;
    }

    public Renderer<Seq<HttpHeader>> trailerRenderer() {
        return this.trailerRenderer;
    }

    public ByteString defaultLastChunkBytes() {
        return this.defaultLastChunkBytes;
    }

    public <T, Mat> Source<T, Mat> CancelSecond(Source<T, Mat> first, Source<T, Object> second) {
        return Source$.MODULE$.fromGraph(GraphDSL$.MODULE$.create(first, (Function1)new Serializable(second){
            public static final long serialVersionUID = 0L;
            public final Source second$1;

            public final Function1<SourceShape<T>, SourceShape<T>> apply(GraphDSL.Builder<Mat> b) {
                return new Serializable(this, b){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.CancelSecond.1 $outer;
                    private final GraphDSL.Builder b$1;

                    public final SourceShape<T> apply(SourceShape<T> frst) {
                        new GraphDSL.Implicits$.SourceArrow(GraphDSL.Implicits$.MODULE$.SourceArrow((Graph)this.$outer.second$1)).$tilde$greater((Graph)Sink$.MODULE$.cancelled(), this.b$1);
                        return new SourceShape(frst.out());
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.b$1 = b$1;
                    }
                };
            }
            {
                this.second$1 = second$1;
            }
        }));
    }

    public Rendering renderEntityContentType(Rendering r, HttpEntity entity) {
        Rendering rendering;
        ContentType ct;
        ContentType contentType = ct = entity.contentType();
        ContentType.Binary binary = ContentTypes$.MODULE$.NoContentType();
        if (!(contentType != null ? !contentType.equals(binary) : binary != null)) {
            rendering = r;
        } else {
            byte[] preRendered = this.PreRenderedContentTypes.get(ct);
            rendering = preRendered != null ? r.$tilde$tilde(preRendered) : r.$tilde$tilde(Content$minusType$.MODULE$, Renderer$.MODULE$.renderableRenderer()).$tilde$tilde(ct, Renderer$.MODULE$.renderableRenderer()).$tilde$tilde(this.CrLf(), Renderer$.MODULE$.renderableRenderer());
        }
        return rendering;
    }

    public Source<ByteString, Object> renderByteStrings(ByteString header, Function0<Source<ByteString, Object>> entityBytes, boolean skipEntity) {
        Source messageStart = Source$.MODULE$.single((Object)header);
        Source messageBytes = skipEntity ? this.CancelSecond(messageStart, (Source)entityBytes.apply()) : ((Source)messageStart.$plus$plus((Graph)entityBytes.apply())).mapMaterializedValue((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(NotUsed x$1) {
            }
        });
        return messageBytes;
    }

    public boolean renderByteStrings$default$3() {
        return false;
    }

    public ByteString akka$http$impl$engine$rendering$RenderSupport$$renderChunk(HttpEntity.ChunkStreamPart chunk) {
        HttpEntity.ChunkStreamPart chunkStreamPart;
        block5: {
            ByteStringRendering r;
            block3: {
                Rendering rendering;
                HttpEntity.LastChunk lastChunk;
                boolean bl;
                block4: {
                    block2: {
                        int renderedSize = CharUtils$.MODULE$.numberOfHexDigits((long)chunk.data().length()) + (chunk.extension().isEmpty() ? 0 : chunk.extension().length() + 1) + chunk.data().length() + 2 + 2;
                        r = new ByteStringRendering(renderedSize);
                        r.$tilde$tilde$percent(chunk.data().length());
                        Object object = new StringOps(Predef$.MODULE$.augmentString(chunk.extension())).nonEmpty() ? r.$tilde$tilde(';').$tilde$tilde(chunk.extension()) : BoxedUnit.UNIT;
                        r.$tilde$tilde(this.CrLf(), Renderer$.MODULE$.renderableRenderer());
                        bl = false;
                        lastChunk = null;
                        chunkStreamPart = chunk;
                        if (!(chunkStreamPart instanceof HttpEntity.Chunk)) break block2;
                        HttpEntity.Chunk chunk2 = (HttpEntity.Chunk)chunkStreamPart;
                        ByteString data = chunk2.data();
                        rendering = r.$tilde$tilde(data);
                        break block3;
                    }
                    if (!(chunkStreamPart instanceof HttpEntity.LastChunk)) break block4;
                    bl = true;
                    lastChunk = (HttpEntity.LastChunk)chunkStreamPart;
                    Seq<HttpHeader> seq = lastChunk.trailer();
                    if (!Nil$.MODULE$.equals(seq)) break block4;
                    rendering = BoxedUnit.UNIT;
                    break block3;
                }
                if (!bl) break block5;
                Seq<HttpHeader> trailer = lastChunk.trailer();
                rendering = r.$tilde$tilde(trailer, this.trailerRenderer()).$tilde$tilde(this.CrLf(), Renderer$.MODULE$.renderableRenderer());
            }
            r.$tilde$tilde(this.CrLf(), Renderer$.MODULE$.renderableRenderer());
            return r.get();
        }
        throw new MatchError((Object)chunkStreamPart);
    }

    public void suppressionWarning(LoggingAdapter log, HttpHeader h, String msg) {
        log.warning("Explicitly set HTTP header '{}' is ignored, {}", (Object)h, (Object)msg);
    }

    public String suppressionWarning$default$3() {
        return "the akka-http-core layer sets this header automatically!";
    }

    private final byte[] preRenderContentType$1(ContentType ct, HashMap m$1) {
        return m$1.put(ct, ((ByteArrayRendering)new ByteArrayRendering(32).$tilde$tilde(Content$minusType$.MODULE$, Renderer$.MODULE$.renderableRenderer()).$tilde$tilde(ct, Renderer$.MODULE$.renderableRenderer()).$tilde$tilde(this.CrLf(), Renderer$.MODULE$.renderableRenderer())).get());
    }

    /*
     * WARNING - void declaration
     */
    private RenderSupport$() {
        void var1_1;
        MODULE$ = this;
        this.DefaultStatusLineBytes = EnhancedString$.MODULE$.asciiBytes$extension(package$.MODULE$.enhanceString_("HTTP/1.1 200 OK\r\n"));
        this.StatusLineStartBytes = EnhancedString$.MODULE$.asciiBytes$extension(package$.MODULE$.enhanceString_("HTTP/1.1 "));
        this.ChunkedBytes = EnhancedString$.MODULE$.asciiBytes$extension(package$.MODULE$.enhanceString_("chunked"));
        this.KeepAliveBytes = EnhancedString$.MODULE$.asciiBytes$extension(package$.MODULE$.enhanceString_("Keep-Alive"));
        this.CloseBytes = EnhancedString$.MODULE$.asciiBytes$extension(package$.MODULE$.enhanceString_("close"));
        HashMap m = new HashMap(16);
        this.preRenderContentType$1(ContentTypes$.MODULE$.application$divjson(), m);
        this.preRenderContentType$1(ContentTypes$.MODULE$.text$divplain$u0028UTF$minus8$u0029(), m);
        this.preRenderContentType$1(ContentTypes$.MODULE$.text$divxml$u0028UTF$minus8$u0029(), m);
        this.preRenderContentType$1(ContentTypes$.MODULE$.text$divhtml$u0028UTF$minus8$u0029(), m);
        this.preRenderContentType$1(ContentTypes$.MODULE$.text$divcsv$u0028UTF$minus8$u0029(), m);
        this.PreRenderedContentTypes = var1_1;
        this.trailerRenderer = Renderer$.MODULE$.genericSeqRenderer(this.CrLf(), Rendering$Empty$.MODULE$, Renderer$.MODULE$.renderableRenderer(), Renderer$.MODULE$.renderableRenderer());
        this.defaultLastChunkBytes = this.akka$http$impl$engine$rendering$RenderSupport$$renderChunk(HttpEntity$LastChunk$.MODULE$);
    }
}

