/*
 * Decompiled with CFR 0.152.
 */
package akka.http.scaladsl;

import akka.event.LogSource$;
import akka.event.Logging$;
import akka.event.LoggingAdapter;
import akka.http.scaladsl.DefaultSSLContextCreation;
import akka.http.scaladsl.HttpsConnectionContext;
import akka.stream.TLSClientAuth;
import com.typesafe.sslconfig.akka.AkkaSSLConfig;
import com.typesafe.sslconfig.akka.util.AkkaLoggerFactory;
import com.typesafe.sslconfig.ssl.ClientAuth;
import com.typesafe.sslconfig.ssl.ConfigSSLContextBuilder;
import com.typesafe.sslconfig.ssl.KeyManagerFactoryWrapper;
import com.typesafe.sslconfig.ssl.SSLConfigSettings;
import com.typesafe.sslconfig.ssl.TrustManagerFactoryWrapper;
import com.typesafe.sslconfig.util.LoggerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.Seq;
import scala.collection.mutable.StringBuilder;

public abstract class DefaultSSLContextCreation$class {
    public static LoggingAdapter akka$http$scaladsl$DefaultSSLContextCreation$$log(DefaultSSLContextCreation $this) {
        return $this.system().log();
    }

    public static void validateAndWarnAboutLooseSettings(DefaultSSLContextCreation $this) {
        String WarningAboutGlobalLoose = "This is very dangerous and may expose you to man-in-the-middle attacks. If you are forced to interact with a server that is behaving such that you must disable this setting, please disable it for a given connection instead, by configuring a specific HttpsConnectionContext for use only for the trusted target that hostname verification would have blocked.";
        if ($this.sslConfig().config().loose().disableHostnameVerification()) {
            DefaultSSLContextCreation$class.akka$http$scaladsl$DefaultSSLContextCreation$$log($this).warning(new StringBuilder().append((Object)"Detected that Hostname Verification is disabled globally (via ssl-config's akka.ssl-config.loose.disableHostnameVerification) for the Http extension! ").append((Object)WarningAboutGlobalLoose).toString());
        }
        if ($this.sslConfig().config().loose().disableSNI()) {
            DefaultSSLContextCreation$class.akka$http$scaladsl$DefaultSSLContextCreation$$log($this).warning(new StringBuilder().append((Object)"Detected that Server Name Indication (SNI) is disabled globally (via ssl-config's akka.ssl-config.loose.disableSNI) for the Http extension! ").append((Object)WarningAboutGlobalLoose).toString());
        }
    }

    public static HttpsConnectionContext createDefaultClientHttpsContext(DefaultSSLContextCreation $this) {
        return $this.createClientHttpsContext($this.sslConfig());
    }

    public static HttpsConnectionContext createServerHttpsContext(DefaultSSLContextCreation $this, AkkaSSLConfig sslConfig) {
        DefaultSSLContextCreation$class.akka$http$scaladsl$DefaultSSLContextCreation$$log($this).warning("Automatic server-side configuration is not supported yet, will attempt to use client-side settings. Instead it is recommended to construct the Servers HttpsConnectionContext manually (via SSLContext).");
        return $this.createClientHttpsContext(sslConfig);
    }

    public static HttpsConnectionContext createClientHttpsContext(DefaultSSLContextCreation $this, AkkaSSLConfig sslConfig) {
        ClientAuth clientAuth;
        block10: {
            None$ none$;
            String[] cipherSuites;
            String[] defaultProtocols;
            SSLParameters defaultParams;
            SSLContext sslContext;
            block7: {
                block9: {
                    block8: {
                        block6: {
                            SSLContext sSLContext;
                            SSLConfigSettings config = sslConfig.config();
                            LoggingAdapter log = Logging$.MODULE$.apply($this.system(), $this.getClass(), LogSource$.MODULE$.fromAnyClass());
                            AkkaLoggerFactory mkLogger = new AkkaLoggerFactory($this.system());
                            if (sslConfig.config().default()) {
                                log.debug("buildSSLContext: ssl-config.default is true, using default SSLContext");
                                sslConfig.validateDefaultTrustManager(config);
                                sSLContext = SSLContext.getDefault();
                            } else {
                                KeyManagerFactoryWrapper keyManagerFactory = sslConfig.buildKeyManagerFactory(config);
                                TrustManagerFactoryWrapper trustManagerFactory = sslConfig.buildTrustManagerFactory(config);
                                sSLContext = new ConfigSSLContextBuilder((LoggerFactory)mkLogger, config, keyManagerFactory, trustManagerFactory).build();
                            }
                            sslContext = sSLContext;
                            defaultParams = sslContext.getDefaultSSLParameters();
                            defaultProtocols = defaultParams.getProtocols();
                            String[] protocols = sslConfig.configureProtocols(defaultProtocols, config);
                            defaultParams.setProtocols(protocols);
                            String[] defaultCiphers = defaultParams.getCipherSuites();
                            cipherSuites = sslConfig.configureCipherSuites(defaultCiphers, config);
                            defaultParams.setCipherSuites(cipherSuites);
                            clientAuth = config.sslParametersConfig().clientAuth();
                            if (!ClientAuth.Default$.MODULE$.equals(clientAuth)) break block6;
                            none$ = None$.MODULE$;
                            break block7;
                        }
                        if (!ClientAuth.Want$.MODULE$.equals(clientAuth)) break block8;
                        none$ = new Some((Object)TLSClientAuth.Want$.MODULE$);
                        break block7;
                    }
                    if (!ClientAuth.Need$.MODULE$.equals(clientAuth)) break block9;
                    none$ = new Some((Object)TLSClientAuth.Need$.MODULE$);
                    break block7;
                }
                if (!ClientAuth.None$.MODULE$.equals(clientAuth)) break block10;
                none$ = new Some((Object)TLSClientAuth.None$.MODULE$);
            }
            None$ clientAuth2 = none$;
            if (!sslConfig.config().loose().disableHostnameVerification()) {
                defaultParams.setEndpointIdentificationAlgorithm("https");
            }
            return new HttpsConnectionContext(sslContext, (Option<AkkaSSLConfig>)new Some((Object)sslConfig), (Option<Seq<String>>)new Some((Object)Predef$.MODULE$.refArrayOps((Object[])cipherSuites).toList()), (Option<Seq<String>>)new Some((Object)Predef$.MODULE$.refArrayOps((Object[])defaultProtocols).toList()), (Option<TLSClientAuth>)clientAuth2, (Option<SSLParameters>)new Some((Object)defaultParams));
        }
        throw new MatchError((Object)clientAuth);
    }

    public static void $init$(DefaultSSLContextCreation $this) {
    }
}

