/*
 * Decompiled with CFR 0.152.
 */
package akka.http.scaladsl.model;

import akka.annotation.InternalApi;
import akka.http.impl.model.JavaInitialization$;
import akka.http.impl.util.StreamUtils$;
import akka.http.scaladsl.model.ContentType;
import akka.http.scaladsl.model.ContentTypes$;
import akka.http.scaladsl.model.HttpEntity;
import akka.http.scaladsl.model.HttpEntity$Chunked$;
import akka.http.scaladsl.model.UniversalEntity;
import akka.http.scaladsl.util.FastFuture$;
import akka.stream.Attributes;
import akka.stream.Attributes$;
import akka.stream.scaladsl.FileIO$;
import akka.stream.scaladsl.Source;
import akka.util.ByteString;
import akka.util.ByteString$;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.concurrent.Future;
import scala.runtime.BoxedUnit;

public final class HttpEntity$ {
    public static final HttpEntity$ MODULE$;
    private final HttpEntity.Strict Empty;
    private final Function1<ByteString, Object> sizeOfByteString;
    private final Function1<HttpEntity.ChunkStreamPart, Object> sizeOfChunkStreamPart;
    private final Attributes akka$http$scaladsl$model$HttpEntity$$limitableDefaults;

    static {
        new HttpEntity$();
    }

    public HttpEntity.Strict apply(String string) {
        return this.apply(ContentTypes$.MODULE$.text$divplain$u0028UTF$minus8$u0029(), string);
    }

    public HttpEntity.Strict apply(byte[] bytes) {
        return this.apply((ContentType)ContentTypes$.MODULE$.application$divoctet$minusstream(), bytes);
    }

    public HttpEntity.Strict apply(ByteString data) {
        return this.apply((ContentType)ContentTypes$.MODULE$.application$divoctet$minusstream(), data);
    }

    public HttpEntity.Strict apply(ContentType.NonBinary contentType, String string) {
        return string.isEmpty() ? this.empty(contentType) : this.apply((ContentType)contentType, ByteString$.MODULE$.apply(string.getBytes(contentType.charset().nioCharset())));
    }

    public HttpEntity.Strict apply(ContentType contentType, byte[] bytes) {
        return bytes.length == 0 ? this.empty(contentType) : this.apply(contentType, ByteString$.MODULE$.apply(bytes));
    }

    public HttpEntity.Strict apply(ContentType contentType, ByteString data) {
        return data.isEmpty() ? this.empty(contentType) : new HttpEntity.Strict(contentType, data);
    }

    public UniversalEntity apply(ContentType contentType, long contentLength, Source<ByteString, Object> data) {
        return contentLength == 0L ? this.empty(contentType) : new HttpEntity.Default(contentType, contentLength, data);
    }

    public HttpEntity.Chunked apply(ContentType contentType, Source<ByteString, Object> data) {
        return HttpEntity$Chunked$.MODULE$.fromData(contentType, data);
    }

    public UniversalEntity apply(ContentType contentType, File file, int chunkSize) {
        return this.fromPath(contentType, file.toPath(), chunkSize);
    }

    public int apply$default$3() {
        return -1;
    }

    public UniversalEntity fromPath(ContentType contentType, Path file, int chunkSize) {
        long fileLength = Files.size(file);
        return fileLength > 0L ? new HttpEntity.Default(contentType, fileLength, (Source<ByteString, Object>)(chunkSize > 0 ? FileIO$.MODULE$.fromPath(file, chunkSize) : FileIO$.MODULE$.fromPath(file, FileIO$.MODULE$.fromPath$default$2()))) : this.empty(contentType);
    }

    public int fromPath$default$3() {
        return -1;
    }

    public HttpEntity.Strict Empty() {
        return this.Empty;
    }

    public HttpEntity.Strict empty(ContentType contentType) {
        ContentType contentType2 = contentType;
        ContentType contentType3 = this.Empty().contentType();
        return !(contentType2 != null ? !contentType2.equals(contentType3) : contentType3 != null) ? this.Empty() : new HttpEntity.Strict(contentType, ByteString$.MODULE$.empty());
    }

    public <Mat> Source<ByteString, Mat> limitableByteSource(Source<ByteString, Mat> source) {
        return source.via(new HttpEntity.Limitable<ByteString>(this.sizeOfByteString()));
    }

    public <Mat> Source<HttpEntity.ChunkStreamPart, Mat> limitableChunkSource(Source<HttpEntity.ChunkStreamPart, Mat> source) {
        return source.via(new HttpEntity.Limitable<HttpEntity.ChunkStreamPart>(this.sizeOfChunkStreamPart()));
    }

    private Function1<ByteString, Object> sizeOfByteString() {
        return this.sizeOfByteString;
    }

    private Function1<HttpEntity.ChunkStreamPart, Object> sizeOfChunkStreamPart() {
        return this.sizeOfChunkStreamPart;
    }

    public Attributes akka$http$scaladsl$model$HttpEntity$$limitableDefaults() {
        return this.akka$http$scaladsl$model$HttpEntity$$limitableDefaults;
    }

    @InternalApi
    public <T extends HttpEntity> Tuple2<T, Future<BoxedUnit>> captureTermination(T entity) {
        T t;
        block10: {
            Tuple2<Source<ByteString, Object>, Future<BoxedUnit>> tuple2;
            block11: {
                Tuple2 tuple22;
                block3: {
                    Tuple2 tuple23;
                    block8: {
                        Tuple2<Source<ByteString, Object>, Future<BoxedUnit>> tuple24;
                        block9: {
                            Tuple2 tuple25;
                            block6: {
                                Tuple2<Source<HttpEntity.ChunkStreamPart, Object>, Future<BoxedUnit>> tuple26;
                                block7: {
                                    Tuple2 tuple27;
                                    block4: {
                                        Tuple2<Source<ByteString, Object>, Future<BoxedUnit>> tuple28;
                                        block5: {
                                            Tuple2 tuple29;
                                            block2: {
                                                t = entity;
                                                if (!(t instanceof HttpEntity.Strict)) break block2;
                                                HttpEntity.Strict strict2 = (HttpEntity.Strict)t;
                                                tuple22 = Predef.ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.ArrowAssoc((Object)strict2), FastFuture$.MODULE$.successful().apply((Object)BoxedUnit.UNIT));
                                                break block3;
                                            }
                                            if (!(t instanceof HttpEntity.Default)) break block4;
                                            HttpEntity.Default default_ = (HttpEntity.Default)t;
                                            tuple28 = StreamUtils$.MODULE$.captureTermination(default_.data());
                                            if (tuple28 == null) break block5;
                                            Source newData = (Source)tuple28._1();
                                            Future whenCompleted = (Future)tuple28._2();
                                            Tuple2 tuple210 = tuple29 = new Tuple2((Object)newData, (Object)whenCompleted);
                                            Source newData2 = (Source)tuple210._1();
                                            Future whenCompleted2 = (Future)tuple210._2();
                                            Source x$19 = newData2;
                                            ContentType x$20 = default_.copy$default$1();
                                            long x$21 = default_.copy$default$2();
                                            tuple22 = Predef.ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.ArrowAssoc((Object)default_.copy(x$20, x$21, (Source<ByteString, Object>)x$19)), (Object)whenCompleted2);
                                            break block3;
                                        }
                                        throw new MatchError(tuple28);
                                    }
                                    if (!(t instanceof HttpEntity.Chunked)) break block6;
                                    HttpEntity.Chunked chunked = (HttpEntity.Chunked)t;
                                    tuple26 = StreamUtils$.MODULE$.captureTermination(chunked.chunks());
                                    if (tuple26 == null) break block7;
                                    Source newChunks = (Source)tuple26._1();
                                    Future whenCompleted = (Future)tuple26._2();
                                    Tuple2 tuple211 = tuple27 = new Tuple2((Object)newChunks, (Object)whenCompleted);
                                    Source newChunks2 = (Source)tuple211._1();
                                    Future whenCompleted3 = (Future)tuple211._2();
                                    Source x$22 = newChunks2;
                                    ContentType x$23 = chunked.copy$default$1();
                                    tuple22 = Predef.ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.ArrowAssoc((Object)chunked.copy(x$23, (Source<HttpEntity.ChunkStreamPart, Object>)x$22)), (Object)whenCompleted3);
                                    break block3;
                                }
                                throw new MatchError(tuple26);
                            }
                            if (!(t instanceof HttpEntity.CloseDelimited)) break block8;
                            HttpEntity.CloseDelimited closeDelimited = (HttpEntity.CloseDelimited)t;
                            tuple24 = StreamUtils$.MODULE$.captureTermination(closeDelimited.data());
                            if (tuple24 == null) break block9;
                            Source newData = (Source)tuple24._1();
                            Future whenCompleted = (Future)tuple24._2();
                            Tuple2 tuple212 = tuple25 = new Tuple2((Object)newData, (Object)whenCompleted);
                            Source newData3 = (Source)tuple212._1();
                            Future whenCompleted4 = (Future)tuple212._2();
                            Source x$24 = newData3;
                            ContentType x$25 = closeDelimited.copy$default$1();
                            tuple22 = Predef.ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.ArrowAssoc((Object)closeDelimited.copy(x$25, (Source<ByteString, Object>)x$24)), (Object)whenCompleted4);
                            break block3;
                        }
                        throw new MatchError(tuple24);
                    }
                    if (!(t instanceof HttpEntity.IndefiniteLength)) break block10;
                    HttpEntity.IndefiniteLength indefiniteLength = (HttpEntity.IndefiniteLength)t;
                    tuple2 = StreamUtils$.MODULE$.captureTermination(indefiniteLength.data());
                    if (tuple2 == null) break block11;
                    Source newData = (Source)tuple2._1();
                    Future whenCompleted = (Future)tuple2._2();
                    Tuple2 tuple213 = tuple23 = new Tuple2((Object)newData, (Object)whenCompleted);
                    Source newData4 = (Source)tuple213._1();
                    Future whenCompleted5 = (Future)tuple213._2();
                    Source x$26 = newData4;
                    ContentType x$27 = indefiniteLength.copy$default$1();
                    tuple22 = Predef.ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.ArrowAssoc((Object)indefiniteLength.copy(x$27, (Source<ByteString, Object>)x$26)), (Object)whenCompleted5);
                }
                return tuple22;
            }
            throw new MatchError(tuple2);
        }
        throw new MatchError(t);
    }

    public HttpEntity HttpEntityScalaDSLSugar(HttpEntity httpEntity) {
        return httpEntity;
    }

    private HttpEntity$() {
        MODULE$ = this;
        this.Empty = new HttpEntity.Strict(ContentTypes$.MODULE$.NoContentType(), ByteString$.MODULE$.empty());
        JavaInitialization$.MODULE$.initializeStaticFieldWith(this.Empty(), akka.http.javadsl.model.HttpEntity.class.getField("EMPTY"));
        this.sizeOfByteString = new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(ByteString x$4) {
                return x$4.size();
            }
        };
        this.sizeOfChunkStreamPart = new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(HttpEntity.ChunkStreamPart x$5) {
                return x$5.data().size();
            }
        };
        this.akka$http$scaladsl$model$HttpEntity$$limitableDefaults = Attributes$.MODULE$.name("limitable");
    }
}

