/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.access.expression;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.ParseException;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.access.expression.SecurityExpressionHandler;
import org.springframework.security.web.FilterInvocation;
import org.springframework.security.web.access.expression.AbstractVariableEvaluationContextPostProcessor;
import org.springframework.security.web.access.expression.WebExpressionConfigAttribute;
import org.springframework.security.web.access.intercept.DefaultFilterInvocationSecurityMetadataSource;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.security.web.util.matcher.RequestVariablesExtractor;
import org.springframework.util.Assert;

public final class ExpressionBasedFilterInvocationSecurityMetadataSource
extends DefaultFilterInvocationSecurityMetadataSource {
    private static final Log logger = LogFactory.getLog(ExpressionBasedFilterInvocationSecurityMetadataSource.class);

    public ExpressionBasedFilterInvocationSecurityMetadataSource(LinkedHashMap<RequestMatcher, Collection<ConfigAttribute>> requestMap, SecurityExpressionHandler<FilterInvocation> expressionHandler) {
        super(ExpressionBasedFilterInvocationSecurityMetadataSource.processMap(requestMap, expressionHandler.getExpressionParser()));
        Assert.notNull(expressionHandler, (String)"A non-null SecurityExpressionHandler is required");
    }

    private static LinkedHashMap<RequestMatcher, Collection<ConfigAttribute>> processMap(LinkedHashMap<RequestMatcher, Collection<ConfigAttribute>> requestMap, ExpressionParser parser) {
        Assert.notNull((Object)parser, (String)"SecurityExpressionHandler returned a null parser object");
        LinkedHashMap<RequestMatcher, Collection<ConfigAttribute>> requestToExpressionAttributesMap = new LinkedHashMap<RequestMatcher, Collection<ConfigAttribute>>(requestMap);
        for (Map.Entry<RequestMatcher, Collection<ConfigAttribute>> entry : requestMap.entrySet()) {
            RequestMatcher request = entry.getKey();
            Assert.isTrue((entry.getValue().size() == 1 ? 1 : 0) != 0, (String)("Expected a single expression attribute for " + request));
            ArrayList<WebExpressionConfigAttribute> attributes = new ArrayList<WebExpressionConfigAttribute>(1);
            String expression = entry.getValue().toArray(new ConfigAttribute[1])[0].getAttribute();
            logger.debug((Object)("Adding web access control expression '" + expression + "', for " + request));
            AbstractVariableEvaluationContextPostProcessor postProcessor = ExpressionBasedFilterInvocationSecurityMetadataSource.createPostProcessor(request);
            try {
                attributes.add(new WebExpressionConfigAttribute(parser.parseExpression(expression), postProcessor));
            }
            catch (ParseException e) {
                throw new IllegalArgumentException("Failed to parse expression '" + expression + "'");
            }
            requestToExpressionAttributesMap.put(request, attributes);
        }
        return requestToExpressionAttributesMap;
    }

    private static AbstractVariableEvaluationContextPostProcessor createPostProcessor(Object request) {
        if (request instanceof RequestVariablesExtractor) {
            return new RequestVariablesExtractorEvaluationContextPostProcessor((RequestVariablesExtractor)request);
        }
        return null;
    }

    static class RequestVariablesExtractorEvaluationContextPostProcessor
    extends AbstractVariableEvaluationContextPostProcessor {
        private final RequestVariablesExtractor matcher;

        public RequestVariablesExtractorEvaluationContextPostProcessor(RequestVariablesExtractor matcher) {
            this.matcher = matcher;
        }

        @Override
        Map<String, String> extractVariables(HttpServletRequest request) {
            return this.matcher.extractUriTemplateVariables(request);
        }
    }

    static class AntPathMatcherEvaluationContextPostProcessor
    extends AbstractVariableEvaluationContextPostProcessor {
        private final AntPathRequestMatcher matcher;

        public AntPathMatcherEvaluationContextPostProcessor(AntPathRequestMatcher matcher) {
            this.matcher = matcher;
        }

        @Override
        Map<String, String> extractVariables(HttpServletRequest request) {
            return this.matcher.extractUriTemplateVariables(request);
        }
    }
}

