/*
 * Decompiled with CFR 0.152.
 */
package com.hierynomus.smbj.connection;

import com.hierynomus.mserref.NtStatus;
import com.hierynomus.mssmb2.SMB2MessageCommandCode;
import com.hierynomus.mssmb2.SMB2MessageFlag;
import com.hierynomus.mssmb2.SMB2Packet;
import com.hierynomus.mssmb2.messages.SMB2NegotiateRequest;
import com.hierynomus.mssmb2.messages.SMB2NegotiateResponse;
import com.hierynomus.mssmb2.messages.SMB2SessionSetup;
import com.hierynomus.protocol.commons.EnumWithValue;
import com.hierynomus.protocol.commons.Factory;
import com.hierynomus.protocol.commons.concurrent.Futures;
import com.hierynomus.protocol.commons.socket.SocketClient;
import com.hierynomus.smbj.Config;
import com.hierynomus.smbj.auth.AuthenticationContext;
import com.hierynomus.smbj.auth.Authenticator;
import com.hierynomus.smbj.common.SMBApiException;
import com.hierynomus.smbj.common.SMBRuntimeException;
import com.hierynomus.smbj.connection.ConnectionInfo;
import com.hierynomus.smbj.connection.NegotiatedProtocol;
import com.hierynomus.smbj.connection.Request;
import com.hierynomus.smbj.event.SMBEventBus;
import com.hierynomus.smbj.event.SessionLoggedOff;
import com.hierynomus.smbj.session.Session;
import com.hierynomus.smbj.transport.PacketReader;
import com.hierynomus.smbj.transport.PacketReceiver;
import com.hierynomus.smbj.transport.TransportException;
import com.hierynomus.smbj.transport.TransportLayer;
import com.hierynomus.smbj.transport.tcp.DirectTcpPacketReader;
import com.hierynomus.spnego.NegTokenInit;
import java.io.IOException;
import java.util.EnumSet;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Future;
import java.util.concurrent.locks.ReentrantLock;
import net.engio.mbassy.listener.Handler;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Connection
extends SocketClient
implements AutoCloseable,
PacketReceiver<SMB2Packet> {
    private static final Logger logger = LoggerFactory.getLogger(Connection.class);
    private ConnectionInfo connectionInfo;
    private Config config;
    private TransportLayer transport;
    private final SMBEventBus bus;
    private PacketReader packetReader;
    private final ReentrantLock lock = new ReentrantLock();

    public Connection(Config config, TransportLayer transport, SMBEventBus bus) {
        super(transport.getDefaultPort());
        this.config = config;
        this.transport = transport;
        this.bus = bus;
        bus.subscribe(this);
    }

    @Override
    protected void onConnect() throws IOException {
        super.onConnect();
        this.connectionInfo = new ConnectionInfo(this.config.getClientGuid(), this.getRemoteHostname());
        this.packetReader = new DirectTcpPacketReader(this.getRemoteHostname(), this.getInputStream(), (PacketReceiver)this);
        this.packetReader.start();
        this.transport.init(this.getInputStream(), this.getOutputStream());
        this.negotiateDialect();
        logger.info("Successfully connected to: {}", (Object)this.getRemoteHostname());
    }

    @Override
    public void close() throws Exception {
        for (Session session : this.connectionInfo.getSessionTable().activeSessions()) {
            try {
                session.close();
            }
            catch (IOException e) {
                logger.warn("Exception while closing session {}", (Object)session.getSessionId(), (Object)e);
            }
        }
        this.packetReader.stop();
        logger.info("Closed connection to {}", (Object)this.getRemoteHostname());
        super.disconnect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Session authenticate(AuthenticationContext authContext) {
        Session session;
        NegTokenInit negTokenInit = new NegTokenInit().read(this.connectionInfo.getGssNegotiateToken());
        Authenticator authenticator = this.getAuthenticator(negTokenInit.getSupportedMechTypes(), authContext);
        Session session2 = new Session(0L, this, this.bus, this.connectionInfo.isServerRequiresSigning());
        SMB2SessionSetup receive = this.authenticationRound(authenticator, authContext, this.connectionInfo.getGssNegotiateToken(), session2);
        long sessionId = receive.getHeader().getSessionId();
        session2.setSessionId(sessionId);
        this.connectionInfo.getPreauthSessionTable().registerSession(sessionId, session2);
        try {
            while (receive.getHeader().getStatus() == NtStatus.STATUS_MORE_PROCESSING_REQUIRED) {
                logger.debug("More processing required for authentication of {} using {}", (Object)authContext.getUsername(), (Object)authenticator);
                receive = this.authenticationRound(authenticator, authContext, receive.getSecurityBuffer(), session2);
            }
            if (receive.getHeader().getStatus() != NtStatus.STATUS_SUCCESS) {
                throw new SMBApiException(receive.getHeader(), String.format("Authentication failed for '%s' using %s", authContext.getUsername(), authenticator));
            }
            if (receive.getSecurityBuffer() != null) {
                authenticator.authenticate(authContext, receive.getSecurityBuffer(), session2);
            }
            logger.info("Successfully authenticated {} on {}, session is {}", new Object[]{authContext.getUsername(), this.getRemoteHostname(), session2.getSessionId()});
            this.connectionInfo.getSessionTable().registerSession(session2.getSessionId(), session2);
            session = session2;
            this.connectionInfo.getPreauthSessionTable().sessionClosed(sessionId);
        }
        catch (Throwable throwable) {
            try {
                this.connectionInfo.getPreauthSessionTable().sessionClosed(sessionId);
                throw throwable;
            }
            catch (IOException e) {
                throw new SMBRuntimeException(e);
            }
        }
        return session;
    }

    private SMB2SessionSetup authenticationRound(Authenticator authenticator, AuthenticationContext authContext, byte[] inputToken, Session session) throws IOException {
        byte[] securityContext = authenticator.authenticate(authContext, inputToken, session);
        SMB2SessionSetup req = new SMB2SessionSetup(this.connectionInfo.getNegotiatedProtocol().getDialect(), EnumSet.of(SMB2SessionSetup.SMB2SecurityMode.SMB2_NEGOTIATE_SIGNING_ENABLED));
        req.setSecurityBuffer(securityContext);
        req.getHeader().setSessionId(session.getSessionId());
        return (SMB2SessionSetup)this.sendAndReceive(req);
    }

    private Authenticator getAuthenticator(List<ASN1ObjectIdentifier> mechTypes, AuthenticationContext context) {
        for (Factory.Named<Authenticator> factory : this.config.getSupportedAuthenticators()) {
            Authenticator authenticator;
            if (!mechTypes.contains(new ASN1ObjectIdentifier(factory.getName())) || !(authenticator = (Authenticator)factory.create()).supports(context)) continue;
            return authenticator;
        }
        throw new SMBRuntimeException("No authenticator is configured for the supported mechtypes: " + mechTypes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends SMB2Packet> Future<T> send(SMB2Packet packet) throws TransportException {
        this.lock.lock();
        try {
            int availableCredits = this.connectionInfo.getSequenceWindow().available();
            int grantCredits = this.calculateGrantedCredits(packet, availableCredits);
            if (availableCredits == 0) {
                logger.info("There are no credits left to send {}, will block until there are more credits available.", (Object)packet.getHeader().getMessage());
            }
            long[] messageIds = this.connectionInfo.getSequenceWindow().get(grantCredits);
            packet.getHeader().setMessageId(messageIds[0]);
            logger.debug("Granted {} (out of {}) credits to {} with message id << {} >>", new Object[]{grantCredits, availableCredits, packet.getHeader().getMessage(), packet.getHeader().getMessageId()});
            packet.getHeader().setCreditRequest(Math.max(512 - availableCredits - grantCredits, grantCredits));
            Request request = new Request(packet.getHeader().getMessageId(), UUID.randomUUID(), packet);
            this.connectionInfo.getOutstandingRequests().registerOutstanding(request);
            this.transport.write(packet);
            Future future = request.getFuture(null);
            return future;
        }
        finally {
            this.lock.unlock();
        }
    }

    private <T extends SMB2Packet> T sendAndReceive(SMB2Packet packet) throws TransportException {
        return (T)((SMB2Packet)Futures.get(this.send(packet), TransportException.Wrapper));
    }

    private int calculateGrantedCredits(SMB2Packet packet, int availableCredits) {
        int maxPayloadSize = packet.getMaxPayloadSize();
        int creditsNeeded = this.creditsNeeded(maxPayloadSize);
        int grantCredits = creditsNeeded < availableCredits ? creditsNeeded : (creditsNeeded > 1 && availableCredits > 1 ? availableCredits - 1 : 1);
        packet.setCreditsAssigned(grantCredits);
        return grantCredits;
    }

    private void negotiateDialect() throws TransportException {
        logger.info("Negotiating dialects {} with server {}", this.config.getSupportedDialects(), (Object)this.getRemoteHostname());
        SMB2NegotiateRequest negotiatePacket = new SMB2NegotiateRequest(this.config.getSupportedDialects(), this.connectionInfo.getClientGuid(), this.config.isSigningRequired());
        Future send = this.send(negotiatePacket);
        SMB2Packet negotiateResponse = (SMB2Packet)Futures.get(send, TransportException.Wrapper);
        if (!(negotiateResponse instanceof SMB2NegotiateResponse)) {
            throw new IllegalStateException("Expected a SMB2 NEGOTIATE Response, but got: " + negotiateResponse.getHeader().getMessageId());
        }
        SMB2NegotiateResponse resp = (SMB2NegotiateResponse)negotiateResponse;
        this.connectionInfo.negotiated(resp);
        logger.info("Negotiated the following connection settings: {}", (Object)this.connectionInfo);
    }

    private int creditsNeeded(int payloadSize) {
        return Math.abs((payloadSize - 1) / 65536) + 1;
    }

    public NegotiatedProtocol getNegotiatedProtocol() {
        return this.connectionInfo.getNegotiatedProtocol();
    }

    @Override
    public void handle(SMB2Packet packet) throws TransportException {
        long messageId = packet.getSequenceNumber();
        if (!this.connectionInfo.getOutstandingRequests().isOutstanding(messageId)) {
            throw new TransportException("Received response with unknown sequence number <<" + messageId + ">>");
        }
        this.connectionInfo.getSequenceWindow().creditsGranted(packet.getHeader().getCreditResponse());
        logger.debug("Server granted us {} credits for message with sequence number << {} >>, now available: {} credits", new Object[]{packet.getHeader().getCreditResponse(), messageId, this.connectionInfo.getSequenceWindow().available()});
        Request request = this.connectionInfo.getOutstandingRequests().getRequestByMessageId(messageId);
        logger.trace("Send/Recv of packet with message id << {} >> took << {} ms >>", (Object)messageId, (Object)(System.currentTimeMillis() - request.getTimestamp().getTime()));
        if (EnumWithValue.EnumUtils.isSet(packet.getHeader().getFlags(), SMB2MessageFlag.SMB2_FLAGS_ASYNC_COMMAND) && packet.getHeader().getStatus() == NtStatus.STATUS_PENDING) {
            request.setAsyncId(packet.getHeader().getAsyncId());
            return;
        }
        if (packet.getHeader().getStatus() == NtStatus.STATUS_NETWORK_SESSION_EXPIRED) {
            return;
        }
        if (packet.getHeader().getSessionId() != 0L && packet.getHeader().getMessage() != SMB2MessageCommandCode.SMB2_SESSION_SETUP) {
            Session session = this.connectionInfo.getSessionTable().find(packet.getHeader().getSessionId());
            if (session == null && (session = this.connectionInfo.getPreauthSessionTable().find(packet.getHeader().getSessionId())) == null) {
                logger.warn("Illegal request, no session matching the sessionId: {}", (Object)packet.getHeader().getSessionId());
                return;
            }
            if (packet.getHeader().isFlagSet(SMB2MessageFlag.SMB2_FLAGS_SIGNED)) {
                if (!session.getPacketSignatory().verify(packet)) {
                    logger.warn("Invalid packet signature for packet {} with message id << {} >>", (Object)packet.getHeader().getMessage(), (Object)packet.getHeader().getMessageId());
                    if (this.config.isSigningRequired()) {
                        throw new TransportException("Packet signature for packet " + (Object)((Object)packet.getHeader().getMessage()) + " with message id << " + packet.getHeader().getMessageId() + " >> was not correct");
                    }
                }
            } else if (this.config.isSigningRequired()) {
                logger.warn("Illegal request, client requires message signing, but the received message is not signed.");
                throw new TransportException("Client requires signing, but packet " + (Object)((Object)packet.getHeader().getMessage()) + " with message id << " + packet.getHeader().getMessageId() + " >> was not signed");
            }
        }
        this.connectionInfo.getOutstandingRequests().receivedResponseFor(messageId).getPromise().deliver(packet);
    }

    @Override
    public void handleError(Throwable t) {
        this.connectionInfo.getOutstandingRequests().handleError(t);
    }

    @Handler
    private void sessionLogoff(SessionLoggedOff loggedOff) {
        this.connectionInfo.getSessionTable().sessionClosed(loggedOff.getSessionId());
        logger.debug("Session << {} >> logged off", (Object)loggedOff.getSessionId());
    }
}

